<?php
class WithdrawModelClass extends ModelClassEx {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $rs							= null;			// 出金リスト
	private $user						= null;			// ユーザデータ
	private $detail						= null;			// 詳細データ
	private $currencies					= null;			// 通貨データ
	private $wId						= NO_STRING;	// 出金ID
	private $drawCurrency				= NO_STRING;	// 通貨（引き出し通貨）
	private $userName					= NO_STRING;	// ユーザ名
	private $userAccount				= NO_STRING;	// iwallet口座番号
	private $amount						= NO_STRING;	// 金額
	private $currency					= NO_STRING;	// 通貨
	private $accountName				= NO_STRING;	// 口座名義
	private $receiptCountry				= NO_STRING;	// 受取人国
	private $receiptAddress1			= NO_STRING;	// 受取人住所1
	private $receiptAddress2			= NO_STRING;	// 受取人住所2
	private $receiptMessage				= NO_STRING;	// 受取人メッセージ
	private $receiptBankName			= NO_STRING;	// 受取銀行名
	private $receiptBankSwift			= NO_STRING;	// 受取銀行SWIFT
	private $receiptBankCountry			= NO_STRING;	// 受取銀行国
	private $receiptBankAddress1		= NO_STRING;	// 受取銀行住所1
	private $receiptBankAddress2		= NO_STRING;	// 受取銀行住所2
	private $accountNumber				= NO_STRING;	// 受取銀行口座番号
	private $intermediaryFlg			= NO_STRING;	// 中継銀行フラグ
	private $intermediaryBankName		= NO_STRING;	// 中継銀行名
	private $intermediaryBankSwift		= NO_STRING;	// 中継銀行SWIFT
	private $intermediaryBankCountry	= NO_STRING;	// 中継銀行国
	private $intermediaryBankAddress1	= NO_STRING;	// 中継銀行住所1
	private $intermediaryBankAddress2	= NO_STRING;	// 中継銀行住所2
	private $intermediaryBankMessage	= NO_STRING;	// 中継銀行メッセージ
	private $status						= NO_COUNT;		// 送金ステータス

	// ------------------ 検索系 ------------------//
	private $sEmail						= NO_COUNT;		// メールアドレス（検索項目）
	private $sCompletion				= NO_COUNT;		// 完了データ（検索項目）
	private $sBank						= NO_COUNT;		// 銀行データ（検索項目）
	private $sAccount					= NO_COUNT;		// 送金先口座番号（検索項目）
	private $sStatus					= NO_COUNT;		// ステータス（検索項目）
	private $sMinAmount					= NO_COUNT;		// 送金額（最少）（検索項目）
	private $sMaxAmount					= NO_COUNT;		// 送金額（最大）（検索項目）
	private $sFrom						= NO_COUNT;		// 登録時刻（開始日）（検索項目）
	private $sTo						= NO_COUNT;		// 登録時刻（終了）（検索項目）
	private $sCurrency					= NO_COUNT;		// 通貨（検索項目）

	// ------------------ 検索系 ------------------//

	/*-------------------------------------------------------------------------
	* @function_name: コントロールパネルシステムindexモデルクラスコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		// スーパークラスコンストラクタ呼び出し
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 初期設定関数
	* @parameter	: なし
	* @return		: 成功:success、失敗:error
	-------------------------------------------------------------------------*/
	public function init() {

		try {

			// パラメータの設定
			$this -> setParameter();

			// チェック
			return $this -> validate();

		} catch (Exception $e) {
			throw new Exception(NO_STRING);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: パラメータの設定
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function setParameter() {
		$this -> wId						= $this -> getDataPost(PARAM_W_ID);							// 出金ID
		$this -> userAccount				= $this -> getDataPost(PARAM_USER_ACCOUNT);					// iwallet口座番号
		$this -> drawCurrency				= $this -> getDataPost(PARAM_DRAW_CURRENCY);				// 金額（引き出し通貨）
		$this -> amount						= $this -> getDataPost(PARAM_AMOUNT);						// 金額
		$this -> currency					= $this -> getDataPost(PARAM_CURRENCY);						// 通貨
		$this -> accountName				= $this -> getDataPost(PARAM_ACCOUNT_NAME);					// 口座名義
		$this -> receiptCountry				= $this -> getDataPost(PARAM_RECEIPT_COUNTRY);				// 受取人国
		$this -> receiptAddress1			= $this -> getDataPost(PARAM_RECEIPT_ADDRESS_1);			// 受取人住所1
		$this -> receiptAddress2			= $this -> getDataPost(PARAM_RECEIPT_ADDRESS_2);			// 受取人住所2
		$this -> receiptMessage				= $this -> getDataPost(PARAM_RECEIPT_MESSAGE);				// 受取人メッセージ
		$this -> receiptBankName			= $this -> getDataPost(PARAM_RECEIPT_BANK_NAME);			// 受取銀行名
		$this -> receiptBankSwift			= $this -> getDataPost(PARAM_RECEIPT_BANK_SWIFT);			// 受取銀行SWIFT
		$this -> receiptBankCountry			= $this -> getDataPost(PARAM_RECEIPT_BANK_COUNTRY);			// 受取銀行国
		$this -> receiptBankAddress1		= $this -> getDataPost(PARAM_RECEIPT_BANK_ADDRESS_1);		// 受取銀行住所1
		$this -> receiptBankAddress2		= $this -> getDataPost(PARAM_RECEIPT_BANK_ADDRESS_2);		// 受取銀行住所2
		$this -> accountNumber				= $this -> getDataPost(PARAM_ACCOUNT_NUMBER);				// 受取銀行口座番号
		$this -> intermediaryFlg			= $this -> getDataPost(PARAM_INTERMEDIARY_FLG);				// 中継銀行フラグ
		$this -> intermediaryBankName		= $this -> getDataPost(PARAM_INTERMEDIARY_BANK_NAME);		// 中継銀行名
		$this -> intermediaryBankSwift		= $this -> getDataPost(PARAM_INTERMEDIARY_BANK_SWIFT);		// 中継銀行SWIFT
		$this -> intermediaryBankCountry	= $this -> getDataPost(PARAM_INTERMEDIARY_BANK_COUNTRY);	// 中継銀行国
		$this -> intermediaryBankAddress1	= $this -> getDataPost(PARAM_INTERMEDIARY_BANK_ADDRESS_1);	// 中継銀行住所1
		$this -> intermediaryBankAddress2	= $this -> getDataPost(PARAM_INTERMEDIARY_BANK_ADDRESS_2);	// 中継銀行住所2
		$this -> intermediaryBankMessage	= $this -> getDataPost(PARAM_INTERMEDIARY_BANK_MESSAGE);	// 中継銀行メッセージ
		$this -> status						= $this -> getDataPost(PARAM_STATUS);						// 出金ステータス

		// ------------------ 検索系 ------------------//
		$this -> sEmail						= $this -> getDataPost(PARAM_S_EMAIL);						// メールアドレス（検索項目）
		$this -> sCompletion				= $this -> getDataPost(PARAM_S_COMPLETION);					// 完了データ（検索項目）
		$this -> sBank						= $this -> getDataPost(PARAM_S_BANK);						// 銀行データ（検索項目）
		$this -> sAccount					= $this -> getDataPost(PARAM_S_ACCOUNT);					// 送金先口座番号（検索項目）
		$this -> sStatus					= $this -> getDataPost(PARAM_S_STATUS);						// ステータス（検索項目）
		$this -> sMinAmount					= $this -> getDataPost(PARAM_S_MIN_AMOUNT);					// 送金額（最少）（検索項目）
		$this -> sMaxAmount					= $this -> getDataPost(PARAM_S_MAX_AMOUNT);					// 送金額（最大）（検索項目）
		$this -> sFrom						= $this -> getDataPost(PARAM_S_FROM);						// 登録時刻（開始日）（検索項目）
		$this -> sTo						= $this -> getDataPost(PARAM_S_TO);							// 登録時刻（終了）（検索項目）
		$this -> sCurrency					= $this -> getDataPost(PARAM_S_CURRENCY);					// 通貨（検索項目）
		// ------------------ 検索系 ------------------//
	}

	/*-------------------------------------------------------------------------
	* @function_name: パラメータの再設定
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function restore() {
		$this -> wId						= $this -> detail[COLUMN_W_ID];							// 出金ID
		$this -> userName					= $this -> detail[COLUMN_USER_NAME];					// ユーザID
		$this -> userAccount				= $this -> detail[COLUMN_USER_ACCOUNT];					// iwallet口座番号
		$this -> amount						= $this -> detail[COLUMN_AMOUNT];						// 金額
		$this -> accountName				= $this -> detail[COLUMN_ACCOUNT_NAME];					// 口座名義
		$this -> receiptCountry				= $this -> detail[COLUMN_RECEIPT_COUNTRY];				// 受取人国
		$this -> receiptAddress1			= $this -> detail[COLUMN_RECEIPT_ADDRESS_1];			// 受取人住所1
		$this -> receiptAddress2			= $this -> detail[COLUMN_RECEIPT_ADDRESS_2];			// 受取人住所2
		$this -> receiptMessage				= $this -> detail[COLUMN_RECEIPT_MESSAGE];				// 受取人メッセージ
		$this -> receiptBankName			= $this -> detail[COLUMN_RECEIPT_BANK_NAME];			// 受取銀行名
		$this -> receiptBankSwift			= $this -> detail[COLUMN_RECEIPT_BANK_SWIFT];			// 受取銀行SWIFT
		$this -> receiptBankCountry			= $this -> detail[COLUMN_RECEIPT_BANK_COUNTRY];			// 受取銀行国
		$this -> receiptBankAddress1		= $this -> detail[COLUMN_RECEIPT_BANK_ADDRESS_1];		// 受取銀行住所1
		$this -> receiptBankAddress2		= $this -> detail[COLUMN_RECEIPT_BANK_ADDRESS_2];		// 受取銀行住所2
		$this -> accountNumber				= $this -> detail[COLUMN_ACCOUNT_NUMBER];				// 受取銀行口座番号
		$this -> intermediaryFlg			= $this -> detail[COLUMN_INTERMEDIARY_FLG];				// 中継銀行フラグ
		$this -> intermediaryBankName		= $this -> detail[COLUMN_INTERMEDIARY_BANK_NAME];		// 中継銀行名
		$this -> intermediaryBankSwift		= $this -> detail[COLUMN_INTERMEDIARY_BANK_SWIFT];		// 中継銀行SWIFT
		$this -> intermediaryBankCountry	= $this -> detail[COLUMN_INTERMEDIARY_BANK_COUNTRY];	// 中継銀行国
		$this -> intermediaryBankAddress1	= $this -> detail[COLUMN_INTERMEDIARY_BANK_ADDRESS_1];	// 中継銀行住所1
		$this -> intermediaryBankAddress2	= $this -> detail[COLUMN_INTERMEDIARY_BANK_ADDRESS_2];	// 中継銀行住所2
		$this -> intermediaryBankMessage	= $this -> detail[COLUMN_INTERMEDIARY_BANK_MESSAGE];	// 中継銀行メッセージ
		$this -> status						= $this -> detail[COLUMN_STATUS];						// 送金ステータス
	}

	/*-------------------------------------------------------------------------
	* @function_name: サーバ側データチェック
	* @parameter	: なし
	* @return		: TRUE:成功、FALSE:失敗
	-------------------------------------------------------------------------*/
	public function validate() {

		// 変数宣言部
		$rtn			= true;
		$userAccount	= NO_STRING;

		if($this -> getType() == TYPE_INPUT) {

			$userAccount = $this -> searchUserAccountCommon($this -> userAccount);

			// データの確認
			if($userAccount == NO_STRING) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NOT_EXIST', array(VAL_STR_USER_ACCOUNT));
				$this -> setType(CONTROL_ACTION);
				$rtn = false;
			} else {
				$this -> userAccount = $userAccount;
			}
		} else if($this -> getType() == TYPE_CONFIRM) {

			// 金額のチェック
			if(!$this -> checkNull($this -> amount)) {
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_AMOUNT));
				$rtn = false;
			}

			// 口座名義のチェック
			if(!$this -> checkNull($this -> accountName)) {
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_ACCOUNT_NAME));
				$rtn = false;
			}

			// 受取人国のチェック
			if(!$this -> checkNull($this -> receiptCountry)) {
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_RECEIPT_COUNTRY));
				$rtn = false;
			}

			// 受取人住所1のチェック
			if(!$this -> checkNull($this -> receiptAddress1)) {
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_RECEIPT_ADDRESS_1));
				$rtn = false;
			}

			// 受取銀行名のチェック
			if(!$this -> checkNull($this -> receiptBankName)) {
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_RECEIPT_BANK_NAME));
				$rtn = false;
			}

			// 受取銀行SWIFTのチェック
			if(!$this -> checkNull($this -> receiptBankSwift)) {
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_RECEIPT_BANK_SWIFT_CODE));
				$rtn = false;
			}

			// 受取銀行国のチェック
			if(!$this -> checkNull($this -> receiptBankCountry)) {
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_RECEIPT_BANK_COUNTRY));
				$rtn = false;
			}

			// 受取銀行住所1のチェック
			if(!$this -> checkNull($this -> receiptBankAddress1)) {
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_RECEIPT_BANK_ADDRESS_1));
				$rtn = false;
			}

			// 受取銀行口座番号のチェック
			if(!$this -> checkNull($this -> accountNumber)) {
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_RECEIPT_BANK_ACCOUNT_NUMBER));
				$rtn = false;
			}

			// 中継銀行のフラグが立っている場合
			if($this -> intermediaryFlg != NO_STRING) {

				// 中継銀行名のチェック
				if(!$this -> checkNull($this -> intermediaryBankName)) {
					$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_INTERMEDIARY_BANK_NAME));
					$rtn = false;
				}

				// 中継銀行SWIFTのチェック
				if(!$this -> checkNull($this -> intermediaryBankSwift)) {
					$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_INTERMEDIARY_BANK_SWIFT_CODE));
					$rtn = false;
				}

				// 中継銀行国のチェック
				if(!$this -> checkNull($this -> intermediaryBankCountry)) {
					$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_INTERMEDIARY_BANK_COUNTRY));
					$rtn = false;
				}

				// 中継銀行住所1のチェック
				if(!$this -> checkNull($this -> intermediaryBankAddress1)) {
					$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_INTERMEDIARY_BANK_ADDRESS_1));
					$rtn = false;
				}

				// 			$this -> intermediaryBankAddress2	= NO_STRING;	// 中継銀行住所2のチェック
				// 			$this -> intermediaryBankMessage	= NO_STRING;	// 中継銀行メッセージのチェック
			}

			// タイプを戻す
			if(!$rtn) {
				$this -> setType(TYPE_INPUT);
				return;
			}

			// 金額の正規表現チェック
			if(!$this -> checkStringNumber($this -> amount)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_REGULAR_NUMBER', array(VAL_STR_AMOUNT));
				$rtn = false;
			}

			// 受取銀行SWIFTの正規表現チェック
			if(!$this -> checkStringAscii($this -> receiptBankSwift)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_REGULAR_ASCII', array(VAL_STR_RECEIPT_BANK_SWIFT_CODE));
				$rtn = false;
			}

			// 受取銀行SWIFTの文字数チェック
			if(!$this -> checkStringLength($this -> receiptBankSwift, VAL_INT_8)) {
				if(!$this -> checkStringLength($this -> receiptBankSwift, VAL_INT_11)) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_STRING_LENGTH', array($this -> receiptBankSwift));
					$rtn = false;
				}
			}

			// 受取人住所1の正規表現チェック
			if(!$this -> checkStringAsciiAndSpace($this -> receiptAddress1)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_REGULAR_ASCII', array(VAL_STR_RECEIPT_ADDRESS_1));
				$rtn = false;
			}

			// 受取銀行住所1の正規表現チェック
			if(!$this -> checkStringAsciiAndSpace($this -> receiptBankAddress1)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_REGULAR_ASCII', array(VAL_STR_RECEIPT_BANK_ADDRESS_1));
				$rtn = false;
			}

			// 中継銀行のフラグが立っている場合
			if($this -> intermediaryFlg != NO_STRING) {

				// 受取銀行SWIFTの正規表現チェック
				if(!$this -> checkStringAscii($this -> intermediaryBankSwift)) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_REGULAR_ASCII', array(VAL_STR_INTERMEDIARY_BANK_SWIFT_CODE));
					$rtn = false;
				}

				// 受取銀行SWIFTの文字数チェック
				if(!$this -> checkStringLength($this -> intermediaryBankSwift, VAL_INT_8)) {
					if(!$this -> checkStringLength($this -> intermediaryBankSwift, VAL_INT_11)) {
						$this -> popUpSessionMessage(ERROR, 'E_ERROR_STRING_LENGTH', array($this -> intermediaryBankSwift));
						$rtn = false;
					}
				}

				// 受取銀行住所1の正規表現チェック
				if(!$this -> checkStringAsciiAndSpace($this -> intermediaryBankAddress1)) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_REGULAR_ASCII', array(VAL_STR_INTERMEDIARY_BANK_ADDRESS_1));
					$rtn = false;
				}
			}

// 			$this -> receiptAddress2			= NO_STRING;	// 受取人住所2のチェック
// 			$this -> receiptMessage				= NO_STRING;	// 受取人メッセージのチェック
// 			$this -> receiptBankAddress2		= NO_STRING;	// 受取銀行住所2のチェック

			// タイプを戻す
			if(!$rtn) {
				$this -> setType(TYPE_INPUT);
			}
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 検索条件を取得する
	* @parameter	: なし
	* @return		: 検索条件
	-------------------------------------------------------------------------*/
	public function getWhere() {

		// 変数宣言部
		$rtn = NO_STRING;

		// メールアドレス（検索項目）
		if($this -> sEmail != NO_STRING) {
			$rtn .= ' AND (users.user_name = \'' . $this -> sEmail . '\''
							. ' OR users.mail = \'' . $this -> sEmail . '\'' . ')';
		}

// 		$this -> sCompletion				= $this -> getDataPost(PARAM_S_COMPLETION);					// 完了データ（検索項目）

		// 銀行データ（検索項目）
		if($this -> sBank != NO_STRING) {
			$rtn .= ' AND (withdraw.receipt_bank_name = \'' . $this -> sBank . '\''
							. ' OR withdraw.receipt_bank_swift = \'' . $this -> sBank . '\''
							. ' OR withdraw.intermediary_bank_name = \'' . $this -> sBank . '\''
							. ' OR withdraw.intermediary_bank_swift = \'' . $this -> sBank . '\''
							. ')';
		}

		// 送金先口座番号（検索項目）
		if($this -> sAccount != NO_STRING) {
			$rtn .= ' AND withdraw.account_number = \'' . $this -> sAccount . '\'';
		}

		// ステータス（検索項目）
		if($this -> sStatus != NO_STRING) {
			$rtn .= ' AND withdraw.status = \'' . $this -> sStatus . '\'';
		}

		// 通貨
		if($this -> sCurrency != NO_STRING) {
			$rtn .= ' AND withdraw.currency = \'' . $this -> sCurrency . '\'';
		}

		// 送金額（最少）（検索項目）
		if($this -> sMinAmount != NO_STRING) {
			if($this -> sCurrency == NO_STRING) {	// 通貨未指定
				$rtn .= ' AND withdraw.amount >= \'' . $this -> sMinAmount . '\'';
			} else {								// 通貨指定
				$rtn .= ' AND withdraw.amount >= \'' . $this -> currencyToInt($this -> sMinAmount, $this -> sCurrency) . '\'';
			}
		}

		// 送金額（最大）（検索項目）
		if($this -> sMaxAmount != NO_STRING) {
			if($this -> sCurrency == NO_STRING) {	// 通貨未指定
				$rtn .= ' AND withdraw.amount <= \'' . $this -> sMaxAmount . '\'';
			} else {								// 通貨指定
				$rtn .= ' AND withdraw.amount <= \'' . $this -> currencyToInt($this -> sMaxAmount, $this -> sCurrency) . '\'';
			}
		}

		// 登録時刻（開始日）（検索項目）
		if($this -> sFrom != NO_STRING) {
			$rtn .= ' AND withdraw.create_time >= \'' . $this -> sFrom . '\'';
		}

		// 登録時刻（終了）（検索項目）
		if($this -> sTo != NO_STRING) {
			$rtn .= ' AND withdraw.create_time < DATE_ADD(\'' . $this -> sTo . '\', INTERVAL 1 DAY)';
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function dispHTML() {
		return array();
	}

	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function echoList() {

		// 変数宣言部
		$rtn			= NO_STRING;
		$intermediary	= NO_STRING;
		$currency		= NO_STRING;
		$amount			= NO_STRING;
		$status			= NO_STRING;
		$statusClass	= NO_STRING;

		if($this -> isLoopData($this -> rs)) {

			// データの数だけループを回す
			foreach($this -> rs as $row) {

				if($this -> getColumnData($row, COLUMN_INTERMEDIARY_FLG) == VAL_INT_1) {
					$intermediary = '利用する';
				} else {
					$intermediary = '利用しない';
				}

				// データを取得する
				$currency	= $this -> getColumnData($row, COLUMN_CURRENCY);
				$amount		= $this -> getColumnData($row, COLUMN_AMOUNT);

				// ステータス
				$status = $this -> dispWithdrawStatusCommon($this -> getColumnData($row, COLUMN_STATUS));
				if($status == '処理中') {
					$statusClass = 'yellow';

				} else if($status == '完了') {
					$statusClass = 'blue';
				} else {
					$statusClass = 'red';
				}

				$rtn	.= '<tr>'
							. '<td>' . $this -> getColumnData($row, COLUMN_CREATE_TIME) . '</td>'
							. '<td class="l"><a href="javascript:userDetail(\'' . $row[COLUMN_USER_ACCOUNT] . '\');">' . $this -> getColumnData($row, COLUMN_USER_NAME) . '</a></td>'
							. '<td>' . $currency . '</td>'
							. '<td class="r">' . number_format($this -> intToCurrency($amount, $currency), $this -> getDigitCount($currency)) . '</td>'
							. '<td>' . $this -> getColumnData($row, COLUMN_ACCOUNT_NUMBER) . '</td>'
							. '<td>' . $this -> getColumnData($row, COLUMN_RECEIPT_BANK_NAME) . '</td>'
							. '<td>' . $this -> getColumnData($row, COLUMN_RECEIPT_BANK_SWIFT) . '</td>'
							. '<td>' . $intermediary . '</td>'
							. '<td class="l">' . $this -> getColumnData($row, COLUMN_PROCESS_USER_NAME) . '</td>'
							. '<td>' . $this -> getColumnData($row, COLUMN_PROCESS_TIME_STRING) . '</td>'
							. '<td><span class="' . $statusClass . '">' . $status . '</span></td>'
							. '<td class="blocka"><a href="javascript:actionDetail(\'' . $this -> getColumnData($row, COLUMN_W_ID). '\');"><span class="fa fa-info-circle fa-lg"></span></a></td>'
							. '</tr>';
			}

		} else {
			$rtn = '<tr><td colspan="12">' . $this -> getMessage(INFO, 'I_NO_SUCHE_SEARCH_DATA', array()) . '</td></tr>';
		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金IDの取得
	* @parameter	: なし
	* @return		: 出金ID
	-------------------------------------------------------------------------*/
	public function getWId() {
		return $this -> wId;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金IDの表示
	* @parameter	: なし
	* @return		: 出金ID
	-------------------------------------------------------------------------*/
	public function echoWId() {
		echo $this -> wId;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 金額の取得
	* @parameter	: なし
	* @return		: 金額
	-------------------------------------------------------------------------*/
	public function echoAmount() {
		echo $this -> amount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 引き出し通貨の取得
	* @parameter	: なし
	* @return		: 通貨
	-------------------------------------------------------------------------*/
	public function getDrawCurrency() {
		return $this -> drawCurrency;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 引き出し通貨の取得
	* @parameter	: なし
	* @return		: 通貨
	-------------------------------------------------------------------------*/
	public function dispDrawCurrency() {
		echo $this -> dispCurrencyCommon($this -> drawCurrency);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 引き出し通貨の取得
	* @parameter	: なし
	* @return		: 通貨
	-------------------------------------------------------------------------*/
	public function echoDrawCurrency() {

		// 変数宣言部
		$rtn = NO_STRING;

		$rtn = '<select id="draw_currency" name="draw_currency">' . $this -> dispCurrencyOptionList($this -> drawCurrency, false) . '</select>';

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 通貨の取得
	* @parameter	: なし
	* @return		: 通貨
	-------------------------------------------------------------------------*/
	public function getCurrency() {
		return $this -> currency;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 通貨の取得
	* @parameter	: なし
	* @return		: 通貨
	-------------------------------------------------------------------------*/
	public function dispCurrency() {
		echo $this -> dispCurrencyCommon($this -> currency);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 通貨の取得
	* @parameter	: なし
	* @return		: 通貨
	-------------------------------------------------------------------------*/
	public function echoCurrency() {

		// 変数宣言部
		$rtn = NO_STRING;

		$rtn = '<select id="currency" name="currency">' . $this -> dispCurrencyOptionList($this -> currency, false) . '</select>';

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座名義の取得
	* @parameter	: なし
	* @return		: 口座名義
	-------------------------------------------------------------------------*/
	public function echoAccountName() {
		echo $this -> accountName;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 受取人国の取得
	* @parameter	: なし
	* @return		: 受取人国
	-------------------------------------------------------------------------*/
	public function getReceiptCountry() {
		return $this -> receiptCountry;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 受取人国の取得
	* @parameter	: なし
	* @return		: 受取人国
	-------------------------------------------------------------------------*/
	public function dispReceiptCountry() {
		echo $this -> dispCountryCommon($this -> receiptCountry);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 受取人国の取得
	* @parameter	: なし
	* @return		: 受取人国
	-------------------------------------------------------------------------*/
	public function echoReceiptCountry() {

		// 変数宣言部
		$rtn = NO_STRING;

		$rtn = '<select id="receipt_country" name="receipt_country">' . $this -> dispCountryOptionList($this -> receiptCountry) . '</select>';

		echo $this -> dispCountryCommon($this -> receiptCountry);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 受取人住所1の取得
	* @parameter	: なし
	* @return		: 受取人住所1
	-------------------------------------------------------------------------*/
	public function echoReceiptAddress1() {
		echo $this -> receiptAddress1;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 受取人住所2の取得
	* @parameter	: なし
	* @return		: 受取人住所2
	-------------------------------------------------------------------------*/
	public function echoReceiptAddress2() {
		echo $this -> receiptAddress2;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 受取人メッセージの取得
	* @parameter	: なし
	* @return		: 受取人メッセージ
	-------------------------------------------------------------------------*/
	public function echoReceiptMessage() {
		echo $this -> receiptMessage;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 受取銀行名の取得
	* @parameter	: なし
	* @return		: 受取銀行名
	-------------------------------------------------------------------------*/
	public function echoReceiptBankName() {
		echo $this -> receiptBankName;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 受取銀行SWIFTの取得
	* @parameter	: なし
	* @return		: 受取銀行SWIFT
	-------------------------------------------------------------------------*/
	public function echoReceiptBankSwift() {
		echo $this -> receiptBankSwift;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 受取銀行国の取得
	* @parameter	: なし
	* @return		: 受取銀行国
	-------------------------------------------------------------------------*/
	public function getReceiptBankCountry() {
		return $this -> receiptBankCountry;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 受取銀行の取得
	* @parameter	: なし
	* @return		: 受取銀行
	-------------------------------------------------------------------------*/
	public function dispReceiptBankCountry() {
		echo $this -> dispCountryCommon($this -> receiptBankCountry);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 受取銀行国の取得
	* @parameter	: なし
	* @return		: 受取銀行国
	-------------------------------------------------------------------------*/
	public function echoReceiptBankCountry() {

		// 変数宣言部
		$rtn = NO_STRING;

		$rtn = '<select id="receipt_bank_country" name="receipt_bank_country">' . $this -> dispCountryOptionList($this -> receiptBankCountry) . '</select>';

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 受取銀行住所1の取得
	* @parameter	: なし
	* @return		: 受取銀行住所1
	-------------------------------------------------------------------------*/
	public function echoReceiptBankAddress1() {
		echo $this -> receiptBankAddress1;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 受取銀行住所2の取得
	* @parameter	: なし
	* @return		: 受取銀行住所2
	-------------------------------------------------------------------------*/
	public function echoReceiptBankAddress2() {
		echo $this -> receiptBankAddress2;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 受取銀行口座番号の取得
	* @parameter	: なし
	* @return		: 受取銀行口座番号
	-------------------------------------------------------------------------*/
	public function echoAccountNumber() {
		echo $this -> accountNumber;
	}


	/*-------------------------------------------------------------------------
	* @function_name: 中継銀行フラグの取得
	* @parameter	: なし
	* @return		: 中継銀行フラグ
	-------------------------------------------------------------------------*/
	public function getIntermediaryFlg() {
		return $this -> intermediaryFlg;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 中継銀行フラグの取得
	* @parameter	: なし
	* @return		: 中継銀行フラグ
	-------------------------------------------------------------------------*/
	public function echoIntermediaryFlg() {
		echo $this -> makeCheckOne(PARAM_INTERMEDIARY_FLG
									, PARAM_INTERMEDIARY_FLG
									, VAL_INT_1
									, '中継銀行を利用する'
									, $this -> intermediaryFlg);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 中継銀行フラグの取得
	* @parameter	: なし
	* @return		: 中継銀行フラグ
	-------------------------------------------------------------------------*/
	public function dispIntermediaryFlg() {

		// 変数宣言部
		$rtn = NO_STRING;

		if($this -> intermediaryFlg == VAL_INT_1) {
			$rtn = '中継銀行を利用する';
		} else {
			$rtn = '中継銀行を利用しない';
		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 中継銀行名の取得
	* @parameter	: なし
	* @return		: 中継銀行名
	-------------------------------------------------------------------------*/
	public function echoIntermediaryBankName() {
		echo $this -> intermediaryBankName;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 中継銀行SWIFTの取得
	* @parameter	: なし
	* @return		: 中継銀行SWIFT
	-------------------------------------------------------------------------*/
	public function echoIntermediaryBankSwift() {
		echo $this -> intermediaryBankSwift;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 中継銀行国の取得
	* @parameter	: なし
	* @return		: 中継銀行国
	-------------------------------------------------------------------------*/
	public function getIntermediaryBankCountry() {
		return $this -> intermediaryBankCountry;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 中継銀行の取得
	* @parameter	: なし
	* @return		: 中継銀行
	-------------------------------------------------------------------------*/
	public function dispIntermediaryBankCountry() {

		// 変数宣言部
		$status = NO_STRING;

		$status = $this -> dispCountryCommon($this -> intermediaryBankCountry);

		if($status == '無効') {
			$status = NO_STRING;
		}
		echo $status;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 中継銀行国の取得
	* @parameter	: なし
	* @return		: 中継銀行国
	-------------------------------------------------------------------------*/
	public function echoIntermediaryBankCountry() {

		// 変数宣言部
		$rtn = NO_STRING;

		$rtn = '<select id="intermediary_bank_country" name="intermediary_bank_country">' . $this -> dispCountryOptionList($this -> intermediaryBankCountry) . '</select>';

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 中継銀行住所1の取得
	* @parameter	: なし
	* @return		: 中継銀行住所1
	-------------------------------------------------------------------------*/
	public function echoIntermediaryBankAddress1() {
		echo $this -> intermediaryBankAddress1;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 中継銀行住所2の取得
	* @parameter	: なし
	* @return		: 中継銀行住所2
	-------------------------------------------------------------------------*/
	public function echoIntermediaryBankAddress2() {
		echo $this -> intermediaryBankAddress2;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 中継銀行メッセージの取得
	* @parameter	: なし
	* @return		: 中継銀行メッセージ
	-------------------------------------------------------------------------*/
	public function echoIntermediaryBankMessage() {
		echo $this -> intermediaryBankMessage;
	}

	/*-------------------------------------------------------------------------
	* @function_name: ユーザ名の取得
	* @parameter	: なし
	* @return		: ユーザ名
	-------------------------------------------------------------------------*/
	public function getUserName() {
		return $this -> userName;
	}

	/*-------------------------------------------------------------------------
	* @function_name: ユーザ名の取得
	* @parameter	: なし
	* @return		: ユーザ名
	-------------------------------------------------------------------------*/
	public function echoUserName() {

		// 変数宣言部
		$rtn = NO_STRING;

		if(count($this -> user)) {
			$rtn = $this -> user[COLUMN_USER_NAME];
		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金ステータスの表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	public function echoStatus() {
		echo '<select id="status" name="status">' . $this -> dispListOption($this -> getWithdrawStatusList(), $this -> status) . '</select>';
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金ステータス（検索用）の表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	public function echoSStatus() {
		echo $this -> dispListOption($this -> getWithdrawStatusList(), $this -> sStatus);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 登録用のデータを取得
	* @parameter	: なし
	* @return		: 登録用データ
	-------------------------------------------------------------------------*/
	public function getRegistData() {

		// 変数宣言部
		$rtn = array();

		$rtn[] = $this -> userAccount;				// ユーザ口座番号
		$rtn[] = $this -> drawCurrency;				// 金額（引き出し口座）
		$rtn[] = intval($this -> amount);			// 金額
		$rtn[] = $this -> currency;					// 通貨
		$rtn[] = $this -> accountName;				// 口座名義
		$rtn[] = $this -> receiptCountry;			// 受取人国
		$rtn[] = $this -> receiptAddress1;			// 受取人住所1
		$rtn[] = $this -> receiptAddress2;			// 受取人住所2
		$rtn[] = $this -> receiptMessage;			// 受取人メッセージ
		$rtn[] = $this -> receiptBankName;			// 受取銀行名
		$rtn[] = $this -> receiptBankSwift;			// 受取銀行SWIFT
		$rtn[] = $this -> receiptBankCountry;		// 受取銀行国
		$rtn[] = $this -> receiptBankAddress1;		// 受取銀行住所1
		$rtn[] = $this -> receiptBankAddress2;		// 受取銀行住所2
		$rtn[] = $this -> accountNumber;			// 受取銀行口座番号
		$rtn[] = intval($this -> intermediaryFlg);	// 中継銀行フラグ
		$rtn[] = $this -> intermediaryBankName;		// 中継銀行名
		$rtn[] = $this -> intermediaryBankSwift;	// 中継銀行SWIFT
		$rtn[] = $this -> intermediaryBankCountry;	// 中継銀行国
		$rtn[] = $this -> intermediaryBankAddress1;	// 中継銀行住所1
		$rtn[] = $this -> intermediaryBankAddress2;	// 中継銀行住所2
		$rtn[] = $this -> intermediaryBankMessage;	// 中継銀行メッセージ

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: ステータス更新用のデータを取得
	* @parameter	: なし
	* @return		: ステータス更新用データ
	-------------------------------------------------------------------------*/
	public function getUpdateStatus() {

		// 変数宣言部
		$rtn = array();

		$rtn[] = $this -> wId;									// 出金ID
		$rtn[] = $this -> status;								// ステータス
		$rtn[] = $this -> getAdminUserData(PARAM_USER_ACCOUNT);	// 担当者口座番号

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金リストの設定
	* @parameter	: 出金リスト
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function setResult($rs) {
		$this -> rs = $rs;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金リストの取得
	* @parameter	: 出金リスト
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function getResult() {
		return $this -> rs;
	}

	/*-------------------------------------------------------------------------
	* @function_name: iwallet口座番号の設定
	* @parameter	: iwallet口座番号
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function setUserAccount() {
		return $this -> userAccount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: iwallet口座番号の取得
	* @parameter	: なし
	* @return		: iwallet口座番号
	-------------------------------------------------------------------------*/
	public function echoUserAccount() {
		echo $this -> userAccount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: メールアドレス（検索項目）の取得
	* @parameter	: なし
	* @return		: メールアドレス（検索項目）
	-------------------------------------------------------------------------*/
	public function echoSEmail() {
		echo $this -> sEmail;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 完了データ（検索項目）の取得
	* @parameter	: なし
	* @return		: 完了データ（検索項目）
	-------------------------------------------------------------------------*/
	public function echoSCompletion() {
		echo $this -> sCompletion;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 銀行データ（検索項目）の取得
	* @parameter	: なし
	* @return		: 銀行データ（検索項目）
	-------------------------------------------------------------------------*/
	public function echoSBank() {
		echo $this -> sBank;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 送金先口座番号（検索項目）の取得
	* @parameter	: なし
	* @return		: 送金先口座番号（検索項目）
	-------------------------------------------------------------------------*/
	public function echoSAccount() {
		echo $this -> sAccount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: ステータス（検索項目）の取得
	* @parameter	: なし
	* @return		: ステータス（検索項目）
	-------------------------------------------------------------------------*/
	public function dispSStatus() {
		echo '<select name="s_status">' . $this -> dispWithdrawStatusOptionList($this -> sStatus) . '</select>';
	}

	/*-------------------------------------------------------------------------
	* @function_name: 送金額（最少）（検索項目）の取得
	* @parameter	: なし
	* @return		: 送金額（最少）（検索項目）
	-------------------------------------------------------------------------*/
	public function echoSMinAmount() {
		echo $this -> sMinAmount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 送金額（最大）（検索項目）の取得
	* @parameter	: なし
	* @return		: 送金額（最大）（検索項目）
	-------------------------------------------------------------------------*/
	public function echoSMaxAmount() {
		echo $this -> sMaxAmount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 登録時刻（開始日）（検索項目）の取得
	* @parameter	: なし
	* @return		: 登録時刻（開始日）（検索項目）
	-------------------------------------------------------------------------*/
	public function echoSFrom() {
		echo $this -> sFrom;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 登録時刻（終了）（検索項目）の取得
	* @parameter	: なし
	* @return		: 登録時刻（終了）（検索項目）
	-------------------------------------------------------------------------*/
	public function echoSTo() {
		echo $this -> sTo;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 通貨リストの取得
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function echoCurrencyList() {

		// 変数宣言部
		$lists	= array();

		if($this -> isLoopData($this -> currencies)) {

			foreach($this -> currencies as $row) {
				$lists[] = array(PARAM_DATA_KEY			=> $this -> getColumnData($row, COLUMN_CURRENCY_NAME)
						, PARAM_DATA_VALUE	=> $this -> getColumnData($row, COLUMN_CURRENCY_NAME));
			}
		}

		echo $this -> dispListOption($lists, $this -> sCurrency);
	}

	/*-------------------------------------------------------------------------
	* @function_name: ユーザデータの設定
	* @parameter	: 出金リスト
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function setUser($rs) {
		$this -> user = $rs[NO_COUNT];
	}

	/*-------------------------------------------------------------------------
	* @function_name: 詳細データの設定
	* @parameter	: 詳細データ
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function setDetail($rs) {
		$this -> detail = $rs[NO_COUNT];
	}

	/*-------------------------------------------------------------------------
	* @function_name: 通貨データの設定
	* @parameter	: 通貨データ
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function setCurrencies($rs) {
		$this -> currencies = $rs;
	}

	/*-------------------------------------------------------------------------
	* @function_name: ページャの表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispPager() {
		echo  $this -> getPagerCommon($this -> getTargetPage()
										, $this -> getTotalPageCommon(VAR_DEFAULT_PAGE_COUNT, count($this -> rs))
										, count($this -> rs)
										, NO_STRING);
	}
}
?>