<?php
require_once(SYSTEM_LOGICS . 'request/logic.php');

class ControlRequest extends LogicRequest {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: コントロールパネルシステム動画データ編集ロジック（各クラス共通）
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function action() {
		try {
		    $this -> checkAvailability("system", function(){
		        require_once($this -> getSystemHTML('TEMPLATE_MAINTENANCE_MODE_SYSTEM_PATH'));
		        exit();
		    });
			// アクション実行
			$this -> logic();

			if($this -> getType() == CONTROL_ACTION) {			// 一覧の表示
				require_once($this -> getSystemHTML('TEMPLATE_REQUEST_LIST_PATH', $this -> dispHTML()));

			} else if($this -> getType() == TYPE_DETAIL) {		// 詳細の表示
				require_once($this -> getSystemHTML('TEMPLATE_REQUEST_DETAIL_PATH', $this -> dispHTML()));

			} else if($this -> getType() == TYPE_SAVE) {		// 修正時
				require_once($this -> getSystemHTML('TEMPLATE_REQUEST_DETAIL_PATH', $this -> dispHTML()));
			
			} else if($this -> getType() == TYPE_EXPORT) {
				header('Content-Type: application/octet-stream; charset=utf8');
				header('Content-Disposition: attachment; filename=Withdrawal_List_' . date('YmdHis') . '.csv');
				header('Content-Transfer-Encoding: binary');
				
				echo "\xEF\xBB\xBF";
				echo $this -> getExportDataCommon();
			} else {											// 一覧の表示
				require_once($this -> getSystemHTML('TEMPLATE_REQUEST_LIST_PATH', $this -> dispHTML()));
			}

		} catch (Exception $e) {
			header('Location: /');
		}
	}
}
?>