<?php
require_once(SITE_LOGICS . 'request/model.php');

class LogicRequest extends RequestModelClass {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $htmlStr = NO_STRING;	// 表示用HTML文字列

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジック（各クラス共通）
	* @parameter	: なし
	* @return		: TRUE:ロジック成功、FALSE:ロジック失敗
	-------------------------------------------------------------------------*/
	function logic() {

		try {

			// 初期データ処理
			$this -> init();

			// ロジック実行
			$this -> biz();

		} catch (Exception $e) {
			throw $e;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジックの実行
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function biz() {

		if($this -> getType() 				== TYPE_COMPLETE) {		// 完了
			$this -> regist();

		} else if($this -> getType()		== TYPE_INPUT) {		// 入力
			$this -> load();

		} else if($this -> getType()		== TYPE_LIST
					|| $this -> getType()	== TYPE_REMOVE) {		// リスト

			if($this -> getType()	== TYPE_REMOVE) {
				$this -> hidden();
			}

			$this -> lists();

		} else if($this -> getType()		== TYPE_APPLY) {		// リスト（申請データ）
			$this -> listApply();

		} else if($this -> getType()		== TYPE_DETAIL
					|| $this -> getType()	== TYPE_BACK) {			// 1件データの取得
			$this -> select();

		} else if($this -> getType()		== TYPE_ROLL_BACK) {	// 更新作業（拒否）
			$this -> rollBack();

			$this -> listApply();

			// 遷移先の変更
			$this -> setType(TYPE_APPLY);

		} else if($this -> getType()	== TYPE_SAVE) {				// 更新作業（承認）

			// //check if 2fa is enabled
			if($this -> check2FAEnabled($this -> getUserData(PARAM_USER_ACCOUNT), 'received')){
				//cehck if 2fa validated
				if(!$this -> checkIs2FAValidated()) {
					$this -> listApply();
					$this -> setType(TYPE_APPLY);
					return;
				}
			}

			$this -> save();

			$this -> listApply();

			$this -> select();

			//create session variable for 2favalidated
			$_SESSION['2fa_validated'] = 'not validated';

		} else if($this -> getType()	== NO_STRING) {				// その他
			$this -> selectHistory();

		} else if($this -> getType()	== TYPE_DELETE) {			// 申請の取り消し
			$this -> deleteRequest();
			$this -> lists();
		} else if($this -> getType() == TYPE_CONFIRM) { // anton
			$this -> selectHistory();
			$this -> load(false);
		} else {
			$this -> selectHistory();
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: データのロード
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function load($restore = true /*anton*/) {
		$this -> setUser($this -> accessSelect('SELECT_USER_BY_ACCOUNT_OR_EMAIL', array(addslashes($this -> getUserAccount()))));
		$this -> restore($restore);
	}

	/*-------------------------------------------------------------------------
	* @function_name: データの取得
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function lists() {
		$this -> setResult($this -> accessSelect('LIST_REQUEST_BY_USER', array($this -> getUserData(PARAM_USER_ACCOUNT))));
	}

	/*-------------------------------------------------------------------------
	* @function_name: データの取得
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function listApply() {
		$this -> setResult($this -> accessSelect('LIST_REQUEST_APPLY_BY_USER', array($this -> getUserData(PARAM_USER_ACCOUNT))));
	}

	/*-------------------------------------------------------------------------
	* @function_name: 引落履歴の取得
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function selectHistory() {
		$this -> setHistory($this -> accessSelect('LIST_REQUEST_HISTORY', array($this -> getUserData(PARAM_USER_ACCOUNT))));
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジックの実行
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function regist() {
		$this -> accessModify('INSERT_REQUEST', $this -> getRegistData());

		// 申請メールの送信
		$this -> send();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 申請メールの送信
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function send() {
		$this -> sendMailByTmp('request_apply.xml'
								, $this -> getSendData()
								, $this -> getUserEMailCommon($this -> getUserAccount())
								, VAR_CS_MAIL_ADDRESS);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 引き落し申請の削除
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function deleteRequest() {
		$this -> accessModify('DELETE_REQUEST', $this -> getDeleteData());
		$this -> popUpSessionMessage(INFO, 'I_COMPLATE_CANCEL', array());
	}


	/*-------------------------------------------------------------------------
	* @function_name: データの取得
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function select() {

		$this -> setUser($this -> accessSelect('LIST_REQUEST_BY_R_ID', array($this -> getRId())));

		// 通貨情報
		$this -> setCurrencies($this -> accessSelect('LIST_MST_CURRENCY_ACTIVE', array()));

		// バランスの取得
		$this -> setBalances($this -> accessSelect('SELECT_USER_BALANCES', array($this -> getUserData(PARAM_USER_ACCOUNT))));

		$this -> restore();
	}

	/*-------------------------------------------------------------------------
	* @function_name: データの更新
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function save() {

		// 変数宣言部
		$data		= null;
		$from		= null;
		$to			= null;
		$request	= null;

		// データの更新
		$this -> accessModify('UPDATE_REQUEST', $this -> getSaveParams());

		$params = $this -> getSendCompleteParams();
		$params2 = $this -> getSendInfoParams();
		

		$this -> sendMailByTmp('request_info.xml'
								, $params2
								, $params2[8]
								, VAR_CS_MAIL_ADDRESS);

		$this -> sendMailByTmp('request_complete.xml'
								, $params
								, $params[VAL_INT_11]
								, VAR_CS_MAIL_ADDRESS);

		$data = $this -> getRowData($this -> accessSelect('LIST_REQUEST_BY_R_ID', array($this -> getRId())));

		// コミッションの登録（送金元）
		$this -> registCommision(VAR_TRANSFER
								, null
								, $this -> getColumnData($data, COLUMN_FROM_ACCOUNT)
								, $this -> getColumnData($data, COLUMN_DEBIT_CURRENCY)
								, $this -> intToCurrency($this -> getColumnData($data, COLUMN_FROM_FEE), $this -> getColumnData($data, COLUMN_DEBIT_CURRENCY)));

		// コミッションの登録（送金先）
		$this -> registCommision(VAR_TRANSFER
								, null
								, $this -> getColumnData($data, COLUMN_TO_ACCOUNT)
								, $this -> getColumnData($data, COLUMN_CURRENCY)
								, $this -> intToCurrency($this -> getColumnData($data, COLUMN_TO_FEE), $this -> getColumnData($data, COLUMN_CURRENCY))
								, PARAM_TO);


		// 異通貨の場合は為替コミッション発生
		$request	= $this -> getRowData($this -> getRequestCommon($this -> getRId()));
		$from		= $this -> getColumnData($request, COLUMN_DEBIT_CURRENCY);
		$to			= $this -> getColumnData($request, COLUMN_CURRENCY);

		if($from != $to) {
			$this -> registCommisionExchange($this -> getUserData(PARAM_USER_ACCOUNT)
											, $to
											, $from
											, $this -> getColumnData($request, COLUMN_DEBIT_AMOUNT));
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: データの更新
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function rollBack() {

		// 変数宣言部
		$params = array();

		// データの更新
		$this -> accessModify('UPDATE_REQUEST_ROLL_BACK', $this -> getRollBackParams());

		$params = $this -> getSendRollBackParams();
		$this -> sendMailByTmp('request_roll_back.xml'
								, $params
								, $params[VAL_INT_9]
								, VAR_CS_MAIL_ADDRESS);
	}

	/*-------------------------------------------------------------------------
	* @function_name: データの更新
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function hidden() {

		// データの更新
		$this -> accessModify('UPDATE_REQUEST_HIDDEN_FLG', $this -> getRemoveParams());
	}

	/*-------------------------------------------------------------------------
	* @function_name: ページ出力文字列取得関数
	* @parameter	: なし
	* @return		: HTML文字列
	-------------------------------------------------------------------------*/
	function getDisplay() {
		return $this -> htmlStr;
	}
}
?>