<?php
class AccountEditModelClass extends ModelClassEx {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $userData			= null;			// ユーザデータ
	private $balances			= null;			// バランス
	private $currencies			= null;			// 通貨データ
	private $history			= null;			// 履歴データ
	private $historyCount		= null;			// 履歴データ件数
	private $cards				= null;			// カードデータ
	private $uId				= NO_STRING;	// ユーザ名
	private $userName			= NO_STRING;	// ユーザ名
	private $wlId				= NO_STRING;	// WLID
	private $accountNumber		= NO_STRING;	// 口座番号
	private $accountType		= NO_STRING;	// 口座種別
	private $currency			= NO_STRING;	// 通貨
	private $lastName			= NO_STRING;	// 姓
	private $firstName			= NO_STRING;	// 名
	private $birth				= NO_STRING;	// 生年月日
	private $birthYear			= NO_STRING;	// 生年月日（年）
	private $birthMonth			= NO_STRING;	// 生年月日（月）
	private $birthDay			= NO_STRING;	// 生年月日（日）
	private $kycFlg				= NO_STRING;	// KYCフラグ
	private $createTime			= NO_STRING;	// 登録日時
	private $status				= NO_STRING;	// 状態
	private $oldStatus			= NO_STRING;	// 旧状態
	private $country			= NO_STRING;	// 国
	private $state				= NO_STRING;	// 都道府県
	private $city				= NO_STRING;	// 市区町村
	private $address			= NO_STRING;	// 番地1
	private $address2			= NO_STRING;	// 番地2
	private $zipCode			= NO_STRING;	// 郵便番号
	private $tel				= NO_STRING;	// 電話番号
	private $mail				= NO_STRING;	// メールアドレス
	private $agentCode			= NO_STRING;	// エージェントコード
	private $myAgentCode		= NO_STRING;	// エージェントコード（自分）
	private $name				= NO_STRING;	// 氏名
	private $detailAccount		= NO_STRING;	// 詳細ユーザ口座番号
	private $crmId				= NO_STRING;	// CRM ID
	private $note				= NO_STRING;	// ユーザメモ
	private $risk				= NO_STRING;	// ユーザメモ
	private $fee				= NO_STRING;	// 手数料（閉鎖時のみ）
	private $fees				= array();		// 手数料振り分けリスト（閉鎖時のみ）
	private $loginLock			= null;			// ログインロック
	private $ceoLastName		= NO_STRING;	// 代表者（名）
	private $ceoFirstName		= NO_STRING;	// 代表者（姓）
	private $registrationNumber = NO_STRING;	// 登録番号
	private $registrationDate   = null;         // 登録日
	private $initialContactName = NO_STRING;
	private $initialEmailAddress= NO_STRING;
	private $skypeAccount       = NO_STRING;
	private $typeOfUsage        = NO_STRING;	// 使用の種類
	private $agreementStatus    = NO_STRING;	// 契約状況
	private $siteName			= NO_STRING;	// サイト名
	private $siteURL			= NO_STRING;	// サイトURL
	private $transferBatchFlg	= NO_STRING;	// 一括バッチ送金フラグ
	private $cId				= NO_STRING;	// カードID
	private $cardHolderId		= NO_STRING;	// カードホルダーID
	private $digit				= NO_STRING;	// カード下四桁
	private $proxy				= NO_STRING;	// カードプロキシ
	private $expireDate			= NO_STRING;	// カード有効期限
	private $cardNumber			= NO_STRING;	// カード番号
	private $msg				= NO_STRING;	// メッセージ
	private $gpsAccountFlg		= NO_COUNT;		// GPS口座フラグ
	private $gpsPayments		= array();		// GPS決済種別
	private $img1Flg			= NO_STRING;	// KYC書類1
	private $img2Flg			= NO_STRING;	// KYC書類2
	private $img3Flg			= NO_STRING;	// KYC書類3
	private $img4Flg			= NO_STRING;	// KYC書類4
	private $img5Flg			= NO_STRING;	// KYC書類5
	private $img6Flg			= NO_STRING;	// KYC書類6
	private $img7Flg			= NO_STRING;	// KYC書類7
	private $img8Flg			= NO_STRING;	// KYC書類8
	private $img9Flg			= NO_STRING;	// KYC書類9
	private $img10Flg			= NO_STRING;	// KYC書類10
	private $img11Flg			= NO_STRING;	// KYC書類11
	private $kId				= NO_STRING;	// KYC書類ID
	private $oldFileName		= NO_STRING;	// 旧ファイル名
	private $path				= NO_STRING;	// ファイルパス
	private $login2fa			= NO_STRING;	//2fa-login
	private $profile2fa			= NO_STRING;	//2fa-profile
	private $money2fa			= NO_STRING;	//2fa-money
	private $enablemail     	= NO_STRING;    //判断是否启用
	private $linkAccount		= null;  		//Mikko 2019 0307
	private $userLink			= array(); 	//Mikko 2019 0307
	private $userLinkId			= NO_STRING; 	//Mikko 2019 0307
	private $msg2				= NO_STRING;	//Mikko 2019 0307
	private $riskLevel 			= NO_STRING; 	//Mikko 2019: 3501
	private $tierLevel 			= NO_STRING; 	//Mikko 2019: 3501
	private $transferFlg 		= NO_STRING;
	private $testAccountFlg 	= NO_STRING;

	// ------------------ 検索系 ------------------//
	private $sEmail				= NO_STRING;	// メールアドレス
	private $sUserAccount		= NO_STRING;	// 口座番号
	private $sFrom				= NO_STRING;	// 開始日
	private $sTo				= NO_STRING;	// 終了日
	private $sCurrency			= NO_STRING;	// 通貨
	private $sTransactionNumber	= NO_STRING;	// 取引番号
	private $sTransactionType 	= NO_STRING;	// anton
	// ------------------ 検索系 ------------------//
	// ------------------ ページング ------------------//
	private $crntPage				= NO_STRING;	// メールアドレス
	private $totalPage				= NO_STRING;	// メールアドレス
	// ------------------ ページング ------------------//

	// ------------------ anton ----------------- //
	private $lang					= NO_STRING;


	/*-------------------------------------------------------------------------
	* @function_name: コントロールパネルシステムindexモデルクラスコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		// スーパークラスコンストラクタ呼び出し
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 初期設定関数
	* @parameter	: なし
	* @return		: 成功:success、失敗:error
	-------------------------------------------------------------------------*/
	public function init() {

		try {

			// パラメータの設定
			$this -> setParameter();

			// チェック
			$this -> validate();

		} catch (Exception $e) {
			throw new Exception(NO_STRING);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: パラメータの設定
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function setParameter() {
		$this -> uId				= $this -> getDataPost(PARAM_UID, true);					// UID
		$this -> wlId				= $this -> getDataPost(PARAM_WL_ID, true);				// WLID
		$this -> userName			= $this -> getDataPost(PARAM_USER_NAME, true);			// ユーザ名
		$this -> currency			= $this -> getDataPost(PARAM_CURRENCY, true);				// 通貨
		$this -> lastName			= $this -> getDataPost(PARAM_LAST_NAME, true);			// 姓
		$this -> firstName			= $this -> getDataPost(PARAM_FIRST_NAME, true);			// 名
		$this -> birth				= $this -> getDataPost(PARAM_BIRTH, true);				// 生年月日
		$this -> birthYear			= $this -> getDataPost(PARAM_BIRTH_YEAR, true);			// 生年月日（年）
		$this -> birthMonth			= $this -> getDataPost(PARAM_BIRTH_MONTH, true);			// 生年月日（月）
		$this -> birthDay			= $this -> getDataPost(PARAM_BIRTH_DAY, true);			// 生年月日（日）
		$this -> country			= $this -> getDataPost(PARAM_COUNTRY, true);				// 国
		$this -> state				= $this -> getDataPost(PARAM_STATE, true);				// 都道府県
		$this -> city				= $this -> getDataPost(PARAM_CITY, true);					// 市区町村
		$this -> address			= $this -> getDataPost(PARAM_ADDRESS, true);				// 番地1
		$this -> address2			= $this -> getDataPost(PARAM_ADDRESS_2, true);			// 番地2
		$this -> zipCode			= $this -> getDataPost(PARAM_ZIP_CODE, true);				// 郵便番号
		$this -> tel				= $this -> getDataPost(PARAM_TEL, true);					// 電話番号
		$this -> agentCode			= $this -> getDataPost(PARAM_AGENT_CODE, true);			// エージェントコード
		$this -> accountType		= $this -> getDataPost(PARAM_ACCOUNT_TYPE, true);			// 口座種別
		$this -> mail				= $this -> getDataPost(PARAM_MAIL, true);					// メールアドレス
		$this -> name				= $this -> getDataPost(PARAM_NAME, true);					// 氏名
		$this -> accountNumber		= $this -> getDataPost(PARAM_USER_ACCOUNT, true);			// 口座番号
		$this -> kycFlg				= $this -> getDataPost(PARAM_KYC_FLG, true);				// KYCフラグ
		$this -> status				= $this -> getDataPost(PARAM_STATUS, true);				// 状態
		$this -> detailAccount		= ($this -> getDataPost(PARAM_DETAIL_ACCOUNT) != NO_STRING) ?
		                                  $this -> getDataPost(PARAM_DETAIL_ACCOUNT, true) : $this -> getDataGet(PARAM_DETAIL_ACCOUNT);		// 詳細ユーザ口座番号
		$this -> note				= $this -> getDataPost(PARAM_NOTE, true);					// ユーザメモ
		$this -> risk				= $this -> getDataPost(PARAM_RISK, true);					// ユーザメモ
		$this -> crmId				= $this -> getDataPost(PARAM_CRM_ID, true);				// CRM ID
		$this -> oldStatus			= $this -> getDataPost(PARAM_OLD_STATUS, true);			// 旧状態
		$this -> ceoLastName		= $this -> getDataPost(PARAM_CEO_LAST_NAME, true);		// 代表者（名）
		$this -> ceoFirstName		= $this -> getDataPost(PARAM_CEO_FIRST_NAME, true);		// 代表者（姓）
		$this -> registrationNumber = $this -> getDataPost(PARAM_REGISTRATION_NUMBER, true);
		$this -> registrationDate   = $this -> getDataPost(PARAM_REGISTRATION_DATE, true);
		$this -> initialContactName = $this -> getDataPost(PARAM_INIT_CONTACT_NAME, true);
		$this -> initialEmailAddress= $this -> getDataPost(PARAM_INIT_EMAIL_ADDRESS, true);
		$this -> skypeAccount       = $this -> getDataPost(PARAM_SKYPE_ACCOUNT, true);
		$this -> siteName			= $this -> getDataPost(PARAM_SITE_NAME, true);			// サイト名
		$this -> siteURL			= $this -> getDataPost(PARAM_SITE_URL, true);				// サイトURL
		$this -> agreementStatus    = $this -> getDataPost(PARAM_AGREEMENT_STATUS, true);
		$this -> typeOfUsage        = $this -> getDataPost(PARAM_TYPE_OF_USAGE, true);
		$this -> transferBatchFlg	= $this -> getDataPost(PARAM_TRANSFER_BATCH_FLG, true);	// 一括バッチ送金フラグ
		$this -> cId				= $this -> getDataPost(PARAM_C_ID, true);					// カードID
		$this -> cardHolderId		= $this -> getDataPost(PARAM_CARD_HOLDER_ID, true);		// カードホルダーID
		$this -> digit				= $this -> getDataPost(PARAM_DIGIT, true);				// カード下四桁
		$this -> proxy				= $this -> getDataPost(PARAM_PROXY, true);				// カードプロキシ
		$this -> expireDate			= $this -> getDataPost(PARAM_EXPIRE_DATE, true);			// カード有効期限
		$this -> cardNumber			= $this -> getDataPost(PARAM_CARD_NUMBER, true);			// カード番号
		$this -> gpsAccountFlg		= $this -> getDataPost(PARAM_GPS_ACCOUNT, true);			// GPS口座
		$this -> gpsPayments		= $this -> getDataPost(PARAM_GPS_KIND_OF_PAYMENT, true);	// GPS決済種別
		$this -> img1Flg			= $this -> getDataPost(PARAM_IMG_1_FLG, true);	// KYC書類1フラグ
		$this -> img2Flg			= $this -> getDataPost(PARAM_IMG_2_FLG, true);	// KYC書類2フラグ
		$this -> img3Flg			= $this -> getDataPost(PARAM_IMG_3_FLG, true);	// KYC書類3フラグ
		$this -> img4Flg			= $this -> getDataPost(PARAM_IMG_4_FLG, true);	// KYC書類4フラグ
		$this -> img5Flg			= $this -> getDataPost(PARAM_IMG_5_FLG, true);	// KYC書類5フラグ
		$this -> img6Flg			= $this -> getDataPost(PARAM_IMG_6_FLG, true);	// KYC書類6フラグ
		$this -> img7Flg			= $this -> getDataPost(PARAM_IMG_7_FLG, true);	// KYC書類7フラグ
		$this -> img8Flg			= $this -> getDataPost(PARAM_IMG_8_FLG, true);	// KYC書類8フラグ
		$this -> img9Flg			= $this -> getDataPost(PARAM_IMG_9_FLG, true);	// KYC書類9フラグ
		$this -> img10Flg			= $this -> getDataPost(PARAM_IMG_10_FLG, true);	// KYC書類10フラグ
		$this -> img11Flg			= $this -> getDataPost(PARAM_IMG_11_FLG, true);	// KYC書類11フラグ
		$this -> kycValidateStatus  = $this -> getDataPost('kyc_validate_status', true);
		$this -> setValidateParaments();
		$this -> login2fa           		= $this -> getDataPost('login2fa', true);
		$this -> profile2fa         		= $this -> getDataPost('profile2fa', true);
		$this -> money2fa           		= $this -> getDataPost('money2fa', true);
		$this -> userLink			= $this -> getDataPost(PARAM_USER_LINK, true);	// Mikko 2019 0307
		$this -> userLinkId 		= $this -> getDataPost(PARAM_L_ID, true);			// Mikko 2019 0307
		$this -> riskLevel 			= $this -> getDataPost(PARAM_RISK_LEVELS, true);	// Mikko 2019 0313
		$this -> tierLevel 			= $this -> getDataPost(PARAM_TIER_LEVELS, true);
		$this -> transferFlg 		= $this -> getDataPost(PARAM_TRANSFER_FLG, true);
		$this -> testAccountFlg 	= ($this -> getDataPost(PARAM_TEST_ACCOUNT_FLG)!==NO_STRING)?$this -> getDataPost(PARAM_TEST_ACCOUNT_FLG, true):NO_COUNT;
		// ------------------ 検索系 ------------------//
		$this -> sEmail				= $this -> getDataPost(PARAM_S_EMAIL, true);				// メールアドレス
		$this -> sUserAccount		= $this -> getDataPost(PARAM_S_ACCOUNT, true);			// 口座番号
		$this -> sFrom				= $this -> getDataPost(PARAM_S_FROM, true);				// 開始日
		$this -> sTo				= $this -> getDataPost(PARAM_S_TO, true);					// 終了日
		$this -> sCurrency			= $this -> getDataPost(PARAM_S_CURRENCY, true);			// 通貨
		$this -> sTransactionNumber	= $this -> getDataPost(PARAM_TRANSACTION_NUMBER, true);	// 取引番号
		$this -> sTransactionType	= $this -> getDataPost(PARAM_TRANSACTION_TYPE, true);		// anton

		// ------------------ 検索系 ------------------//
		// ------------------ ページング ------------------//
		$this -> crntPage			= $this -> getDataPost(PARAM_P_CURRENT, true);
		$this -> totalPage			= $this -> getDataPost(PARAM_P_TOTAL, true);
		// ------------------ ページング ------------------//

		$this -> userDepositBypassAccess		= ($this -> getDataPost(PARAM_USER_DEPOSIT_BYPASS_ACCESS) != NULL) ? $this -> getDataPost(PARAM_USER_DEPOSIT_BYPASS_ACCESS, true) : array();
		$this -> userWithdrawBypassAccess		= ($this -> getDataPost(PARAM_USER_WITHDRAW_BYPASS_ACCESS) != NULL) ? $this -> getDataPost(PARAM_USER_WITHDRAW_BYPASS_ACCESS, true) : array();

		$this -> lang = $this -> getLangage();

	}

	/*-------------------------------------------------------------------------
	* @function_name: パラメータの再設定
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function restore() {
		$this -> uId				= $this -> getColumnData($this -> userData, COLUMN_UID);					// UID
		$this -> wlId				= $this -> getColumnData($this -> userData, COLUMN_WL_ID);					// WLID
		$this -> userName			= $this -> getColumnData($this -> userData, COLUMN_USER_NAME);				// ユーザ名
		$this -> accountNumber		= $this -> getColumnData($this -> userData, COLUMN_USER_ACCOUNT);			// 口座番号
		$this -> currency			= $this -> getColumnData($this -> userData, COLUMN_CURRENCY);				// 通貨
		$this -> lastName			= $this -> getColumnData($this -> userData, COLUMN_LAST_NAME);				// 姓
		$this -> firstName			= $this -> getColumnData($this -> userData, COLUMN_FIRST_NAME);				// 名
		$this -> birth				= $this -> getColumnData($this -> userData, COLUMN_BIRTH_STRING);			// 生年月日
		$this -> birthYear			= $this -> getColumnData($this -> userData, COLUMN_BIRTH_YEAR);				// 生年月日（年）
		$this -> birthMonth			= $this -> getColumnData($this -> userData, COLUMN_BIRTH_MONTH);			// 生年月日（月）
		$this -> birthDay			= $this -> getColumnData($this -> userData, COLUMN_BIRTH_DAY);				// 生年月日（日）
		$this -> createTime			= $this -> getColumnData($this -> userData, COLUMN_CREATE_TIME_STRING);		// 登録日時
		$this -> country			= $this -> getColumnData($this -> userData, COLUMN_COUNTRY);				// 国
		$this -> state				= $this -> getColumnData($this -> userData, COLUMN_STATE);					// 都道府県
		$this -> city				= $this -> getColumnData($this -> userData, COLUMN_CITY);					// 市区町村
		$this -> address			= $this -> getColumnData($this -> userData, COLUMN_ADDRESS);				// 番地1
		$this -> address2			= $this -> getColumnData($this -> userData, COLUMN_ADDRESS_2);				// 番地2
		$this -> zipCode			= $this -> getColumnData($this -> userData, COLUMN_ZIP_CODE);				// 郵便番号
		$this -> tel				= $this -> getColumnData($this -> userData, COLUMN_TEL);					// 電話番号
		$this -> agentCode			= $this -> getColumnData($this -> userData, COLUMN_PARENT_AGENT_CODE);		// エージェントコード
		$this -> myAgentCode		= $this -> getColumnData($this -> userData, COLUMN_AGENT_CODE);				// エージェントコード(自分)
		$this -> accountType		= $this -> getColumnData($this -> userData, COLUMN_ACCOUNT_TYPE);			// 口座種別
		$this -> mail				= $this -> getColumnData($this -> userData, COLUMN_MAIL);					// メールアドレス
		$this -> kycFlg				= $this -> getColumnData($this -> userData, COLUMN_KYC_FLG);				// KYCフラグ
		$this -> note				= $this -> getColumnData($this -> userData, COLUMN_NOTE);					// 備考
		$this -> risk				= $this -> getColumnData($this -> userData, COLUMN_RISK);					// 備考
		$this -> crmId				= $this -> getColumnData($this -> userData, COLUMN_CRM_ID);					// CRM ID
		$this -> transferBatchFlg	= $this -> getColumnData($this -> userData, COLUMN_TRANSFER_BATCH_FLG);		// 一括バッチ送金フラグ
		$this -> gpsAccountFlg		= $this -> getColumnData($this -> userData, COLUMN_GPS_ACCOUNT_FLG);		// GPS口座
		$this -> gpsPayments		= $this -> getColumnData($this -> userData, COLUMN_GPS_KIND_OF_PAYMENT);	// GPS決済種別
		$this -> kycValidateStatus 	= $this -> getColumnData($this -> userData, 'kyc_validate_status');
		$this -> riskLevel 			= $this -> getColumnData($this -> userData, COLUMN_RISK_LEVEL);				//Mikko 2019: 3501
		$this -> tierLevel 			= $this -> getColumnData($this -> userData, COLUMN_TIER_LEVEL);				//Mikko 2019: 3501
		$this -> typeOfUsage 		= $this -> getColumnData($this -> userData, COLUMN_TYPE_OF_USAGE);			//使用の種類
		$this -> agreementStatus 	= $this -> getColumnData($this -> userData, COLUMN_AGREEMENT_STATUS);			//使用の種類
		$this -> transferFlg 		= $this -> getColumnData($this -> userData, COLUMN_TRANSFER_FLG);
		$this -> testAccountFlg 	= $this -> getColumnData($this -> userData, COLUMN_TEST_ACCOUNT_FLG);
		// データが存在したら、上書きは行わない
// 		if($this -> status == NO_STRING) {
			$this -> status		= $this -> getColumnData($this -> userData, COLUMN_STATUS);				// 状態
// 		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: サーバ側データチェック
	* @parameter	: なし
	* @return		: TRUE:成功、FALSE:失敗
	-------------------------------------------------------------------------*/
	public function validate() {

		// 変数宣言部
		$rtn		= true;
		$fee		= null;
		$balances	= null;
		$exAmount	= NO_COUNT;
		$total		= NO_COUNT;
		$tmpFee		= NO_COUNT;
		$str		= NO_STRING;

		// ログインチェック
		if(!$this -> checkAdminUserLogin()) {
			throw new Exception(NO_STRING);
		}

		/**
		 *
		 * -- anton --
		 * 04/22/2019
		 *
		 */
		$redirect = ($this -> lang != "en" ? "" : "{$this -> lang}/");

		//check access
		if(!$this -> checkAdminUserAccess('UDTL', array(''))){
			$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_PAGE_ACCESS', array());
			header('Location: /'.$redirect.'menu');
			exit();
		}

		if($this -> getType() == TYPE_INPUT) {
			//check access
			if(!$this -> checkAdminUserAccess('UDTL', array('','1'))){
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_FUNCTION_ACCESS', array());
				header('Location: /'.$redirect.'menu');
				exit();
			}
		}

		if($this -> getType() == TYPE_CARD) {
			//check access
			if(!$this -> checkAdminUserAccess('RCRD', array('','1'))){
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_FUNCTION_ACCESS', array());
				header('Location: /'.$redirect.'menu');
				exit();
			}
		}


		if($this -> getType() == TYPE_REMOVE_CARD) {
			//check access
			if(!$this -> checkAdminUserAccess('RCRD', array('','2'))){
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_FUNCTION_ACCESS', array());
				header('Location: /'.$redirect.'menu');
				exit();
			}
		}

		if($this -> getType() == TYPE_SAVE) {
			//check access
			if(!$this -> checkAdminUserAccess('RCLM', array('','1'))){
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_FUNCTION_ACCESS', array());
				header('Location: /'.$redirect.'menu');
				exit();
			}
		}

		if($this -> getType() == TYPE_SAVE_RISK) {
			//check access
			if(!$this -> checkAdminUserAccess('RRMK', array('','1'))){
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_FUNCTION_ACCESS', array());
				header('Location: /'.$redirect.'menu');
				exit();
			}
		}

		if($this -> getType() == TYPE_ADMIN_KYC_UPLOAD || $this -> getType() == TYPE_ROLL_BACK) {
			//check access
			if(!$this -> checkAdminUserAccess('KYCD', array('','1','3'))){
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_FUNCTION_ACCESS', array());
				header('Location: /'.$redirect.'menu');
				exit();
			}
		}

		if($this -> getType() == TYPE_INPUT_ACCESS || $this -> getType() == TYPE_SAVE_ACCESS) {
			//check access
			if(!$this -> checkAdminUserAccess('PSCA', array('','1'))){
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_FUNCTION_ACCESS', array());
				header('Location: /'.$redirect.'menu');
				exit();
			}
		}
		// Mikko 2019 0307 start
		if($this -> getType() == TYPE_LINK_ACCOUNT) {
			//check access
			if(!$this -> checkAdminUserAccess('ACLK', array('','1'))){

				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_FUNCTION_ACCESS', array());
				header('Location: /'.$redirect.'menu');
				exit();
			}
		}

		if($this -> getType() == TYPE_REMOVE_LINK) {
			//check access
			if(!$this -> checkAdminUserAccess('ACLK', array('','2'))){
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_FUNCTION_ACCESS', array());
				header('Location: /'.$redirect.'menu');
				exit();
			}
		}
		// Mikko 2019 0307 end

		if($this -> getType() == TYPE_COMPLETE) {		// ユーザデータ更新時

			if($this -> status == VAR_ACCOUNT_STATUS_INVALID) {				// 無効ステータスへは変更できない
				$str = $this -> getValueByList($this -> getStatusList(), VAR_ACCOUNT_STATUS_INVALID);

				$this -> popUpSessionMessage(ERROR, 'E_DONT_CHANGE', array(VAL_STR_STATUS, $str));
				$this -> setType(TYPE_INPUT);

			} else if($this -> status != $this -> oldStatus
						&& $this -> status == VAR_ACCOUNT_STATUS_DELETE) {	// ステータスが閉鎖の場合は金額を徴収
				// 口座残高を取得する
				$balances = $this -> getBalanceListCommon($this -> detailAccount);

				if($this -> isLoopData($balances)) {

					foreach($balances as $currency => $amount) {
						$exAmount	= $this -> getExchangeCommon($amount, $currency, USD);
						$total		+= $this -> intToCurrency($exAmount[PARAM_AMOUNT], USD);
					}
				}

				$fee = $this -> getFeeCommon(VAR_DELETE
											, NO_COUNT
											, $this -> detailAccount
											, USD);
				$this -> fee = $fee[$this -> detailAccount . VAL_INT_1];

				// 口座にお金がなかったら閉鎖できない
				if($this -> fee > $total) {
					$this -> popUpSessionMessage(ERROR, 'E_INSUFFICIENT_FUNDS', array(USD, $this -> formatCurrency($this -> fee, USD)));
					$rtn = false;
				} else {

					// 手数料の振り分け
					$total	= NO_COUNT;
					$tmpFee	= $this -> fee;
					foreach($balances as $currency => $amount) {

						// USDに変換
						$exAmount	= $this -> getExchangeCommon($amount, $currency, USD);
						$exAmount	= $this -> intToCurrency($exAmount[PARAM_AMOUNT], USD);

						if($exAmount > $tmpFee) {

							// 手数料を逆換算
							$exAmount	= $this -> getExchangeCommon($tmpFee, USD, $currency);
							$exAmount	= $exAmount[PARAM_AMOUNT];

							$this -> fees[$currency] = $exAmount;
							break;
						} else {

							// 手数料を逆換算
							$exAmount	= $this -> getExchangeCommon($tmpFee, USD, $currency);
							$exAmount	= $this -> intToCurrency($exAmount[PARAM_AMOUNT], $currency);

							// 全部もらう
							$this -> fees[$currency] = $amount;

							// 残り
							$tmpFee -= $exAmount;
						}
					}
				}

				if(!$rtn) {
					$this -> setType(TYPE_INPUT);
				}
			}
			//Mikko 2019 0307 start
		} else if($this -> getType() == TYPE_LINK_ACCOUNT) {

			$numbers = $this -> userLink;

			if($this -> isLoopData($numbers)){

				foreach($numbers as $val){
					//check if it's own account
					if($val == $this -> detailAccount){
			   			$this -> msg2 .= $this -> getMessage(ERROR, 'E_ERROR_LINK_OWN_ACOUNT', array(VAL_STR_USER_ACCOUNT));
						$rtn = false;
					}

					//check if account number field is empty
					if(!$this -> checkNull($val)) {
			   			$this -> msg2 .= $this -> getMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_USER_ACCOUNT));
			   			$rtn = false;
					}

					// check if account number submitted exists
					if($val != NULL){
						if(!$this -> checkExistAccount($val)) {
						   	$this -> msg2 .= $this -> getMessage(ERROR, 'E_ERROR_NOT_EXIST', array(VAL_STR_USER_ACCOUNT));
							$rtn = false;
						}
					}

					//check if accounts are already linked
					if($this -> existUserLink($val, $this -> detailAccount)) {
			   			$this -> msg2 .= $this -> getMessage(ERROR, 'E_ERROR_LINK_ALREADY_EXIST', array(VAL_STR_USER_ACCOUNT));
						$rtn = false;
					}
				}

			}

			if(!$rtn) {
				$this -> setType(NO_STRING);
			}
			//Mikko 2019 0307 end
		} else if($this -> getType() == TYPE_CARD) {	// ユーザデータ更新時

			// カードホルダーIDのチェック
			if(!$this -> checkNull($this -> cardHolderId)) {
				$this -> msg .= $this -> getMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_CARD_HOLDER_ID));
				$rtn = false;
			}

			if(!$this -> checkStringNumberOnly($this -> cardHolderId)) {
				$this -> msg .= $this -> getMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_CARD_HOLDER_ID));
				$rtn = false;
			}

			if($this -> existCardHolderId($this -> cardHolderId)) {
				$this -> msg .= $this -> getMessage(ERROR, 'E_NO_SUCH_ANYTHING_DATA', array(VAL_STR_CARD_HOLDER_ID, $this -> cardHolderId));
				$rtn = false;
			}

			// 下4桁のチェック
// 			if(!$this -> checkNull($this -> cardHolderId)) {
// 				$this -> msg .= $this -> getMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_CARD_HOLDER_ID));
// 				$rtn = false;
// 			}

// 			if(!$this -> checkStringNumberOnly($this -> digit)) {
// 				$this -> msg .= $this -> getMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_CARD_DIGIT));
// 				$rtn = false;
// 			}

// 			if(!$this -> checkLength($this -> digit
// 										, VAL_INT_4
// 										, VAL_INT_4)) {
// 				$this -> msg .= $this -> getMessage(ERROR, 'E_ERROR_STRING_LENGTH_ANY', array(VAL_STR_CARD_DIGIT
// 																								, VAL_INT_4
// 																								, VAL_INT_4));

// 				$rtn = false;
// 			}

			// エラーの場合
			if(!$rtn) {
				$this -> setType(NO_STRING);
			}
		} else if($this -> getType() == TYPE_ADMIN_KYC_UPLOAD) {	// KYCアップロード前のチェック

			// ユーザデータの取得
			$account = $this -> getAccountCommon($this -> detailAccount);
			$account = $this -> getRowData($account);

			// 州・都道府県
			// 市区町村
			// 住所
			// 郵便番号
			// 電話番号が空欄の場合はデータの転送
			if($this -> getColumnData($account, PARAM_STATE)		== NO_STRING
				|| $this -> getColumnData($account, PARAM_CITY)		== NO_STRING
				|| $this -> getColumnData($account, PARAM_ADDRESS)	== NO_STRING
				|| $this -> getColumnData($account, PARAM_ZIP_CODE)	== NO_STRING
				|| $this -> getColumnData($account, PARAM_TEL)		== NO_STRING) {
				$this -> popUpSessionMessage(WARNING, 'W_NOT_ADDRESS', array());

				$this -> setType();
			}

		} else if($this -> getType() == TYPE_ADMIN_KYC_UPLOAD_COMPLETE) {			// KYC登録

			// 画像1がアップロードされている
			if($this -> isUpload(PARAM_IMG1)) {

				$f = $_FILES[PARAM_IMG1];

				// 拡張子のチェック
				if(!$this -> checkStringExtension($f[PARAM_NAME])) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_FILE_FORMAT', array());
					$rtn = false;
				}

				// ファイルサイズ
				if(filesize($f[PARAM_TMP_NAME]) > 5242880) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_UPLOAD_SIZE', array());
					$rtn = false;
				}
			}


			// 画像2がアップロードされている
			if($this -> isUpload(PARAM_IMG2)) {

				$f = $_FILES[PARAM_IMG2];

				// 拡張子のチェック
				if(!$this -> checkStringExtension($f[PARAM_NAME])) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_FILE_FORMAT', array());
					$rtn = false;
				}

				// ファイルサイズ
				if(filesize($f[PARAM_TMP_NAME]) > 5242880) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_UPLOAD_SIZE', array());
					$rtn = false;
				}
			}

			// 画像3がアップロードされている
			if($this -> isUpload(PARAM_IMG3)) {

				$f = $_FILES[PARAM_IMG3];

				// 拡張子のチェック
				if(!$this -> checkStringExtension($f[PARAM_NAME])) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_FILE_FORMAT', array());
					$rtn = false;
				}

				// ファイルサイズ
				if(filesize($f[PARAM_TMP_NAME]) > 5242880) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_UPLOAD_SIZE', array());
					$rtn = false;
				}
			}

			// 画像4がアップロードされている
			if($this -> isUpload(PARAM_IMG4)) {

				$f = $_FILES[PARAM_IMG4];

				// 拡張子のチェック
				if(!$this -> checkStringExtension($f[PARAM_NAME])) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_FILE_FORMAT', array());
					$rtn = false;
				}

				// ファイルサイズ
				if(filesize($f[PARAM_TMP_NAME]) > 5242880) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_UPLOAD_SIZE', array());
					$rtn = false;
				}
			}

			// 画像5がアップロードされている
			if($this -> isUpload(PARAM_IMG5)) {

				$f = $_FILES[PARAM_IMG5];

				// 拡張子のチェック
				if(!$this -> checkStringExtension($f[PARAM_NAME])) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_FILE_FORMAT', array());
					$rtn = false;
				}

				// ファイルサイズ
				if(filesize($f[PARAM_TMP_NAME]) > 5242880) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_UPLOAD_SIZE', array());
					$rtn = false;
				}
			}

			// 画像6がアップロードされている
			if($this -> isUpload(PARAM_IMG6)) {

				$f = $_FILES[PARAM_IMG6];

				// 拡張子のチェック
				if(!$this -> checkStringExtension($f[PARAM_NAME])) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_FILE_FORMAT', array());
					$rtn = false;
				}

				// ファイルサイズ
				if(filesize($f[PARAM_TMP_NAME]) > 5242880) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_UPLOAD_SIZE', array());
					$rtn = false;
				}
			}

			// 画像6がアップロードされている
			if($this -> isUpload(PARAM_IMG7)) {

				$f = $_FILES[PARAM_IMG7];

				// 拡張子のチェック
				if(!$this -> checkStringExtension($f[PARAM_NAME])) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_FILE_FORMAT', array());
					$rtn = false;
				}

				// ファイルサイズ
				if(filesize($f[PARAM_TMP_NAME]) > 5242880) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_UPLOAD_SIZE', array());
					$rtn = false;
				}
			}

			// 画像6がアップロードされている
			if($this -> isUpload(PARAM_IMG8)) {

				$f = $_FILES[PARAM_IMG8];

				// 拡張子のチェック
				if(!$this -> checkStringExtension($f[PARAM_NAME])) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_FILE_FORMAT', array());
					$rtn = false;
				}

				// ファイルサイズ
				if(filesize($f[PARAM_TMP_NAME]) > 5242880) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_UPLOAD_SIZE', array());
					$rtn = false;
				}
			}

			// 画像6がアップロードされている
			if($this -> isUpload(PARAM_IMG9)) {

				$f = $_FILES[PARAM_IMG9];

				// 拡張子のチェック
				if(!$this -> checkStringExtension($f[PARAM_NAME])) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_FILE_FORMAT', array());
					$rtn = false;
				}

				// ファイルサイズ
				if(filesize($f[PARAM_TMP_NAME]) > 5242880) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_UPLOAD_SIZE', array());
					$rtn = false;
				}
			}

			// 画像6がアップロードされている
			if($this -> isUpload(PARAM_IMG10)) {

				$f = $_FILES[PARAM_IMG10];

				// 拡張子のチェック
				if(!$this -> checkStringExtension($f[PARAM_NAME])) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_FILE_FORMAT', array());
					$rtn = false;
				}

				// ファイルサイズ
				if(filesize($f[PARAM_TMP_NAME]) > 5242880) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_UPLOAD_SIZE', array());
					$rtn = false;
				}
			}

			// 画像6がアップロードされている
			if($this -> isUpload(PARAM_IMG11)) {

				$f = $_FILES[PARAM_IMG11];

				// 拡張子のチェック
				if(!$this -> checkStringExtension($f[PARAM_NAME])) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_FILE_FORMAT', array());
					$rtn = false;
				}

				// ファイルサイズ
				if(filesize($f[PARAM_TMP_NAME]) > 5242880) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_UPLOAD_SIZE', array());
					$rtn = false;
				}
			}

			if(!$rtn) {
				$this -> setType(TYPE_ADMIN_KYC_UPLOAD);
			}
		}
	}

	public function setValidateParaments(){
		$this -> arrValidate[] = VAR_KYC_VALIDATE_STATUS_1;
		$this -> arrValidate[] = VAR_KYC_VALIDATE_STATUS_2;
		$this -> arrValidate[] = VAR_KYC_VALIDATE_STATUS_3;
		$this -> arrValidate[] = VAR_KYC_VALIDATE_STATUS_4;
		$this -> arrValidate[] = VAR_KYC_VALIDATE_STATUS_5;
		$this -> arrValidate[] = VAR_KYC_VALIDATE_STATUS_6;
		$this -> arrValidate[] = VAR_KYC_VALIDATE_STATUS_7;
		$this -> arrValidate[] = VAR_KYC_VALIDATE_STATUS_8;
		$this -> arrValidate[] = VAR_KYC_VALIDATE_STATUS_9;
		$this -> arrValidate[] = VAR_KYC_VALIDATE_STATUS_10;
		$this -> arrValidate[] = VAR_KYC_VALIDATE_STATUS_11;
		$this -> arrValidate[] = VAR_KYC_VALIDATE_STATUS_12;
		$this -> arrValidate[] = VAR_KYC_VALIDATE_STATUS_13;
		$this -> arrValidate[] = VAR_KYC_VALIDATE_STATUS_14;
		$this -> arrValidate[] = VAR_KYC_VALIDATE_STATUS_15;
		$this -> arrValidate[] = VAR_KYC_VALIDATE_STATUS_16;
		$this -> arrValidate[] = VAR_KYC_VALIDATE_STATUS_17;
		$this -> arrValidate[] = VAR_KYC_VALIDATE_STATUS_18;
		$this -> arrValidate[] = VAR_KYC_VALIDATE_STATUS_19;
		$this -> arrValidate[] = VAR_KYC_VALIDATE_STATUS_20;
		$this -> arrValidate[] = VAR_KYC_VALIDATE_STATUS_21;
	}

	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function dispHTML() {
		return array();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 通貨のバランスデータの設定
	* @parameter	: 結果セット
	* @return		: なし
	-------------------------------------------------------------------------*/
	function setBalances($rs) {
		$this -> balances = $rs;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 通貨データの設定
	* @parameter	: 通貨データ
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function setCurrencies($rs) {
		$this -> currencies = $rs;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 通貨データの取得
	* @return		: 通貨データ
	-------------------------------------------------------------------------*/
	public function getCurrencies() {
		return $this -> currencies;
	}

	/*-------------------------------------------------------------------------
	* @function_name: カードデータの設定
	* @parameter	: カードデータ一覧
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function setCards($rs) {
		$this -> cards = $rs;
	}

	/*------------------------Mikko 2019 0301---------------------------------------
	* @function_name:
	* @parameter	:
	* @return		:
	-------------------------------------------------------------------------*/
	public function setLinkUser($rs) {
		$this -> linkAccount = $rs;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 履歴データの設定
	* @parameter	: 履歴データ
	* @return		: なし
	/-------------------------------------------------------------------------*/
	 /* anton
	 -------------------------------------------------------------------------*/
	public function setHistory($ccy, $rs, $count) {
		$this -> historyCount[$ccy] = $count;
		if($this -> isLoopData($rs)) {

			// まずはデータを詰め替える
			foreach($rs as $row) {

				// 初期化
				$tType			= NO_STRING;
				$wAmount		= NO_STRING;
				$dAmount		= NO_STRING;
				$dStatus		= NO_STRING;
				$fee			= NO_STRING;
				$account		= NO_STRING;
				$accountName	= NO_STRING;
				$dispTotal		= NO_STRING;
				$tmpRow			= array();

				// 初期値
				$tmpRow[COLUMN_TRANSACTION_TIME_STRING]	= $this -> getColumnData($row, COLUMN_TRANSACTION_TIME_STRING);
				$tmpRow[COLUMN_PROCESS_TIME_STRINTG]	= $this -> getColumnData($row, COLUMN_PROCESS_TIME_STRINTG);
				$tmpRow[COLUMN_TRANSACTION_NUMBER]		= $this -> getColumnData($row, COLUMN_TRANSACTION_NUMBER);
				$tmpRow[COLUMN_MESSAGE]					= $this -> getColumnData($row, COLUMN_MESSAGE);
				$tmpRow[COLUMN_METHOD]					= $this -> getColumnData($row, COLUMN_METHOD);
				if(intval($this -> getColumnData($row, COLUMN_ACCOUNT_NUMBER)) > NO_COUNT) {
					$tmpRow[COLUMN_USER_ACCOUNT]		= $this -> getColumnData($row, COLUMN_ACCOUNT_NUMBER);
				} else {
					$tmpRow[COLUMN_USER_ACCOUNT]		= NO_STRING;
				}
				$tmpRow[COLUMN_ACCOUNT_NAME]			= $this -> getColumnData($row, COLUMN_ACCOUNT_NAME);
				$tmpRow[COLUMN_DEPOSIT_AMOUNT]			= $this -> getColumnData($row, COLUMN_DEPOSIT_AMOUNT);
				$tmpRow[COLUMN_WITHDRAW_AMOUNT]			= $this -> getColumnData($row, COLUMN_WITHDRAW_AMOUNT);
				$tmpRow[COLUMN_FEE]						= $this -> getColumnData($row, COLUMN_FEE);
				$tmpRow[COLUMN_BALANCE]					= $this -> getColumnData($row, COLUMN_BALANCE);

				//  anton


				// 処理種別
				if($this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)		== VAL_INT_1) {					// 入金
					$tType 		= VAL_STR_DEPOSIT;
					$dStatus	= VAL_STR_STATUS_COMP;

				} else if($this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)	== VAL_INT_2
				&& $this -> getColumnData($row, COLUMN_TYPE)		== VAR_WITHDRAW_TYPE_NORMAL) {		// 通常出金

							$tType		= VAL_STR_WITHDARAW.'（' . $this -> dispWithdrawStatusCommon($this -> getColumnData($row, COLUMN_STATUS)) . '）';
							$dStatus	= $this -> dispWithdrawStatusCommon($this -> getColumnData($row, COLUMN_STATUS));

				} else if($this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)	== VAL_INT_2
				&& $this -> getColumnData($row, COLUMN_TYPE)		== VAR_WITHDRAW_TYPE_FEE) {			// 手数料出金
							$tType		= VAL_STR_FEE;
							$dStatus	= VAL_STR_STATUS_COMP;

				} else if($this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)	== VAL_INT_2
				&& $this -> getColumnData($row, COLUMN_TYPE)		== VAR_WITHDRAW_TYPE_TRANSFER) {			// 口座間送金出金

							$tType		= VAL_STR_TRANSFER_TRASH;
							$dStatus	= VAL_STR_STATUS_COMP;

				} else if($this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)	== VAL_INT_3) {						// 両替入金

					$tType		= VAL_STR_EXCHANGE;
					$dStatus	= VAL_STR_STATUS_COMP;

				} else if($this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)	== VAL_INT_4) {						// 両替出金

					$tType		= VAL_STR_EXCHANGE;
					$dStatus	= VAL_STR_STATUS_COMP;

				} else if($this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)	== VAL_INT_5) {						// 口座振替（出金）

					$tType 		= VAL_STR_TRANSFER;
					$dStatus	= VAL_STR_STATUS_COMP;

				} else if($this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)	== VAL_INT_6) {					// 口座振替（出金）

					$tType 		= VAL_STR_TRANSFER;
					$dStatus	= VAL_STR_STATUS_COMP;

				} else if($this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)	== VAL_INT_7) {					// 引落（出金）

					$tType 		= VAL_STR_REQUEST;
					$dStatus	= VAL_STR_STATUS_COMP;

				} else if($this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)	== VAL_INT_8) {					// 引落（入金）

					$tType 		= VAL_STR_REQUEST;
					$dStatus	= VAL_STR_STATUS_COMP;
				} else if($this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)			== VAL_INT_9
							|| $this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)	== VAL_INT_10
							|| $this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)	== VAL_INT_12) {		// 出金（返却系）

							$tType 		= VAL_STR_WITHDARAW.'（' . $this -> dispWithdrawStatusCommon($this -> getColumnData($row, COLUMN_STATUS)) . '）';
							$dStatus	= VAL_STR_STATUS_COMP;

				} else if($this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)	== VAL_INT_11) {		// 出金（返却系）

					$tType 		= VAL_STR_FEE;
					$dStatus	= VAL_STR_STATUS_COMP;

				} else {
					$tType = NO_STRING;
				}

				// 処理ステータス
				if($this -> getColumnData($row, COLUMN_PROCESS_STATUS) == NO_COUNT) {			// ユーザ側操作
					$pStatus = 'User';
				} else if($this -> getColumnData($row, COLUMN_PROCESS_STATUS) == VAL_INT_1) {	// 管理者側操作
					$pStatus = 'Admin';
				} else if($this -> getColumnData($row, COLUMN_PROCESS_STATUS) == VAL_INT_2) {	// API操作
					$pStatus = 'API';
				} else if($this -> getColumnData($row, COLUMN_PROCESS_STATUS) == VAL_INT_3) {	// API操作
					$pStatus = 'Batch';
				} else {
					$pStatus = '&nbsp;';
				}

				$tmpRow[COLUMN_TYPE]			= $tType;
				$tmpRow[COLUMN_STATUS]			= $dStatus;
				$tmpRow[COLUMN_TOTAL]			= $dispTotal;
				$tmpRow[COLUMN_PROCESS_STATUS]			= $pStatus;

				// データが存在したら挿入
				$lists[] = $tmpRow;
			}
		} else {
			return;
		}

		$this -> history[$ccy] = $lists;
	}

	//set history count
	public function setHistoryCount($currency, $count)
	{
		$this -> historyCount[$currency] = $count;
	}

	//get history count
	public function getHistoryCount($currency)
	{
		return $this -> historyCount[$currency];
	}

	/*-------------------------------------------------------------------------
	* @function_name: ユーザ詳細データ
	* @parameter	: 結果セット
	* @return		: なし
	-------------------------------------------------------------------------*/
	function setUserDetail($rs) {
		$this -> userData = $rs[NO_COUNT];
	}

	/*-------------------------------------------------------------------------
	* @function_name: ユーザ詳細データ
	* @parameter	: 結果セット
	* @return		: なし
	-------------------------------------------------------------------------*/
	function setLoginLock($rs) {
		$this -> loginLock = $this -> getRowData($rs);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 決済セットの設定（口座一覧）
	* @parameter	: 結果セット
	* @return		: なし
	-------------------------------------------------------------------------*/
	function dispBalances() {

		// 変数宣言部
		$lists	= array();
		$rtn	= NO_STRING;

		// データを入れ替える
		if($this -> isLoopData($this -> balances)) {

			foreach($this -> balances as $row) {
				$lists[$this -> getColumnData($row, COLUMN_CURRENCY)] = $row;
			}
		}

		if($this -> isLoopData($this -> currencies)) {

			// データの数だけループを回す
			foreach($this -> currencies as $row) {

				$currency	= $this -> getColumnData($row, COLUMN_CURRENCY_NAME);
				$data		= $this -> getColumnData($lists, $currency);
				$amount		= NO_COUNT;

				// データを生成
				if($data == NO_STRING) {	// データが無い
					$amount = number_format($this -> intToCurrency(NO_COUNT, $currency), $this -> getDigitCount($currency));
				} else {
					$amount = number_format($this -> intToCurrency($this -> getColumnData($data, COLUMN_BALANCE), $currency), $this -> getDigitCount($currency));
				}

				$rtn .= '<li>' . $currency . ': ' . $amount . '</li>';
			}

		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座履歴の取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispHistoryList() {
		// 変数宣言部
		$rtn				= NO_STRING;
		$count 				= $this -> historyCount;

		// anton

		$acchistory = VAL_STR_ACCOUNT_HISTORY;
		if($count) {
			// データの作成
			foreach($count as $currency => $total) {
				if ($total > 0) {
					// タイトル部
					$rtn	.= '<div class="caption" data-toggle="collapse" href="#' . $currency . '" aria-expanded="true" aria-controls="' . $currency . '">'
							. '<span>' . $currency . $acchistory . '</span>'
							. '<i class="icontop" aria-hidden="true"></i>'
							. '</div>'
							. '<div class="t_collapse_box collapse" id="' . $currency . '" aria-expanded="true">'
								. '<div id="tbl_' . $currency . '">'
								. $this -> createTable($currency)
								. '</div>'
								. $this -> dispPager($total, $currency)
							. '</div><br>';
				}
			}
		}

		echo $rtn;

	}

	/*-------------------------------------------------------------------------
	* @function_name: エクスポートデータの作成
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function makeExportData() {

		// 変数宣言部
		$data				= NO_STRING;
		$arr				= null;
		$intermediaryFlg	= NO_STRING;

		// まずはタイトル


		$data = ($this -> lang == "en" ? 'Transaction Type,Account Number,Account Name,Currency,Deposit Amount,Withdrawal Amount,Fee,Date Requested,Processing Date,Transaction Number,Message,Type,Current Status,Balance' . "\n" :
			'取引種別, 口座番号, 口座名義, 通貨種別, 入金額, 出金額, 手数料, 申請日, 処理日, 取引番号	, メッセージ, 種別, 状態, 残高'."\n");

		// データの存在確認
		if($this -> isLoopData($this -> history)) {

			foreach($this -> history as $currency => $rows) {

				foreach($rows as $row) {
					// 配列の初期化
					$arr = array();

					// データの設定
					$arr[] = $row[COLUMN_TYPE];						// (01)Transaction type
					$arr[] = $row[COLUMN_USER_ACCOUNT];				// (02)Account number
					$arr[] = $row[COLUMN_ACCOUNT_NAME];				// (03)Account holder
					$arr[] = $currency;								// (04)Currency
					$arr[] = $row[COLUMN_DEPOSIT_AMOUNT];			// (05)Payment amount
					$arr[] = $row[COLUMN_WITHDRAW_AMOUNT];			// (06)Withdrawal amount
					$arr[] = $row[COLUMN_FEE];						// (07)Fee
					$arr[] = $row[COLUMN_TRANSACTION_TIME_STRING];	// (08)Application date
					$arr[] = $row[COLUMN_PROCESS_TIME_STRINTG];		// (09)Disposal day
					$arr[] = $row[COLUMN_TRANSACTION_NUMBER];		// (10)Transition Number
					$arr[] = ($row[COLUMN_MESSAGE] != NULL) ? $row[COLUMN_MESSAGE] : $row[COLUMN_METHOD];					// (11)message
					$arr[] = $row[COLUMN_PROCESS_STATUS];
					$arr[] = $row[COLUMN_STATUS];					// (12)State
					$arr[] = $this -> formatCurrency($row[COLUMN_BALANCE], $currency);								// (13)Balance

					$data .= '"'. implode('"' . DELIMIT_COMMA . '"', $arr) . '"' . "\n";
				}
			}
		}

		return mb_convert_encoding($data, "UTF-8");
	}

	function getWhere($currency) {
		$rtn = array();

		$rtn[] = $this -> detailAccount;
		$rtn[] = $currency;
		$whereStr = NO_STRING;
		// 取引番号
		if($this -> sTransactionNumber != NO_STRING) {
			$whereStr .= ' AND trans.transaction_number = (\')' . $this -> sTransactionNumber . '(\')';
		}
		// メールアドレス
		if($this -> sEmail != NO_STRING) {
			$whereStr .= ' AND (withdraw_user.mail LIKE (\')%' . $this -> sEmail . '%(\') OR deposit_user.mail LIKE (\')%' . $this -> sEmail . '%(\'))';
		}
		// 口座番号
		if($this -> sUserAccount != NO_STRING) {
			$whereStr .= ' AND (trans.deposit_account_number = (\')' . $this -> sUserAccount . '(\') OR trans.withdraw_account_number = (\')' . $this -> sUserAccount . '(\'))';
		}

		// 開始日
		if($this -> sFrom != NO_STRING) {
			$whereStr .= ' AND transaction_time >= (\')' . $this -> sFrom . '(\')';
		} else {
			$whereStr .= ' AND transaction_time >= (\')' . date('Y/m/01', strtotime('-2 month')) . '(\')';
		}
		// 終了日
		if($this -> sTo != NO_STRING) {
			$whereStr .= ' AND transaction_time < DATE_ADD((\')' . $this -> sTo . '(\'), INTERVAL 1 DAY)';
		} else {
			$whereStr .= ' AND transaction_time < DATE_ADD((\')' . date('Y/m/d') . '(\'), INTERVAL 1 DAY)';
		}

		// anton
		if($this -> sTransactionType != NO_STRING) {
			switch($this -> sTransactionType){
				case VAL_INT_1:
					$whereStr .= ' AND trans.transaction_type = (\')1(\')';					// 入金
					break;
				case VAL_INT_2:
					$whereStr .= ' AND (trans.transaction_type IN ((\')9(\'), (\')10(\'), (\')12(\')) OR (trans.transaction_type = (\')2(\') AND trans.type = (\')0(\')))';	// 出金
					break;
				case VAL_INT_3:
					$whereStr .= ' AND trans.transaction_type IN ((\')3(\'), (\')4(\'))';					// 通貨両替
					break;
				case VAL_INT_4:
					$whereStr .= ' AND (trans.transaction_type IN ((\')5(\'), (\')6(\')) OR (trans.transaction_type = (\')2(\') AND trans.type = (\')3(\')))';				// 口座振替
					break;
				case VAL_INT_5:
					$whereStr .= ' AND trans.transaction_type IN ((\')7(\'), (\')8(\'))';					// 引き落し
					break;
				case VAL_INT_6:
					$whereStr .= ' AND (trans.transaction_type = (\')11(\') OR trans.type = (\')1(\'))';					// 引き落し
					break;
				default:
					break;
			}

		}

		$rtn[] = $whereStr;

		return $rtn;
	}

	//without currency for where condition
	function getCondition()
	{
		$rtn = array();

		$rtn[] = $this -> detailAccount;

		$whereStr = NO_STRING;
		// 取引番号
		if($this -> sTransactionNumber != NO_STRING) {
			$whereStr .= ' AND trans_in.transaction_number = (\')' . $this -> sTransactionNumber . '(\')';
		}
		// メールアドレス
		if($this -> sEmail != NO_STRING) {
			$whereStr .= ' AND (withdraw_user.mail LIKE (\')%' . $this -> sEmail . '%(\') OR deposit_user.mail LIKE (\')%' . $this -> sEmail . '%(\'))';
		}
		// 口座番号
		if($this -> sUserAccount != NO_STRING) {
			$whereStr .= ' AND (trans_in.deposit_account_number = (\')' . $this -> sUserAccount . '(\') OR trans_in.withdraw_account_number = (\')' . $this -> sUserAccount . '(\'))';
		}

		// 開始日
		if($this -> sFrom != NO_STRING) {
			$whereStr .= ' AND transaction_time >= (\')' . $this -> sFrom . '(\')';
		} else {
			$whereStr .= ' AND transaction_time >= (\')' . date('Y/m/01', strtotime('-2 month')) . '(\')';
		}
		// 終了日
		if($this -> sTo != NO_STRING) {
			$whereStr .= ' AND transaction_time < DATE_ADD((\')' . $this -> sTo . '(\'), INTERVAL 1 DAY)';
		} else {
			$whereStr .= ' AND transaction_time < DATE_ADD((\')' . date('Y/m/d') . '(\'), INTERVAL 1 DAY)';
		}

		// anton
		if($this -> sTransactionType != NO_STRING) {
			switch($this -> sTransactionType){
				case VAL_INT_1:
					$whereStr .= ' AND trans_in.transaction_type = (\')1(\')';					// 入金
					break;
				case VAL_INT_2:
					$whereStr .= ' AND (trans_in.transaction_type IN ((\')9(\'), (\')10(\'), (\')12(\')) OR (trans_in.transaction_type = (\')2(\') AND trans_in.type = (\')0(\')))';	// 出金
					break;
				case VAL_INT_3:
					$whereStr .= ' AND trans_in.transaction_type IN ((\')3(\'), (\')4(\'))';					// 通貨両替
					break;
				case VAL_INT_4:
					$whereStr .= ' AND (trans_in.transaction_type IN ((\')5(\'), (\')6(\')) OR (trans_in.transaction_type = (\')2(\') AND trans_in.type = (\')3(\')))';				// 口座振替
					break;
				case VAL_INT_5:
					$whereStr .= ' AND trans_in.transaction_type IN ((\')7(\'), (\')8(\'))';					// 引き落し
					break;
				case VAL_INT_6:
					$whereStr .= ' AND (trans_in.transaction_type = (\')11(\') OR trans_in.type = (\')1(\'))';					// 引き落し
					break;
				default:
					break;
			}

		}

		$rtn[] = $whereStr;

		return $rtn;
	}

	function dispPaging() {
		$currency = array_keys($this -> historyCount)[0];
		echo $this -> createTable($currency);
	}

	function createTable($currency) {

		$lists = $this -> history;

		$titleData = '<tr>'
				. '<th class="w5p">&nbsp;</th>'
				. '<th class="w7p">'.VAL_STR_HEADER_TRANSACTION_TYPE.'</th>'
				. '<th class="w7p">'.VAL_STR_USER_ACCOUNT.'</th>'
				. '<th class="w10p">'.VAL_STR_USER_ACCOUNT_NAME.'</th>'
				. '<th class="w7p">'.VAL_DEPOSIT_AMOUNT.'</th>'
				. '<th class="w7p">'.VAL_WITHDRAWAL_AMOUNT.'</th>'
				. '<th class="w7p">'.VAL_STR_FEE.'</th>'
				. '<th class="w7p">'.VAL_STR_DATE_REQUESTED.'</th>'
				. '<th class="w7p">'.VAL_STR_PROCESSING_DATE.'</th>'
				. '<th class="w7p">'.VAL_STR_TRANSACTION_NUMBER.'</th>'
				. '<th class="w15p">'.VAL_STR_MESSAGE.'</th>'
				. '<th class="w7p">'.VAL_STR_TYPE.'</th>'
				. '<th class="w5p">'.VAL_STR_CURRENT_STATUS.'</th>'
				. '<th class="w7p">'.VAL_STR_HEADER_BALANCE.'</th>'
			. '</tr>';

			if(isset($lists[$currency])) {

				// データの数だけループを回す
				$no			= 1;
				$rowData	= NO_STRING;
				$total		= NO_COUNT;

				foreach($lists[$currency] as $data) {

					$total		= $this -> getColumnData($data, COLUMN_BALANCE);
					$dispTotal	= $currency . ' ' . $this -> formatCurrency($total, $currency);
					$deposit	= NO_STRING;
					$withdraw	= NO_STRING;

					if($this -> getColumnData($data, COLUMN_DEPOSIT_AMOUNT) != NO_STRING) {
						$deposit = $currency . DELIMIT_SPACE . $this -> formatCurrency(floatval($this -> getColumnData($data, COLUMN_DEPOSIT_AMOUNT)), $currency);
					}

					if($this -> getColumnData($data, COLUMN_WITHDRAW_AMOUNT) != NO_STRING) {
						$withdraw = $currency . DELIMIT_SPACE . $this -> formatCurrency(floatval($this -> getColumnData($data, COLUMN_WITHDRAW_AMOUNT)), $currency);
					}

					//set user account link
					$userAccountLink = (strlen($this -> getColumnData($data, COLUMN_USER_ACCOUNT) > 0)) ? '<a href="account_edit?detail_account=' . $this -> getColumnData($data, COLUMN_USER_ACCOUNT) . '">'. $this -> getColumnData($data, COLUMN_USER_ACCOUNT) .'</a>' : '';

					//return message if not empty else method
					$message = ($this -> getColumnData($data, COLUMN_MESSAGE) != NULL) ? $this -> getColumnData($data, COLUMN_MESSAGE) : $this -> getColumnData($data, COLUMN_METHOD);

					$rowData	.= '<tr>'
							. '<td class="c">' . $no++ . '</td>'
							. '<td class="c">' . $this -> getColumnData($data, COLUMN_TYPE) . '</td>'
							// . '<td class="c">' . $this -> getColumnData($data, COLUMN_USER_ACCOUNT) . '</td>'
							. '<td class="c">' . $userAccountLink . '</td>'
							. '<td class="l">' . $this -> getColumnData($data, COLUMN_ACCOUNT_NAME) . '</td>'
							. '<td class="r">' . $deposit . '</td>'
							. '<td class="r">' . $withdraw . '</td>'
							. '<td class="r">' . $currency. DELIMIT_SPACE . $this -> formatCurrency($this -> getColumnData($data, COLUMN_FEE), $currency) . '</td>'
							. '<td>' . $this -> getColumnData($data, COLUMN_TRANSACTION_TIME_STRING) . '</td>'
							. '<td>' . $this -> getColumnData($data, COLUMN_PROCESS_TIME_STRINTG) . '</td>'
							. '<td class="c">' . $this -> getColumnData($data, COLUMN_TRANSACTION_NUMBER) . '</td>'
							. '<td class="l">' . $message . '</td>'
							. '<td class="c">' . $this -> getColumnData($data, COLUMN_PROCESS_STATUS) . '</td>'
							. '<td class="c">' . $this -> getColumnData($data, COLUMN_STATUS) . '</td>'
							. '<td class="r">' . $dispTotal . '</td>'
						. '</tr>';
				}
			} else {
				$rowData	= '<tr><td colspan="14">' . $this -> getMessage(INFO, 'I_NO_SUCHE_SEARCH_DATA', array()) . '</td></tr>';
			}

			return '<table class="table col bdr default odd calign w100p fontXS">' . $titleData . $rowData . '</table>';
	}


	/*-------------------------------------------------------------------------
	 * @function_name: ページャの表示
	 * @parameter	: なし
	 * @return		: 表示用HTML文字列
	 -------------------------------------------------------------------------*/
	function dispPager($count, $currency) {

		$totalPage = 0;
		$remainder = 0;
		$totalPage = intval(floor($count / 50));
		$remainder = $count % 50;
		if ($remainder != 0) {
			$totalPage++;
		}

		return '<div class="article-bottom mt-0"><div class="pager">'
				.''.VAL_STR_SEARCH_RESULT.'' . $count . '&nbsp;Page <span id="crntPageNum_' . $currency . '">1</span> / ' . $totalPage . '&nbsp;'
				.'<input id="move_page_high_' . $currency . '" value="1" class="px30 ralign" type="text">'
				.'&nbsp;'
				.'<input value="'.VAL_STR_DISPLAY.'" class="btn bg-default px60 hi22" onclick="movePageEx(\'' . $currency . '\');" type="button">'
				.'&nbsp;'
				.'<input onclick="movePrevPage(\'' . $currency . '\');" value="'.VAL_STR_PREVIOUS_PAGE.'" class="btn2 bg-default px90 hi22" type="button">'
				.'&nbsp;'
				.'<input onclick="moveNextPage(\'' . $currency . '\');" value="'.VAL_STR_NEXT_PAGE.'" class="btn2 bg-default px90 hi22" type="button">'
				.'&nbsp;'
				.'<input id="crnt_page_' . $currency . '" value="1" type="hidden">'
			.'<input id="total_page_' . $currency . '" value="' . $totalPage . '" type="hidden"></div></div>';
	}

	/*-------------------------------------------------------------------------
	* @function_name: メールアドレスの取得
	* @parameter	: なし
	* @return		: メールアドレス
	-------------------------------------------------------------------------*/
	function getMail() {
		return  $this -> mail;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 氏名の取得
	* @parameter	: 結果セット
	* @return		: 氏名
	-------------------------------------------------------------------------*/
	function getName() {
		return $this -> name;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座番号の取得
	* @parameter	: なし
	* @return		: 口座番号
	-------------------------------------------------------------------------*/
	function getAccountNumber() {
		return $this -> accountNumber;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座番号の取得
	* @parameter	: なし
	* @return		: 口座番号
	-------------------------------------------------------------------------*/
	function getDetailAccount() {
		return $this -> detailAccount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 国の取得
	* @parameter	: なし
	* @return		: 国
	-------------------------------------------------------------------------*/
	function getCountry() {
		return $this -> country;
	}
	/*-------------------------------------------------------------------------
	* @function_name: 住所の取得
	* @parameter	: なし
	* @return		: 住所
	-------------------------------------------------------------------------*/
	function getAddress() {
		return $this -> address;
	}

	/*-------------------------------------------------------------------------
	* @function_name: エージェントコードの取得
	* @parameter	: なし
	* @return		: エージェントコード
	-------------------------------------------------------------------------*/
	function getAgentCode() {
		return $this -> agentCode;
	}

	/*-------------------------------------------------------------------------
	* @function_name: KYCフラグの取得
	* @parameter	: なし
	* @return		: KYCフラグ
	-------------------------------------------------------------------------*/
	function getKycFlg() {
		return $this -> arrValidate[$this -> kycValidateStatus];
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座状態の取得
	* @parameter	: なし
	* @return		: 口座状態
	-------------------------------------------------------------------------*/
	function getStatus() {
		return $this -> status;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座種別の取得
	* @parameter	: なし
	* @return		: 口座種別
	-------------------------------------------------------------------------*/
	function getAccountType() {
		return $this -> accountType;
	}
	/*-------------------------------------------------------------------------
	* @function_name: 検索開始日の取得
	* @parameter	: なし
	* @return		: 検索開始日
	-------------------------------------------------------------------------*/
	function getFrom() {
		return $this -> from;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 検索終了日の取得
	* @parameter	: なし
	* @return		: 検索終了日
	-------------------------------------------------------------------------*/
	function getTo() {
		return $this -> to;
	}

	/*-------------------------------------------------------------------------
	* @function_name: UIDの表示
	* @parameter	: なし
	* @return		: UID
	-------------------------------------------------------------------------*/
	function echoUId() {
		echo $this -> uId;
	}

	/*-------------------------------------------------------------------------
	* @function_name: KYCの表示
	* @parameter	: なし
	* @return		: KYC
	-------------------------------------------------------------------------*/
	function dispKYCFlg() {
		$isUpload = $this -> accessSelect('COUNT_KYC_DOCUMENT',array($this -> accountNumber));
		echo empty($isUpload) || $this -> kycValidateStatus == 99 ? '': '<a href="kyc?type=detail&user_account='.$this -> accountNumber.'" target="_blank">'.$this -> arrValidate[$this -> kycValidateStatus].'</a>';
	}

	/*-------------------------------------------------------------------------
	* @function_name: KYCの表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function echoKYCFlg() {
		echo $this -> dispListOption($this -> getKYCFlgList(), $this -> kycFlg);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 状態の表示
	* @parameter	: なし
	* @return		: 状態
	-------------------------------------------------------------------------*/
	function dispStatus() {
		echo $this -> dispUserStatusCommon($this -> status);
	}

	/*-------------------------------------------------------------------------
	* @function_name: エージェントコードの取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispAgentCode() {
		echo $this -> dispListOption($this -> getAgentCodeListCommon($this -> myAgentCode), $this -> agentCode);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 状態の表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function echoStatus() {
		echo $this -> dispListOption($this -> getStatusList(), $this -> status);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座種別の表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispAccountType() {
		echo $this -> dispListOption($this -> getAccountTypeList(), $this -> accountType);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座種別の表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function echoAccountType() {
		echo $this -> dispUserAccountTypeCommon($this -> accountType);
	}

	/*-------------------------------------------------------------------------
	* @function_name: ユーザ名の表示
	* @parameter	: なし
	* @return		: ユーザ名
	-------------------------------------------------------------------------*/
	function echoUserName() {
		echo $this -> userName;
	}

	/*-------------------------------------------------------------------------
	* @function_name: ユーザ名の表示
	* @parameter	: なし
	* @return		: ユーザ名
	-------------------------------------------------------------------------*/
	function getUserName() {
		return $this -> userName;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 通貨の表示
	* @parameter	: なし
	* @return		: 通貨
	-------------------------------------------------------------------------*/
	function echoCurrency() {
		echo $this -> currency;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 姓の表示
	* @parameter	: なし
	* @return		: 姓
	-------------------------------------------------------------------------*/
	function echoLastName() {
		echo $this -> lastName;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 名の表示
	* @parameter	: なし
	* @return		: 名
	-------------------------------------------------------------------------*/
	function echoFirstName() {
		echo $this -> firstName;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 生年月日の表示
	* @parameter	: なし
	* @return		: 生年月日
	-------------------------------------------------------------------------*/
	function echoBirth() {
		echo $this -> birth;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 生年月日（年）の表示
	* @parameter	: なし
	* @return		: 生年月日（年）
	-------------------------------------------------------------------------*/
	function echoBirthYear() {
		echo $this -> birthYear;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 生年月日（月）の表示
	* @parameter	: なし
	* @return		: 生年月日（月）
	-------------------------------------------------------------------------*/
	function echoBirthMonth() {
		echo $this -> birthMonth;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 生年月日（日）の表示
	* @parameter	: なし
	* @return		: 生年月日（日）
	-------------------------------------------------------------------------*/
	function echoBirthDay() {
		echo $this -> birthDay;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 生年月日（年）の表示
	* @parameter	: なし
	* @return		: 生年月日（年）
	-------------------------------------------------------------------------*/
	function dispBirthYear() {
		$this -> dispBirthYearList($this -> birthYear);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 生年月日（月）の表示
	* @parameter	: なし
	* @return		: 生年月日（月）
	-------------------------------------------------------------------------*/
	function dispBirthMonth() {
		$this -> dispBirthMonthList($this -> birthMonth);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 生年月日（日）の表示
	* @parameter	: なし
	* @return		: 生年月日（日）
	-------------------------------------------------------------------------*/
	function dispBirthDay() {
		$this -> dispBirthDayList($this -> birthDay);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 国の表示
	* @parameter	: なし
	* @return		: 国
	-------------------------------------------------------------------------*/
	function echoCountry() {
		echo $this -> dispCountryCommon($this -> country);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 国の表示
	* @parameter	: なし
	* @return		: 国
	-------------------------------------------------------------------------*/
	function dispCountry() {
		echo $this -> dispListOption($this -> getCountyList(), $this -> country);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 都道府県の表示
	* @parameter	: なし
	* @return		: 都道府県
	-------------------------------------------------------------------------*/
	function echoState() {
		echo $this -> state;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 市区町村の表示
	* @parameter	: なし
	* @return		: 市区町村
	-------------------------------------------------------------------------*/
	function echoCity() {
		echo $this -> city;
	}

	/*------------------------Mikko 2019 0313----------------------------------
	* @function_name:
	* @parameter	:
	* @return		:
	-------------------------------------------------------------------------*/

	function echoRiskLevel() {
		echo ($this -> riskLevel != NO_STRING) ? $this -> getValueByList($this -> getRiskLevels(), $this -> riskLevel) : "";
	}

	function echoTierLevel() {
		echo ($this -> tierLevel != NO_STRING) ? $this -> getValueByList($this -> getTierStatusList(), $this -> tierLevel) : "";
	}

	/*-------------------------------------------------------------------------
	* @function_name: 番地1の表示
	* @parameter	: なし
	* @return		: 番地1
	-------------------------------------------------------------------------*/
	function echoAddress() {
		echo $this -> address;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 番地2の表示
	* @parameter	: なし
	* @return		: 番地2
	-------------------------------------------------------------------------*/
	function echoAddress2() {
		echo $this -> address2;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 郵便番号の表示
	* @parameter	: なし
	* @return		: 郵便番号
	-------------------------------------------------------------------------*/
	function echoZipCode() {
		echo $this -> zipCode;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 電話番号の表示
	* @parameter	: なし
	* @return		: 電話番号
	-------------------------------------------------------------------------*/
	function echoTel() {
		echo $this -> tel;
	}

	/*-------------------------------------------------------------------------
	* @function_name: エージェントコードの表示
	* @parameter	: なし
	* @return		: エージェントコード
	-------------------------------------------------------------------------*/
	function echoAgentCode() {
		echo $this -> agentCode;
	}

	/*-------------------------------------------------------------------------
	* @function_name: メールアドレスの表示
	* @parameter	: なし
	* @return		: メールアドレス
	-------------------------------------------------------------------------*/
	function echoMail() {
		echo $this -> mail;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座番号の表示
	* @parameter	: なし
	* @return		: 口座番号
	-------------------------------------------------------------------------*/
	function echoAccountNumber() {
		echo $this -> accountNumber;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 登録日時の表示
	* @parameter	: なし
	* @return		: 登録日時
	-------------------------------------------------------------------------*/
	function echoCreateTime() {
		echo $this -> createTime;
	}

	/*-------------------------------------------------------------------------
	* @function_name: CRM IDを取得する
	* @parameter	: なし
	* @return		: CRM ID
	-------------------------------------------------------------------------*/
	function echoCrmId() {
		echo $this -> crmId;
	}

	/*-------------------------------------------------------------------------
	* @function_name: ユーザメモの表示
	* @parameter	: なし
	* @return		: ユーザメモ
	-------------------------------------------------------------------------*/
	function echoNote() {
		echo $this -> note;
	}
	function echoRisk() {
		echo $this -> risk;
	}

	/*-------------------------------------------------------------------------
	* @function_name: カードIDの表示
	* @parameter	: なし
	* @return		: カードID
	-------------------------------------------------------------------------*/
	function getCardId() {
		return $this -> cId;
	}

	/*-------------------------------------------------------------------------
	* @function_name: カードIDの表示
	* @parameter	: なし
	* @return		: カードID
	-------------------------------------------------------------------------*/
	function getUserLinkId() {
		return $this -> userLinkId;
	}

	/*-------------------------------------------------------------------------
	* @function_name: カードホルダーIDの表示
	* @parameter	: なし
	* @return		: カードホルダーID
	-------------------------------------------------------------------------*/
	function echoCardHolderId() {
		echo $this -> cardHolderId;
	}

	/*-----------------------Mikko 2019 0312-----------------------------------
	* @function_name:
	* @parameter	:
	* @return		:
	-------------------------------------------------------------------------*/
	function echoUserLink() {
		echo $this -> userLink;
	}

	/*-------------------------------------------------------------------------
	* @function_name: カード下四桁の表示
	* @parameter	: なし
	* @return		: カード下四桁
	-------------------------------------------------------------------------*/
	function echoDigit() {
		echo $this -> digit;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: プロキシの表示
	 * @parameter	: なし
	 * @return		: プロキシ
	 -------------------------------------------------------------------------*/
	function echoProxy() {
		echo $this -> proxy;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 有効期限の表示
	 * @parameter	: なし
	 * @return		: 有効期限
	 -------------------------------------------------------------------------*/
	function echoExpireDate() {
		echo $this -> expireDate;
	}

	/*-------------------------------------------------------------------------
	* @function_name: WL名の取得
	* @parameter	: なし
	* @return		: WL名
	-------------------------------------------------------------------------*/
	function echoWLName() {
		/**
		 *
		 * 2019/04/11
		 * anton
		 *
		 */

		echo $this -> dispWhiteLabelNameCommon($this -> wlId) ;
	}

	/*-------------------------------------------------------------------------
	* @function_name: WL名の取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispWLName() {
		echo $this -> dispListOption($this -> getWhiteLabelList(), $this -> wlId);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 手数料の取得
	* @parameter	: なし
	* @return		: 手数料
	-------------------------------------------------------------------------*/
	function getFee() {
		return  $this -> fee;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 手数料振り分けリストの取得
	* @parameter	: なし
	* @return		: 手数料振り分けリスト
	-------------------------------------------------------------------------*/
	function getFees() {
		return  $this -> fees;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 手数料振り分けリストの取得
	* @parameter	: なし
	* @return		: 手数料振り分けリスト
	-------------------------------------------------------------------------*/
	function echoTransferBatchFlg() {
		echo $this -> getValueByList($this -> getTransferBatchList(), $this -> transferBatchFlg);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 手数料振り分けリストの取得
	* @parameter	: なし
	* @return		: 手数料振り分けリスト
	-------------------------------------------------------------------------*/
	function echoTransferFlg() {
		echo $this -> getValueByList($this -> getTransferList(), $this -> transferFlg);
	}

	function echoTestAccountFlg() {
		echo $this -> getValueByList($this -> getTestAccountList(), $this -> testAccountFlg);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 手数料振り分けリストの取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispTransferBatchFlg() {

		// 変数背減歩
		$rtn	= NO_STRING;
		$list	= $this -> getTransferBatchList();

		foreach($list as $val) {
			$rtn .= '<label>' . $this -> makeRadioOne(PARAM_TRANSFER_BATCH_FLG . $this -> getColumnData($val, PARAM_DATA_KEY)
														, PARAM_TRANSFER_BATCH_FLG
														, $this -> getColumnData($val, PARAM_DATA_KEY)
														, $this -> transferBatchFlg)
					. $this -> getColumnData($val, PARAM_DATA_VALUE) . '</label>&nbsp;';
		}


		echo $rtn;
	}

	function dispTestAccountFlg() {

		$rtn	= NO_STRING;
		$list	= $this -> getTestAccountList();

		foreach($list as $val) {
			$rtn .= '<label>' . $this -> makeRadioOne(PARAM_TEST_ACCOUNT_FLG . $this -> getColumnData($val, PARAM_DATA_KEY)
														, PARAM_TEST_ACCOUNT_FLG
														, $this -> getColumnData($val, PARAM_DATA_KEY)
														, $this -> testAccountFlg)
					. $this -> getColumnData($val, PARAM_DATA_VALUE) . '</label>';
		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 手数料振り分けリストの取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispTransferFlg() {

		// 変数背減歩
		$rtn	= NO_STRING;
		$list	= $this -> getTransferList();

		foreach($list as $val) {
			$rtn .= '<label>' . $this -> makeRadioOne(PARAM_TRANSFER_FLG . $this -> getColumnData($val, PARAM_DATA_KEY)
														, PARAM_TRANSFER_FLG
														, $this -> getColumnData($val, PARAM_DATA_KEY)
														, $this -> transferFlg)
					. $this -> getColumnData($val, PARAM_DATA_VALUE) . '</label>';
		}


		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: カードデータ一覧の取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispCards() {

		// 変数宣言部
		$rtn	= NO_STRING;
		$card	= null;

		// 編集した

		if($this -> isLoopData($this -> cards)) {

			foreach($this -> cards as $card) {

				// カード番号
				$rtn .= '<li>' . $this -> getColumnData($card, COLUMN_CARD_HOLDER_ID) . '&nbsp;**** **** **** ' . $this -> getColumnData($card, COLUMN_CARD_NUMBER)
				. '<br/>' . $this -> getColumnData($card, COLUMN_PROXY) . '&nbsp;' . $this -> getColumnData($card, COLUMN_EXPIRE_DATE) . '&nbsp;<a href="javascript:removeCard(\'' . $this -> getColumnData($card, COLUMN_CARD_HOLDER_ID) . '\');"> '.VAL_STR_REMOVE.'</a></li>';
			}
		} else {
			$rtn = VAL_STR_CARD_MESSAGE . "<br/>";
		}

		echo $rtn;
	}

	/*---------------------------------Mikko 2019 0301---------------------
	* @function_name:
	* @parameter	:
	* @return		:
	-------------------------------------------------------------------------*/
	function dispUserLink() {

		$rtn	= NO_STRING;
		$user	= null;

		if($this -> isLoopData($this -> linkAccount)) {

				foreach($this -> linkAccount as $user) {
					if($this -> accountNumber == $this -> getColumnData($user, COLUMN_USER_1)){

						$rtn .= '<li><a href="account_edit?detail_account=' . $this -> getColumnData($user, COLUMN_USER_2) . '" target="_blank">'

						. $this -> getColumnData($user, COLUMN_USER_2) .'&nbsp;' . $this -> getColumnData($user, COLUMN_FIRST_NAME_2) . '&nbsp;' . $this -> getColumnData($user, COLUMN_LAST_NAME_2) . '</a>' .'&nbsp; &nbsp'. ' &nbsp;<a href="javascript:removeLink(\'' . $this -> getColumnData($user, COLUMN_L_ID) . '\');">&nbsp;'.VAL_STR_REMOVE.'</a></li>';

					} else {
						$rtn .= '<li><a href="account_edit?detail_account=' . $this -> getColumnData($user, COLUMN_USER_1) . '" target="_blank">'

						. $this -> getColumnData($user, COLUMN_USER_1) .'&nbsp;' . $this -> getColumnData($user, COLUMN_FIRST_NAME) . '&nbsp;'. $this -> getColumnData($user, COLUMN_LAST_NAME) .'</a>' . ' &nbsp;<a href="javascript:removeLink(\'' . $this -> getColumnData($user, COLUMN_L_ID) . '\');">&nbsp;'.VAL_STR_REMOVE.'</a></li>';
					}
				}

		} else {
			$rtn = VAL_STR_USER_NO_LINK;
		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: カードデータ登録エラーメッセージの表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispMsg() {

		// 変数宣言部
		$rtn = NO_STRING;

		if($this -> msg != NO_STRING) {
			$rtn = '<li class="red">' . $this -> msg . '</li>';
		}

		echo $rtn;
	}

	/*-------------------------Mikko 2019 0312--------------------------------
	* @function_name:
	* @parameter	:
	* @return		:
	-------------------------------------------------------------------------*/
		function dispMsg2() {

		// 変数宣言部
		$rtn = NO_STRING;

		if($this -> msg2 != NO_STRING) {
			$rtn = '<li class="red">' . $this -> msg2 . '</li>';
		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: ログインロック状態の取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	public function dispLoginLock() {

		// 変数宣言部
		$rtn = NO_STRING;
		// ログインロックデータがあった場合はロック中
		if($this -> isLoopData($this -> loginLock)) {

			$rtn = '<a href="#" id="btnUnlock">' . VAL_LOGIN_LOCK . VAL_STR_USER_LOCK_TIME . $this -> getColumnData($this -> loginLock, COLUMN_DIFF_TIME_STRING) . ')</a>';
		} else {
			$rtn = VAL_LOGIN_UNLOCK;
		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: GPSの口座種別フラグ
	* @parameter	: なし
	* @return		: GPSの口座種別フラグ
	-------------------------------------------------------------------------*/
	public function getGPSAccountFlg() {
		return intval($this -> gpsAccountFlg);
	}

	/*-------------------------------------------------------------------------
	* @function_name: GPSの口座種別フラグ
	* @parameter	: なし
	* @return		: GPSの口座種別フラグ
	-------------------------------------------------------------------------*/
	public function echoGPSAccountFlg() {
		echo $this -> getValueByList($this -> getGPSAccountList(), $this -> gpsAccountFlg);
	}

	/*-------------------------------------------------------------------------
	* @function_name: GPSの口座種別フラグ
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	public function dispGPSAccountFlg() {

		// 変数宣言部
		$rtn	= NO_STRING;
		$list	= $this -> getGPSAccountList();

		foreach($list as $val) {
			$rtn .= '<label>' . $this -> makeRadioOne(PARAM_GPS_ACCOUNT . $this -> getColumnData($val, PARAM_DATA_KEY)
														, PARAM_GPS_ACCOUNT
														, $this -> getColumnData($val, PARAM_DATA_KEY)
														, $this -> gpsAccountFlg)
					. $this -> getColumnData($val, PARAM_DATA_VALUE) . '</label>&nbsp;';
		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: GPSの決済種別
	* @parameter	: なし
	* @return		: GPSの決済種別
	-------------------------------------------------------------------------*/
	public function getGpsKindOfPayments() {
		return $this -> gpsPayments;
	}

	/*-------------------------------------------------------------------------
	* @function_name: GPSの決済種別
	* @parameter	: なし
	* @return		: GPSの決済種別
	-------------------------------------------------------------------------*/
	public function echoGpsKindOfPayments() {

		// 変数宣言部
		$rtn	= array();
		$list	= $this -> makeArrayByPowerCommon($this -> gpsPayments);

		if($list[NO_COUNT] == VAL_INT_1) {	// VISA
			$rtn[] = VAL_STR_DEPOSIT_VISA;
		}

		if($list[VAL_INT_1] == VAL_INT_1) {	// MASTERCARD
			$rtn[] = VAL_STR_DEPOSIT_MASTERCARD;
		}

		if($list[VAL_INT_2] == VAL_INT_1) {	// 銀行送金
			$rtn[] = VAL_STR_DEPOSIT_INSTANTBANKTRANSFER;
		}

		if($list[VAL_INT_3] == VAL_INT_1) {	// CUP送金
			$rtn[] = VAL_STR_CUP_NAME;
		}

		if($list[VAL_INT_4] == VAL_INT_1) {	// Visa/Master Direct送金
			$rtn[] = VAL_STR_VSMS_NAME;
		}

		echo  implode(DELIMIT_COMMA, $rtn);
	}


	/*-------------------------------------------------------------------------
	* @function_name: GPSの決済種別リスト
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	public function dispGPSKindOfPayment() {

		// 変数宣言部
		$rtn		= NO_STRING;
		$list		= null;
		$flgs		= null;
		$cnt		= NO_COUNT;
		$selected	= NO_STRING;

		// リストを取得する
		$list	= $this -> getDepositMethodListAdminCommon();
		$flgs	= $this -> makeArrayByPowerCommon($this -> gpsPayments);

		if($this -> isLoopData($list)) {

			foreach($list as $val) {

				// チェックフラグ
				if($flgs[$cnt] == VAL_INT_1) {
					$selected = $this -> getColumnData($val, PARAM_DATA_KEY);
				} else {
					$selected = NO_STRING;
				}

				$rtn .=  '<label>'
							. $this -> makeCheckOne(PARAM_GPS_KIND_OF_PAYMENT
													, PARAM_GPS_KIND_OF_PAYMENT . '[]'
													, $this -> getColumnData($val, PARAM_DATA_KEY)
													, $this -> getColumnData($val, PARAM_DATA_VALUE)
													, $selected)
							. '</label>&nbsp;';

				$cnt++;
			}
		}

		echo $rtn;
	}


	/*-------------------------Mikko 2019: 3501--------------------------------
	* @function_name:
	* @parameter	:
	* @return		:
	-------------------------------------------------------------------------*/
	public function dispRiskLevels() {
		$rtn 		= NO_STRING;
		$list 		= null;
		$cnt		= NO_COUNT;
		$selected	= NO_STRING;
		$level 		= $this -> riskLevel;

		$list 		= $this -> getRiskLevels();
		if($this -> isLoopData($list)) {
		foreach($list as $val) {
				if($level == VAL_INT_1){
					$selected = VAL_INT_1;
				}elseif($level == VAL_INT_2){
					$selected = VAL_INT_2;
				}

				$rtn .= '<label>'
						. $this -> makeCheckOne(PARAM_RISK_LEVELS
												,	PARAM_RISK_LEVELS . '" class="risk_levels'
												,	$this -> getColumnData($val, PARAM_DATA_KEY)
												,	$this -> getColumnData($val, PARAM_DATA_VALUE)
												,	$selected)
						. '</label>&nbsp';

			}
		}

		echo $rtn;


	}
	public function dispTierLevels() {
		$rtn 		= NO_STRING;
		$list 		= null;
		$cnt		= NO_COUNT;
		$selected	= NO_STRING;
		$level 		= $this -> tierLevel;

		$list 		= $this -> getTierStatusList();
		if($this -> isLoopData($list)) {
		foreach($list as $val) {
				$selected = ($level!= NULL || $level!= NO_STRING) ? $level : NO_STRING;

				$rtn .= '<label>'
						. $this -> makeRadioOne(PARAM_TIER_LEVELS
												,	PARAM_TIER_LEVELS
												,	$this -> getColumnData($val, PARAM_DATA_KEY)
												,	$selected)
						. $this -> getColumnData($val, PARAM_DATA_VALUE) . '</label>&nbsp';

			}
		}

		echo $rtn;


	}

	/*-------------------------------------------------------------------------
	* @function_name: 更新用データの取得
	* @parameter	: なし
	* @return		: 更新用データ配列
	-------------------------------------------------------------------------*/
	function getUpdateDatas() {

		// 変数宣言部
		$rtn = array();

		// パラメータの作成
		$rtn[] = $this -> detailAccount;	// ユーザ口座番号
		$rtn[] = $this -> lastName;			// 姓
		$rtn[] = $this -> firstName;		// 名
		$rtn[] = $this -> country;			// 国
		$rtn[] = $this -> state;			// 都道府県
		$rtn[] = $this -> city;				// 市区町村
		$rtn[] = $this -> address;			// 番地1
		$rtn[] = $this -> address2;			// 番地2
		$rtn[] = $this -> zipCode;			// 郵便番号
		$rtn[] = $this -> tel;				// 電話番号
		$rtn[] = $this -> mail;				// 連絡メールアドレス
		$rtn[] = $this -> birthYear;		// 生年月日（年）
		$rtn[] = $this -> birthMonth;		// 生年月日（月）
		$rtn[] = $this -> birthDay;			// 生年月日（日）
		$rtn[] = $this -> accountType;		// 口座種別
		$rtn[] = $this -> crmId;			// CRM ID
		$rtn[] = $this -> status;			// 口座状態
		$rtn[] = $this -> agentCode;		// エージェントコード
		$rtn[] = $this -> transferBatchFlg;	// エージェントコード
		$rtn[] = $this -> riskLevel;		// mikko 2019: 3501
		$rtn[] = $this -> tierLevel;
		$rtn[] = $this -> transferFlg;
		$rtn[] = $this -> testAccountFlg;


		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: WLの更新用データの取得
	* @parameter	: なし
	* @return		: 更新用データ配列
	-------------------------------------------------------------------------*/
	function getUpdateWlIdDatas() {

		// 変数宣言部
		$rtn = array();

		$rtn[] = $this -> detailAccount;	// ユーザ口座番号
		$rtn[] = $this -> wlId;				// WLID

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 更新用データの取得（法人情報）
	* @parameter	: なし
	* @return		: 更新用データ配列
	-------------------------------------------------------------------------*/
	function getUpdateCorporationDatas() {

		// 変数宣言部
		$rtn = array();

		// パラメータの作成
		$rtn[] = $this -> uId;			// UID
		$rtn[] = $this -> registrationNumber;
		$rtn[] = $this -> registrationDate;
		$rtn[] = $this -> ceoLastName;	// 代表者（姓）
		$rtn[] = $this -> ceoFirstName;	// 代表者（名）
		$rtn[] = $this -> siteName;		// サイト名
		$rtn[] = $this -> siteURL;		// サイトURL
		$rtn[] = $this -> typeOfUsage;
		$rtn[] = $this -> agreementStatus;
		$rtn[] = $this -> initialContactName;
		$rtn[] = $this -> initialEmailAddress;
		$rtn[] = $this -> skypeAccount;

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: ユーザメモ更新用データの取得
	* @parameter	: なし
	* @return		: ユーザメモ更新用データ配列
	-------------------------------------------------------------------------*/
	function getUpdateUserNoteDatas() {

		// 変数宣言部
		$rtn = array();

		// パラメータの作成
		$rtn[] = $this -> detailAccount;	// ユーザ口座番号
		$rtn[] = $this -> note;				// ユーザメモ

		return $rtn;
	}
	function getUpdateUserRiskDatas() {

		// 変数宣言部
		$rtn = array();

		// パラメータの作成
		$rtn[] = $this -> detailAccount;	// ユーザ口座番号
		$rtn[] = $this -> risk;				// ユーザメモ

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: カード登録用データの取得
	* @parameter	: なし
	* @return		: カード登録用データ配列
	-------------------------------------------------------------------------*/
	function getRegistCardDatas() {

		// 変数宣言部
		$rtn = array();

		// パラメータの作成
		$rtn[] = $this -> detailAccount;	// ユーザ口座番号
		$rtn[] = $this -> cardHolderId;		// カードホルダーID
		$rtn[] = $this -> digit;			// カード下4桁
		$rtn[] = $this -> cardNumber;		// カード番号
		$rtn[] = $this -> proxy;			// カードプロキシ
		$rtn[] = $this -> expireDate;		// カード有効期限

		return $rtn;
	}

	/*-----------------Mikko 2019 0312----------------------------------------
	* @function_name:
	* @parameter	:
	* @return		:
	-------------------------------------------------------------------------*/
	function getUserLinkDatas() {

		$insertValues = NO_STRING;
		$user2 = $this -> userLink;

		foreach($user2 as $value){
			$insertValues .=  '((\')' . $this -> detailAccount .'(\'), (\')' . $value . '(\'), CONVERT_TZ(NOW(),@@session.time_zone,(\')+09:00(\'))), ';
		}

		$rtn[] = rtrim($insertValues,', ');

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: カード登録用データの取得
	* @parameter	: なし
	* @return		: カード登録用データ配列
	-------------------------------------------------------------------------*/
	function getDeleteCardDatas() {

		// 変数宣言部
		$rtn = array();

		// パラメータの作成
		$rtn[] = $this -> cId;				// カードホルダーID

		return $rtn;
	}

	/*----------------------Mikko 2019 0312------------------------------------
	* @function_name:
	* @parameter	:
	* @return		:
	-------------------------------------------------------------------------*/
	function getDeleteUserLinkDatas() {

		// 変数宣言部
		$rtn = array();

		// パラメータの作成
		$rtn[] = $this -> userLinkId;				// カードホルダーID

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: ユーザ削除データの取得
	* @parameter	: なし
	* @return		: ユーザ削除データ配列
	-------------------------------------------------------------------------*/
	function getUpdateUserDeleteDatas() {

		// 変数宣言部
		$rtn = array();

		// パラメータの作成
		$rtn[] = $this -> detailAccount;	// ユーザ口座番号
		$rtn[] = VAL_INT_1;					// 削除フラグ

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: ユーザ削除データの取得
	* @parameter	: なし
	* @return		: ユーザ削除データ配列
	-------------------------------------------------------------------------*/
	function echoReferer() {
		$referer = (isset($_SERVER['HTTP_REFERER'])) ? basename($_SERVER['HTTP_REFERER']) : 'account_list';
		echo $referer;
	}

	/*-------------------------------------------------------------------------
	* @function_name: メール認証再送信
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function reSendLink() {

		// 変数宣言部
		$rtn = NO_STRING;

		$value = VAL_STR_USER_LINK_VALUE;

		// 仮登録の場合
		if($this -> status == VAR_ACCOUNT_STATUS_TEMPORARILY) {
			$rtn =	'<tr>'
					. '<th>'.VAL_STR_USER_LINK_LABEL.'</th>'
							. '<td><a href="#" id="btnSend">'.VAL_STR_USER_LINK_VALUE.'</a></td>'
									. '</tr>';
		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 会社データの取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	public function dispCorporation() {
		// 変数宣言部
		$rtn = NO_STRING;

		if($this -> getColumnData($this -> userData, COLUMN_ACCOUNT_TYPE) == VAR_CORP) {	// 法人口座の場合

			$rtn = '<table class="table col bdr default odd w60p fontXS m_auto mb20">'
					. '<colgroup>'
					. '<col class="w40p">'
					. '<col class="w60p">'
					. '</colgroup>'
					. '<tr>'
					. '<th>'.VAL_STR_CORP_REGISTRATION_NUMBER.'</th>'
					. '<td>' . $this -> getColumnData($this -> userData, COLUMN_REGISTRATION_NUMBER) .'</td>'
					. '</tr>'
					. '<tr>'
					. '<th>'.VAL_STR_CORP_REGISTRATION_DATE.'</th>'
					. '<td>' . $this -> getColumnData($this -> userData, COLUMN_REGISTRATION_DATE) .'</td>'
					. '</tr>'
					. '<tr>'
					. '<th>'.VAL_STR_CORP_REP_NAME.'</th>'
					. '<td>' . $this -> getColumnData($this -> userData, COLUMN_CEO_FIRST_NAME) . DELIMIT_SPACE . $this -> getColumnData($this -> userData, COLUMN_CEO_LAST_NAME) . '</td>'
					. '</tr>';
			if($this -> checkAdminUserAccess('UCTCT', array(''))){
				$rtn = $rtn . '<tr>'
				. '<th>'.VAL_STR_CORP_INIT_CONTACT_NAME.'</th>'
				. '<td>' . $this -> getColumnData($this -> userData, COLUMN_INIT_CONTACT_NAME) . '</td>'
				. '</tr>'
				. '<tr>'
				. '<th>'.VAL_STR_CORP_INIT_EMAIL_ADD.'</th>'
				. '<td>' . $this -> getColumnData($this -> userData, COLUMN_INIT_EMAIL_ADD) . '</td>'
				. '</tr>'
				. '<tr>'
				. '<th>'.VAL_STR_CORP_SKYPE_ACC.'</th>'
				. '<td>' . $this -> getColumnData($this -> userData, COLUMN_SKYPE_ACC) . '</td>'
				. '</tr>'
				;
			}

			$rtn = $rtn . '<tr>'
					. '<th>'.VAL_STR_CORP_SITE_NAME.'</th>'
					. '<td>' . $this -> getColumnData($this -> userData, COLUMN_SITE_NAME) . '</td>'
					. '</tr>'
					. '<tr>'
					. '<th>'.VAL_STR_CORP_SITE_URL.'</th>'
					. '<td>' . $this -> getColumnData($this -> userData, COLUMN_SITE_URL) . '</td>'
					. '</tr>'
					. '<tr>'
					. '<th>'.VAL_STR_CORP_TYPE_OF_USAGE.'</th>'
					. '<td>' . $this -> getColumnData($this -> userData, COLUMN_TYPE_OF_USAGE) . '</td>'
					. '</tr>'
					. '<tr>'
					. '<th>'.VAL_STR_CORP_AGREEMENT_STATUS.'</th>'
					. '<td>' . $this -> getColumnData($this -> userData, COLUMN_AGREEMENT_STATUS) . '</td>'
					. '</tr>'
				. '</table>';
		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 会社データの取得（入力バージョン）
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	public function dispCorporationInput() {
		// 変数宣言部
		$rtn = NO_STRING;

		if($this -> getColumnData($this -> userData, COLUMN_ACCOUNT_TYPE) == VAR_CORP) {	// 法人口座の場合

			$rtn = '<table class="table col bdr default odd w60p fontXS m_auto mb20">'
				. '<colgroup>'
				. '<col class="w40p">'
				. '<col class="w60p">'
				. '</colgroup>'
				. '<tr>'
				. '<th>'.VAL_STR_CORP_REGISTRATION_NUMBER.'</th>'
				. '<td><input type="text" id="registration_number" name="registration_number" value="' . $this -> getColumnData($this -> userData, COLUMN_REGISTRATION_NUMBER) . '" class="w30p"></td>'
				. '</tr>'
				. '<tr>'
				. '<th>'.VAL_STR_CORP_REGISTRATION_DATE.'</th>'
				. '<td><input type="text" class="px110" id="s_to" name="registration_date" value="' . $this -> getColumnData($this -> userData, COLUMN_REGISTRATION_DATE) . '" class="px110 hasDatepicker"></td>'
				. '</tr>'
				. '<tr>'
				. '<th>'.VAL_STR_CORP_REP_NAME.'</th>'
				. '<td><input type="text" id="ceo_last_name" name="ceo_last_name" value="' . $this -> getColumnData($this -> userData, COLUMN_CEO_LAST_NAME) . '" class="w30p" placeholder="'.VAL_STR_FIRST_NAME.'"><input type="text" id="ceo_first_name" name="ceo_first_name" value="' . $this -> getColumnData($this -> userData, COLUMN_CEO_FIRST_NAME) . '" class="w30p" placeholder="'.VAL_STR_LAST_NAME.'"></td>'
				. '</tr>'
				. '<tr>';
			if($this -> checkAdminUserAccess('UCTCT', array('', '1'))){
				$rtn = $rtn
					. '<th>'.VAL_STR_CORP_INIT_CONTACT_NAME.'</th>'
					. '<td><input type="text" id="initial_contact_name" name="initial_contact_name" value="' . $this -> getColumnData($this -> userData, COLUMN_INIT_CONTACT_NAME) . '" class="w30p"></td>'
					. '</tr>'
					. '<tr>'
					. '<th>'.VAL_STR_CORP_INIT_EMAIL_ADD.'</th>'
					. '<td><input type="text" id="initial_email_address" name="initial_email_address" value="' . $this -> getColumnData($this -> userData, COLUMN_INIT_EMAIL_ADD) . '" class="w30p"></td>'
					. '</tr>'
					. '<tr>'
					. '<th>'.VAL_STR_CORP_SKYPE_ACC.'</th>'
					. '<td><input type="text" id="skype_account" name="skype_account" value="' . $this -> getColumnData($this -> userData, COLUMN_SKYPE_ACC) . '" class="w30p"></td>'
					. '</tr>';
			}
			$rtn = $rtn
				. '<tr>'
				. '<th>'.VAL_STR_CORP_SITE_NAME.'</th>'
				. '<td><input type="text" id="site_name" name="site_name" value="' . $this -> getColumnData($this -> userData, COLUMN_SITE_NAME) . '" class="w30p"></td>'
				. '</tr>'
				. '<tr>'
				. '<th>'.VAL_STR_CORP_SITE_URL.'</th>'
				. '<td><input type="text" id="site_url" name="site_url" value="' . $this -> getColumnData($this -> userData, COLUMN_SITE_URL) . '" class="w30p"></td>'
				. '</tr>'
				. '<tr>'
				. '<th>'.VAL_STR_CORP_TYPE_OF_USAGE.'</th>'
				. '<td><select name="type_of_usage" id="type_of_usage">' . $this -> dispTypeOfUsage() .  '</select></td>'
				. '</tr>'
				. '<tr>'
				. '<th>'.VAL_STR_CORP_AGREEMENT_STATUS.'</th>'
				. '<td><select name="agreement_status">' . $this -> dispAgreementStatus() .  '</select></td>'
				. '</tr>'
			. '</table>';
		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: カード登録データの消去
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function clear() {

		$this -> cardHolderId	= NO_STRING;
		$this -> digit			= NO_STRING;
		$this -> userLink		= NO_STRING;//mikko 2019 0312
	}

	/*-------------------------------------------------------------------------
	* @function_name: KYC画像のアップロード（個人用）
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function loadImageKycPerson() {

		// 変数宣言部
		$path		= NO_STRING;
		$saveName	= NO_STRING;
		$flg		= false;
		$oldName	= NO_STRING;
		$imgFlg		= NO_STRING;
		$uploads	= array();

		// ルートディレクトリを取得する
		$path = $this -> getKycDirectory($this -> detailAccount);

		// 該当ディレクトリの確認
		if(!file_exists($path)) {
			mkdir($path, 0777, true);
		} else {
			chmod($path, 0777);
		}

		// 画像1の存在確認
		if($this -> isUpload(PARAM_IMG1)) {

			// 保存ファイル名
			$info		= new SplFileInfo($_FILES[PARAM_IMG1][PARAM_NAME]);
			$saveName	= $this -> createUId() . DELIMIT_DOT . $info->getExtension();

			// 画像の移動
			if(move_uploaded_file($_FILES[PARAM_IMG1][PARAM_TMP_NAME], $path . DELIMIT_SLASH . $saveName)) {

				// アップロードファイル名
				$oldName	= basename($_FILES[PARAM_IMG1][PARAM_NAME]);
				$imgFlg		= $this -> getImg1Flg();

				// ファイルパーミッションの変更
				chmod($path . DELIMIT_SLASH . $saveName, 0777);

				// データの登録
				$this -> accessModify('INSERT_KYC', array($this -> detailAccount
						, $oldName
						, $saveName
						, $imgFlg
						, NO_COUNT
						, NO_COUNT
				        , NO_COUNT
				));
				$flg = true;

				if($this -> getColumnData($uploads, $imgFlg) == NO_STRING) {
					$uploads[$imgFlg] = array($oldName);
				} else {
					$uploads[$imgFlg][] = $oldName;
				}
			}
		}

		// 画像2の存在確認
		if($this -> isUpload(PARAM_IMG2)) {

			// 保存ファイル名
			$info		= new SplFileInfo($_FILES[PARAM_IMG2][PARAM_NAME]);
			$saveName	= $this -> createUId() . DELIMIT_DOT . $info->getExtension();

			// 画像の移動
			if(move_uploaded_file($_FILES[PARAM_IMG2][PARAM_TMP_NAME], $path . DELIMIT_SLASH . $saveName)) {

				// アップロードファイル名
				$oldName	= basename($_FILES[PARAM_IMG2][PARAM_NAME]);
				$imgFlg		= $this -> getImg2Flg();

				// ファイルパーミッションの変更
				chmod($path . DELIMIT_SLASH . $saveName, 0777);

				// データの登録
				$this -> accessModify('INSERT_KYC', array($this -> detailAccount
															, $oldName
															, $saveName
															, $imgFlg
															, NO_COUNT
															, NO_COUNT
															, NO_COUNT));
				$flg = true;

				if($this -> getColumnData($uploads, $imgFlg) == NO_STRING) {
					$uploads[$imgFlg] = array($oldName);
				} else {
					$uploads[$imgFlg][] = $oldName;
				}
			}
		}

		// 画像3の存在確認
		if($this -> isUpload(PARAM_IMG3)) {

			// 保存ファイル名
			$info		= new SplFileInfo($_FILES[PARAM_IMG3][PARAM_NAME]);
			$saveName	= $this -> createUId() . DELIMIT_DOT . $info->getExtension();

			// 画像の移動
			if(move_uploaded_file($_FILES[PARAM_IMG3][PARAM_TMP_NAME], $path . DELIMIT_SLASH . $saveName)) {

				// アップロードファイル名
				$oldName	= basename($_FILES[PARAM_IMG3][PARAM_NAME]);
				$imgFlg		= $this -> getImg3Flg();

				// ファイルパーミッションの変更
				chmod($path . DELIMIT_SLASH . $saveName, 0777);

				// データの登録
				$this -> accessModify('INSERT_KYC', array($this -> detailAccount
															, $oldName
															, $saveName
															, $imgFlg
															, NO_COUNT
															, NO_COUNT
															, NO_COUNT));
				$flg = true;

				if($this -> getColumnData($uploads, $imgFlg) == NO_STRING) {
					$uploads[$imgFlg] = array($oldName);
				} else {
					$uploads[$imgFlg][] = $oldName;
				}
			}
		}

		// 画像4の存在確認
		if($this -> isUpload(PARAM_IMG4)) {

			// 保存ファイル名
			$info		= new SplFileInfo($_FILES[PARAM_IMG4][PARAM_NAME]);
			$saveName	= $this -> createUId() . DELIMIT_DOT . $info->getExtension();

			// 画像の移動
			if(move_uploaded_file($_FILES[PARAM_IMG4][PARAM_TMP_NAME], $path . DELIMIT_SLASH . $saveName)) {

				// アップロードファイル名
				$oldName	= basename($_FILES[PARAM_IMG4][PARAM_NAME]);
				$imgFlg		= $this -> getImg4Flg();

				// ファイルパーミッションの変更
				chmod($path . DELIMIT_SLASH . $saveName, 0777);

				// データの登録
				$this -> accessModify('INSERT_KYC', array($this -> detailAccount
															, $oldName
															, $saveName
															, $imgFlg
															, NO_COUNT
															, NO_COUNT
															, NO_COUNT));
				$flg = true;

				if($this -> getColumnData($uploads, $imgFlg) == NO_STRING) {
					$uploads[$imgFlg] = array($oldName);
				} else {
					$uploads[$imgFlg][] = $oldName;
				}
			}
		}

		// 画像5の存在確認
		if($this -> isUpload(PARAM_IMG5)) {

			// 保存ファイル名
			$info		= new SplFileInfo($_FILES[PARAM_IMG5][PARAM_NAME]);
			$saveName	= $this -> createUId() . DELIMIT_DOT . $info->getExtension();

			// 画像の移動
			if(move_uploaded_file($_FILES[PARAM_IMG5][PARAM_TMP_NAME], $path . DELIMIT_SLASH . $saveName)) {

				// アップロードファイル名
				$oldName	= basename($_FILES[PARAM_IMG5][PARAM_NAME]);
				$imgFlg		= $this -> getImg5Flg();

				// ファイルパーミッションの変更
				chmod($path . DELIMIT_SLASH . $saveName, 0777);

				// データの登録
				$this -> accessModify('INSERT_KYC', array($this -> detailAccount
															, $oldName
															, $saveName
															, $imgFlg
															, NO_COUNT
															, NO_COUNT
															, NO_COUNT));
				$flg = true;

				if($this -> getColumnData($uploads, $imgFlg) == NO_STRING) {
					$uploads[$imgFlg] = array($oldName);
				} else {
					$uploads[$imgFlg][] = $oldName;
				}
			}
		}

		// 画像6の存在確認
		if($this -> isUpload(PARAM_IMG6)) {

			// 保存ファイル名
			$info		= new SplFileInfo($_FILES[PARAM_IMG6][PARAM_NAME]);
			$saveName	= $this -> createUId() . DELIMIT_DOT . $info->getExtension();

			// 画像の移動
			if(move_uploaded_file($_FILES[PARAM_IMG6][PARAM_TMP_NAME], $path . DELIMIT_SLASH . $saveName)) {

				// アップロードファイル名
				$oldName	= basename($_FILES[PARAM_IMG6][PARAM_NAME]);
				$imgFlg		= $this -> getImg6Flg();

				// ファイルパーミッションの変更
				chmod($path . DELIMIT_SLASH . $saveName, 0777);

				// データの登録
				$this -> accessModify('INSERT_KYC', array($this -> detailAccount
															, $oldName
															, $saveName
															, $imgFlg
															, NO_COUNT
															, NO_COUNT
															, NO_COUNT));
				$flg = true;

				if($this -> getColumnData($uploads, $imgFlg) == NO_STRING) {
					$uploads[$imgFlg] = array($oldName);
				} else {
					$uploads[$imgFlg][] = $oldName;
				}
			}
		}

		// アップロードファイルが存在したらメールを送信する
		// if($this -> isLoopData($uploads)) {

		// 	// 送信用パラメータの作成
		// 	$imgs		= array();
		// 	$params		= array();
		// 	$params[]	= $this -> detailAccount;
		// 	$params[]	= $this -> getCurrentTimeCommon();
		// 	$dest		= NO_STRING;

		// 	// アップロードファイルのリスト化
		// 	foreach($uploads as $key => $val) {

		// 		$str	= $this -> dispIdentityTypeCommon($key);
		// 		$imgs	= array();

		// 		foreach($val as $val) {
		// 			$imgs[] = $val;
		// 		}

		// 		$dest .=	"\n" . $str . DELIMIT_COLON . DELIMIT_SPACE
		// 				 	. implode(DELIMIT_COMMA . DELIMIT_SPACE, $imgs);
		// 	}

		// 	$params[]	= $dest;

		// 	// メールの送信（管理者側）
		// 	$this -> sendMailByTmp('kyc_upload_for_admin.xml'
		// 							, $params
		// 							, VAR_NOTICE_MAIL_ADDRESS
		// 							, VAR_NOTICE_MAIL_ADDRESS);
		// }

		// アップロードが完了したら一旦認証フラグを落とす
		if($flg) {
			$this -> accessModify('UPDATE_KYC_FLG', array($this -> detailAccount, NO_COUNT), false);
		}
		
		$keyPrefix = "KYC/".substr($this->detailAccount, strlen($this->detailAccount) - 3);
		
		AWSMangos3Bucket::getInstance()->uploadDirectory($path, $keyPrefix);
	}

	/*-------------------------------------------------------------------------
	 * @function_name: KYC画像のアップロード（法人用）
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function loadImageKycCorp() {

		// 変数宣言部
		$path		= NO_STRING;
		$saveName	= NO_STRING;
		$flg		= false;
		$oldName	= NO_STRING;
		$uploads	= array();

		$path = $this -> getKycDirectory($this -> detailAccount);
		// 該当ディレクトリの確認
		if(!file_exists($path)) {
			@mkdir($path, 0777, true);
		} else {
			@chmod($path, 0777);
		}

		// 画像1の存在確認
		if($this -> isUpload(PARAM_IMG1)) {

			// 保存ファイル名
			$info		= new SplFileInfo($_FILES[PARAM_IMG1][PARAM_NAME]);
			$saveName	= $this -> createUId() . DELIMIT_DOT . $info->getExtension();

			// 画像の移動
			if(move_uploaded_file($_FILES[PARAM_IMG1][PARAM_TMP_NAME], $path . DELIMIT_SLASH . $saveName)) {

				// アップロードファイル名
				$oldName	= basename($_FILES[PARAM_IMG1][PARAM_NAME]);
				$imgFlg		= $this -> getImg1Flg();

				// ファイルパーミッションの変更
				chmod($path . DELIMIT_SLASH . $saveName, 0777);

				// データの登録
				$this -> accessModify('INSERT_KYC', array($this -> detailAccount
															, $oldName
															, $saveName
															, $imgFlg
															, NO_COUNT
															, NO_COUNT
															, NO_COUNT));
				$flg = true;

				if($this -> getColumnData($uploads, NO_COUNT) == NO_STRING) {
					$uploads[NO_COUNT] = array($oldName);
				} else {
					$uploads[NO_COUNT][] = $oldName;
				}
			}
		}

		// 画像2の存在確認
		if($this -> isUpload(PARAM_IMG2)) {

			// 保存ファイル名
			$info		= new SplFileInfo($_FILES[PARAM_IMG2][PARAM_NAME]);
			$saveName	= $this -> createUId() . DELIMIT_DOT . $info->getExtension();

			// 画像の移動
			if(move_uploaded_file($_FILES[PARAM_IMG2][PARAM_TMP_NAME], $path . DELIMIT_SLASH . $saveName)) {

				// アップロードファイル名
				$oldName	= basename($_FILES[PARAM_IMG2][PARAM_NAME]);
				$imgFlg		= $this -> getImg2Flg();

				// ファイルパーミッションの変更
				chmod($path . DELIMIT_SLASH . $saveName, 0777);

				// データの登録
				$this -> accessModify('INSERT_KYC', array($this -> detailAccount
															, $oldName
															, $saveName
															, $imgFlg
															, NO_COUNT
															, NO_COUNT
															, NO_COUNT));
				$flg = true;

				if($this -> getColumnData($uploads, NO_COUNT) == NO_STRING) {
					$uploads[NO_COUNT] = array($oldName);
				} else {
					$uploads[NO_COUNT][] = $oldName;
				}
			}
		}

		// 画像3の存在確認
		if($this -> isUpload(PARAM_IMG3)) {

			// 保存ファイル名
			$info		= new SplFileInfo($_FILES[PARAM_IMG3][PARAM_NAME]);
			$saveName	= $this -> createUId() . DELIMIT_DOT . $info->getExtension();

			// 画像の移動
			if(move_uploaded_file($_FILES[PARAM_IMG3][PARAM_TMP_NAME], $path . DELIMIT_SLASH . $saveName)) {

				// アップロードファイル名
				$oldName	= basename($_FILES[PARAM_IMG3][PARAM_NAME]);
				$imgFlg		= $this -> getImg3Flg();

				// ファイルパーミッションの変更
				chmod($path . DELIMIT_SLASH . $saveName, 0777);

				// データの登録
				$this -> accessModify('INSERT_KYC', array($this -> detailAccount
															, $oldName
															, $saveName
															, $imgFlg
															, NO_COUNT
															, NO_COUNT
															, NO_COUNT));
				$flg = true;

				if($this -> getColumnData($uploads, NO_COUNT) == NO_STRING) {
					$uploads[NO_COUNT] = array($oldName);
				} else {
					$uploads[NO_COUNT][] = $oldName;
				}
			}
		}

		// 画像4の存在確認
		if($this -> isUpload(PARAM_IMG4)) {

			// 保存ファイル名
			$info		= new SplFileInfo($_FILES[PARAM_IMG4][PARAM_NAME]);
			$saveName	= $this -> createUId() . DELIMIT_DOT . $info->getExtension();

			// 画像の移動
			if(move_uploaded_file($_FILES[PARAM_IMG4][PARAM_TMP_NAME], $path . DELIMIT_SLASH . $saveName)) {

				// アップロードファイル名
				$oldName	= basename($_FILES[PARAM_IMG4][PARAM_NAME]);
				$imgFlg		= $this -> getImg4Flg();

				// ファイルパーミッションの変更
				chmod($path . DELIMIT_SLASH . $saveName, 0777);

				// データの登録
				$this -> accessModify('INSERT_KYC', array($this -> detailAccount
															, $oldName
															, $saveName
															, $imgFlg
															, NO_COUNT
															, NO_COUNT
															, NO_COUNT));
				$flg = true;

				if($this -> getColumnData($uploads, VAL_INT_1) == NO_STRING) {
					$uploads[VAL_INT_1] = array($oldName);
				} else {
					$uploads[VAL_INT_1][] = $oldName;
				}
			}
		}

		// 画像5の存在確認
		if($this -> isUpload(PARAM_IMG5)) {

			// 保存ファイル名
			$info		= new SplFileInfo($_FILES[PARAM_IMG5][PARAM_NAME]);
			$saveName	= $this -> createUId() . DELIMIT_DOT . $info->getExtension();

			// 画像の移動
			if(move_uploaded_file($_FILES[PARAM_IMG5][PARAM_TMP_NAME], $path . DELIMIT_SLASH . $saveName)) {

				// アップロードファイル名
				$oldName	= basename($_FILES[PARAM_IMG5][PARAM_NAME]);
				$imgFlg		= $this -> getImg5Flg();

				// ファイルパーミッションの変更
				chmod($path . DELIMIT_SLASH . $saveName, 0777);

				// データの登録
				$this -> accessModify('INSERT_KYC', array($this -> detailAccount
															, $oldName
															, $saveName
															, $imgFlg
															, NO_COUNT
															, NO_COUNT
															, NO_COUNT));
				$flg = true;

				if($this -> getColumnData($uploads, VAL_INT_1) == NO_STRING) {
					$uploads[VAL_INT_1] = array($oldName);
				} else {
					$uploads[VAL_INT_1][] = $oldName;
				}
			}
		}

		// 画像6の存在確認
		if($this -> isUpload(PARAM_IMG6)) {

			// 保存ファイル名
			$info		= new SplFileInfo($_FILES[PARAM_IMG6][PARAM_NAME]);
			$saveName	= $this -> createUId() . DELIMIT_DOT . $info->getExtension();

			// 画像の移動
			if(move_uploaded_file($_FILES[PARAM_IMG6][PARAM_TMP_NAME], $path . DELIMIT_SLASH . $saveName)) {

				// アップロードファイル名
				$oldName	= basename($_FILES[PARAM_IMG6][PARAM_NAME]);
				$imgFlg		= $this -> getImg6Flg();

				// ファイルパーミッションの変更
				chmod($path . DELIMIT_SLASH . $saveName, 0777);

				// データの登録
				$this -> accessModify('INSERT_KYC', array($this -> detailAccount
															, $oldName
															, $saveName
															, $imgFlg
															, NO_COUNT
															, NO_COUNT
															, NO_COUNT));
				$flg = true;

				if($this -> getColumnData($uploads, VAL_INT_1) == NO_STRING) {
					$uploads[VAL_INT_1] = array($oldName);
				} else {
					$uploads[VAL_INT_1][] = $oldName;
				}
			}
		}

		// 画像7の存在確認
		if($this -> isUpload(PARAM_IMG7)) {

			// 保存ファイル名
			$info		= new SplFileInfo($_FILES[PARAM_IMG7][PARAM_NAME]);
			$saveName	= $this -> createUId() . DELIMIT_DOT . $info->getExtension();

			// 画像の移動
			if(move_uploaded_file($_FILES[PARAM_IMG7][PARAM_TMP_NAME], $path . DELIMIT_SLASH . $saveName)) {

				// アップロードファイル名
				$oldName	= basename($_FILES[PARAM_IMG7][PARAM_NAME]);
				$imgFlg		= $this -> getImg7Flg();

				// ファイルパーミッションの変更
				chmod($path . DELIMIT_SLASH . $saveName, 0777);

				// データの登録
				$this -> accessModify('INSERT_KYC', array($this -> detailAccount
															, $oldName
															, $saveName
															, $imgFlg
															, NO_COUNT
															, NO_COUNT
															, NO_COUNT));
				$flg = true;

				if($this -> getColumnData($uploads, VAL_INT_2) == NO_STRING) {
					$uploads[VAL_INT_2] = array($oldName);
				} else {
					$uploads[VAL_INT_2][] = $oldName;
				}
			}
		}

		// 画像8の存在確認
		if($this -> isUpload(PARAM_IMG8)) {

			// 保存ファイル名
			$info		= new SplFileInfo($_FILES[PARAM_IMG8][PARAM_NAME]);
			$saveName	= $this -> createUId() . DELIMIT_DOT . $info->getExtension();

			// 画像の移動
			if(move_uploaded_file($_FILES[PARAM_IMG8][PARAM_TMP_NAME], $path . DELIMIT_SLASH . $saveName)) {

				// アップロードファイル名
				$oldName	= basename($_FILES[PARAM_IMG8][PARAM_NAME]);
				$imgFlg		= $this -> getImg8Flg();

				// ファイルパーミッションの変更
				chmod($path . DELIMIT_SLASH . $saveName, 0777);

				// データの登録
				$this -> accessModify('INSERT_KYC', array($this -> detailAccount
															, $oldName
															, $saveName
															, $imgFlg
															, NO_COUNT
															, NO_COUNT
															, NO_COUNT));
				$flg = true;

				if($this -> getColumnData($uploads, VAL_INT_3) == NO_STRING) {
					$uploads[VAL_INT_3] = array($oldName);
				} else {
					$uploads[VAL_INT_3][] = $oldName;
				}
			}
		}

		// 画像9の存在確認
		if($this -> isUpload(PARAM_IMG9)) {

			// 保存ファイル名
			$info		= new SplFileInfo($_FILES[PARAM_IMG9][PARAM_NAME]);
			$saveName	= $this -> createUId() . DELIMIT_DOT . $info->getExtension();

			// 画像の移動
			if(move_uploaded_file($_FILES[PARAM_IMG9][PARAM_TMP_NAME], $path . DELIMIT_SLASH . $saveName)) {

				// アップロードファイル名
				$oldName	= basename($_FILES[PARAM_IMG9][PARAM_NAME]);
				$imgFlg		= $this -> getImg9Flg();

				// ファイルパーミッションの変更
				chmod($path . DELIMIT_SLASH . $saveName, 0777);

				// データの登録
				$this -> accessModify('INSERT_KYC', array($this -> detailAccount
															, $oldName
															, $saveName
															, $imgFlg
															, NO_COUNT
															, NO_COUNT
															, NO_COUNT));
				$flg = true;

				if($this -> getColumnData($uploads, VAL_INT_4) == NO_STRING) {
					$uploads[VAL_INT_4] = array($oldName);
				} else {
					$uploads[VAL_INT_4][] = $oldName;
				}
			}
		}

		// 画像10の存在確認
		if($this -> isUpload(PARAM_IMG10)) {

			// 保存ファイル名
			$info		= new SplFileInfo($_FILES[PARAM_IMG10][PARAM_NAME]);
			$saveName	= $this -> createUId() . DELIMIT_DOT . $info->getExtension();

			// 画像の移動
			if(move_uploaded_file($_FILES[PARAM_IMG10][PARAM_TMP_NAME], $path . DELIMIT_SLASH . $saveName)) {

				// アップロードファイル名
				$oldName	= basename($_FILES[PARAM_IMG10][PARAM_NAME]);
				$imgFlg		= $this -> getImg10Flg();

				// ファイルパーミッションの変更
				chmod($path . DELIMIT_SLASH . $saveName, 0777);

				// データの登録
				$this -> accessModify('INSERT_KYC', array($this -> detailAccount
															, $oldName
															, $saveName
															, $imgFlg
															, NO_COUNT
															, NO_COUNT
															, NO_COUNT));

				$flg = true;

				if($this -> getColumnData($uploads, VAL_INT_5) == NO_STRING) {
					$uploads[VAL_INT_5] = array($oldName);
				} else {
					$uploads[VAL_INT_5][] = $oldName;
				}
			}
		}

		// 画像11の存在確認
		if($this -> isUpload(PARAM_IMG11)) {

			// 保存ファイル名
			$info		= new SplFileInfo($_FILES[PARAM_IMG11][PARAM_NAME]);
			$saveName	= $this -> createUId() . DELIMIT_DOT . $info->getExtension();

			// 画像の移動
			if(move_uploaded_file($_FILES[PARAM_IMG11][PARAM_TMP_NAME], $path . DELIMIT_SLASH . $saveName)) {

				// アップロードファイル名
				$oldName	= basename($_FILES[PARAM_IMG11][PARAM_NAME]);
				$imgFlg		= $this -> getImg11Flg();

				// ファイルパーミッションの変更
				chmod($path . DELIMIT_SLASH . $saveName, 0777);

				// データの登録
				$this -> accessModify('INSERT_KYC', array($this -> detailAccount
															, $oldName
															, $saveName
															, $imgFlg
															, NO_COUNT
															, NO_COUNT
															, NO_COUNT));
				$flg = true;

				if($this -> getColumnData($uploads, VAL_INT_6) == NO_STRING) {
					$uploads[VAL_INT_6] = array($oldName);
				} else {
					$uploads[VAL_INT_6][] = $oldName;
				}
			}
		}

		// アップロードが完了したら一旦認証フラグを落とす
		if($flg) {
			$this -> accessModify('UPDATE_KYC_FLG', array($this -> detailAccount, NO_COUNT), false);
		}
		
		$keyPrefix = "KYC/".substr($this->detailAccount, strlen($this->detailAccount) - 3);
		
		AWSMangos3Bucket::getInstance()->uploadDirectory($path, $keyPrefix);

		// アップロードファイルが存在したらメールを送信する
		// if($this -> isLoopData($uploads)) {

		// 	// 送信用パラメータの作成
		// 	$imgs		= array();
		// 	$params		= array();
		// 	$params[]	= $this -> detailAccount;
		// 	$params[]	= $this -> getCurrentTimeCommon();
		// 	$dest		= NO_STRING;

		// 	// アップロードファイルのリスト化
		// 	foreach($uploads as $key => $val) {

		// 		$str	= $this -> dispIdentityTypeCommon($key);
		// 		$imgs	= array();

		// 		foreach($val as $val) {
		// 			$imgs[] = $val;
		// 		}

		// 		$dest .=	"\n" . $str . DELIMIT_COLON . DELIMIT_SPACE
		// 				 	. implode(DELIMIT_COMMA . DELIMIT_SPACE, $imgs);
		// 	}

		// 	$params[]	= $dest;

		// 	// メールの送信（管理者側）
		// 	$this -> sendMailByTmp('kyc_upload_for_admin.xml'
		// 							, $params
		// 							, VAR_NOTICE_MAIL_ADDRESS
		// 							, VAR_NOTICE_MAIL_ADDRESS);
		// }
	}

	/*-------------------------------------------------------------------------
	* @function_name: アップロードファイルの存在確認
	* @parameter	: パラメータ
	* @return		: 存在する:true、存在しない:false
	-------------------------------------------------------------------------*/
	function isUpload($param) {

		// 変数宣言部
		$rtn = false;

		if(isset($_FILES[$param])) {

			if(is_uploaded_file($_FILES[$param][PARAM_TMP_NAME])) {
				$rtn = true;
			}
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 画像1フラグの取得
	* @parameter	: なし
	* @return		: 画像1フラグ
	-------------------------------------------------------------------------*/
	public function getImg1Flg() {
		return $this -> img1Flg;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 画像2フラグの取得
	* @parameter	: なし
	* @return		: 画像2フラグ
	-------------------------------------------------------------------------*/
	public function getImg2Flg() {
		return $this -> img2Flg;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 画像3フラグの取得
	* @parameter	: なし
	* @return		: 画像3フラグ
	-------------------------------------------------------------------------*/
	public function getImg3Flg() {
		return $this -> img3Flg;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 画像4フラグの取得
	* @parameter	: なし
	* @return		: 画像4フラグ
	-------------------------------------------------------------------------*/
	public function getImg4Flg() {
		return $this -> img4Flg;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 画像5フラグの取得
	* @parameter	: なし
	* @return		: 画像5フラグ
	-------------------------------------------------------------------------*/
	public function getImg5Flg() {
		return $this -> img5Flg;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 画像6フラグの取得
	* @parameter	: なし
	* @return		: 画像6フラグ
	-------------------------------------------------------------------------*/
	public function getImg6Flg() {
		return $this -> img6Flg;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 画像7フラグの取得
	* @parameter	: なし
	* @return		: 画像7フラグ
	-------------------------------------------------------------------------*/
	public function getImg7Flg() {
		return $this -> img7Flg;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 画像8フラグの取得
	* @parameter	: なし
	* @return		: 画像8フラグ
	-------------------------------------------------------------------------*/
	public function getImg8Flg() {
		return $this -> img8Flg;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 画像9フラグの取得
	* @parameter	: なし
	* @return		: 画像9フラグ
	-------------------------------------------------------------------------*/
	public function getImg9Flg() {
		return $this -> img9Flg;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 画像10フラグの取得
	* @parameter	: なし
	* @return		: 画像10フラグ
	-------------------------------------------------------------------------*/
	public function getImg10Flg() {
		return $this -> img10Flg;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 画像11フラグの取得
	* @parameter	: なし
	* @return		: 画像11フラグ
	-------------------------------------------------------------------------*/
	public function getImg11Flg() {
		return $this -> img11Flg;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 取引タイプの取得
	 * @parameter	: なし
	 * @return		: HTML表示用データ
	 -------------------------------------------------------------------------*/
	public function dispTransactionTypeList() {
		echo $this -> dispListOption($this -> getTransactionTypeList(), $this -> sTransactionType);
	}

	/*-------------------------------------------------------------------------
	* @function_name: パスワードの取得
	* @parameter	: なし
	* @return		: パスワード
	-------------------------------------------------------------------------*/
	public function echoPassword() {
		echo $this -> password;
	}

	/*-------------------------------------------------------------------------
	* @function_name: KYC書類IDの取得
	* @parameter	: なし
	* @return		: KYC書類ID
	-------------------------------------------------------------------------*/
	public function getKId() {
		return $this -> kId;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 旧ファイル名の取得
	* @parameter	: なし
	* @return		: 旧ファイル名
	-------------------------------------------------------------------------*/
	public function getOldFileName() {
		return $this -> oldFileName;
	}

	/*-------------------------------------------------------------------------
	* @function_name: ファイルパスの取得
	* @parameter	: なし
	* @return		: ファイルパス
	-------------------------------------------------------------------------*/
	public function getPath() {
		return $this -> path;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 旧ファイル名の設定
	* @parameter	: 旧ファイル名
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function setOldFileName($name) {
		$this -> oldFileName = $name;
	}

	/*-------------------------------------------------------------------------
	* @function_name: ファイルパスの設定
	* @parameter	: ファイルパス
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function setPath($path) {
		$this -> path = $path;
	}

	/*-------------------------------------------------------------------------
	* @function_name: ユーザデータの設定
	* @parameter	: 出金リスト
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function setUser($rs) {
		$this -> user = $rs[NO_COUNT];
	}

	/*-------------------------------------------------------------------------
	* @function_name: ユーザデータの設定
	* @parameter	: 出金リスト
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function setKYCS($rs) {
		$this -> kycs = $rs;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 取引番号の取得
	* @parameter	: なし
	* @return		: 取引番号
	-------------------------------------------------------------------------*/
	public function echoSTransactionNumber() {
		echo $this -> sTransactionNumber;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 検索メールアドレスの取得
	* @parameter	: なし
	* @return		: 検索メールアドレス
	-------------------------------------------------------------------------*/
	public function echoSEmail() {
		echo $this -> sEmail;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 検索口座番号の取得
	* @parameter	: なし
	* @return		: 検索口座番号
	-------------------------------------------------------------------------*/
	public function echoSUserAccount() {
		echo $this -> sUserAccount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 検索開始日の取得
	* @parameter	: なし
	* @return		: 検索開始日
	-------------------------------------------------------------------------*/
	public function echoSFrom() {
		echo $this -> sFrom;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 検索終了日の取得
	* @parameter	: なし
	* @return		: 検索終了日
	-------------------------------------------------------------------------*/
	public function echoSTo() {
		echo $this -> sTo;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 検索通貨の取得
	* @parameter	: なし
	* @return		: 検索通貨
	-------------------------------------------------------------------------*/
	public function getSCurrency() {
		return $this -> sCurrency;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 通貨リストの取得
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function echoCurrencyList() {

		// 変数宣言部
		$lists	= array();
		if($this -> isLoopData($this -> currencies)) {

			foreach($this -> currencies as $row) {
				$lists[] = array(PARAM_DATA_KEY			=> $this -> getColumnData($row, COLUMN_CURRENCY_NAME)
									, PARAM_DATA_VALUE	=> $this -> getColumnData($row, COLUMN_CURRENCY_NAME));
			}
		}

		echo $this -> dispListOption($lists, $this -> sCurrency);
	}

	public function getCrntPage() {
		return $this -> crntPage;
	}
	/*-------------------------------------------------------------------------
	* @function_name: エージェントコードの表示
	* @parameter	: なし
	* @return		: エージェントコード
	-------------------------------------------------------------------------*/
	function echo2facontrol($disable = 'disabled') {

		$code = NO_STRING;
		$outhtml = NO_STRING;
		if ($this -> enablemail == NO_COUNT) {
			$disable = 'disabled';
		}

		//拼接html
		if( $this -> login2fa == VAL_INT_1){
			$code = '<input type="checkbox" name="login2fa" value="login2fa" checked="checked" '.$disable.' /> '.VAL_STR_2FA_LOGIN.'<br>';
		} else {
			$code = '<input type="checkbox" name="login2fa" value="login2fa"  '.$disable.' /> '.VAL_STR_2FA_LOGIN.'<br>';
		}

		if ($this -> profile2fa == VAL_INT_1) {
			$code .= '<input type="checkbox" name="profile2fa" value="profile2fa" checked="checked" '.$disable.' />'.VAL_STR_2FA_PROF_CHANGE.'<br>';
		} else {
			$code .= '<input type="checkbox" name="profile2fa" value="profile2fa" '.$disable.' /> '.VAL_STR_2FA_PROF_CHANGE.'<br>';
		}
		if ($this -> money2fa == VAL_INT_1 ) {

			$code .= '<input type="checkbox" name="money2fa" value="money2fa" checked="checked" '.$disable.' /> '.VAL_STR_2FA_MONEY_OUT.'<br>';
		} else {
			$code .= '<input type="checkbox" name="money2fa" value="money2fa" '.$disable.' /> '.VAL_STR_2FA_MONEY_OUT.'<br>';
		}
		if ($this -> get2faAccount()) {
			$outhtml = '<tr><th>'.VAL_STR_2FA_TEXT.'</th><td>'.$code.'</td></tr>';
		} else {
			$outhtml = '<tr style="display:none;"><th>'.VAL_STR_2FA_TEXT.'</th><td>'.$code.'</td></tr>';
		}

		echo $outhtml;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 确认二次认证code enable
	* @parameter	: なし
	* @return		: エージェントコード
	-------------------------------------------------------------------------*/
	function set2fa($con = true){
		$param = array();
		//获取2faenable
		$rtn = $this -> accessSelect('SELECT_2FA_ENABLE',array($this -> getAccountNumber()));

		if (count($rtn) == NO_COUNT) {

			if($this->getAccountType() == VAR_CORP){
				$this -> accessModify('INSERT_2FA_ENABLE_CORP', array($this -> accountNumber), false);
			}else{
				$this -> accessModify('INSERT_2FA_ENABLE', array($this -> accountNumber), false);
			}
			$this -> accessModify('INSERT_2FA_CODE', array($this -> accountNumber), false);
			$rtn = $this -> accessSelect('SELECT_2FA_ENABLE', array($this -> accountNumber));
		}


		if( $this -> getColumnData($rtn[0],'login') == VAL_INT_1){
			$param[] = VAL_INT_1;
		} else {
			$param[] = NO_COUNT;
		}

		if ($this -> getColumnData($rtn[0],'password') ==  VAL_INT_1 && $this -> getColumnData($rtn[0],'mail') == VAL_INT_1) {
			$param[] = VAL_INT_1;
		} else {
			$param[] = NO_COUNT;
		}
		if ($this -> getColumnData($rtn[0],'withdrawal_international') == VAL_INT_1 && $this -> getColumnData($rtn[0],'withdrawal_sdpay') ==  VAL_INT_1 && $this -> getColumnData($rtn[0],'transfer') ==  VAL_INT_1 && $this -> getColumnData($rtn[0],'exchange') ==  VAL_INT_1 && $this -> getColumnData($rtn[0],'received') == VAL_INT_1 ) {
			$param[] = VAL_INT_1;
		} else {
			$param[] = NO_COUNT;
		}
		$param[] = $this -> getColumnData($rtn[0],'enablemail');

		if ($con) {
			$this -> login2fa		=	$param[0];
			$this -> profile2fa		=	$param[1];
			$this -> money2fa		=	$param[2];
			$this -> enablemail 	=	$param[3];
		}
		$param[] = $this -> getColumnData($rtn[0],'lang');
		return $param;

	}

	/*-------------------------------------------------------------------------
	* @function_name: 确认二次认证code 修改
	* @parameter	: なし
	* @return		: エージェントコード
	-------------------------------------------------------------------------*/
	function get2faAll(){
		$rtn = array();

		$this -> login2fa 	=  $this -> getNothien($this -> login2fa);
		$this -> profile2fa =  $this -> getNothien($this -> profile2fa);
		$this -> money2fa 	=  $this -> getNothien($this -> money2fa);
		$rtn[] = $this -> login2fa;
		$rtn[] = $this -> profile2fa;
		$rtn[] = $this -> money2fa;
		$rtn[] = $this -> accountNumber;

		return $rtn;
	}
	function getNothien($rth){

		if ($rth == '') {
			return '0';
		} else {
			return '1';
		}
	}
	/*-------------------------------------------------------------------------
	* @function_name: 判断是否是法人
	* @parameter	: なし
	* @return		: エージェントコード
	-------------------------------------------------------------------------*/
	function get2faAccount(){
		if ($this -> accountType == VAL_INT_1) {
			return true;
		} else {
			return false;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 判断是否需要发送变更信息
	* @parameter	: なし
	* @return		: エージェントコード
	-------------------------------------------------------------------------*/
	function take2faChangeMail($param){

		$rth = array();

		if ($this -> get2faAccount()) {
			if ($param[3] == VAL_INT_1) {

				if ( ($param[0] != $this -> login2fa) || ($param[1] != $this -> profile2fa) || ($param[2] != $this -> money2fa)) {

					$rth[] = $this -> accountNumber;
					$rth[] = $this -> firstName.' '.$this -> lastName;
					if($this -> login2fa == '1' &&  $this -> profile2fa == '1' && $this -> money2fa == '1'){

						$this -> sendMailByTmpFromManual('2fa_enable.xml'
								, $rth
								, $this -> mail
								, VAR_CS_MAIL_ADDRESS
								, $param[4]);
					} else {

						$this -> sendMailByTmpFromManual('2fa_disable.xml'
								, $rth
								, $this -> mail
								, VAR_CS_MAIL_ADDRESS
								,  $param[4]);
					}
				}
			}
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 个人法人变化启动所有认证code
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function exchangeAccount(){
		$useraccount	= $this -> getDetailAccount();
		$user			= $this -> accessSelect('SELECT_USER_BY_ACCOUNT', array($useraccount));
		$accountType	= $this -> getColumnData($user[0],'account_type');
		$lang			= $this -> getColumnData($user[0],'use_language');

		if ($this -> accountType != $accountType) {
			if ($this -> accountType == VAL_INT_1){
					$this -> accessModify('UPDATE_2FA_ENABLE',array('0','0','0',$useraccount),false);
					$this -> accessModify('UPDATE_2FA_ENABLE_MAIL', array('1',$useraccount,$lang),false);
					$this -> login2fa 		= 0;
					$this -> profile2fa 	= 0;
					$this -> money2fa		= 0;
			} else {
					$this -> accessModify('UPDATE_2FA_ENABLE',array('1','1','1',$useraccount),false);
					$this -> accessModify('UPDATE_2FA_ENABLE_MAIL', array('1',$useraccount,$lang),false);
					$this -> login2fa 		= 1;
					$this -> profile2fa 	= 1;
					$this -> money2fa		= 1;
			}

		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: dispUserCustomAccess
	* @parameter	: none
	* @return		: string containing user access html
	-------------------------------------------------------------------------*/

	public function dispUserCustomAccess($method) {

		// 変数宣言部
		$rtn		= NO_STRING;
		$list		= null;
		$checkboxId		= NO_STRING;
		$flgs		= null;
		$cnt		= NO_COUNT;
		$selected	= NO_STRING;

		if($method == PARAM_DEPOSIT){
			$list	= $this -> getDepositSolutionListAdminCommon();
			$checkboxId = PARAM_USER_DEPOSIT_BYPASS_ACCESS;
		}else{
			$list	= $this -> getWithdrawSolutionListAdminCommon();
			$checkboxId = PARAM_USER_WITHDRAW_BYPASS_ACCESS;
		}

		if($this -> isLoopData($list)) {

			foreach($list as $val) {

				$params = array();
				$params[] = $method;
				$params[] = $this -> getColumnData($val, PARAM_DATA_KEY);
				$params[] = $this -> accountNumber;

				$res = $this -> getRowData($this -> accessSelect('SELECT_USER_BYPASS_SOLUTION', $params));

				if($res!=NULL){
					$selected = $this -> getColumnData($val, PARAM_DATA_KEY);

				} else {
					$selected = NO_STRING;
				}

				$rtn .=  '<label>'
							. $this -> makeCheckOne($checkboxId
													, $checkboxId . '[]'
													, $this -> getColumnData($val, PARAM_DATA_KEY)
													, $this -> getColumnData($val, PARAM_DATA_VALUE)
													, $selected)
							. '</label>';

				$cnt++;
			}
		}
	//	$rtn .= '</div>';

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: echoUserCustomAccess
	* @parameter	: method string (deposit ir withdraw)
	* @return		: string containing user access html
	-------------------------------------------------------------------------*/

	public function echoUserCustomAccess($method) {

		$params = array();
		$params[] = $method;
		$params[] = $this -> accountNumber;

		$accessList = $this -> accessSelect('LIST_USER_BYPASS_SOLUTION', $params);
		if($method == 'deposit'){
			$solutionArray = $this -> getDepositSolutionListAdminCommon();
		}else{
			$solutionArray = $this -> getWithdrawSolutionListAdminCommon();
		}

		$rtn = array();

		$row='';
		$listCount	= count($accessList);
		for($cnt = 0; $cnt < $listCount; $cnt++) {
				$row = $this -> getRowData($accessList, $cnt);
				$solution = $this -> getColumnData($row, 'solution');


				if(in_array($solution, array_column($solutionArray, PARAM_DATA_KEY))) { // search value in the array

					foreach($solutionArray as $val) {
						if($solution == $this -> getColumnData($val, PARAM_DATA_KEY)){
							 $rtn[]= $this -> getColumnData($val, PARAM_DATA_VALUE);
						}
					}
				}

		}

		if($rtn==NULL){
			$rtn[] = VAL_STR_DEFAULT_ACCESS;
		}
		echo implode(DELIMIT_COMMA, $rtn);
	}

	public function getUserDepositBypassAccess() {
		return $this -> userDepositBypassAccess;
	}
	public function getUserWithdrawBypassAccess() {
		return $this -> userWithdrawBypassAccess;
	}

	public function getUserBypassSolutionList($method){
		$rtn = array();
		$params = array();
		$params[] = $method;
		$params[] = $this -> detailAccount;

		$accessList = $this -> accessSelect('LIST_USER_BYPASS_SOLUTION', $params);
		$listCount	= count($accessList);
		$row='';
		for($cnt = 0; $cnt < $listCount; $cnt++) {
				$row = $this -> getRowData($accessList, $cnt);
				$rtn[] = $this -> getColumnData($row, 'solution');
		}
		return $rtn;
	}
	function getUpdateBypassAccessData($method, $solution) {

		$rtn = array();

		$rtn[] = $method;
		$rtn[] = $solution;
		$rtn[] = $this -> detailAccount;
		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: insertActivity
	* @parameter	:
	* @return		:
	-------------------------------------------------------------------------*/
   function getActivity(){
  	 	$type 					= $this -> getType();
  	 	$details 				= array();
		$accountNumber 			= $this -> detailAccount;
   		$newFirstName 			= $this -> firstName;
   		$newLastName 			= $this -> lastName;
   		$newStatus 				= $this -> status;
   		$newTransferFlg 		= $this -> transferFlg;
   		$type 					= $this -> getType();
   		$newAgentCode 			= $this -> agentCode;
   		$row 					= $this -> getAccountCommon($accountNumber);

   		$originalAgentCode 		= $this -> getColumnData($row[0], COLUMN_PARENT_AGENT_CODE);
   		$origFirstName 			= $this -> getColumnData($row[0], COLUMN_FIRST_NAME);
   		$origLastName 			= $this -> getColumnData($row[0], COLUMN_LAST_NAME);
   		$origStatus 			= $this -> getColumnData($row[0], COLUMN_STATUS);
   		$oldTransferFlg 		= $this -> getColumnData($row[0], COLUMN_TRANSFER_FLG);
   		$oldTestAccountFlg 		= $this -> getColumnData($row[0], COLUMN_TEST_ACCOUNT_FLG);


   		if($type == TYPE_COMPLETE){

   			if($origFirstName != $newFirstName || $origLastName != $newLastName) {
   				$details[] = 'name from ['.$origLastName.' '.$origFirstName.'] to ['.$newLastName.' '.$newFirstName.']';
   			}

   			if($origStatus != $newStatus){
   				$details[] = 'account status from ['. $this -> dispUserStatusCommon($origStatus) .'] to ['. $this -> dispUserStatusCommon($newStatus) .']';
   			}

   			if($originalAgentCode != $newAgentCode){
   				$details[] = 'agent code from ['. $originalAgentCode .'] to ['. $newAgentCode .']';
   			}

   			if($oldTestAccountFlg != $this -> testAccountFlg){
   				$details[] = 'Account Category from ['. $this -> getValueByList($this -> getTestAccountList(), $oldTestAccountFlg) .'] to ['. $this -> getValueByList($this -> getTestAccountList(), $this -> testAccountFlg) .']';
   			}

   			if($oldTransferFlg != $newTransferFlg){
   				$details[] = 'Receive User-Initiated Internal Transfer from ['. $this -> getValueByList($this -> getTransferList(), $oldTransferFlg) .'] to ['. $this -> getValueByList($this -> getTransferList(), $newTransferFlg) .']';
   			}

   			if($details != NULL){
   				$message = 'Edited '.$accountNumber.' '.$newLastName.' '.$newFirstName.'\'s '. implode(', <br/>', $details);
   			}else{
   				$message = 'Edited '.$accountNumber.' '.$newLastName.' '.$newFirstName.'\'s account details';
   			}
   		}elseif($type == TYPE_SAVE) {
   			$message = 'Edited '.$accountNumber.' '.$newLastName.' '.$newFirstName.'\'s remarks';
   		}elseif($type == NO_STRING){
   			$message = 'Viewed '.$accountNumber.' '.$newLastName.' '.$newFirstName.'\'s account details' ;
   		}elseif($type == TYPE_SAVE_RISK){
   			$message = 'Edited '.$accountNumber.' '.$newLastName.' '.$newFirstName.'\'s Risk Remark' ;

   		}


		$rtn = array();

		$rtn[] = $this -> getAdminUserData(PARAM_UID);
		$rtn[] = $_SERVER[PARAM_REMOTE_ADDR];
		$rtn[] = $_SERVER[PARAM_HTTP_USER_AGENT];
		$rtn[] = 14;
		$rtn[] = date("Y-m-d H:i:s");
		$rtn[] = $message;

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: dispTypeOfUsage
	* @parameter	:
	* @return		:
	-------------------------------------------------------------------------*/
	public function dispTypeOfUsage() {
		return $this -> dispListOption($this -> getTypeOfUsage(), $this -> typeOfUsage);
	}

	/*-------------------------------------------------------------------------
	* @function_name: dispAgreementStatus
	* @parameter	:
	* @return		:
	-------------------------------------------------------------------------*/
	public function dispAgreementStatus() {
		return $this -> dispListOption($this -> getAgreementStatus(), $this -> agreementStatus);
	}

}
?>
