<?php
$page_title = "卡-输入信息";
include_once('site_config.php');
include_once('template/base_site_head.php');
?>
	<!-- メインエリア -->
	<div id="main" class="container">
		<ol class="breadcrumb">
			<li><a href="<?php echo $home_url; ?>">首页</a></li>
			<li class="active"><?php echo $page_title; ?></li>
		</ol>
		<div class="progress">
			<div class="progress-bar progress-bar-striped active w80p" role="progressbar" aria-valuenow="20" aria-valuemin="0" aria-valuemax="100"><span class="visible-xs">第1步</span><span class="hidden-xs">输入卡片信息</span></div>
		</div>
		<h2><?php echo $page_title; ?></h2>
		<form id="acForm" action="" method="post">
			<?php $this -> dispMessagesCommon(); ?>
			<table class="table table-bordered c_th mb05">
				<colgroup>
					<col class="w40p">
					<col class="w60p">
				</colgroup>
				<tbody>
					<tr>
						<th>出生日期</th>
						<td>
							<select name="year" class="select">
								<?php $this -> dispYear(); ?>
							</select>
							<span class="spcr-br">年</span>
							<select name="month" class="select">
								<?php $this -> dispMonth(); ?>
							</select>
							<span class="spcr-br">月</span>
							<select name="day" class="select">
								<?php $this -> dispDay(); ?>
							</select>
							<span>日</span>
						</td>
					</tr>
					<tr>
						<th>卡号</th>
						<td><input type="text" id="card_number" name="card_number" value="<?php $this -> echoCardNumber(); ?>" /></td>
					</tr>
				</tbody>
			</table>
			<p class="red font12 mb20">
				注意事项<br/>
				※请保管好您的密码，不要告诉任何人。<br/>
				※请注意，如果您在同一读卡器上连续输错三次密码您的卡将会被冻结。
			</p>
			<p class="text-center"><input type="button" id="btnConfirm" value="已阅读注意事项" class="btn btn-primary btn-lg"></p>
			<input type="hidden" id="type" name="type" value="" />
		</form>
	</div>
	<script src="../js/card_pin.js"></script>
     <!-- /メインエリア -->
<?php
	include_once('template/base_site_foot.php');
	echo $endscripts;
?>
</body>
</html>