$(function() {

	$('#btnCardInput').click(function() {
		$('#type').val('input');
		submitForm();
	});

	$('#btnCardConfirm').click(function() {
		$('#type').val('confirm');
		submitForm();
	});

	$('#btnCardComplete').click(function() {
		$('#btnCardComplete').attr('disabled', true);
		$('#type').val('complete');
		submitForm();
	});

	$('#btnBalance').click(function() {
		getWalletBalance();
	});

	$('#btnDisp').click(function() {
		$('#input').val('detail');
		submitForm();
	});

	$('#card_holder_id').change(function() {
		getCardBalance($('#card_holder_id').val());
	});


	// カードが選択されている場合
	if($('#card_holder_id').val()	!= ''
		&& getParam('type')			!= 'detail'
		&& getParam('type')			!= 'input'
		&& getParam('type')			!= 'confirm'
		&& getParam('type')			!= 'complete') {
		getCardBalance($('#card_holder_id').val());
	}
});

// カード残高の取得
function getCardBalance(cardHolderId) {

	$('#balanceSpan').text('Checking...');
	$('#expire_date').text('Checking...');

	// ポストアクション
	postAction('../api/GetPlatinumCardBalance', {'card_holder_id':cardHolderId}).done(function(data) {
console.log(data);
		$('#balanceSpan').text('USD ' + data.result);
		$('#expire_date').text(data.expire_date);
	})
	.fail(function(data) {
		console.log(data);
	});

}

//カード残高の取得
function getWalletBalance() {

	$('#balanceCurrency').text('Checking...');

	// ポストアクション
	postAction('../api/GetAccountBalance', {'currency':$('#debit_currency').val(), 'user_account':$('#user_account').val()})
	.done(function(data) {
		$('#balanceCurrency').text($('#debit_currency').val() + ' ' + data.balance.balance.toString());
	})
	.fail(function(data) {
		console.log(data);
	});
}