
<?php
require_once('config.php');

class APICheckPasswordBase extends System {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $signature	= NO_STRING;
	private $account	= NO_STRING;
	private $password	= NO_STRING;
	private $user		= NO_STRING;

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: パスワードの更新
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function action() {

		// 変数宣言部
		$rtn		= array();

		try {

			// パラメータの設定
			$this -> signature	= $this -> getDataPost(PARAM_SIGNATURE);
			$this -> account	= $this -> getDataPost(PARAM_USER_ACCOUNT);
			$this -> password	= $this -> getDataPost(PARAM_PASSWORD);

			// エラーチェック
			$this -> validate();

		} catch (Exception $e) {
			throw $e;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: エラーチェック
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function validate() {

		// 変数宣言部
		$msgs = array();

		try {

			// 口座の存在確認
			$this -> user = $this -> getAccountCommon($this -> account);

			if(count($this -> user) == NO_COUNT) {
				throw new Exception('E_REQUIRED_VALUE');
			}

			$this -> user = $this -> getRowData($this -> user);

			// パスワードチェック
			if(!$this -> checkNull($this -> password)) {
				throw new Exception('E_REQUIRED_VALUE');
			}

			// パスワードの正規表現
			if(!$this -> checkStringPassword($this -> password)) {
				$msgs[] = 'E_ERROR_REGULAR_PASSWORD';
			} else {

				if(!$this -> checkStringPasswordSecond($this -> password)) {
					$msgs[] = 'E_ERROR_REGULAR_PASSWORD_SECOND';
				}
			}

			// 新パスワードの文字数制限
			if(!$this -> checkLength($this -> password
									, VAR_PASSWORD_MIN
									, VAR_PASSWORD_MAX)) {
				$msgs[] = 'E_ERROR_STRING_LENGTH_ANY';
			}

			if(count($msgs) > NO_COUNT) {
				throw new Exception(implode(DELIMIT_COMMA, $msgs));
			}
		} catch (Exception $e) {
			throw  $e;
		}
	}
}
?>