<?php
class TransferModelClassBatch extends ModelClassEx {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $rs					= null;			// 結果セット
	private $tId				= NO_COUNT;		// トランザクションID
	private $from				= NO_STRING;	// 送金元口座番号
	private $to					= NO_STRING;	// 送金先口座番号
	private $amount				= NO_STRING;	// 金額
	private $balances			= null;			// バランス
	private $currencies			= null;			// 通貨データ
	private $message			= NO_STRING;	// メッセージ
	private $fromCurrency		= NO_STRING;	// From通貨
	private $toCurrency			= NO_STRING;	// To通貨
	private $transferType		= NO_COUNT;		// 送金タイプ
	private $fromName			= NO_STRING;	// from名前
	private $toName				= NO_STRING;	// to名前
	private $rate 				= NO_STRING;	// レート
	private $debitAmount		= NO_COUNT;		// 出金金額
	private $debitCurrency		= NO_STRING;	// 出金通貨
	private $transferCurrency	= NO_STRING;	// 送金通貨
	private $transferAmount		= NO_STRING;	// 送金金額
	private $fromFee			= NO_COUNT;		// 送金元手数料
	private $toFee				= NO_COUNT;		// 送金先手数料
	private $summaryList		= null;			// 残高リスト
	private $afterSummaryList	= null;			// 処理後残高リスト

	// ------------------ インポート系 ------------------//
	private $csv				= array();		// CSVデータ
	private $errCsv				= null;			// CSVエラーデータ
	private $errFlg				= NO_COUNT;		// エラーフラグ
	private $tmpPath			= NO_STRING;	// テンプレートパス
	private $oldFilename		= NO_STRING;	// 元ファイル名
	private $newFilename		= NO_STRING;	// 元ファイル名

	// ------------------ 検索系 ------------------//
	private $sTId				= NO_STRING;	// トランザクションID
	private $sTransactionNumber = NO_STRING; 	// 取引番号
	private $sFromAccount		= NO_STRING;	// From口座番号
	private $sToAccount			= NO_STRING;	// To口座番号
	private $sFromName			= NO_STRING;	// Fromユーザネーム
	private $sToName			= NO_STRING;	// Toユーザネーム
	private $sFrom				= NO_STRING;	// 開始日
	private $sTo				= NO_STRING;	// 終了日
	private $sProcessType		= array();		// 処理タイプ
	private $csvdata			= NO_STRING;	// anton (5342)
	private $tempcsv			= NO_STRING;	// anton (5342)
	// ------------------ 検索系 ------------------//
	
	/**
	 *
	 * anton
	 *
	 */
	private $lang				= NO_STRING;

	/*-------------------------------------------------------------------------
	* @function_name: コントロールパネルシステムindexモデルクラスコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		// スーパークラスコンストラクタ呼び出し
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 初期設定関数
	* @parameter	: なし
	* @return		: 成功:success、失敗:error
	-------------------------------------------------------------------------*/
	public function init() {

		try {

			// パラメータの設定
			$this -> setParameter();

			// チェック
			return $this -> validate();

		} catch (Exception $e) {
			throw new Exception(NO_STRING);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: パラメータの設定
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function setParameter() {
		$this -> tId				= $this -> getDataPost(PARAM_T_ID, true, true, true);							// 送金元口座番号
		$this -> from				= $this -> getDataPost(PARAM_FROM, true);							// 送金元口座番号
		$this -> to					= $this -> getDataPost(PARAM_TO, true);							// 送金先口座番号
		$this -> amount				= $this -> getDataPost(PARAM_AMOUNT, true);						// 金額
		$this -> message			= $this -> getDataPost(PARAM_MESSAGE, true);						// メッセージ
		$this -> fromCurrency		= $this -> getDataPost(PARAM_TRANSFER_FROM_CURRENCY, true);		// From通貨
		$this -> toCurrency			= $this -> getDataPost(PARAM_TRANSFER_TO_CURRENCY, true);			// To通貨
		$this -> transferType		= $this -> getDataPost(PARAM_TRANSFER_TYPE, true);				// 送金タイプ
		$this -> fromName			= $this -> getDataPost(PARAM_TRANSFER_FROM_NAME, true);			// from名前
		$this -> toName				= $this -> getDataPost(PARAM_TRANSFER_TO_NAME, true);				// to名前
		$this -> rate				= $this -> getDataPost(PARAM_RATE, true);							// レート
		$this -> debitAmount		= $this -> getDataPost(PARAM_DEBIT_AMOUNT, true);					// 出金金額
		$this -> debitCurrency		= $this -> getDataPost(PARAM_DEBIT_CURRENCY, true);				// 出金通貨
		$this -> transferCurrency	= $this -> getDataPost(PARAM_TRANSFER_CURRENCY, true);			// 送金通貨
		$this -> transferAmount		= $this -> getDataPost(PARAM_TRANSFER_AMOUNT, true);				// 送金金額
		$this -> fromFee			= $this -> getDataPost(PARAM_FROM_FEE, true);						// 送金元手数料
		$this -> toFee				= $this -> getDataPost(PARAM_TO_FEE, true);						// 送金先手数料
		// ------------------ インポート系 ------------------//
		$this -> tmpPath			= $this -> getDataPost(PARAM_TMP_PATH, true, true);				// テンプレートパス
		$this -> oldFilename		= $this -> getDataPost(PARAM_D_ID, true);					// 元ファイル名
		$this -> newFilename		= $this -> getDataPost(PARAM_NEW_FILENAME, true, true);			// 新ファイル名

		// ------------------ 検索系 ------------------//
		$this -> sTId				= $this -> getDataPost(PARAM_S_T_ID, true);				// トランザクションID
		$this -> sTransactionNumber = $this -> getDataPost(PARAM_TRANSACTION_NUMBER, true);	// 取引番号
		$this -> sFromName 			= $this -> getDataPost(PARAM_S_FROM_NAME, true);			// From名前
		$this -> sToName 			= $this -> getDataPost(PARAM_S_TO_NAME, true);			// To名前
		$this -> sFromAccount		= $this -> getDataPost(PARAM_S_FROM_ACCOUNT, true);		// From口座
		$this -> sToAccount			= $this -> getDataPost(PARAM_S_TO_ACCOUNT, true);			// To口座
		$this -> sFrom				= $this -> getDataPost(PARAM_S_FROM, true);				// From日付
		$this -> sTo				= $this -> getDataPost(PARAM_S_TO, true);					// To日付
		$this -> sProcessType		= $this -> getDataPost(PARAM_S_PROCESS_TYPE, true);		// To処理タイプ
		// ------------------ 検索系 ------------------//

		$this -> csvdata			= $this -> getDataPost(PARAM_CSVDATA, true);
		$this -> lang 				= $this -> getLangage();
	}

	/*-------------------------------------------------------------------------
	* @function_name: サーバ側データチェック
	* @parameter	: なし
	* @return		: TRUE:成功、FALSE:失敗
	-------------------------------------------------------------------------*/
	public function validate() {

		// 変数宣言部
		$rtn = true;

		// ログインチェック
		if(!$this -> checkAdminUserLogin()) {
			throw new Exception(NO_STRING);
		}

		/**
		 *
		 * -- anton --
		 * 04/22/2019
		 *
		 */
		$redirect = ($this -> lang != "en" ? "" : "{$this -> lang}/");

		//check access
		if(!$this -> checkAdminUserAccess('BATR', array(''))){
			$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_PAGE_ACCESS', array());
			header('Location: /'.$redirect.'menu');
			exit();
		}

		if($this -> getType() == TYPE_IMPORT) {
			//check access
			if(!$this -> checkAdminUserAccess('BATR', array('','3'))){
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_FUNCTION_ACCESS', array());
				header('Location: /'.$redirect.'menu');
				exit();
			}
		}

		if($this -> getType() == TYPE_IMPORT_CONFIRM) {	// ファイルインポート時のチェック

			// 送金元口座の入力チェック
			if(!$this -> checkNull($this -> from)) {
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_TRANSFER_FROM_ACCOUNT));
				$rtn = false;
			}

			// 入力状態に変更
			if(!$rtn) {
				$this -> setType(TYPE_IMPORT);
				$rtn = false;
			}

			// 送金元口座の存在チェック
			if(!$this -> checkExistAccount($this -> from)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NOT_EXIST', array(VAL_STR_TRANSFER_FROM_ACCOUNT));
				$rtn = false;
			}

			if(!isset($_FILES)
				|| !isset($_FILES[PARAM_CSV])
				|| !is_uploaded_file($_FILES[PARAM_CSV][PARAM_TMP_NAME])) {

				if($this -> csvdata != NO_STRING){
					$this -> unserializeBulkTransferData();
				}else{
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_NOT_EXIST', array(VAL_STR_UPLOAD_FILE));
					$rtn = false;
				}
			}

			// 入力状態に変更
			if(!$rtn) {
				$this -> setType(TYPE_IMPORT);
				$rtn = false;
				return;
			}

			// 送金元のバッチステータスチェック
			$rs			= $this -> getAccountCommon($this -> from);
			$account	= $this -> getRowData($rs);

			if(intval($this -> getColumnData($account, COLUMN_TRANSFER_BATCH_FLG)) == NO_COUNT) {
				$this -> popUpSessionMessage(ERROR, 'E_DONT_TRANSFER_DEPOSIT_ACCOUNT_ADMIN', array());
				$rtn = false;
			}

			// 入力状態に変更
			if(!$rtn) {
				$this -> setType(TYPE_IMPORT);
				$rtn = false;
				return;
			}

			// 変数宣言部
			$errorFlg = false;

			if(isset($_FILES[PARAM_CSV])){
				// ファイル名の設定
				$this -> tmpPath		=  $_FILES[PARAM_CSV][PARAM_NAME];	// アップロードファイル名
				$this -> newFilename	=  $this -> createUId();			// 新ファイル名

				// ファイルパスの取得
				$path = SYSTEM_DOCUMENT_TRANSFER . $this -> newFilename . '.csv';
				// 			 . ;

				// アップロードファイルの移動
				move_uploaded_file($_FILES[PARAM_CSV][PARAM_TMP_NAME], $path);

				// CSV読み込み
				$this -> load($path);
			}

			// CSV成形
			$errorFlg = $this -> shapeCsv();

			// エラーがあった場合
			if((!$errorFlg) && ($this -> getType() == TYPE_IMPORT_CONFIRM)) {

				// エラーメッセージ表示
				$this -> popUpSessionMessage(WARNING, 'W_NOT_EXECUTE_DATA', array());

			}
		}

		return true;
	}

	// anton (5342)
	private function unserializeBulkTransferData(){
		$this -> csvdata = str_replace('\'', "&#39;", $this -> csvdata);
		$this -> csv = unserialize($this -> csvdata);
	}

	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function dispHTML() {
		return array();
	}

	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function echoList() {

		// 変数宣言部
		$rtn			= NO_STRING;
		$failFileName	= NO_STRING;

		if($this -> isLoopData($this -> rs)) {

			// データの数だけループを回す
			$start	= 	($this -> getTargetPage() - VAL_INT_1) * VAR_DEFAULT_PAGE_COUNT;
			$end		= $this -> getTargetPage() * VAR_DEFAULT_PAGE_COUNT;
			$listCount	= count($this -> rs);
			for($cnt = $start; $cnt < $end && $cnt < $listCount; $cnt++) {

				$row = $this -> getRowData($this -> rs, $cnt);

				// 失敗ファイル名の取得
				if($this -> getColumnData($row, COLUMN_FAIL_FILENAME) != NO_STRING) {
					$failFileName = '<a id="linkDownload" href="javascript:failFileDownload(\'' . $this -> getColumnData($row, COLUMN_TRANSACTION_ID) . '\');">' . $this -> getColumnData($row, COLUMN_TRANSACTION_ID) . '_fail.csv</a>';
				} else {
					$failFileName = NO_STRING;
				}

				$rtn	.= '<tr>'
							. '<td>' . $this -> getColumnData($row, COLUMN_TRANSACTION_TIME) . '</td>'
							. '<td class="l">' . $this -> getColumnData($row, COLUMN_CREATE_TIME) . '</td>'
							. '<td>' . $this -> getColumnData($row, COLUMN_TRANSACTION_ID) . '</td>'
							. '<td><a id="linkDownload" href="javascript:fileDownload(\'' . $this -> getColumnData($row, COLUMN_TRANSACTION_ID) . '\');">' . $this -> getColumnData($row, COLUMN_OLD_FILENAME) . '</a></td>'
							. '<td>' . $failFileName . '</td>'
							. '</tr>';
			}

		} else {
			$rtn = '<tr><td colspan="5">' . $this -> getMessage(INFO, 'I_NO_SUCHE_SEARCH_DATA', array()) . '</td></tr>';
		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 検索条件パラメータの取得
	 * @parameter	: なし
	 * @return		: 検索条件パラメータ
	 -------------------------------------------------------------------------*/
	public function getWhere() {

		// 変数宣言部
		$rtnParams = array();

		if($this -> sTId != NO_STRING) {			// トランザクションID
			$rtnParams[] = ' transaction_id = (\')' . $this -> sTId . '(\') '; // modified (anton)
		}

		if($this -> sTransactionNumber != NO_STRING) {	// 取引番号
			$rtnParams[] = ' transfer.transaction_number = (\')' . $this -> sTransactionNumber . '(\') ';
		}

		if($this -> sFromName != NO_STRING) {	// From名前
			$rtnParams[] = ' from_user.user_name = (\')' . $this -> sFromName . '(\') ';
		}

		if($this -> sFromAccount != NO_STRING) {	// From口座
			$rtnParams[] = ' transfer.from_account = (\')' . $this -> sFromAccount . '(\') ';
		}

		if($this -> sToName != NO_STRING) {	// To名前
			$rtnParams[] = ' to_user.user_namet = (\')' . $this -> sToName . '(\') ';
		}

		if($this -> sToAccount != NO_STRING) {	// To口座
			$rtnParams[] = ' transfer.to_account = (\')' . $this -> sToAccount . '(\') ';
		}

		if($this -> sFrom != NO_STRING) {			//
			$rtnParams[] = ' create_time >= (\')' . $this -> sFrom . ' 00:00:00(\') '; // modified (anton)
		}

		if($this -> sTo != NO_STRING) {				// 終了日
			$rtnParams[] = ' create_time < (\')' . date('Y-m-d H:i:s', strtotime($this -> sTo . ' +1 days')) . '(\') '; // modified (anton)
		}

		if(!empty($this -> sProcessType)) {				// 処理タイプ
			$rtnParams[] = ' transfer.process_type IN (' . implode(DELIMIT_COMMA, $this -> sProcessType) . ') ';
		}

		// 検索条件の結合
		if(count($rtnParams) > NO_COUNT) {
			return DELIMIT_AND . implode(DELIMIT_AND, $rtnParams);
		} else {
			return NO_STRING;
		}
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 決済セットの設定（口座一覧）
	 * @parameter	: 結果セット
	 * @return		: なし
	 -------------------------------------------------------------------------*/
	function dispBalances() {

		// 変数宣言部
		$lists	= array();
		$rtn	= NO_STRING;

		// データを入れ替える
		if($this -> isLoopData($this -> balances)) {
			foreach($this -> balances as $row) {
				$lists[$this -> getColumnData($row, COLUMN_CURRENCY)] = $row;
			}
		}

		if($this -> isLoopData($this -> currencies)) {

			// データの数だけループを回す
			foreach($this -> currencies as $row) {

				$currency	= $this -> getColumnData($row, COLUMN_CURRENCY_NAME);
				$data		= $this -> getColumnData($lists, $currency);
				$amount		= NO_COUNT;

				// データを生成
				if($data == NO_STRING) {	// データが無い
					$amount = number_format($this -> intToCurrency(NO_COUNT, $currency), $this -> getDigitCount($currency));
				} else {
					$amount = number_format($this -> intToCurrency($this -> getColumnData($data, COLUMN_BALANCE), $currency), $this -> getDigitCount($currency));
				}

				if($this -> fromCurrency != NO_STRING) {
					if($this -> fromCurrency == $currency) {
						$rtn .= '<label class="w33p"> <input type="radio" id="from_currency" name="from_currency" value="' . $currency . '" checked> ' . $currency . ' - ' . $amount . '</label>';
					} else {
						$rtn .= '<label class="w33p"> <input type="radio" id="from_currency" name="from_currency" value="' . $currency . '"> ' . $currency . ' - ' . $amount . '</label>';
					}
				} else {
					if($currency == USD) {
						$rtn .= '<label class="w33p"> <input type="radio" id="from_currency" name="from_currency" value="' . $currency . '" checked> ' . $currency . ' - ' . $amount . '</label>';
					} else {
						$rtn .= '<label class="w33p"> <input type="radio" id="from_currency" name="from_currency" value="' . $currency . '"> ' . $currency . ' - ' . $amount . '</label>';
					}
				}
			}

		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: HTML表示用のデータ取得関数
	 * @parameter	: なし
	 * @return		: HTML表示用データ配列
	 -------------------------------------------------------------------------*/
	public function echoUploadDataList() {

		// 変数宣言部
		$lists		= NO_STRING;
		$dataFlg	= false;

		if(count($this -> csv) > NO_COUNT) {

			// タイトル行の削除
			foreach($this -> csv as $row) {

				if(count($row) >= VAL_INT_9) { //  anton

					$dataFlg	= true;

					$lists	.= '<tr>'
							. '<td>' . $row[NO_COUNT] . '</td>'										// 口座番号
							. '<td class="r">' . $row[VAL_INT_1] . ' ' . $this -> formatCurrency($row[VAL_INT_2], $row[VAL_INT_1]) . '</td>'	// 通貨、金額
							. '<td>' . $row[VAL_INT_3] . '</td>'									// 処理日時
							. '<td class="l">' . $row[VAL_INT_4] . '</td>'							// メッセージ
							. '<td class="r">' . ($row[VAL_INT_9] ? $row[VAL_INT_9] : NO_COUNT) . '</td>'							// 手数料 modified - anton
							. '<td class="l">' . $row[VAL_INT_8] . '</td>'							// 備考欄
							. '</tr>';
				}
			}

			if(!$dataFlg) {		// CSVはあったけどデータがない
				echo '<tr><td colspan="6">' . $this -> getMessage(INFO, 'I_NO_SUCHE_SEARCH_DATA', array()) . '</td></tr>';

			} else {			// データが存在
				echo $lists;
			}
		} else {
			echo '<tr><td colspan="6">' . $this -> getMessage(INFO, 'I_NO_SUCHE_SEARCH_DATA', array()) . '</td></tr>';
		}
	}

	/*-------------------------------------------------------------------------
	 * @function_name: CSVデータの取得
	 * @parameter	: なし
	 * @return		: CSVデータ
	 -------------------------------------------------------------------------*/
	public function getCsv() {
		// 成形する
		$this -> shapeCsv();
		return $this -> csv;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 入力用CSVデータの取得
	 * @parameter	: なし
	 * @return		: CSVデータ
	 -------------------------------------------------------------------------*/
	public function shapeCsv() {

		// 変数宣言部
		$csv			= null;
		//$path			= NO_STRING; // unused
		$cnt			= NO_COUNT;
		$rs				= null;
		$errorFlg		= true;
		$statusStr		= array();
		$msg			= NO_STRING;
		$errCnt			= NO_COUNT;
		$cList 			= $this -> getCurrencyList();	// 通貨リスト
		$balanceList	= null;

		// 残高取得
		$currencies 	= $this -> accessSelect('LIST_MST_CURRENCY_ACTIVE', array());
		if($this -> isLoopData($currencies)) {
			foreach($currencies as $row) {
				$currency = $this -> getColumnData($row, COLUMN_CURRENCY_NAME);
				$balanceList[$currency][] = $this -> getBalanceCommon($this -> from, $currency);
			}
		}

		// 残高リストを取得
		$this -> summaryList = $balanceList;
		$this -> tempcsv = $this -> csv;

		if(count($this -> csv) > NO_COUNT) {

			$csv = $this -> csv;

			// CSV行数分ループ
			for($cnt = NO_COUNT; $cnt < count($csv); $cnt++) {

				// 行データの取得
				$row = $csv[$cnt];

				if(count($row) == VAL_INT_5) {

					// 初期化
					//$dataFlg 	= true; // unused
					$statusStr 	= array();
					$msg 		= NO_STRING;

					// 送金先口座のステータスチェック
					if(!$this -> checkAccountStatus($row[NO_COUNT], VAR_TRANSACTION_TRANSFER_DEPOSIT)) {
						$statusStr[] = VAL_STR_CANNOT_TRANSFER_MONEY;
						$errorFlg = false;
					}

					// 口座番号のチェック
					$rs = $this -> accessSelect('SELECT_USER_BY_ACCOUNT', array($row[NO_COUNT]));

					if($this -> isLoopData($rs)) {
						$row[]	= $rs[NO_COUNT][COLUMN_USER_NAME];
					} else {
						$statusStr[] = VAL_STR_CANNOT_TRANSFER_MONEY;
						$errorFlg = false;
					}

					// 通貨のチェック
					if(!$this -> checkNull($row[VAL_INT_1])) {
					    $statusStr[] = VAL_STR_AMOUNT_OF_MONEY_CURRENCY_NOT_ENTERED;
						$errorFlg = false;
						// 通貨の正規表現チェック
					} else {
						$activeCurrencyFlg = false;
						foreach ($cList as $key => $value) {
							if($value[PARAM_DATA_VALUE] == $row[VAL_INT_1]) {
								$activeCurrencyFlg = TRUE;
							}
						}
						if(!$activeCurrencyFlg) {
						    $statusStr[] = VAL_STR_AMOUNT_OF_MONEY_ILLEGAL_CURRENCY_ENTERED;
							$errorFlg = false;
						}
					}

					// 金額の入力チェック
					if(!$this -> checkNull($row[VAL_INT_2])) {
					    $statusStr[] = VAL_STR_AMOUNT_OF_MONEY_NOT_ENTERED;
						$errorFlg = false;
						// 金額の正規表現チェック
					} else if(!$this -> checkNumber($row[VAL_INT_2])
							|| !$this -> checkStringNumber($row[VAL_INT_2])) {
							    $statusStr[] = VAL_STR_AMOUNT_OF_MONEY_NOT_A_NUMBER;
								$errorFlg = false;
								// 金額の整数チェック
					} else if($row[VAL_INT_2] < 0.01) {
					    $statusStr[] = VAL_STR_AMOUNT_OF_MONEY_GREATER_THAN_0_01;
						$errorFlg = false;
						// 金額の小数点チェック
					} else {
					// JPYの場合
					if(($row[VAL_INT_1]) == JPY) {
						if(strstr($row[VAL_INT_2], DELIMIT_DOT)) {
						    $statusStr[] = VAL_STR_AMOUNT_OF_MONEY_JPY_INTEGER;
							$errorFlg = false;
						}
					} else {

							$amountDecArr = explode('.', $row[VAL_INT_2]);
							if(isset($amountDecArr[VAL_INT_1])) {
								if(strlen($amountDecArr[VAL_INT_1]) > VAL_INT_2) {
								    $statusStr[] = VAL_STR_AMOUNT_OF_MONEY_2_DECIMAL_PLACES;
									$errorFlg = false;
								}
							}
						}
					}

					// 処理日時の入力チェック
					if(!$this -> checkNull($row[VAL_INT_3])) {
					    $statusStr[] = VAL_STR_PROCESSING_DATE_NOT_ENTERED;
						$errorFlg = false;
					} else
						// 処理日時の数字チェック
						if(!$this -> checkNumber($row[VAL_INT_3])) {
						    $statusStr[] = VAL_STR_PROCESSING_DATE_HALF_WIDTH;
							$errorFlg = false;
						} else
							// 処理日時の正規表現チェック
						if(strlen($row[VAL_INT_3]) != VAL_INT_8) {
						    $statusStr[] = VAL_STR_PROCESSING_DATE_FORMAT_INVALID;
							$errorFlg = false;
						}

						if(strtotime($row[VAL_INT_3]) < strtotime(date("Y-m-d"))){
						    $statusStr[] = VAL_STR_PROCESSING_DATE_IS_PREVIOUS;
						    $errorFlg = false;
						}
						
					// これまでのチェックがOKならば、日付形式のチェック
					if(count($statusStr) == NO_COUNT) {

						$year	= intval(substr($row[VAL_INT_3], NO_COUNT, VAL_INT_4));
						$month	= intval(substr($row[VAL_INT_3], VAL_INT_4, VAL_INT_2));
						$day	= intval(substr($row[VAL_INT_3], VAL_INT_6, VAL_INT_2));

						if(!$this -> checkDate($year, $month, $day)) {
						    $statusStr[] = VAL_STR_PROCESSING_DATE_DATE_INVALID;
							$errorFlg = false;
						}
					}

					// 残高チェック
					$fee = NO_STRING;
					if(count($statusStr) == NO_COUNT) {
						if(array_key_exists($row[VAL_INT_1], $balanceList)) {

							$this -> toFee = NO_COUNT;

							// 手数料取得
							$fee = $this -> getImportFee($row[VAL_INT_2]
														, $row[VAL_INT_1]
														, $this -> from
														, $row[NO_COUNT]
														, $this -> toFee);

							// 残高確認
							if(!isset($balanceList[$row[VAL_INT_1]][VAL_INT_1])) {
								$balanceList[$row[VAL_INT_1]][VAL_INT_1] = $balanceList[$row[VAL_INT_1]][NO_COUNT];
							}
							if(($row[VAL_INT_2] + $fee) <= $balanceList[$row[VAL_INT_1]][VAL_INT_1]) {
								$balanceList[$row[VAL_INT_1]][VAL_INT_1] = $balanceList[$row[VAL_INT_1]][VAL_INT_1] - ($row[VAL_INT_2] + $fee);
								$row[] = $fee;
							} else {
							    $statusStr[] = VAL_STR_BALANCE_INSUFFICIENT_FUNDS;
								$errorFlg = false;
								$row[] = $fee;
							}
						}
					} else {
						$row[] = NO_COUNT;
					}

					// 備考文字を成形
					if($this -> isLoopData($statusStr)) {
						foreach ($statusStr as $err) {
							$msg .= '<strong class="red">' . $err . '</strong><br />';
						}

						// エラーCSVに行を追加
						$this -> errCsv[$errCnt] = $row;
						$errCnt ++;

						// CSVエラーフラグ
						$row[]	= VAL_INT_1;

						// エラーフラグ
						$this -> errFlg = VAL_INT_1;

					} else {
						$msg = '<strong class="blue">'.VAL_STR_ADMIN_IMPORTABLE.'</strong>';

						// エラーフラグ
						$row[]	= NO_COUNT;
					}

					// 備考を追加
					$row[] = $msg;
					$row[] = $this -> toFee; // anton

					// データを戻す
					$csv[$cnt] = $row;
				} else {
					// anton (5342)
					if($cnt == NO_COUNT){
						$csv[NO_COUNT][VAL_INT_4] = str_replace('\'', '&#39;', $csv[NO_COUNT][VAL_INT_4]);
					}
				}
			}

			// データを戻す
			$this -> csv = $csv;
		}

		// 処理後残高リストを取得
		$this -> summaryList = $balanceList;

		return $errorFlg;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 手数料の算出
	 * @parameter	: なし
	 * @return		: 手数料
	 -------------------------------------------------------------------------*/
	function getImportFee($amount
							, $currency
							, $from
							, $to
							, &$toFee) {

		$rtn	= NO_COUNT;
		$toFee	= NO_COUNT;

		// 手数料取得
		$fee = $this -> getFeeCommon(VAR_TRANSFER
									, $amount
									, $currency
									, $from
									, $to
									, $currency
									, $amount
				);

		if($fee[$currency . VAL_INT_1] > NO_COUNT) {

			// 送金元の手数料を出金通貨に両替
			$exchangeFromFee = 	$this -> getExchangeCommon($fee[$currency . VAL_INT_1]
															, $currency
															, $currency);

			// 小数点を桁数で切り捨て
			$digit	= $this -> getDigit($currency);
			$rtn 	= floor($exchangeFromFee[PARAM_AMOUNT] * $digit);
			$rtn	= $rtn / $digit;

			// 最小金額を算出
			$low	= VAL_INT_1 / $digit;

			// 0の場合は最低金額を設定
			if($rtn < $low) {
				$rtn = VAL_INT_1 / $digit;
			}
		}

		if($fee[$currency . VAL_INT_2] > NO_COUNT) {

			// 送金元の手数料を出金通貨に両替
			$exchangeFromFee = 	$this -> getExchangeCommon($fee[$currency . VAL_INT_2]
															, $currency
															, $currency);

			// 小数点を桁数で切り捨て
			$digit	= $this -> getDigit($currency);
			$toFee 	= floor($exchangeFromFee[PARAM_AMOUNT] * $digit);
			$toFee	= $toFee / $digit;


			// 最小金額を算出
			$low	= VAL_INT_1 / $digit;

			// 0の場合は最低金額を設定
			if($toFee < $low) {
				$toFee = VAL_INT_1 / $digit;
			}
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 残高リストの表示
	 * @parameter	: なし
	 * @return		: 残高リスト
	 -------------------------------------------------------------------------*/
	public function echoSummaryList() {

		$rtn = NO_STRING;
		//$list = null; // unused

		if($this -> isLoopData($this -> summaryList)) {
			foreach ($this -> summaryList as $key => $value) {


				if(isset($value[VAL_INT_1])) {
					$after = $this -> formatCurrency($value[VAL_INT_1], $key);
				} else {
					$after = $this -> formatCurrency($value[NO_COUNT], $key);
				}
				$rtn .= '<tr>'
						. '<td>' . $key . '</td>'
						. '<td class="r">' . $this -> formatCurrency($value[NO_COUNT], $key)  . '</td>'
						. '<td class="r">' . $after . '</td>'
						. '</tr>';
			}
		}
		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: CSVデータの設定
	 * @parameter	: CSVデータ
	 * @return		: なし
	 -------------------------------------------------------------------------*/
	public function setCsv($csv) {
		$this -> csv = $csv;
	}

	/**
	 * anton
	 * (5342)
	 * serialized
	 */
	public function getTempCsv(){
		foreach($this -> tempcsv as $k => $row){
			$this -> tempcsv[$k][4] = str_replace('\'', "&#39;", $this -> tempcsv[$k][4]);
		}

		return serialize($this -> tempcsv);
	}

	/*-------------------------------------------------------------------------
	 * @function_name: テンプレートファイルのパス取得
	 * @parameter	: なし
	 * @return		: テンプレートファイルのパス
	 -------------------------------------------------------------------------*/
	public function getTmpPath() {
		return SYSTEM_DOCUMENT_TRANSFER . $this -> newFilename . '.csv';
	}

	/*-------------------------------------------------------------------------
	 * @function_name: テンプレートファイルのパス取得
	* @parameter	: なし
	* @return		: テンプレートファイルのパス
	-------------------------------------------------------------------------*/
	public function getTmpFile() {
		return $this -> tmpPath;
	}

	/*-------------------------------------------------------------------------
	* @function_name: テンプレートファイルのパス取得
	* @parameter	: なし
	* @return		: テンプレートファイルのパス
	-------------------------------------------------------------------------*/
	public function echoTmpPath() {
		echo $this -> tmpPath;
	}


	/*-------------------------------------------------------------------------
	* @function_name: エラーフラグ取得
	* @parameter	: なし
	* @return		: エラーフラグ
	 -------------------------------------------------------------------------*/
	public function getErrFlg() {
		return $this -> errFlg;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 金額の取得
	* @parameter	: なし
	* @return		: 金額
	-------------------------------------------------------------------------*/
	public function echoAmount() {
		echo $this -> amount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 送金メッセージの取得
	* @parameter	: なし
	* @return		: 送金メッセージ
	-------------------------------------------------------------------------*/
	public function echoTransferMessage() {
		echo $this -> message;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 送金元口座番号の取得
	* @parameter	: なし
	* @return		: 送金元口座番号
	-------------------------------------------------------------------------*/
	public function echoFrom() {
		echo $this -> from;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 送金先口座番号の取得
	* @parameter	: なし
	* @return		: 送金先口座番号
	-------------------------------------------------------------------------*/
	public function echoTo() {
		echo $this -> to;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 送金先口名の取得
	 * @parameter	: なし
	 * @return		: 送金先口名
	 -------------------------------------------------------------------------*/
	public function echoToName() {
		if($this -> getType() == TYPE_INPUT) {
			echo $this -> rs[VAL_INT_1][COLUMN_USER_NAME];
		} else {
			echo $this -> toName;
		}
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 送金元口名の取得
	 * @parameter	: なし
	 * @return		: 送金先元名
	 -------------------------------------------------------------------------*/
	public function echoFromName() {
		if($this -> getType() == TYPE_INPUT) {
			echo $this -> rs[NO_COUNT][COLUMN_USER_NAME];
		} else {
			echo $this -> fromName;
		}
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 通貨一覧の取得
	 * @parameter	: なし
	 * @return		: 通貨一覧
	 -------------------------------------------------------------------------*/
	public function echoCurrencyList() {
		echo $this -> dispCurrencyOptionList($this -> toCurrency, false);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 登録用のデータを取得
	* @parameter	: なし
	* @return		: 登録用データ
	-------------------------------------------------------------------------*/
	public function getRegistData() {

		// 変数宣言部
		$rtn = array();

		$rtn[] = $this -> from;																	// 送金元口座番号
		$rtn[] = $this -> from;																	// 送金元口座番号
		$rtn[] = $this -> debitCurrency;														// 送金通貨
		$rtn[] = $this -> currencyToInt($this -> fromFee, $this -> debitCurrency);				// 口座元手数料
		$rtn[] = $this -> to;																	// 送金先口座番号
		$rtn[] = $this -> transferCurrency;														// 送金元通貨
		$rtn[] = $this -> currencyToInt($this -> toFee, $this -> transferCurrency);				// 送金元手数料
		$rtn[] = $this -> amount;																// 入力金額
		$rtn[] = $this -> transferType;															// 送金方法
		$rtn[] = $this -> message;																// メッセージ
		$rtn[] = $this -> debitCurrency;														// 出金通貨
		$rtn[] = $this -> currencyToInt($this -> debitAmount, $this -> debitCurrency);			// 出金金額
		$rtn[] = $this -> transferCurrency;														// 送金通貨
		$rtn[] = $this -> currencyToInt($this -> transferAmount, $this -> transferCurrency);	// 送金金額
		$rtn[] = $this -> rate;																	// レート
		$rtn[] = VAL_INT_1;																		// 処理種別
		$rtn[] = $this -> getAdminUserData(PARAM_USER_ACCOUNT);									// 管理者ID
		$rtn[] = VAL_INT_1;																		// 処理ステータス
		$rtn[] = $this -> getTransactionNumberCommon(VAR_TRANSACTION_TRANSFER_DEPOSIT);			// トランザクションナンバー

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 表示用のデータを取得
	 * @parameter	: なし
	 * @return		: 表示用データ
	 -------------------------------------------------------------------------*/
	public function getViewData() {

		// 変数宣言部
		$rtn = array();

		$rtn[] = $this -> from;				// 送金元口座番号
		$rtn[] = $this -> to;				// 送金先口座番号
		return $rtn;

	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座振替リストの設定
	* @parameter	: 出金リスト
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function setResult($rs) {
		$this -> rs = $rs;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 通貨のバランスデータの設定
	 * @parameter	: 結果セット
	 * @return		: なし
	 -------------------------------------------------------------------------*/
	function setBalances($rs) {
		$this -> balances = $rs;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 通貨データの設定
	 * @parameter	: 通貨データ
	 * @return		: なし
	 -------------------------------------------------------------------------*/
	public function setCurrencies($rs) {
		$this -> currencies = $rs;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: ユーザアカウントの取得
	 * @parameter	: なし
	 * @return		: ユーザアカウント
	 -------------------------------------------------------------------------*/
	public function getUserAccount() {
		return $this -> rs[NO_COUNT][COLUMN_USER_ACCOUNT];
	}

	/*-------------------------------------------------------------------------
	 * @function_name: ユーザアカウントの取得
	 * @parameter	: なし
	 * @return		: ユーザアカウント
	 -------------------------------------------------------------------------*/
	public function getFrom() {
		return $this -> from;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: ページャの表示
	 * @parameter	: なし
	 * @return		: 表示用HTML文字列
	 -------------------------------------------------------------------------*/
	function dispPager() {
		echo  $this -> getPagerCommon($this -> getTargetPage()
				, $this -> getTotalPageCommon(VAR_DEFAULT_PAGE_COUNT, count($this -> rs))
				, count($this -> rs)
				, NO_STRING);
	}

	/*-------------------------------------------------------------------------
	 * @function_name: トランザクションIDの取得
	 * @parameter	: なし
	 * @return		: トランザクションID
	 -------------------------------------------------------------------------*/
	public function echoSTId() {
		echo $this -> sTId;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: From名前の取得
	 * @parameter	: なし
	 * @return		: From名前
	 -------------------------------------------------------------------------*/
	public function echoSFromName() {
		echo $this -> sFromName;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: From口座の取得
	 * @parameter	: なし
	 * @return		: From口座
	 -------------------------------------------------------------------------*/
	public function echoSFromAccount() {
		echo $this -> sFromAccount;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: To名前の取得
	 * @parameter	: なし
	 * @return		: To名前
	 -------------------------------------------------------------------------*/
	public function echoSToName() {
		echo $this -> sToName;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: To口座の取得
	 * @parameter	: なし
	 * @return		: To口座
	 -------------------------------------------------------------------------*/
	public function echoSToAccount() {
		echo $this -> sToAccount;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: From日付の取得
	 * @parameter	: なし
	 * @return		: From日付
	 -------------------------------------------------------------------------*/
	public function echoSFrom() {
		echo $this -> sFrom;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: To日付の取得
	 * @parameter	: なし
	 * @return		: To日付
	 -------------------------------------------------------------------------*/
	public function echoSTo() {
		echo $this -> sTo;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: トランザクションIDの取得
	 * @parameter	: なし
	 * @return		: トランザクションID
	 -------------------------------------------------------------------------*/
	public function getTId() {
		return $this -> tId;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 送金通貨の取得
	 * @parameter	: なし
	 * @return		: 送金通貨
	 -------------------------------------------------------------------------*/
	public function echoDebitCurrency() {
		echo $this -> debitCurrency;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 送金金額の取得
	 * @parameter	: なし
	 * @return		: 送金金額
	 -------------------------------------------------------------------------*/
	public function echoDebitAmount() {
		echo $this -> debitAmount;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 送金元手数料の取得
	 * @parameter	: なし
	 * @return		: 送金元手数料
	 -------------------------------------------------------------------------*/
	public function echoFromFee() {
		echo $this -> fromFee;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 受取通貨の取得
	 * @parameter	: なし
	 * @return		: 受取通貨
	 -------------------------------------------------------------------------*/
	public function echoTransferCurrency() {
		echo $this -> transferCurrency;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 受取金額の取得
	 * @parameter	: なし
	 * @return		: 受取金額
	 -------------------------------------------------------------------------*/
	public function echoTransferAmount() {
		echo $this -> transferAmount;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 送金先手数料の取得
	 * @parameter	: なし
	 * @return		: 送金先手数料
	 -------------------------------------------------------------------------*/
	public function echoToFee() {
		echo $this -> toFee;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 送金先手数料の取得
	* @parameter	: なし
	* @return		: 送金先手数料
	-------------------------------------------------------------------------*/
	public function getToFee() {
		return $this -> toFee;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 送金タイプの取得
	 * @parameter	: なし
	 * @return		: 送金タイプ
	 -------------------------------------------------------------------------*/
	public function echoDispTransferType($type) {
		if($this -> transferType == $type) {
			echo 'checked';
		}
	}

	/*-------------------------------------------------------------------------
	 * @function_name: レートの取得
	 * @parameter	: なし
	 * @return		: レート
	 -------------------------------------------------------------------------*/
	public function echoRate() {
		echo $this -> rate;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: レートの取得
	 * @parameter	: なし
	 * @return		: レート
	 -------------------------------------------------------------------------*/
	public function echoTransferType() {
		echo $this -> transferType;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: to通貨の取得
	 * @parameter	: なし
	 * @return		: to通貨
	 -------------------------------------------------------------------------*/
	public function echoToCurrency() {
		echo $this -> toCurrency;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: from通貨の取得
	 * @parameter	: なし
	 * @return		: from通貨
	 -------------------------------------------------------------------------*/
	public function echoFromCurrency() {
		echo $this -> fromCurrency;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: メッセージの取得
	 * @parameter	: なし
	 * @return		: メッセージ
	 -------------------------------------------------------------------------*/
	public function echoIMessage() {
		echo $this -> message;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 表示用メッセージの取得
	 * @parameter	: なし
	 * @return		: 表示用メッセージ
	 -------------------------------------------------------------------------*/
	public function echoViewMessage() {
		echo nl2br($this -> message);
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 新ファイル名の取得
	 * @parameter	: なし
	 * @return		: 新ファイル名
	 -------------------------------------------------------------------------*/
	public function getNewFilename() {
		return $this -> newFilename;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 元ファイル名の取得
	 * @parameter	: なし
	 * @return		: 元ファイル名
	 -------------------------------------------------------------------------*/
	public function getOldFilename() {
		return $this -> oldFilename;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 旧ファイル名の設定
	 * @parameter	: 旧ファイル名
	 * @return		: なし
	 -------------------------------------------------------------------------*/
	function setOldFileName($name) {
		$this -> oldFilename = $name;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 新ファイル名の設定
	 * @parameter	: 新ファイル名
	 * @return		: なし
	 -------------------------------------------------------------------------*/
	function setNewFileName($name) {
		$this -> newFilename = $name;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 取引番号の設定
	 * @parameter	: 取引番号
	 * @return		: なし
	 -------------------------------------------------------------------------*/
	public function echoSTransactionNumber() {
		echo $this -> sTransactionNumber;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: HTML表示用のデータ取得関数
	 * @parameter	: なし
	 * @return		: HTML表示用データ配列
	 -------------------------------------------------------------------------*/
	public function echoUploadFromFee() {

		// 変数宣言部
		$lists		= NO_STRING;
		$dataFlg	= false;

		if(count($this -> csv) > NO_COUNT) {

			// タイトル行の削除
			foreach($this -> csv as $row) {

				if(count($row) >= VAL_INT_9) { //  anton

					$dataFlg	= true;

					$lists	.= '<tr>'
							. '<td>' . $this->getFrom() . '</td>'										// 口座番号
							. '<td class="r">' . $row[VAL_INT_1] . ' ' . $this -> formatCurrency($row[VAL_INT_2], $row[VAL_INT_1]) . '</td>'	// 通貨、金額
							. '<td>' . $row[VAL_INT_3] . '</td>'									// 処理日時
							. '<td class="l">' . $row[VAL_INT_4] . '</td>'							// メッセージ
							. '<td class="r">' . ($row[VAL_INT_6] ? $row[VAL_INT_6] : NO_COUNT) . '</td>'							// 手数料 modified - anton
							. '<td class="l">' . $row[VAL_INT_8] . '</td>'							// 備考欄
							. '</tr>';
				}
			}

			if(!$dataFlg) {		// CSVはあったけどデータがない
				echo '<tr><td colspan="6">' . $this -> getMessage(INFO, 'I_NO_SUCHE_SEARCH_DATA', array()) . '</td></tr>';

			} else {			// データが存在
				echo $lists;
			}
		} else {
			echo '<tr><td colspan="6">' . $this -> getMessage(INFO, 'I_NO_SUCHE_SEARCH_DATA', array()) . '</td></tr>';
		}
	}
}
?>