<?php
require_once(SYSTEM_LOGICS . 'transfer_batch/model.php');

class LogicTransferBatch extends TransferModelClassBatch {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $htmlStr = NO_STRING;	// 表示用HTML文字列

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジック（各クラス共通）
	* @parameter	: なし
	* @return		: TRUE:ロジック成功、FALSE:ロジック失敗
	-------------------------------------------------------------------------*/
	function logic() {

		try {
			// 初期化
			$this -> init();
			// 処理
			$this -> biz();
		} catch (Exception $e) {
			throw $e;
		}
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 処理
	 * @parameter	: なし
	 * @return		: なし
	 -------------------------------------------------------------------------*/
	function biz() {		
		if($this -> getType() == TYPE_INPUT) {
			$this -> input();
		} else if($this -> getType() == TYPE_EXPORT) {
			$this -> selectFileName();
		} else if($this -> getType() == TYPE_EXPORT_ERROR) {
			$this -> selectFileName();
		} else if($this -> getType() == TYPE_IMPORT_COMPLETE) {		// アップロードのファイルデータの登録
			$this -> load($this -> getTmpPath());
			$this -> importRegist();
			$this -> lists();
		} else {
			$this -> lists();
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座振替リストの取得
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function lists() {
		$this -> setResult($this -> accessSelect('LIST_TRANSFER_BATCH', array($this -> getWhere())));
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 口座振替情報の取得
	 * @parameter	: 口座番号セット
	 * @return		: なし
	 -------------------------------------------------------------------------*/
	function input() {

		// ユーザ情報の取得
		$this -> setResult($this -> accessSelect('SELECT_TRANSFER_ACCOUNT_INFO', $this -> getViewData()));

		// バランスの取得
		$this -> setBalances($this -> accessSelect('SELECT_USER_BALANCES', array($this -> getUserAccount())));

		// 通貨情報
		$this -> setCurrencies($this -> accessSelect('LIST_MST_CURRENCY_ACTIVE', array()));
	}

	/*-------------------------------------------------------------------------
	 * @function_name: アップロードデータのロード
	 * @parameter	: ロードファイルのパス
	 * @return		: なし
	 -------------------------------------------------------------------------*/
	function load($path) {

		// ファイルのロード
		$tmpFile = fopen($path, 'r');

		// CSV配列へ変換
		while ($csv[] = fgetcsv($tmpFile, VAL_INT_1024)) {}

		// 配列 $csv の文字コードをSJIS-winからUTF-8に変換
// 		mb_convert_variables(CHAR_SET_UTF_8, CHAR_SET_SJIS, $csv);

		// タイトル行の削除
		$csv = array_splice($csv, VAL_INT_1);

		$this -> setCsv($csv);
		
		fclose($tmpFile);
	}

	/*-------------------------------------------------------------------------
	 * @function_name: アップロードデータの登録
	 * @parameter	: なし
	 * @return		: なし
	 -------------------------------------------------------------------------*/
	function importRegist() {	
		// 変数宣言部
		$csv		= $this -> getCsv();
		$params		= array();
		$newFName	= $this -> getNewFilename();
		$account	= NO_STRING;
		$currency	= NO_STRING;
		$amount		= NO_STRING;
		$flg		= true;
		$cnt 		= NO_COUNT;
		$today		= date('Y-m-d');

		$processTime = $this -> getRowData($csv);
		$processTime = date("Y-m-d",strtotime($this -> getColumnData($processTime, VAL_INT_3)));

		// まずはバッチデータを登録
		$params[] = $this -> getNewFilename();			// トランザクションID
		$params[] = $processTime;						// 実行日
		$params[] = $this -> getTmpFile();				// アップロードファイル名
		$params[] = $this -> getNewFilename() . '.csv';	// ロードファイル名

		// データの一旦削除
		$this -> accessModify('DLETE_TRANSFER_BATCH', array($this -> getNewFilename()));
		$this -> accessModify('DLETE_TRANSFER_DETAIL', array($this -> getNewFilename()));

		// リロード対策
		if(!$this -> accessModify('INSERT_TRANSFER_BATCH', $params)) {
			return;
		} else {}
		
		foreach($csv as $row) {			
			// エラーでは無い行のみインサート
			if(count($row) >= VAL_INT_9) { // anton

				// 初期化
				$params = array();

				// 処理時間設定
				//$tDate = date("Y-m-d",strtotime($row[VAL_INT_3]));

// 				if(strtotime($today) <= strtotime($tDate)) {
// 					$iDate = date('Y-m-d H:i:s');
// 				} else {
// 					$iDate = date("Y-m-d 00:00:00",strtotime($row[VAL_INT_3]));
// 				}
				
				$iDate = date("Y-m-d H:i:s",strtotime($row[VAL_INT_3]));
				
				if(date("Y-m-d", strtotime($row[VAL_INT_3])) == date("Y-m-d")){
				    $iDate = date("Y-m-d H:i:s");
				}

				// 登録用パラメータの作成
				$params[] = $this -> getFrom();														// 送金元口座番号
				$params[] = $this -> getFrom();														// 送金元口座番号
				$params[] = $row[VAL_INT_1];														// 送金通貨
				$params[] = $this -> currencyToInt($row[VAL_INT_6], $row[VAL_INT_1]);				// 口座元手数料
				$params[] = $row[NO_COUNT];															// 送金先口座番号
				$params[] = $row[VAL_INT_1];														// 送金元通貨
				$params[] = $this -> currencyToInt($row[VAL_INT_9], $row[VAL_INT_1]);			// 送金先手数料
				$params[] = $row[VAL_INT_2];														// 入力金額
				$params[] = VAL_INT_1;																// 送金方法
				$params[] = addslashes($row[VAL_INT_4]);											// メッセージ
				$params[] = $row[VAL_INT_1];														// 出金通貨
				$params[] = $this -> currencyToInt($row[VAL_INT_2], $row[VAL_INT_1]);				// 出金金額
				$params[] = $row[VAL_INT_1];														// 送金通貨
				$params[] = $this -> currencyToInt($row[VAL_INT_2], $row[VAL_INT_1]);				// 送金金額
				$params[] = VAL_INT_1;																// レート
				$params[] = VAL_INT_1;																// 処理種別
				$params[] = NO_STRING;																// 管理者ID
				$params[] = VAL_INT_3;																// 処理ステータス
				$params[] = $iDate;																	// 処理日付
				$params[] = $this -> getTransactionNumberCommon(VAR_TRANSACTION_TRANSFER_DEPOSIT);	// トランザクションナンバー
				$params[] = $newFName;																// 新ファイル名
				$params[] = $this -> getTmpFile();													// 元ファイル名
				$params[] = $this -> getErrFlg();													// エラーフラグ
				$params[] = $this -> getNewFilename();												// トランザクションID
				
				if($cnt == NO_COUNT) {
					if(!$this -> accessModify('INSERT_TRANSFER_CSV', $params, false)) {
						$flg = false;
						break;
					}

					$cnt++;

				} else {
					// データ登録
					$this -> accessModify('INSERT_TRANSFER_CSV', $params, false);
				}
			}
		}
		$this -> transfer($newFName);
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 旧ファイル名の取得
	 * @parameter	: なし
	 * @return		: なし
	 -------------------------------------------------------------------------*/
	function selectFileName() {

		// 変数宣言部
		$rs			= null;
		$row		= null;
		$oldName	= NO_STRING;
		$newName	= NO_STRING;

		$rs = $this -> accessSelect('SELECT_TRANSFER_BATCH', array($this -> getTId()));

		if($this -> isLoopData($rs)) {

			$row = $this -> getRowData($rs);

			$oldName = $this -> getColumnData($rs[NO_COUNT], COLUMN_OLD_FILENAME);
			$newName = $this -> getColumnData($rs[NO_COUNT], COLUMN_NEW_FILENAME);
		}

		$this -> setOldFileName($oldName);
		$this -> setNewFileName($newName);
	}
	
	function transfer($tbId) {
		// 変数宣言部
		$batch			= null;
		$rowBatch		= null;
		$detail			= null;
		$rowDetail		= null;
		$errorList		= array();
		$resultCounter	= array();
		$error			= array();
		$params			= null;
		
		// バッチデータの取得
		$batch = $this -> accessSelect('SELECT_TRANSFER_BATCH', array($tbId));
		
		if($this -> isLoopData($batch)) {
			// 詳細データの取得
			$detail		= $this -> accessSelect('LIST_TRANSFER_BATCH_DETAIL', array($this -> getColumnData($batch[0], COLUMN_TRANSACTION_ID)));
			
			if($this -> isLoopData($detail)) {
				
				// データがある場合はメール送信用の配列を取得
				$account = $this -> getRowData($detail);
				
				$this -> getCurrencies($this -> getColumnData($account, COLUMN_FROM_ACCOUNT), $resultCounter);
				
				foreach($detail as $rowDetail) {
					
					$account	= $this -> getColumnData($rowDetail, COLUMN_FROM_ACCOUNT);
					$currency	= $this -> getColumnData($rowDetail, COLUMN_TRANSFER_CURRENCY);
					
					// 口座間送金前のチェックｋ
					$result = $this -> checkTransfer($account
							, $this -> getColumnData($rowDetail, COLUMN_TO_ACCOUNT)
							, $currency
							, $this -> intToCurrency($this -> getColumnData($rowDetail, COLUMN_DEBIT_AMOUNT), $this -> getColumnData($rowDetail, COLUMN_DEBIT_CURRENCY))
							, $this -> getColumnData($rowDetail, COLUMN_DEBIT_CURRENCY));
					
					
					if($result[PARAM_RESULT] == NO_COUNT) {	// チェックOKだった場合は送金
						
						// データの挿入
						$this -> accessModify('INSERT_FROM_BATCH_TO_TRANSFER', array($this -> getColumnData($rowDetail, COLUMN_T_ID)), false);
						
						$this -> accessModify('INSERT_ACTIVITY', array($this -> getAdminUserData(PARAM_UID)
															, $_SERVER[PARAM_REMOTE_ADDR]
															, $_SERVER[PARAM_HTTP_USER_AGENT]
															, VAL_INT_13
															, date("Y-m-d H:i:s")
															, 'Created/Imported transaction '.'['.$this -> getColumnData($rowDetail, COLUMN_TRANSACTION_NUMBER).']'.'['.$this -> getColumnData($rowDetail, COLUMN_OLD_FILENAME).']'));
						// 送金元口座情報の取得
						$from = $this -> getRowData($this -> getAccountCommon($this -> getColumnData($rowDetail, COLUMN_FROM_ACCOUNT)));
						
						// コミッションの集計（送金元）
						$this -> registCommision(VAR_TRANSFER
								, null
								, $account
								, $currency
								, $this -> intToCurrency($this -> getColumnData($rowDetail, COLUMN_FROM_FEE), $currency));
						
						// 送金先口座情報の取得
						$from = $this -> getRowData($this -> getAccountCommon($this -> getColumnData($rowDetail, COLUMN_TO_ACCOUNT)));
						
						// コミッションの集計（送金先）
						$this -> registCommision(VAR_TRANSFER
								, null
								, $this -> getColumnData($rowDetail, COLUMN_TO_ACCOUNT)
								, $currency
								, $this -> intToCurrency($this -> getColumnData($rowDetail, COLUMN_TO_FEE), $currency)
								, PARAM_TO);
						
						
						
						// データの削除
						$this -> accessModify('DELETE_TRANSFER_BATCH_DETAIL', array($this -> getColumnData($rowDetail, COLUMN_T_ID)), false);
						
						// 送金完了メールの送信
						$params = array();
						$params[] = $this -> getColumnData($rowDetail, COLUMN_TO_ACCOUNT);											// 送金先
						$params[] = $this -> getColumnData($rowDetail, COLUMN_TO_FIRST_NAME)
						. DELIMIT_SPACE . $this -> getColumnData($rowDetail, COLUMN_TO_LAST_NAME);						// 送金先名義
						$params[] = $account;																						// 送金元
						$params[] = $this -> getColumnData($rowDetail, COLUMN_FROM_FIRST_NAME)
						. DELIMIT_SPACE . $this -> getColumnData($rowDetail, COLUMN_FROM_LAST_NAME);					// 送金元名義
						$params[] = $this -> getCurrentTimeCommon();																// 処理日時
						$params[] = $currency;																						// 通貨
						$params[] = $this -> intToCurrency($this -> getColumnData($rowDetail, COLUMN_DEBIT_AMOUNT), $currency);		// 送金金額
						$params[] = $currency;																						// 手数料通貨
						$params[] = $this -> intToCurrency($this -> getColumnData($rowDetail, COLUMN_TO_FEE), $currency);			// 手数料金額
						$params[] = $this -> getColumnData($rowDetail, COLUMN_MESSAGE);												// メッセージ
						$params[] = $this -> getColumnData($rowDetail, COLUMN_TRANSACTION_NUMBER);									// 取引番号
						
						// echo $this -> getColumnData($rowDetail, COLUMN_TO_ACCOUNT) . ' => transfer_receive_user.xml<br/>';
						// 送金先へ通知
						$this -> sendMailByTmpAndWL($this -> getColumnData($rowDetail, COLUMN_TO_ACCOUNT)
								, 'transfer_receive_user.xml'
								, $params
								, NO_STRING
								, 'cs@');
						
						// 成功件数のインクリメント
						$resultCounter[$account][PARAM_SUCCESS][$currency][PARAM_COUNTER]	+= VAL_INT_1;
						$resultCounter[$account][PARAM_SUCCESS][$currency][PARAM_AMOUNT]	+= $this -> getColumnData($rowDetail, COLUMN_DEBIT_AMOUNT);
						
					} else {								// エラーだった場合はエラーファイルの削除
						
						// データの削除
						$this -> accessModify('DELETE_TRANSFER_BATCH_DETAIL', array($this -> getColumnData($rowDetail, COLUMN_T_ID)), false);
						
						$errorList[] = implode(DELIMIT_COMMA, $rowDetail);
						
						// 失敗件数のインクリメント
						$resultCounter[$account][PARAM_NG][$currency][PARAM_COUNTER]	+= VAL_INT_1;
						$resultCounter[$account][PARAM_NG][$currency][PARAM_AMOUNT]		+= $this -> getColumnData($rowDetail, COLUMN_DEBIT_AMOUNT);
					}
				}
				
				// エラーがあった場合はエラーファイルの作成
				if($this -> isLoopData($errorList)) {
					
					$fileName	= $this -> getColumnData($rowBatch, COLUMN_TRANSACTION_ID) . '_err.csv';
					$path		= SYSTEM_DOCUMENT_TRANSFER . $fileName;
					
					// ファイルのロード
					$file = fopen($path, 'w+');
					
					$csv = implode("\n", $errorList);
					fwrite($file, $csv . "\n");
					
					fclose($file);
					
					// エラーファイルの更新
					$this -> accessModify('UPDATE_TRANSFER_BATCH_ERROR_FILE', array($this -> getColumnData($rowBatch, COLUMN_TRANSACTION_ID), $fileName), false);
				}
				
				// エラーリストの初期化
				$errorList = array();
			}
			
			// メールを送信する（送金者、管理者）
			if($this -> isLoopData($resultCounter)) {
				
				foreach($resultCounter as $key => $val) {
					
					// 変数宣言部
					$suc = NO_STRING;
					$err = NO_STRING;
					
					// ユーザデータを取得する
					$account = $this -> getAccountCommon($key);
					$account = $this -> getRowData($account);
					
					$params = array();
					$params[] = $account[PARAM_USER_ACCOUNT];					// 口座名義
					$params[] = $account[PARAM_FIRST_NAME]
					. DELIMIT_SPACE . $account[PARAM_LAST_NAME];	// 氏名
					$params[] = $this -> getCurrentTimeCommon();				// 処理日時
					
					
					// 成功の一覧
					foreach($val[PARAM_SUCCESS] as $cur => $success) {
						$suc .=	'出金通貨計：' . $cur
						. DELIMIT_SPACE . $this -> intToCurrency($success[PARAM_AMOUNT], $cur)
						. DELIMIT_SPACE . number_format($success[PARAM_COUNTER]) . '件' . "\n";
					}
					
					// 失敗の一覧
					foreach($val[PARAM_NG] as $cur => $error) {
						$err .=	'出金通貨計：' . $cur
						. DELIMIT_SPACE . $this -> intToCurrency($error[PARAM_AMOUNT], $cur)
						. DELIMIT_SPACE . number_format($error[PARAM_COUNTER]) . '件' . "\n";
						
					}
					
					$params[] = $suc;								// 成功データ
					$params[] = $err;								// 失敗データ
					
					// 管理者へ通知
					$this -> sendMailByTmp('batchtransfer_admin.xml'
							, $params
							, VAR_NOTICE_MAIL_ADDRESS
							, VAR_NOTICE_MAIL_ADDRESS);
					// echo $account[PARAM_USER_ACCOUNT] . ' => batchtransfer_corporate.xml<br/> ';
					// 送金者へ通知
					$this -> sendMailByTmpAndWL($account[PARAM_USER_ACCOUNT]
							, 'batchtransfer_corporate.xml'
							, $params
							, $this -> getColumnData($account, COLUMN_MAIL)
							, 'merchant@');
				}
			}
		}
	}
	
	function getCurrencies($account, &$resultCounter) {
		
		// 変数宣言部
		$currenies	= $this -> getCurrencyList();
		$suc		= array();
		$err		= array();
		
		if($this -> isLoopData($currenies)) {
			
			foreach($currenies as $cur) {
				$suc[$cur[PARAM_DATA_KEY]]	= array(PARAM_COUNTER => NO_COUNT, PARAM_AMOUNT => NO_COUNT);
				$err[$cur[PARAM_DATA_KEY]]	= array(PARAM_COUNTER => NO_COUNT, PARAM_AMOUNT => NO_COUNT);
			}
			
			$resultCounter[$account][PARAM_SUCCESS]	= $suc;
			$resultCounter[$account][PARAM_NG]		= $err;
		}
	}
}
?>