$(function() {

	$("#intermediary_flg:checkbox").click(function() {
		toggleIntermediaries();
	});

	$("#btnSearch").click(function() {
		$('#type').val('search');
		$('#type_search').val('');
		submitForm('searchForm');
	});

	$("#btnSearchToday").click(function() {
		$('#type').val('search');
		$('#s_from:text').datepicker().datepicker('setDate','today');
		$('#s_to:text').datepicker().datepicker('setDate','today');
		$('#s_email').val('');
		$('#s_completion').val('');
		$('#s_bank').val('');
		$('#s_account').val('');
		$('#s_status').val('');
		$('#s_currency').val('');
		$('#s_min_amount').val('');
		$('#s_max_amount').val('');
		$('#transaction_number').val('');
		$('#type_search').val('');
		$('#s_user_account').val('');
		$('#s_order_number').val('');
		$('#s_solution').val('Select');
		$('#s_fee').val('Select');
		$('#s_apply_flg').prop('checked', true);
		$('#s_process_flg').prop('checked', false);
		submitForm('searchForm');
	});

	$("#btnSearchAll").click(function() {
		$('#type').val('search');
		$('#s_from:text').datepicker().datepicker('setDate',nowStr);
		$('#s_to:text').datepicker().datepicker('setDate','today');
		$('#s_process_from').val('');
		$('#s_process_to').val('');
		$('#s_email').val('');
		$('#s_completion').val('');
		$('#s_bank').val('');
		$('#s_account').val('');
		$('#s_status').val('');
		$('#s_currency').val('');
		$('#s_min_amount').val('');
		$('#s_max_amount').val('');
		$('#s_solution').val('Select');
		$('#s_fee').val('Select');
		$('#transaction_number').val('');
		$('#s_user_account').val('');
		$('#s_apply_flg').prop('checked', true);
		$('#s_process_flg').prop('checked', false);
		$('#s_order_number').val('');
		$('#type_search').val('');
		submitForm('searchForm');
	});

	$("#btnExport").click(function() {
		$('#type').val('export');
		submitForm();
	});

	$("#btnExportFlat3").click(function() {
		$('#type').val('export_flat3');
		submitForm();
	});

	$("#btnSave").click(function() {
		$('#type').val('save');
		submitForm();
	});

	$('#s_from').datepicker({
		// カレンダーの設定
		dateFormat	: 'yy/mm/dd'
	});

	$('#s_to').datepicker({
		// カレンダーの設定
		dateFormat	: 'yy/mm/dd'
	});

	$('#s_process_from').datepicker({
		// カレンダーの設定
		dateFormat	: 'yy/mm/dd'
	});

	$('#s_process_to').datepicker({
		// カレンダーの設定
		dateFormat	: 'yy/mm/dd'
	});
	
	$('input[type=radio][name=s_withdraw_type]').change(function() {
		if($('#s_withdraw_type0').prop('checked') == true) {
			$('#s_fee').hide().val('Select');
			$('#s_solution').show();		
		}else{
			$('#s_solution').hide().val('Select');
			$('#s_fee').show();
		}
    });

	if($('#s_from').val() == '') {
		$('#s_from:text').datepicker().datepicker('setDate',nowStr);
	}

	if($('#s_to').val() == '') {
		$('#s_to:text').datepicker().datepicker('setDate','today');
	}

	if($('#s_process_from').val() == '') {
		$('#s_process_from:text').datepicker().datepicker('setDate',nowStr);
	}

	if($('#s_process_to').val() == '') {
		$('#s_process_to:text').datepicker().datepicker('setDate','today');
	}

	$("#status").change(function() {
		toggleFeeRefund();
	});

	toggleFeeRefund();

    toggleFlat3();
  
    setDefault();
});

 var deleteTransaction = (lang == "en" ? "Delete the transaction?"
     : "取引を削除しますか？");

/**
 * 取引削除
 */
$('#btnDelete').click(function(){
	if(confirm(deleteTransaction)){
		$('#type').val('delete');
		$('#acForm').submit();
	}
});

/**
 * 検索
 */
function actionSearch() {
	$('#type').val('search');
	submitForm();
}

/**
 * 入力
 */
function actionInput() {
	$('#type').val('input');
	submitForm();
}

/**
 * ファイルインポート（確認）
 */
function actionConfirm() {
	$('#type').val('confirm');
	submitForm();
}

/**
 * ファイルインポート（確認）
 */
function actionComplete() {
	$('#type').val('complete');
	submitForm();
}

/**
 * 中継銀行の表示の切り替え
 */
function toggleIntermediaries() {
	if($('#intermediary_flg:checked').val()) {
		$('#intermediaries').show();
	} else {
		$('#intermediaries').hide();
	}
}

/**
 * 詳細表示
 */
function actionDetail(dId, target) {
	$('#acForm').attr('action','');
	$('#type').val('detail');
	$('#w_id').val(dId);

	// ターゲットがない場合
	if(target != undefined) {
		getForm().attr('target', target);
	} else {
		getForm().attr('target', '');
	}

	submitForm();
}

/**
 * 組戻しの表示
 */
function toggleFeeRefund() {
	if($('#status').val() == '4') {
		$('#txt_fee_refund').show();
	} else {
		$('#txt_fee_refund').hide();
	}
}

/**
 * toggle fla3 preview
 */
function toggleFlat3(){
	var previewBtn = (lang == "en" ? "Preview" : "プレビュー");
    var pagerElement = document.getElementsByClassName('pager');
    var previewFlat3Btn = '<a href="javascript:actionFlat3Preview(\'_blank\');" id="btn-preview" class="btn bg-default hi22 float-left" style="margin: auto; text-align: center;">'+previewBtn+'</a>';

	if($('#s_solution').val()=='Flat3'){
		pagerElement[1].innerHTML = previewFlat3Btn + pagerElement[0].innerHTML;
	}
}

/**
 * fla3 preview
 */
function actionFlat3Preview(target) {
	$('#acForm').attr('action','');
	$('#type').val('flat3_preview');

	// ターゲットがない場合
	if(target != undefined) {
		getForm().attr('target', target);
	} else {
		getForm().attr('target', '');
	}

	submitForm();
}

function setDefault() {
	if($('#s_withdraw_type0').prop('checked') == true){
		$('#s_fee').hide();
		$('#s_solution').show();	
	}else{
		$('#s_solution').hide();
		$('#s_fee').show();
	}
}