<?php
$page_title = "KYCアップロード";
include_once('template/base_head.php');
?>
			<!-- サイドバー -->
			<aside id="colLeft">
				<h1><a href="/ja/menu"><img src="../img/logo.png" alt="iWallet"></a></h1>
<?php include_once('template/base_sidebar_setting.php'); ?>
			</aside>
			<!-- /サイドバー -->
			<!-- メインカラム -->
			<div id="colMain">
				<div class="mainIn">
<?php include_once('template/base_nav.php'); ?>
					<article>
						<div class="article-heading">
							<h2><?php echo $page_title; ?></h2>
						</div>
						<?php $this -> echoMessage(); ?>
						<p class="pb30 pleft40"><strong>KYC書類：ご本人確認書類とご住所確認書類をセットでアップロードして下さい。</strong><br>
						KYC書類が基準を満たしていない場合、お受付できません。<u><a href="../kyc/kyc_ja_00notes.pdf" target="_blank" title="KYCご案内と注意事項">コチラ</a></u>の案内をご覧くださいませ。</p>
						<p class="pb30 pleft40"><strong>ご本人確認書類とは</strong><br>
						政府または公的機関が発行したお客様の氏名、顔写真、生年月日、有効期限、発行機関名が明記されている書類です。<br>
						有効期限失効まで3ヶ月以上の書類をご準備ください。<br>
						※現在、お受付しているご本人各書類は下記3種類です。事前にサンプルをご確認ください。<br><br>
						・<u><a href="../kyc/kyc_ja_11PT.pdf" target="_blank" title="パスポートサンプル">パスポート</a></u>
						・<u><a href="../kyc/kyc_ja_12DL.pdf" target="_blank" title="運転免許証サンプル">運転免許証</a></u>
						・<u><a href="../kyc/kyc_ja_13RC.pdf" target="_blank" title="住基カードサンプル">住基カード</a></u></p>

						<p class="pb30 pleft40"><strong>ご住所確認書類とは</strong><br>
						政府・公的機関または一部企業が発行したお客様の氏名、現住所、発行日または有効期限、発行機関名が明記されている書類です。<br>
						有効期限失効まで3ヶ月以上、または発行から3ヶ月以内の書類をご準備ください。<br>
						※現在、お受付しているご住所確認書類は下記11種類です。事前にサンプルをご確認ください。<br><br>

						・<u><a href="../kyc/kyc_ja_21EB.pdf" target="_blank" title="電気料金サンプル">電気料金</a></u>
						・<u><a href="../kyc/kyc_ja_22GB.pdf" target="_blank" title="ガス料金サンプル">ガス料金</a></u>
						・<u><a href="../kyc/kyc_ja_23PB.pdf" target="_blank" title="電話/金融機関明細">電話/金融機関明細</a></u>
						・<u><a href="../kyc/kyc_ja_24WB.pdf" target="_blank" title="水道料金サンプル">水道料金</a></u>
						・<u><a href="../kyc/kyc_ja_25RP.pdf" target="_blank" title="住民票サンプル">住民票</a></u>
						・<u><a href="../kyc/kyc_ja_26IC.pdf" target="_blank" title="健康保険証サンプル">健康保険証</a></u><br>
						・<u><a href="../kyc/kyc_ja_27RC.pdf" target="_blank" title="住基カードサンプル">※住基カード</a></u>
						・<u><a href="../kyc/kyc_ja_28DL.pdf" target="_blank" title="運転免許証サンプル">※運転免許証</a></u>
						・<u><a href="../kyc/kyc_ja_29OT.pdf" target="_blank" title="組合員証サンプル">組合員証</a></u>
						・<u><a href="../kyc/kyc_ja_30OT.pdf" target="_blank" title="障害者受給者証サンプル">障害者受給者証</a></u>
						・<u><a href="../kyc/kyc_ja_31OT.pdf" target="_blank" title="福祉受給者証サンプル">福祉受給者証</a></u><br><br>

						<span class="red">
						<strong>弊社推奨のKYC書類セットは、パスポート＋運転免許証です。</strong>（カード審査が比較的スムーズです。）<br><br>
						※住基カードと運転免許証は住所確認書類としてもご使用できますが、その際はご本人確認書類として同時には併用できません。<br>
						※ファイルは、サイズ5MB以下のjpg、jpeg、pdf、png、gifにてお願いします。<br>
						※アップロードできるKYC書類の枚数制限は10枚（ご本人確認書類 5 枚、ご住所確認書類 5 枚）までとなっております。<br>
                        ※一般的な公的書類に記載されている情報とiWallet口座での登録情報が一致することをご確認お願い致します。<br>
						※口座認証や今後の金融取引において遅延が発生しないためにiWallet口座でのご登録名は、パスポート、銀行/クレジットカード明細書、通帳などの正式な書類にあるローマ字表記のお名前と必ず一致していることをご確認ください。<br>
						&emsp;ご登録情報の照合のため書類のご提出をお願いすることもありますことを予めご了承ください。<br>
                        ※「字」「大字」「甲」などの地名表記、「建物名」も含まれます。また、「番地」や「建物番号」の記載もご確認ください。<br>
						※書類の全体をカラー撮影し、小さな文字が読める鮮明な画像をお願いします。<br>
						※ピンボケ、ブレ、不鮮明、全体像が撮影されていない画像は不可になりますのでお気をつけ下さい。<br>
						※画像の目安は、拡大して小さい文字が判読できる鮮明度になります。</span></p>
					<?php
					if($this -> canUpload()){
					?>
						<form id="acForm" action="" method="post" enctype="multipart/form-data" class="pleft40">
						<?php if($this -> canUploadPI(0)){ ?>
						<p class="pb10 pleft40"><strong>【ご本人確認書類】</strong><br>
							<table class="table col bdr default odd kycT fontM mb30 ma90sp">
								<?php $this -> dispInputs(0); ?>
							</table>
						<?php } ?>
						<?php if($this -> canUploadPI(1)){ ?>
							<p class="kycT respM pb10"><strong>【ご住所確認書類】</strong><br>
							<table class="table col bdr default odd kycT fontM mb30 ma90sp">
								<?php $this -> dispInputs(1); ?>
							</table>
						<?php } ?>
							<p class="kycT respM pb10 red">※不鮮明な画質や当社基準に適合しない場合は、再アップロードをお願いする場合があります。<br>
							※ご本人確認書類とご住所確認書類はそれぞれ別の書類が必要です。<br>
							※ご提出頂いた順に書類確認させて頂いておりますので、アップロード書類状態が未認証のお客様は審査完了までファイルを追加しないでお待ちください。</p>

							<p class="kycT mb20"><input type="button" id="btnKyc" value="アップロード" class="btn bg-grad px120 calign"></p>
							<input type="hidden" value="save" id="type" name="type" />
							<input type="hidden" value="settting_kyc" id="action" name="action" />

							<input type="hidden" value="0" id="img_1_flg" name="img_1_flg" />
							<input type="hidden" value="0" id="img_2_flg" name="img_2_flg" />
							<input type="hidden" value="0" id="img_3_flg" name="img_3_flg" />
							<input type="hidden" value="1" id="img_4_flg" name="img_4_flg" />
							<input type="hidden" value="1" id="img_5_flg" name="img_5_flg" />
							<input type="hidden" value="1" id="img_6_flg" name="img_6_flg" />
							<input type="hidden" value="" id="k_id" name="k_id" />
						</form>

						<hr class="mb20">
						<h3>KYCアップロード</h3>
                     	<table class="table col bdr default odd fontXS calign" style="margin-top: 10px;">
                        <colgroup>
							<col width="50%">
						</colgroup>
                        <tr>
                        	<th>書類審査状況</th>
                            <td><?php echo $this -> getStatus(); ?></td>
                        </tr>
                        </table>
                        <?php
							$validateStatus = $this -> getValidateStatus();
							if($validateStatus == '8' || $validateStatus == '18'){
						?>
							<p class="red" style="margin-top: 10px;">※書類審査状況　【KYC不備】の場合　ご登録メールアドレスへ不備詳細をお送りしております。確認ができない場合はカスタマサポートへお問い合わせ下さい。</p>
						<?php
							}
						?>
                        <br>
                        <h3>アップロード書類状態</h3>
                        <table class="table col bdr default odd fontXS calign" style="margin-top: 5px;">
                        	<tr>
                            	<th class="w25p">アップロード日時</th>
                                <th class="w20p">書類タイプ</th>
                                <th class="w20p">ファイル名</th>
                            </tr>
                            <?php $this -> dispKYCList(); ?>
                        </table>
					<?php
						}else{
					?>
						<hr class="mb20">
						<h3>KYCアップロード</h3>
                       	<p style="margin-top: 10px;" class="red">お客様は書類審査中または書類審査完了により現在アップロードできません。</p>
                     	<table class="table col bdr default odd fontXS calign" style="margin-top: 10px;">
                        <colgroup>
							<col width="50%">
						</colgroup>
                        <tr>
                        	<th>書類審査状況</th>
                            <td><?php echo $this -> getStatus(); ?></td>
                        </tr>
                        </table>
                        <p class="red" style="margin-top: 10px;">※書類審査状況　【KYC不備】の場合　ご登録メールアドレスへ不備詳細をお送りしております。確認ができない場合はカスタマサポートへお問い合わせ下さい。</p>
                        <br>
                        <h3>アップロード書類状態</h3>
                        <table class="table col bdr default odd fontXS calign" style="margin-top: 5px;">
                        	<tr>
                            	<th class="w25p">アップロード日時</th>
                                <th class="w20p">書類タイプ</th>
                                <th class="w20p">ファイル名</th>
                            </tr>
                            <?php $this -> dispKYCList(); ?>
                        </table>
					<?php
						}
					?>
					</article>
				</div>
			</div>
			<!-- /メインカラム -->
		</div>
<?php include_once('template/base_foot.php'); ?>
	</div>
	<script src="../js/setting.js"></script>
</body>
</html>
