<?php
require_once(SYSTEM_LOGICS . 'mst_fee/model.php');

class LogicMstFee extends MstFeeModelClass {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $htmlStr = NO_STRING;	// 表示用HTML文字列

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジック（各クラス共通）
	* @parameter	: なし
	* @return		: TRUE:ロジック成功、FALSE:ロジック失敗
	-------------------------------------------------------------------------*/
	function logic() {

		try {

			// 初期データ処理
			$this -> init();
			
			// データの登録
			if($this -> getType()			== TYPE_REGITS) {	// 新規登録
				$this -> insertActivity();
				$this -> regist();
			} else if($this -> getType()	== TYPE_UPDATE) {	// 更新
				$this -> insertActivity();
				$this -> update();
			} else if($this -> getType()	== TYPE_EDIT) {		// 編集
				$this -> edit();
			} else if($this -> getType()	== TYPE_DELETE) {	// 削除
				$this -> insertActivity();
				$this -> delete();
			}

			// 新規作成の場合は何もしない
			if($this -> getType() == TYPE_CREATE) {
				return;
			}

			// データの取得
			if($this -> getType()			== NO_STRING
				|| $this -> getType()		== TYPE_DELETE) {	// 何もなし、完了、削除時
				$this -> lists();
			} else if($this -> getType()	== TYPE_INPUT) {	// 入力画面遷移時
				// 何もしない
			} else if($this -> getType()	== TYPE_COMPLETE) {
				$this -> setType(TYPE_INPUT);
				$this -> select();
			} else {											// その他
				$this -> select();
			}

		} catch (Exception $e) {
			throw $e;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 一覧の取得
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function lists() {

		// 変数宣言部
		$rs = null;

		// データの取得
		$rs = $this -> accessSelect('LIST_FEES', array());

		// データをモデルクラスへ設定
		$this -> setFees($rs);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 手数料の取得
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function select() {

		// 変数宣言部
		$rs		= null;
		$row	= null;

		// データの取得
		$rs = $this -> accessSelect('SELECT_FEES', array($this -> getFId()));

		// 共通項目だけ設定する
		if($this -> isLoopData($rs)) {

			$row = $rs[NO_COUNT];

			$this -> setName($this -> getColumnData($row, COLUMN_FEE_TYPE_NAME));
			$this -> setFeeType($this -> getColumnData($row, COLUMN_FEE_TYPE));
		}

		// データをモデルクラスへ設定
		$this -> setFees($rs);
	}

	/*-------------------------------------------------------------------------
	* @function_name: データの登録
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function regist() {

		// 変数宣言部
		$cnt = NO_COUNT;

		// 手数料IDの取得
		$this -> setFId($this -> getSequenceNo(SQ_KEY_FEES));

		// 手数料の登録
		$this -> accessModify('INSERT_FEES', $this -> getRegistFees());

		for($cnt = VAL_INT_1; $cnt <= VAL_INT_8; $cnt++) {

			if($cnt == VAR_TRANSFER) {		// 口座振替のみ特殊

				// 手数料詳細の登録（個人→法人）
				$this -> accessModify('INSERT_FEES_DETAIL', $this -> getRegistFeesDetail($cnt, VAR_C_TO_B));

				// 手数料詳細の登録（個人→個人）
				$this -> accessModify('INSERT_FEES_DETAIL', $this -> getRegistFeesDetail($cnt, VAR_C_TO_C));

				// 手数料詳細の登録（法人→個人）
				$this -> accessModify('INSERT_FEES_DETAIL', $this -> getRegistFeesDetail($cnt, VAR_B_TO_C));

				// 手数料詳細の登録（法人→法人）
				$this -> accessModify('INSERT_FEES_DETAIL', $this -> getRegistFeesDetail($cnt, VAR_B_TO_B));

			} else {						// その他

				// 手数料詳細の登録（個人）
				$this -> accessModify('INSERT_FEES_DETAIL', $this -> getRegistFeesDetail($cnt, VAR_FEE_PERSON));

				// 手数料詳細の登録（法人）
				$this -> accessModify('INSERT_FEES_DETAIL', $this -> getRegistFeesDetail($cnt, VAR_FEE_CORP));
			}
		}

		$this -> setType(TYPE_COMPLETE);
		$this -> popUpSessionMessage(INFO, 'I_COMPLATE_REGIST', array());
	}

	/*-------------------------------------------------------------------------
	* @function_name: データの更新
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function update() {
		// 変数宣言部
		$cnt = NO_COUNT;

		// 手数料の更新
		$this -> accessModify('UPDATE_FEES', $this -> getRegistFees(), false);

		// 手数料詳細の削除
		//$this -> accessModify('DELETE_FEES_DETAIL', array($this -> getFId()));

		for($cnt = VAL_INT_1; $cnt <= VAL_INT_8; $cnt++) {

			if($cnt == VAR_TRANSFER) {		// 口座振替のみ特殊

				// 手数料詳細の登録（個人→法人）
				$this -> accessModify('UPDATE_FEES_DETAIL', $this -> getRegistFeesDetail($cnt, VAR_C_TO_B), false);

				// 手数料詳細の登録（個人→個人）
				$this -> accessModify('UPDATE_FEES_DETAIL', $this -> getRegistFeesDetail($cnt, VAR_C_TO_C), false);

				// 手数料詳細の登録（法人→個人）
				$this -> accessModify('UPDATE_FEES_DETAIL', $this -> getRegistFeesDetail($cnt, VAR_B_TO_C), false);

				// 手数料詳細の登録（法人→法人）
				$this -> accessModify('UPDATE_FEES_DETAIL', $this -> getRegistFeesDetail($cnt, VAR_B_TO_B), false);

			} else {						// その他


				// 手数料詳細の登録（個人）
				$this -> accessModify('UPDATE_FEES_DETAIL', $this -> getRegistFeesDetail($cnt, VAR_FEE_PERSON), false);

				// 手数料詳細の登録（法人）
				$this -> accessModify('UPDATE_FEES_DETAIL', $this -> getRegistFeesDetail($cnt, VAR_FEE_CORP), false);
			}
		}
		
		$this -> setType(TYPE_COMPLETE);
		$this -> popUpSessionMessage(INFO, 'I_COMPLATE_REGIST', array());
	}

	/*-------------------------------------------------------------------------
	* @function_name: データの編集
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function edit() {
// echo $this -> getFId();
	}

	/*-------------------------------------------------------------------------
	* @function_name: データの削除
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function delete() {

		// 手数料の削除
		$this -> accessModify('DELETE_FEES', array($this -> getFId()));

		// 手数料詳細の削除
		$this -> accessModify('DELETE_FEES_DETAIL', array($this -> getFId()));

		$this -> popUpSessionMessage(INFO, 'I_COMPLATE_DELETE', array());
	}

	/*-------------------------------------------------------------------------
    * @function_name: insertActivity
    * @parameter	:
    * @return		:
    -------------------------------------------------------------------------*/

    function insertActivity(){
		$this -> accessModify('INSERT_ACTIVITY', $this -> getActivity(), false);
	}
}
?>