
<?php
require_once('config.php');
require_once('CheckCardLoadBase.php');
include_once('APICardDeposit.php');

class APIMakeCardLoad extends System {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $signature		= NO_STRING;
	private $account		= NO_STRING;
	private $cardHolderId	= NO_STRING;
	private $code			= NO_STRING;
	private $data			= NO_STRING;
	private $result			= NO_STRING;

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: パスワードの更新
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function action() {

		// 変数宣言部
		$rtn		= array();
		$base		= null;
		$param		= null;

		try {

			// パラメータの設定
			$this -> signature		= $this -> getDataPost(PARAM_SIGNATURE);
			$this -> account		= $this -> getDataPost(PARAM_USER_ACCOUNT);
			$this -> cardHolderId	= $this -> getDataPost(PARAM_CARD_HOLDER_ID);

			// エラーチェック
			$base = new APICheckCardLoadBase();
			$base -> action();

			// カードのチャージ
			$api = new APICardDeposit();
			$rtn = $api -> action();

			$this -> code	= $this -> getColumnData($rtn, PARAM_CODE);
			$this -> data	= $rtn[PARAM_DATA] -> ProcessResult;

			if($this -> getColumnData($rtn, PARAM_RESULT) != PARAM_SUCCESS) {		// 処理失敗
				throw new Exception('E_FATAL');
			}

			// 出金申請の登録
			$this -> transactionNumber = $this -> getTransactionNumberCommon(VAR_TRANSACTION_WITHDRAW);

			$param		= array();
			$param[]	= $this -> account;																	// 口座番号
			$param[] 	= USD;																				// 通貨
			$param[] 	= $this -> currencyToInt($base -> getAmount(), USD);								// 金額
			$param[] 	= USD;																				// 通貨
			$param[] 	= $this -> cardHolderId;															// CHID
			$param[] 	= $this -> getUserData(PARAM_USER_ACCOUNT);											// 口座名義
			$param[] 	= $base -> getDebitCurrency();														// 引落口座通貨
			$param[] 	= $this -> currencyToInt($base -> getDebitAmount(), $base -> getDebitCurrency());	// 引落口座金額
			$param[] 	= floatval($this -> getRateEx());													// レート
			$param[] 	= $this -> currencyToInt($this -> getFeeEx(), $base -> getDebitCurrency());			// 手数料
			$param[] 	= $this -> transactionNumber;														// 取引番号
			$param[] 	= VAL_INT_2;																		// ステータス（2：送金済み）
			$param[] 	= VAL_INT_3;																		// タイプ（3：カード入金）
			$param[] 	= 'Card Loading';																	// 送金先銀行
			$param[] 	= $this -> code;																	// カードチャージコード
			$param[] 	= $this -> data;																	// 備考

			if($this -> accessModify('INSERT_WITHDRAW_CARD', $param, false)) {

				// 異通貨の場合は為替コミッション発生
				if(USD != $base -> getDebitCurrency()) {

					if($base -> getTransferType() == NO_COUNT) {

						$this -> registCommisionExchange($this -> getUserData(PARAM_USER_ACCOUNT)
								, $this -> getDebitCurrency()
								, USD
								, $this -> currencyToInt($this -> getToAmount(), USD));
					} else {
						$this -> registCommisionExchange($this -> getUserData(PARAM_USER_ACCOUNT)
								, USD
								, $this -> getDebitCurrency()
								, $this -> currencyToInt($this -> getDebitAmount(), $this -> getDebitCurrency()));
					}
				}

				// コミッションの設定
				$this -> registCommision(VAR_CARD_DEPOSIT
										, null
										, $this -> account
										, $base -> getDebitCurrency()
										, $base -> getFeeEx());

				// メール送信用のパラメータ取得
				$params	= array();
				$row	= $this -> getRowData($this -> getAccountCommon($this -> getUserData(PARAM_USER_ACCOUNT)));

				$params[] = $this -> account;																	// ユーザ口座番号
				$params[] = $this -> getNameCommon($this -> account);											// ユーザ名
				$params[] = $this -> getCurrentTimeCommon();													// 現在時刻
				$params[] = USD;																				// 通貨
				$params[] = $this -> formatCurrency($base -> getToAmount(), USD);								// 金額
				$params[] = $this -> getColumnData($row, COLUMN_MAIL);											// メールアドレス
				$params[] = $base -> getDebitCurrency();														// 引落口座通貨
				$params[] = $this -> formatCurrency($base -> getDebitAmount(), $base -> getDebitCurrency());	// 引落口座金額
				$params[] = $this -> formatCurrency($base -> getFeeEx(), $base -> getDebitCurrency());			// 手数料
				$params[] = $this -> transactionNumber;															// 取引番号

				// メールを送信（ユーザ）
				$this -> sendMailByTmp('cardloading_complete.xml'
										, $params
										, $params[VAL_INT_5]
										, VAR_CARD_MAIL_ADDRESS);

				// メールを送信（管理者）
				$this -> sendMailByTmp('cardloading_complete_for_admin.xml'
										, $params
										, VAR_NOTICE_MAIL_ADDRESS
										, VAR_NOTICE_MAIL_ADDRESS);


				echo json_encode(array('result'			=> 'OK'
										, 'messages'	=> 'I_COMPLETE_PROCESS'
										, 'data'		=> $rtn));
			}

		} catch (Exception $e) {
			$rtn = array('result'		=> 'NG'
						, 'messages'	=> $e -> getMessage());

			echo json_encode($rtn);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: エラーチェック
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function validate() {}
}

try {

	// チェックロジック
	$api = new APIMakeCardLoad();
	$api -> action();

	// カードのロード
// 	require_once('DepositCard.php');

} catch (Exception $e) {	// チェックエラー
}

?>