<?php
require_once(SYSTEM_LOGICS . 'card_apply/model.php');

class LogicCardApply extends CardApplyModelClass {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $htmlStr = NO_STRING;	// 表示用HTML文字列

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジック（各クラス共通）
	* @parameter	: なし
	* @return		: TRUE:ロジック成功、FALSE:ロジック失敗
	-------------------------------------------------------------------------*/
	function logic() {

		try {

			// 初期データ処理
			if($this -> init()) {

				if($this -> getType()				== TYPE_SAVE) {			// データ保存
					$this -> save();
					$this -> lists();

				} else if($this -> getType()		== TYPE_UPDATE) {	// データ保存（コメントのみ）
					$this -> update();
					$this -> select();
					$this -> restore();

				} else if($this -> getType()		== TYPE_DETAIL) {	// データ詳細
					$this -> select();
					$this -> restore();

				} else if($this -> getType()		== TYPE_INPUT) {	// データ入力画面（初期値）
					$this -> restore();

				} else if($this -> getType()		== TYPE_BACK
							|| $this -> getType()	== TYPE_CONFIRM) {	// データ入力画面（エラー戻り）
					$this -> setDetail($this -> getRowData($this -> getAccountCommon($this -> getUserAccount())));
					$this -> restore();

				} else if($this -> getType()		== TYPE_COMPLETE) {	// データ入力画面（完了）
						$this -> regist();
						$this -> lists();

				} else {
					$this -> lists();
				}
			}

		} catch (Exception $e) {
			throw $e;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: カード申請リストの取得
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function lists() {
		$this -> setResult($this -> accessSelect('LIST_CARD_APPLY', array($this -> getWhere())));
	}

	/*-------------------------------------------------------------------------
	* @function_name: カード申請の表示
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function select() {
		$this -> setDetail($this -> getRowData($this -> accessSelect('SELECT_CARD_APPLY', $this -> getDetailDatas())));
	}

	/*-------------------------------------------------------------------------
	* @function_name: データの更新
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function save() {

		// 変数宣言部
		if($this -> accessModify('UPDATE_CARD_APPLY', $this -> getUpdateParams())) {	// 登録OKであればメールを送信する

			// UP完了、NUP完了の場合、ユーザデータのカード紐づけ
			if($this -> getStatus()			== VAR_CARD_UP_COMPLETE
				|| $this -> getStatus()		== VAR_CARD_NUP_COMPLETE) {

				// データの削除
				$this -> accessModify('DELETE_USER_CARDS', $this -> getDeleteParams());

				// データの登録
				$this -> accessModify('INSERT_USER_CARDS', $this -> getUserCardRegistParams());
			}

			// メールを送信する
			if($this -> getStatus()			== VAR_CARD_UP_COMPLETE) {	// UP完了

				$this -> sendMailByTmpAndWL($this -> getUserAccount()
											, 'card_apply_complete.xml'
											, $this -> getSendParams()
											, NO_STRING
											, 'card@');

			} else if($this -> getStatus()	== VAR_CARD_NUP_COMPLETE) {	// NUP完了

				$this -> sendMailByTmpAndWL($this -> getUserAccount()
											, 'card_apply_nup_complete.xml'
											, $this -> getSendParams()
											, NO_STRING
											, 'card@');
			}

			$this -> popUpSessionMessage(INFO, 'I_COMPLATE_REGIST', array());
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: データの更新（コメントのみ）
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function update() {

		// 変数宣言部
		$this -> accessModify('UPDATE_CARD_APPLY_COMMENT', $this -> getUpdateCommentParams());

		$this -> popUpSessionMessage(INFO, 'I_COMPLATE_REGIST', array());
	}

	/*-------------------------------------------------------------------------
	* @function_name: データの登録
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function regist() {

		// 変数宣言部
		$this -> accessModify('INSERT_INTO_CARD_APPLY', $this -> getRegistParams());

		$this -> popUpSessionMessage(INFO, 'I_COMPLATE_REGIST', array());
	}
}
?>