<?php
$page_title = "新規口座開設";
include_once('site_config.php');
include_once('template/base_site_head.php');
?>
    <!-- メインエリア -->
<wrapper class="mymain_container">
	<section class="container page-container">
		<div class="form_information">
			<div class="number-list">
	            <ul class="num_ul">
	                <li class="f_1 done"><div class="circle">1</div><div class="line"></div></li><!--
	                --><li class="active f_2"><div class="circle">2</div><div class="line"></div></li><!--
	                --><li class="f_3"><div class="circle">3</div><div class="line"></div></li><!--
	                --><li class="f_4"><div class="circle">4</div><div class="line"></div></li><!--
	                --><li class="f_5"><div class="circle">5</div></li>
	            </ul>
	        </div>
		<form id="acForm" action="" method="post" class="form_list active">
		<?php $this -> dispMessagesCommon(); ?>
	        	<div class="cont_steps s_step">
	        		<div class="field_list">
	        			<div class="limit_width">
	        				<label class="title_name"><?php echo $page_title; ?></label>
			        		<p>
			        			以下の情報をご入力ください。
			        		</p>
			        		<div class="cus_form">
			        			<div class="table_form table_form_list">
				        			<div class="form_elem ">
				        				<label class="title_txt">名<span id="required" class="required">*</span><br><span>アルファベットで名をご入力ください。（例：Taro）</span></label>
				        				<input type="text" name="first_name" class="verify_input" value="<?php $this -> echoFirstName(); ?>" /><i class="fa"></i>
				        			</div>
				        			<div class="form_elem ">
				        				<label class="title_txt">姓<span id="required" class="required">*</span><br><span>アルファベットで姓をご入力ください。（例：Yamada）</span></label>
				        				<input type="text" name="last_name" class="verify_input" value="<?php $this -> echoLastName(); ?>" /><i class="fa"></i>
				        			</div>
				        			<div class="form_elem ">
				        				<label class="title_txt">法人名<span id="required" class="required">*</span></label>
				        				<input type="text" name="name" value="<?php $this -> echoName(); ?>" class="verify_input"><i class="fa"></i>
				        			</div>
				        			<div class="form_elem ">
				        				<label class="title_txt">電話番号<span id="required" class="required">*</span></label>
				        				<input type="tel" name="tel" value="<?php $this -> echoTel(); ?>" class="verify_input"><i class="fa"></i>
				        			</div>
				        			<div class="form_elem ">
				        				<label class="title_txt">代表者生年月日</label>
				        	<select name="birth_year" id="birth_year" class="select">
								<option>--年--</option>
								<?php $this -> dispYear(); ?>
							</select>			
							<select name="birth_month" id="birth_month" class="select">
								<option value="--MM--">--月--</option>
								<?php $this -> dispMonth(); ?>
							</select>
							<select name="birth_day" id="birth_day" class="select">
								<option>--日--</option>
								<?php $this -> dispDay(); ?>
							</select>
				        			</div>
				        			<div class="form_elem ">
				        				<label class="title_txt">メールアドレス</label>
				        				<?php $this -> echoEmail(); ?><i class="fa"></i>
				        			</div>
				        			<div class="form_elem verify_password">
				        				<label class="title_txt">パスワード<span id="required" class="required">*</span><br><span>8～12字以内で、数字と大文字を含むパスワードにしてください。（例：AtoZ^%-@0~9!）</span></label>
				        				<input type="password" name="password" class="verify_input" value="" /><i class="fa"></i>
				        			</div>
				        			<div class="form_elem verify_password2">
				        				<label class="title_txt">パスワード<span id="required" class="required">*</span><br><span>（再入力）</span></label>
				        				<input type="password" name="password_confirm" class="verify_input" value="" /><i class="fa"></i>
				        			</div>
				        			<div class="form_elem ">
				        				<label class="title_txt">国</label>
								<select name="country" value="<?php $this -> echoEmail(); ?>" class="select">
									<option value=''>--選択--</option>
									<?php $this -> dispCountry(); ?>
								</select>
				        			</div>
				        			<div class="form_elem ">
				        				<label class="title_txt">州・都道府県<span id="required" class="required">*</span></label>
								<input type="text" name="state" value="<?php $this -> echoState(); ?>" class="verify_input">
				        			</div>
				        			<div class="form_elem ">
				        				<label class="title_txt">市・区名<span id="required" class="required">*</span></label>
								<input type="text" name="city" value="<?php $this -> echoCity(); ?>" class="verify_input">
				        			</div>
				        			<div class="form_elem ">
				        				<label class="title_txt">住所（建物名#部屋番号,番地,町村名）<span id="required" class="required">*</span></label>
								<input type="text" name="address" value="<?php $this -> echoAddress(); ?>" class="verify_input">
				        			</div>
				        			<div class="form_elem ">
				        				<label class="title_txt">郵便番号<span id="required" class="required">*</span></label>
								<input type="text" name="zip_code" value="<?php $this -> echoZipCode(); ?>" class="verify_input">
				        			</div>
				        			<div class="form_elem ">
				        				<label class="title_txt">サイト名・屋号<br><span>お客様に表示可能なサイト名、屋号名をご記入ください。</span></label>
								<input type="text" name="site_name" value="<?php $this -> echoSiteName(); ?>" class="verify_input">
				        			</div>
				        			<div class="form_elem ">
				        				<label class="title_txt">サイトURL<span id="required" class="required">*</span></label>
								<input type="url" name="site_url" value="<?php $this -> echoSiteUrl(); ?>" class="verify_input">
				        			</div>

				        		</div>
			        		</div>
	        			</div>
	        			
	        		</div>
	        		<div class="event_next1 event_custom">
	        			<input type="button" id="btnConfirm" value="Confirm" class="custom nxt_form">
	        		</div>

			<input type="hidden" id="type" name="type" value="" />
			<input type="hidden" id="account_type" name="account_type" value="<?php $this -> echoAccountType(); ?>" />
			<input type="hidden" id="email" name="email" value="<?php $this -> echoEmail(); ?>" />
			<input type="hidden" id="agent_code" name="agent_code" value="<?php $this -> echoAgent(); ?>" />
			</div>
		</form>

	<script src="../js/register.js"></script>
		</div>
	</section>

</wrapper>





    <!-- メインエリア -->
	<div id="main" class="container" style="display:none;">
		<h2><?php echo $page_title; ?></h2>
		<p>以下の情報をご入力ください。</p>
		<form id="acForm" action="" method="post">
			<?php $this -> dispMessagesCommon(); ?>
			<table class="table table-bordered c_th mb20">
				<colgroup>
					<col class="w20p">
					<col class="w20p">
					<col class="w60p">
				</colgroup>
				<tbody>
					<tr>
						<th colspan="2">メールアドレス</th>
						<td><?php $this -> echoEmail(); ?></td>
					</tr>
					<tr>
						<th colspan="2">パスワード <span class="label label-danger">必須</span></th>
						<td>
							<input type="password" name="password" class="form-control w50p">
							<span class="note_s">8～12字以内で、数字と大文字を含むパスワードにしてください。（例：AtoZ^%-@0~9!）</span>
						</td>
					</tr>
					<tr>
						<th colspan="2">パスワード<span class="note_s">（再入力） <span class="label label-danger">必須</span></span></th>
						<td>
							<input type="password" name="password_confirm" class="form-control w50p">
							<span class="note_s">上と同じパスワードを入力してください。</span>
						</td>
					</tr>
					<tr>
						<th colspan="2">法人名 <span class="label label-danger">必須</span></th>
						<td>
							<input type="text" name="name" value="<?php $this -> echoName(); ?>" class="form-control w50p">
						</td>
					</tr>
					<tr>
						<th colspan="2">電話番号 <span class="label label-danger">必須</span></th>
						<td>
							<input type="tel" name="tel" value="<?php $this -> echoTel(); ?>" class="form-control w50p">
						</td>
					</tr>


					</tr>
						<th rowspan="2">代表者氏名 <span class="label label-danger">必須</span></th>
						<th>名</th>
						<td>
							<input type="text" name="first_name" class="form-control w50p" value="<?php $this -> echoFirstName(); ?>" />
							<span class="note_s">アルファベットで名をご入力ください。（例：Taro）</span>
						</td>
					</tr>
					<tr>
						<th>姓</th>
						<td>
							<input type="text" name="last_name" class="form-control w50p" value="<?php $this -> echoLastName(); ?>" />
							<span class="note_s">アルファベットで姓をご入力ください。（例：Yamada）</span>
						</td>
					</tr>
					<tr>
						<th colspan="2">代表者生年月日 <span class="label label-danger">必須</span></th>
						<td>
							<select name="birth_year" class="select">
								<?php $this -> dispYear(); ?>
							</select>
							<span class="spcr-br">年</span>
							<select name="birth_month" class="select">
								<?php $this -> dispMonth(); ?>
							</select>
							<span class="spcr-br">月</span>
							<select name="birth_day" class="select">
								<?php $this -> dispDay(); ?>
							</select>
							<span>日</span>
						</td>
					</tr>
					<tr>
						<th colspan="2">国 <span class="label label-danger">必須</span></th>
						<td>
							<select name="country" value="<?php $this -> echoEmail(); ?>" class="select">
							<?php $this -> dispCountry(); ?>
						</select>
						</td>
					</tr>
					<tr>
						<th colspan="2">州・都道府県 <span class="label label-danger">必須</span></th>
						<td>
							<input type="text" name="state" value="<?php $this -> echoState(); ?>" class="form-control w30p">
							<span class="note_s">アルファベットでご入力ください。（例：○○-Ken）</span>
						</td>
					</tr>
					<tr>
						<th colspan="2">市・区名 <span class="label label-danger">必須</span></th>
						<td>
							<input type="text" name="city" value="<?php $this -> echoCity(); ?>" class="form-control w100p">
							<span class="note_s">アルファベットでご入力ください。（例：Chuo-Ku,□□-Shi）</span>
						</td>
					</tr>
					<tr>
						<th colspan="2">住所（建物名#部屋番号,番地,町村名） <span class="label label-danger">必須</span></th>
						<td>
							<input type="text" name="address" value="<?php $this -> echoAddress(); ?>" class="form-control w100p">
							<span class="note_s">アルファベットでご入力ください。（例：ABC Bldg #102,1-2-3,△△Cho)</span>
						</td>
					</tr>
					<tr>
						<th colspan="2">郵便番号 <span class="label label-danger">必須</span></th>
						<td>
							<input type="text" name="zip_code" value="<?php $this -> echoZipCode(); ?>" class="form-control w30p">
						</td>
					</tr>
					<tr>
						<th colspan="2">サイト名・屋号</th>
						<td>
							<input type="text" name="site_name" value="<?php $this -> echoSiteName(); ?>" class="form-control w100p">
							<span class="note_s">お客様に表示可能なサイト名、屋号名をご記入ください。</span>
						</td>
					</tr>
					<tr>
						<th colspan="2">サイトURL <span class="label label-danger">必須</span></th>
						<td>
							<input type="url" name="site_url" value="<?php $this -> echoSiteUrl(); ?>" class="form-control w100p">
						</td>
					</tr>
				</tbody>
			</table>
			<p class="text-center"><input type="button" id="btnConfirm" value="確認ページへ進む" class="btn btn-primary btn-lg"></p>

			<input type="hidden" id="type" name="type" value="" />
			<input type="hidden" id="account_type" name="account_type" value="<?php $this -> echoAccountType(); ?>" />
			<input type="hidden" id="email" name="email" value="<?php $this -> echoEmail(); ?>" />
			<input type="hidden" id="agent_code" name="agent_code" value="<?php $this -> echoAgent(); ?>" />
		</form>
	</div>
	<script src="../js/register.js"></script>
    <!-- /メインエリア -->
<?php
include_once('template/base_site_foot.php');
echo $endscripts;
?>
</body>
</html>