<?php

/**
 * 
 * the action of this class is identical to GetBalanceAllUser class located @ ui/api dir.
 * 
 * @author antonio
 *
 */
class BalanceAllUserAPI extends OpenAPIAbstraction{
    
    /**
     * 
     * 
     * @var ParamHolder
     */
    private $holder;
    
    public function showResults(){
        $this -> holder = $this -> getHolder();
        
        $this -> list();
    }
    
    private function list(){
        $rs = $this -> accessSelect('SELECT_USER_BALANCES_API', array());
        
        $result = [];
        
        if($this -> isLoopData($rs)) {
            // ファイルを作成する
            foreach($rs as $row) {
                
                $csv = [];
                $csv[] = $this -> getColumnData($row, COLUMN_USER_ACCOUNT);
                $csv[] = $this -> getColumnData($row, COLUMN_CURRENCY);
                $csv[] = $this -> getAmountString($this -> getColumnData($row, COLUMN_DEPOSIT_AMOUNT), $this -> getColumnData($row, COLUMN_CURRENCY));
                $csv[] = $this -> getAmountString($this -> getColumnData($row, COLUMN_WITHDRAW_AMOUNT), $this -> getColumnData($row, COLUMN_CURRENCY));
                $csv[] = $this -> getAmountString($this -> getColumnData($row, COLUMN_BALANCE), $this -> getColumnData($row, COLUMN_CURRENCY));
                
                $result[] = $csv;
            }
        }
        
        echo json_encode($result);
    }
}

