/**
 * anton
 *  
 **/
var invalidPrice = (lang == "en" ? "Invalid Price" : "不正な値です。");

$(function() {

	$('#btnAdd').click(function() {
		$('#type').val('action');
		submitForm();
	});

	$('#btnConfirm').click(function() {
		$('#type').val('confirm');
		submitForm();
	});

	$('#btnComplete').click(function() {
		$('#type').val('complete');
		submitForm();
	});

	$("#btnSearch").click(function() {
		$('#type').val('search');
		submitForm('searchForm');
	});

	$("#btnSave").click(function() {
		$('#type').val('save');
		submitForm();
	});

	$("#btnNext").click(function() {
		$('#type').val('input');
		submitForm();
	});

	$("#create_password").click(function() {
		generatePw();
	});

	$("#btnDelete").click(function(){
		actionDelete();
	});
});

function actionDelete(){
	var conftext = (lang == "en" ? "Are you sure you want to delete an API Signature Setting?" : "APIシグネチャ設定を本当に削除しますか？");
	
	var conf = confirm(conftext);
	if(conf){
		$("#type").val('delete')
		submitForm()
	}
	
}

/**
 * データ修正
 */
function actionEdit(aId) {
	$('#type').val('edit');
	$('#a_id').val(aId);
	submitForm();
}

/**
 * 検索
 */
function actionSearch() {
	$('#type').val('search');
	submitForm();
}


/**
 * 詳細表示
 */
function actionDetail(dId) {
	$('#type').val('detail');
	$('#d_id').val(dId);
	submitForm();
}

/**
 * 子エージェントの追加
 */
function addAgent() {

	// コエージェントを追加する
	$.ajax({
		type		: 'POST'
		, url		: '../api/addAgent'
		, dataType	: 'json'
		, data	: {
			'user_account'	: $('#add_code').val()
			, 'd_id'		: $('#d_id').val()
		},
		success: function(data) {

			// 結果
			if(data.result == 'OK') {
				location.reload();
			} else {
				alert(data.msg);
			}
		}
	});
}

/**
 * コミッションの計算
 */
function calcurate(ag, mst) {

	// 変数宣言部
	var rtn		= true;
	var agent	= $('#' + ag).val();
	var master	= $('#' + mst).val();
	var sp		= null;

	// エラーチェック
	if(!agent.match(/^-?[0-9]+\.[0-9]+$/)
		&& !agent.match((/^-?[0-9]+$/))) {
		alert(invalidPrice);
		rtn = false;
	}

	if(!master.match(/^-?[0-9]+\.[0-9]+$/)
		&& !master.match((/^-?[0-9]+$/))) {
		alert(invalidPrice);
		rtn = false;
	}

	if(rtn) {

		agent	= parseFloat(agent);
		master	= parseFloat(master);

		sp = ag.split('_');

		$('#' + sp[0] + '_' + sp[1] + '_total').text((agent + master) + ' %');
	}
}

/**
 * パスワードの再生成
 */
function generatePw() {

	// コエージェントを追加する
	$.ajax({
		type		: 'POST'
		, url		: '../api/GeneratePassword.php'
		, dataType	: 'json'
		, data	: {},
		success: function(data) {
			$('#password').val(data.password);
		}
		, error: function( data ) {
			console.log(data);
		}

	});
}