<?php
//银行集合
function getLocalBankAllowList()
{
    return array(
        'ABC'   => array('农业银行', 'Agricultural Bank of China', 'ABC'),
        'BJRCB' => array('北京农村商业银行', 'Beijing Rural Commercial Bank', 'BJRCB'),
        // 'BOB'   => array('北京银行', 'Bank of Beijing', 'BOB'),
        'BCCB'   => array('北京银行', 'Bank of Beijing', 'BCCB'),
        'BOC'   => array('中国银行', 'Bank of China', 'BOC'),
        'BOCOM'   => array('交通银行', 'Bank of Communications', 'BOCOM'),
        // 'BOD'   => array('东莞银行', 'Bank of Dongguan', 'BOD'),
        'BODL'   => array('大连银行', 'Bank of Dalian', 'BODL'),
        'BOS'   => array('上海银行', 'Bank of Shanghai', 'BOS'),
        // 'CBHB'  => array('渤海银行', 'China Bohai Bank', 'CBHB'),
        'CCB'   => array('建设银行', 'China Construction Bank', 'CCB'),
        'CEB'   => array('中国光大银行', 'China Everbright Bank', 'CEB'),
        'CIB'   => array('兴业银行', 'Industrial Bank', 'CIB'),
        'CITIC' => array('中信银行', 'China CITIC Bank', 'CITIC'),
        'CMB'   => array('招商银行', 'China Merchants Bank', 'CMB'),
        'CMBC'  => array('中国民生银行', 'China Minsheng Bank', 'CMBC'),
        'CQCB'  => array('重庆银行', 'Bank of Chongqing', 'CQCB'),
        // 'COMM'  => array('交通银行', 'Bank of Communications', 'COMM'),
        'CZB'   => array('浙商银行', 'China Zheshang Bank', 'CZB'),
        'GDB'   => array('广东发展银行', 'Guangdong Development Bank', 'GDB'),
        'GZCB'   => array('广州银行', 'Bank of Guangzhou', 'GZCB'),
        // 'GZB'   => array('广州银行', 'Bank of Guangzhou', 'GZB'),
        'HXB'   => array('华夏银行', 'Hua Xia Bank', 'HXB'),
        // 'HZB'   => array('杭州银行', 'Bank of Hangzhou', 'HZB'),
        'HCCB'   => array('杭州银行', 'Bank of Hangzhou', 'HCCB'),
        'ICBC'  => array('工商银行', 'Industrial and Commercial Bank of China', 'ICBC'),
        'JNB'  => array('济宁银行', 'Bank of Jining', 'JNB'),
        'JSB'  => array('江苏银行', 'Bank of Jiangsu', 'JSB'),
        'NBCB'  => array('宁波银行', 'Bank of Ningbo', 'NBCB'),
        // 'PAB'   => array('平安银行', 'Ping An Bank', 'PAB'),
        'PINAN'   => array('平安银行', 'Ping An Bank', 'PINAN'),
        'PSBC'  => array('中国邮政储蓄银行', 'Postal Savings Bank of China', 'PSBC'),
        'SDB'   => array('深圳发展银行', 'Shenzhen Development Bank', 'SDB'),
        'SPDB'  => array('上海浦东发展银行', 'Shanghai Pudong Development Bank', 'SPDB'),
        'SRCB'   => array('上海农村商业银行', 'Shanghai Rural Commercial Bank', 'SRCB'),
        'TCCB'   => array('天津银行', 'Bank of Tianjin', 'TCCB'),
        'TZB'   => array('台州银行', 'Bank of Taizhou', 'TZB'),
        'XMCCB'   => array('厦门银行', 'Xiamen Bank', 'XMCCB'),
        'ZJTLCB'   => array('浙江泰隆商业银行', 'Zhejiang Tailong Commercial Bank', 'ZJTLCB'),
    );
}

function getProvinceCityData() { //for SDPay
    return json_decode(file_get_contents(__DIR__.'/sdAreaList.txt'), true);
}

function getH2PBankAllowList($country){
    $rtn = "";
    if($country == 'ID'){
        $rtn = array(
            'BCA'   => array('Bank Central Asia', 'BCA'),
            'BNI'   => array('Bank Negara Indonesia', 'BNI'),
            'MDR'   => array('Bank Mandiri', 'MDR'),
            'BRI'   => array('Bank Rakyat Indonesia', 'BRI'),
            'CIMBN' => array('CIMB Niaga', 'CIMBN'),
            'CITI' => array('CITI Bank', 'CITI'),
        );
    }else if($country == 'MY'){
        $rtn = array(
             'AFF'   => array('Affin Bank', 'AFF'),
             'ALB'   => array('Alliance Bank', 'ALB'),
             'AMB'   => array('AM Bank', 'AMB'),
             'BSN'   => array('Bank Simpanan National', 'BSN'),
             'CIMB'  => array('CIMB Bank', 'CIMB'),
             'CITI'  => array('Citi bank', 'CITI'),
             'HLB'   => array('Hong Leong Bank', 'HLB'),
             'HSBC'  => array('HSBC Bank', 'HSBC'),
             'MBB'   => array('Maybank', 'MBB'),
             'OCBC'  => array('OCBC Bank', 'OCBC'),
             'PBB'   => array('Public Bank', 'PBB'),
             'RHB'   => array('RHB Bank', 'RHB'),
             'UOB'   => array('UOB Bank', 'UOB'),
             'SCTB'  => array('Standard Chartered Bank', 'SCTB'),
             'BIMB'  => array('Bank Islam Malaysia', 'BIMB'),
        );
    }else if($country == 'TH'){
        $rtn = array(
             'BBL'    => array('Bangkok Bank', 'BBL'),
             'BOA'    => array('Bank Of Ayudhya', 'BOA'),
             'GSB'    => array('Government Savings Bank', 'GSB'),
             'KKR'    => array('KasiKorn Bank', 'KKR'),
             'KTB'    => array('KTB Net Bank', 'KTB'),
             'SCB'    => array('Siam Commercial Bank', 'SCB'),
             'TMB'    => array('TMB Bank Public Company Limited', 'TMB'),
             'CIMBT'  => array('CIMB Thai', 'CIMBT'),
             'KNK'    => array('Kiatnakin Bank', 'KNK'),
        );
    }else if($country == 'VN'){
        $rtn = array(
            'ACB'   => array('Asia Commercial Bank', 'ACB'),
            'DAB'   => array('DongA Joint Stock Commercial Bank', 'DAB'),
            'SACOM' => array('Sacom Bank', 'SACOM'),
            'TCB'   => array('Techcom Bank', 'TCB'),
            'VCB'   => array('Vietcom Bank', 'VCB'),
            'VTB'   => array('Vietin Bank', 'VTB'),
            'EXIM'  => array('Eximbank Vietnam', 'EXIM'),
            'BIDV'  => array('Bank for Investment and Development of Vietnam', 'BIDV'),
            'SCMB'  => array('SAIGON Bank', 'SCMB'),
            'VIB'   => array('Vietnam International Bank', 'VIB'),
            'AGB'   => array('Agribank', 'AGB'),
        );
    }

    return $rtn;
}

//提交api请求数据
function getApiXml()
{
    return ('<TransferInfomation><Id>__MEGELM01__</Id><IntoAccount>__MEGELM02__</IntoAccount><IntoName>__MEGELM03__</IntoName><IntoBank1>__MEGELM04__</IntoBank1><IntoBank2>__MEGELM05__</IntoBank2><IntoAmount>__MEGELM06__</IntoAmount><SerialNumber>__MEGELM07__</SerialNumber></TransferInfomation>');
}
//存储是live环境还是test环境(数组第一个数 为 0 则为显示，为 1 则为隐藏)
function getOouMoney(){

    return array(

        'H2P' => array('0','H2P','<li class ="newtag"><a href="#" style=" float:left;" class = "h2p_btnNext" ><img src="../img/local_bank.png"><input type="text" id="withdraw_h2p_type" value="0" class="btn bg-grad px80" style="display: none;"></a>','en_id'),

        'Flat3' => array('0','Flat3','<li><a href="#" style=" float:left;" class = "flat3_btnNext" ><img src="../img/local_bank.png"><input type="text" id="withdraw_flat3_type" value="0" class="btn bg-grad px80" style="display: none;"></a>','en_ja'),

        // 'SDPay' => array('0','SDPay','<li><a href="#" style=" float:left;"  class = "local_btnNext" ><img src="../img/local_bank.png"><input type="text" id="withdraw_local_type" value="0" class="btn bg-grad px80" style="display: none;"></a>','en_tc_sc'),

        // 'International' => array('0','International','<li><a href="#" style=" float:left;" class = "btnNext" ><img src="../img/int_bank.png"><input type="text" id="withdraw_type" value="0" class="btn bg-grad px80" style="display: none;"></a>','en_tc_sc_ja_id')

    );
}

function getOutMoney(){

    return array(

        'H2P' => array('0','H2P','<li class ="newtag"><a href="#" style=" float:left;" class = "h2p_btnNext" ><img src="../img/local_bank.png"><input type="text" id="withdraw_h2p_type" value="0" class="btn bg-grad px80" style="display: none;"></a>','en_id'),

        'Flat3' => array('0','Flat3','<li><a href="#" style=" float:left;" class = "flat3_btnNext" ><img src="../img/local_bank.png"><input type="text" id="withdraw_flat3_type" value="0" class="btn bg-grad px80" style="display: none;"></a>','en_ja'),

        // 'SDPay' => array('0','SDPay','<li><a href="#" style=" float:left;"  class = "local_btnNext" ><img src="../img/local_bank.png"><input type="text" id="withdraw_local_type" value="0" class="btn bg-grad px80" style="display: none;"></a>','en_tc_sc'),

        'International' => array('0','International','<li><a href="#" style=" float:left;" class = "btnNext" ><img src="../img/int_bank.png"><input type="text" id="withdraw_type" value="0" class="btn bg-grad px80" style="display: none;"></a>','en_tc_sc_ja_id')

    );
}


//提取不同语言的文言
function getOutLanguage($address){
    $list = array(

        //英文文言
        'en_International'  =>  '<span class="logofee1"><a href="javascript:void(0)" style=" float:left;" class = "btnNext" ><h4>International Bank Transfer</h4></a><br></li>',
        'en_Flat3'  =>  '<span class="logofee1"><a href="javascript:void(0)" style=" float:left;" class = "flat3_btnNext" ><h4>Transfer Agency Service (Japan)</h4></a><br><span class="grey">0.50% (Minimum USD 35.00) per transaction</span><br><span class="red" style="color:red;">*Only available for members in Japan</span></span></li>',
        // 'en_SDPay'  =>  '<span class="logofee1"><a href="javascript:void(0)" style=" float:left;"  class = "local_btnNext" ><h4>Local Bank Transfer (China)</h4></a><br><span class="grey">1.5% per withdrawal</span><br><span class="red" style="color:red;">*Only available for members in China</span></span></li>',
        'en_H2P'  =>  '<span class="logofee1"><a href="javascript:void(0)" style=" float:left;"  class = "h2p_btnNext" ><h4>Local Bank Transfer (Southeast Asia)</h4></a><br><span class="grey">2.00% (Minimum VND 300,000.00/THB 500.00/IDR 200,000.00/MYR 50.00) per transaction</span><br><span class="red" style="color:red;">*Only available for members in Vietnam, Thailand, Malaysia, and Indonesia</span></span></li>',

        //简体中文文言
        'sc_International'  => '<span class="logofee1"><a href="javascript:void(0)" style=" float:left;" class = "btnNext" ><h4>国际银行转账</h4></a><br></li>',
        // 'sc_SDPay'  => '<span class="logofee1"><a href="javascript:void(0)" style=" float:left;"  class = "local_btnNext" ><h4>转账至本地银行（中国）</h4></a><br><span class="grey"">每笔转出金额的1.5%</span><br><span class="red" style="color:red;">*仅限中国会员</span></span>',

        //繁体中文文言
        'tc_International'  => '<span class="logofee1"><a href="javascript:void(0)" style=" float:left;" class = "btnNext" ><h4>國際銀行轉賬</h4></a><br><span class="grey"></li>',
        // 'tc_SDPay'  => '<span class="logofee1"><a href="javascript:void(0)" style=" float:left;"  class = "local_btnNext" ><h4>轉賬至本地銀行（中國）</h4></a><br><span class="grey">每筆轉出金額的1.5%</span><br><span class="red" style="color:red;">*僅限中國會員</span></span></li>',

        //日语文言
        'ja_International'  => '<span class="logofee1"><a href="javascript:void(0)" style=" float:left;" class = "btnNext" ><h4>国際銀行振込</h4></a><br><span class="grey"></span></span></li>',
        'ja_Flat3'  =>  '<span class="logofee1"><a href="javascript:void(0)" style=" float:left;" class = "flat3_btnNext" ><h4>収納代行サービス（日本）</h4></a><br><span class="grey">取引1回あたり0.50%（最小 35.00USD）</span><br><span class="red" style="color:red;">*日本にお住いのお客様のみご利用いただけます。</span></span></li>',

        'id_International' => '<span class="logofee1"><a href="javascript:void(0)" style=" float:left;" class = "btnNext" ><h4>Transfer Bank Internasional</h4></a><br></li>',
        'id_H2P'  =>  '<span class="logofee1"><a href="javascript:void(0)" style=" float:left;"  class = "h2p_btnNext" ><h4>Transfer Bank Lokal (Asia Tenggara)</h4></a><br><span class="grey">2,00% (Minimum VND 300.000,00/THB 500,00/IDR 200.000,00/MYR 50,00) per transaksi</span><br><span class="red" style="color:red;">*Hanya Tersedia untuk anggota di Vietnam, Thailand, Malaysia dan Indonesia</span></span></li>',
    );
    return $list[$address];
}

//提取不同备注
function getLanguageMessage($lang){

    $list =  array(
        'en' => 'Local Bank Transfer (China)',
        'sc' => '转账至本地银行（中国）',
        'tc' => '轉賬至本地銀行（中國）'
    );

    return $list[$lang];
}

function getLimitedAccount($param){

    $rtn =  array(
        'iwloptiuser001@gmail.com'     =>   '55746607',
        'lovy.iwallet@gmail.com'       =>   '85823926',
        'lovytestmujertest@gmail.com'  =>   '45175293',
        'mio.fan@zoho.com'             =>   '48751860',
        'bylgia@vip.qq.com'            =>   '37812073',
        'chuankoala@163.com'            =>  '94101762',
        'dev2017test@163.com'          =>   '13782355'
    );
    return in_array($param,$rtn);
}

//return the beneficiary address text based on language
function getAddressText($lang){

    $textArray = array(
        'en' => array('Beneficiary Address', 'Bank Address'),
        'id' => array('Alamat Penerima', 'Alamat Bank'),
        'ja' => array('受取人住所', '銀行住所'),
        'sc' => array('收款方地址', '收款行地址'),
        'tc' => array('收款方地址', '收款銀行地址')
    );

    return $textArray[$lang];
}

//set type confirm, type complete and type back based on money out solution
function setWithdrawalType(){
    $typeArray = array();

    //set defaults
    $typeArray["Confirm"]  = null;
    $typeArray["Complete"] = null;
    $typeArray["Back"]     = null;

    if(isset($_SESSION['moneyoutSolution'])){
        switch($_SESSION['moneyoutSolution']){
            case 'Flat3':
                $typeArray["Confirm"]  = TYPE_FLAT3_CONFIRM;
                $typeArray["Complete"] = TYPE_FLAT3_COMPLETE;
                $typeArray["Back"]     = TYPE_FLAT3_BACK;
                break;
            case 'International':
                $typeArray["Confirm"]  = TYPE_CONFIRM;
                $typeArray["Complete"] = TYPE_COMPLETE;
                $typeArray["Back"]     = TYPE_BACK;
                break;
            default:
                $typeArray["Confirm"]  = NO_STRING;
                $typeArray["Complete"] = NO_STRING;
                $typeArray["Back"]     = NO_STRING;
        }
    }

    return $typeArray;
}


function getFlat3BankList(){
    return array(
        '9900'  => 'ゆうちょ銀行',
        '0177'  => '福岡銀行',
        '0038'  => '住信ＳＢＩネット銀行',
        '0036'  => '楽天銀行',
        '0035'  => 'ソニー銀行',
        '0033'  => 'PayPay銀行',
        '0017'  => '埼玉りそな銀行',
        '0010'  => 'りそな銀行',
        '0009'  => '三井住友銀行',
        '0005'  => '三菱ＵＦＪ銀行',
        '0001'  => 'みずほ銀行',
        '0041'  => '大和ネクスト銀行',
        '0123'  => '岩手銀行'
    );
}
