<?php
class HistoryModelClass extends ModelClassEx {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $rs				= null;			// 出金リスト
	private $balance		= null;			// バランス
	private $currency		= NO_STRING;	// 通貨
	private $from			= NO_STRING;	// 期間開始
	private $to				= NO_STRING;	// 期間終了
    private $accountType	= NO_STRING;	// account type attribute (string). created by joshua dino
    
    private $total          = NO_STRING;
    private $page           = NO_STRING;
    private $totalPage      = NO_STRING;

	/*-------------------------------------------------------------------------
	* @function_name: コントロールパネルシステムindexモデルクラスコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		// スーパークラスコンストラクタ呼び出し
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 初期設定関数
	* @parameter	: なし
	* @return		: 成功:success、失敗:error
	-------------------------------------------------------------------------*/
	public function init() {

		try {

			// パラメータの設定
			$this -> setParameter();

			// チェック
			$this -> validate();

		} catch (Exception $e) {
			throw new Exception(NO_STRING);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: パラメータの設定
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function setParameter() {


		// GETがあったら、GETを入れる
		if($this -> getDataGet(PARAM_CURRENCY) != NO_STRING) {
			$this -> currency	= $this -> getDataGet(PARAM_CURRENCY, true);
		}

		// POSTがあったら、POSTを優先
		if($this -> getDataPost(PARAM_CURRENCY) != NO_STRING) {
			$this -> currency	= $this -> getDataPost(PARAM_CURRENCY, true);
		}

		// 通貨データがなければ、デフォルト値（USD）
		if($this -> currency == NO_STRING) {
			$this -> currency = USD;
		}
		
		$this -> page = empty($this -> getDataPost("page")) ? 1 : $this -> getDataPost("page");

		// Fromの日付は確定させないとダメ
		if($this -> getDataPost(PARAM_FROM) == NO_STRING) {
			// $this -> from = date('Y/m/1', strtotime('-1 month'));
			$this -> from = date('Y/m/d', strtotime('-1 month'));
		} else {
			$this -> from		= $this -> getDataPost(PARAM_FROM, true);
		}

		$this -> to			 = $this -> getDataPost(PARAM_TO, true);
        $this -> accountType = $this -> getColumnData($this -> getRowData($this -> getAccountCommon($this -> getUserData(PARAM_USER_ACCOUNT))), COLUMN_ACCOUNT_TYPE);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 検索条件の取得
	* @parameter	: なし
	* @return		: 検索条件
	-------------------------------------------------------------------------*/
	private function getWhere() {

		// 変数宣言部
		$params	= array();
		$rtn	= NO_STRING;

		// 通貨指定
		if($this -> currency != NO_STRING) {
			$params[] = ' (trans.deposit_currency = (\')' . $this -> currency . '(\') OR trans.withdraw_currency = (\')' . $this -> currency . '(\') OR trans.transfer_currency = (\')' . $this -> currency . '(\'))';
		}

		// 日付指定(from)
		if($this -> from != NO_STRING) {
			$params[] = ' transaction_time >= (\')' . $this -> from . '(\')';
		}

		// 日付指定(to)
		if($this -> to != NO_STRING) {
			$params[] = ' transaction_time < DATE_ADD((\')' . $this -> to . '(\'), INTERVAL 1 DAY)';
		}

		// データが存在した場合
		if($this -> isLoopData($params)) {
			$rtn = DELIMIT_AND . implode(DELIMIT_AND, $params);
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: サーバ側データチェック
	* @parameter	: なし
	* @return		: TRUE:成功、FALSE:失敗
	-------------------------------------------------------------------------*/
	public function validate() {
		// ログインチェック
		if(!$this -> checkSiteUserLogin()) {
			throw new Exception(NO_STRING);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function dispHTML() {
		return array();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 表示用データを取得
	* @parameter	: なし
	* @return		: 表示用データ
	-------------------------------------------------------------------------*/
	public function getUserAccountData() {

		// 変数宣言部
		$rtn = array();

		$rtn[] = $this -> getUserData(PARAM_USER_ACCOUNT);	// ユーザアカウント
		$rtn[] = $this -> currency;
		$rtn[] = $this -> getWhere();						// 検索条件
		$rtn[] = NO_STRING;

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 表示用データを取得（バランス取得用）
	* @parameter	: なし
	* @return		: 表示用データ
	-------------------------------------------------------------------------*/
	public function getBalanceParams() {

		// 変数宣言部
		$rtn = array();

		$rtn[] = $this -> getUserData(PARAM_USER_ACCOUNT);	// ユーザアカウント
		$rtn[] = $this -> currency;							// 通貨
		$rtn[] = $this -> from;								// 以前までのバランス

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function echoList() {

		// 変数宣言部
		$rtn				= NO_STRING;
		$tType				= NO_STRING;
		$wAmount			= NO_STRING;
		$dAmount			= NO_STRING;
		$currency			= NO_STRING;
		$total				= NO_COUNT;
		$balanceCurrency	= NO_STRING;
		$dispTotal			= NO_STRING;
		$account			= NO_STRING;
		$accountName		= NO_STRING;
		$no					= NO_COUNT;
		$thousand			= NO_STRING;
        $data               = NO_STRING; //string variable for export data -  added by Joshua Dino 04/23/2018

		// 残高通貨の指定
		if($this -> currency == NO_STRING) {
			$balanceCurrency = USD;
		} else {
			$balanceCurrency = $this -> currency;
		}

		if($this -> isLoopData($this -> rs)) {

			// THOUSAND対応
			$thousand = $this -> getRowData($this -> getAccountCommon('65373403'));

			// バランスの追加
			$rtn = '<tr>';

			if($this -> isLoopData($this -> balance)) {
				$row	= $this -> getRowData($this -> balance);
				$total	= $this -> intToCurrency($this -> getColumnData($row, COLUMN_BALANCE), $this -> currency);

				$rtn .= '<td colspan="12" class="c">' . $this -> getMessage(INFO, 'I_BEFORE_BALANCE', array()) . '</td><td class="r">' . $this -> currency . DELIMIT_SPACE . $this -> formatCurrency($total, $this -> currency) . '</td>';
			} else {

				$total	= NO_COUNT;
				$rtn .= '<td colspan="12" class="c">' . $this -> getMessage(INFO, 'I_BEFORE_BALANCE', array()) . '</td><td class="r">' . $this -> currency . DELIMIT_SPACE . $this -> formatCurrency($total, $this -> currency) . '</td>';
			}

			$rtn .= '</tr>';

			$pageRowCount = $this -> page * $this -> getHistoryDefaultLimitCount();
			
			if($this -> page == $this -> totalPage)
			    $pageRowCount = $this -> total;
			
			$no      = $pageRowCount;
            $counter = $no; //counter for id number - added by Joshua Dino 04/23/2018

            $this -> rs = array_reverse($this -> rs, true);
            
			// データの数だけループを回す
			foreach($this -> rs as $row) {
				// 初期化
				$tType			= NO_STRING;
				$wAmount		= NO_STRING;
				$dAmount		= NO_STRING;
				$dStatus		= NO_STRING;
				$fee			= NO_STRING;
				$account		= NO_STRING;
				$accountName	= NO_STRING;

				//***************************set values*******************************//
				if(intval($this -> getColumnData($row, COLUMN_ACCOUNT_NUMBER)) > NO_COUNT) {
					$account		= $this -> getColumnData($row, COLUMN_ACCOUNT_NUMBER);
				} else {
					$account		= NO_STRING;
				}

				if($account == '65373403') {
					$accountName = $this -> getColumnData($thousand, COLUMN_SITE_NAME);
				} else {
					$accountName = $this -> getColumnData($row, COLUMN_ACCOUNT_NAME);
				}

				$currency = $this -> getColumnData($row, COLUMN_CURRENCY);
				$dAmount	= $currency . DELIMIT_SPACE . $this -> formatCurrency($this -> getColumnData($row, COLUMN_DEPOSIT_AMOUNT), $currency);
				$wAmount	= $currency . DELIMIT_SPACE . $this -> formatCurrency($this -> getColumnData($row, COLUMN_WITHDRAW_AMOUNT), $currency);
				$fee		= $this -> formatCurrency($this -> getColumnData($row, COLUMN_FEE), $currency);
				$total = $this -> getColumnData($row, COLUMN_BALANCE);
				//***************************************************************//

				// if($this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)			== VAL_INT_1
				// 	|| $this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)		== VAL_INT_3
				// 	|| $this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)		== VAL_INT_6
				// 	|| $this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)		== VAL_INT_8
				// 	|| $this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)		== VAL_INT_9
				// 	|| $this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)		== VAL_INT_10) {		// 入金時
				//
				// 	$currency	= $this -> getColumnData($row, COLUMN_DEPOSIT_CURRENCY);
				// 	$dAmount	= $this -> intToCurrency($this -> getColumnData($row, COLUMN_DEPOSIT_AMOUNT), $currency);
				// 	$fee		= $this -> getAmountString($this -> getColumnData($row, COLUMN_DEPOSIT_FEE), $currency);
				//
				// 	// 出金額があった場合
				// 	if(intval($this -> getColumnData($row, COLUMN_WITHDRAW_AMOUNT)) > NO_COUNT) {
				// 		$wAmount	= $this -> intToCurrency($this -> getColumnData($row, COLUMN_WITHDRAW_AMOUNT), $currency);
				// 		$total		-= $wAmount;																				// 出金額
				// 		$wAmount	= $currency . DELIMIT_SPACE .  $this -> formatCurrency($wAmount, $currency);
				// 	}
				//
				// 	$total		+= $dAmount;																					// 入金額
				// 	$total		-= $this -> intToCurrency($this -> getColumnData($row, COLUMN_DEPOSIT_FEE), $currency);			// 手数料
				//
				// 	$dAmount	= $currency . DELIMIT_SPACE .  $this -> formatCurrency($dAmount, $currency);
				//
				// 	if(intval($this -> getColumnData($row, COLUMN_WITHDRAW_ACCOUNT_NUMBER)) > NO_COUNT) {
				// 		$account	= $this -> getColumnData($row, COLUMN_WITHDRAW_ACCOUNT_NUMBER);
				//
				// 	}
				//
				// 	if($account == '65373403') {
				// 		$accountName = $this -> getColumnData($thousand, COLUMN_SITE_NAME);
				// 	} else {
				// 		$accountName = $this -> getColumnData($row, COLUMN_WITHDRAW_ACCOUNT_NAME);
				// 	}
				//
				// } else if($this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)		== VAL_INT_2
				// 	|| $this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)		== VAL_INT_4
				// 	|| $this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)		== VAL_INT_5
				// 	|| $this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)		== VAL_INT_7
				// 	|| $this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)		== VAL_INT_11
				// 	|| $this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)		== VAL_INT_12) {		// 出金時
				//
				// 	$currency	= $this -> getColumnData($row, COLUMN_WITHDRAW_CURRENCY);
				// 	$wAmount	= $this -> intToCurrency($this -> getColumnData($row, COLUMN_WITHDRAW_AMOUNT), $currency);
				// 	$fee		= $this -> getAmountString($this -> getColumnData($row, COLUMN_WITHDRAW_FEE), $currency);
				//
				// 	// 入金額があった場合
				// 	if(intval($this -> getColumnData($row, COLUMN_DEPOSIT_AMOUNT)) > NO_COUNT) {
				// 		$dAmount	= $this -> intToCurrency($this -> getColumnData($row, COLUMN_DEPOSIT_AMOUNT), $currency);
				// 		$total		+= $dAmount;																				// 出金額
				// 		$dAmount	= $currency . DELIMIT_SPACE .  $this -> formatCurrency($dAmount, $currency);
				// 	}
				//
				// 	$total		-= $wAmount;																					// 出金額
				// 	$total		-= $this -> intToCurrency($this -> getColumnData($row, COLUMN_WITHDRAW_FEE), $currency);		// 手数料
				//
				// 	$wAmount	= $currency . DELIMIT_SPACE .  $this -> formatCurrency($wAmount, $currency);
				//
				// 	if(intval($this -> getColumnData($row, COLUMN_DEPOSIT_ACCOUNT_NUMBER)) > NO_COUNT) {
				// 		$account	= $this -> getColumnData($row, COLUMN_DEPOSIT_ACCOUNT_NUMBER);
				// 	}
				//
				// 	if($account == '65373403') {
				// 		$accountName = $this -> getColumnData($thousand, COLUMN_SITE_NAME);
				// 	} else {
				// 		$accountName = $this -> getColumnData($row, COLUMN_DEPOSIT_ACCOUNT_NAME);
				// 	}
				// }

				// 処理種別
				if($this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)		== VAL_INT_1) {						// 入金
					$tType 		= VAL_STR_DEPOSIT;
					$dStatus	= VAL_STR_STATUS_COMP;

				} else if($this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)	== VAL_INT_2
							&& $this -> getColumnData($row, COLUMN_TYPE)		== VAR_WITHDRAW_TYPE_NORMAL) {		// 通常出金

					$tType		= VAL_STR_WITHDARAW . '（' . $this -> dispWithdrawStatusCommon($this -> getColumnData($row, COLUMN_STATUS)) . '）';
					$dStatus	= $this -> dispWithdrawStatusCommon($this -> getColumnData($row, COLUMN_STATUS));

				} else if($this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)	== VAL_INT_2
							&& $this -> getColumnData($row, COLUMN_TYPE)		== VAR_WITHDRAW_TYPE_FEE) {			// 手数料出金
					$tType					= VAL_STR_FEE;
					$dStatus				= VAL_STR_STATUS_COMP;
					$row[COLUMN_MESSAGE]	= VAL_STR_MONTHLY_FEE;

				} else if($this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)	== VAL_INT_2
					&& $this -> getColumnData($row, COLUMN_TYPE)		== VAR_WITHDRAW_TYPE_TRANSFER) {			// 出金（カード出金）
					$tType		= VAL_STR_CARD_DEPOSIT;
					$dStatus	= VAL_STR_STATUS_COMP;

				} else if($this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)	== VAL_INT_3) {						// 両替入金

					$tType		= VAL_STR_EXCHANGE;
					$dStatus	= VAL_STR_STATUS_COMP;

				} else if($this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)	== VAL_INT_4) {						// 両替出金

					$tType		= VAL_STR_EXCHANGE;
					$dStatus	= VAL_STR_STATUS_COMP;

				} else if($this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)	== VAL_INT_5) {						// 口座振替（出金）

					$tType 		= VAL_STR_TRANSFER;
					$dStatus	= VAL_STR_STATUS_COMP;

				} else if($this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)	== VAL_INT_6) {						// 口座振替（出金）

					$tType 		= VAL_STR_TRANSFER;
					$dStatus	= VAL_STR_STATUS_COMP;

				} else if($this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)	== VAL_INT_7) {						// 引落（出金）

					$tType 		= VAL_STR_REQUEST;
					$dStatus	= VAL_STR_STATUS_COMP;

				} else if($this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)	== VAL_INT_8) {						// 引落（入金）

					$tType 		= VAL_STR_REQUEST;
					$dStatus	= VAL_STR_STATUS_COMP;
				}  else if($this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)	== VAL_INT_11 && $this -> getColumnData($row, COLUMN_STATUS) == VAL_INT_2) {

					$tType					= VAL_STR_FEE;
					$dStatus				= VAL_STR_STATUS_COMP;
					$row[COLUMN_MESSAGE]	= VAL_STR_DOMANT_FEE;
				}  else if($this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)	== VAL_INT_9
							|| $this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)	== VAL_INT_10
							|| $this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)	== VAL_INT_11
							|| $this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)	== VAL_INT_12) {			// 出金（返却系）

					$tType 		= VAL_STR_WITHDARAW . '（' . $this -> dispWithdrawStatusCommon($this -> getColumnData($row, COLUMN_STATUS)) . '）';
					$dStatus	= VAL_STR_STATUS_COMP;

				} else {
					$tType = NO_STRING;
				}

				//change $total into 2 decimal format
				$total = round($total,2);

				// 通貨を指定していなければ、非表示
				if($this -> currency == NO_STRING) {
					$dispTotal = '&nbsp;';
				} else {
					$dispTotal = $balanceCurrency . ' ' . $this -> formatCurrency($total, $this -> currency);
				}

				$rtn	= '<tr>'
							. '<td class="c">' . $no-- . '</td>'
							. '<td class="c break">' . $tType . '</td>'
							. '<td class="c">' . $account . '</td>'
							. '<td class="l break">' . $accountName . '</td>'
							. '<td class="r">' . $dAmount . '</td>'
							. '<td class="r">' . $wAmount . '</td>'
							. '<td class="r">' . $currency . DELIMIT_SPACE . $fee . '</td>'
							. '<td>' . $this -> getColumnData($row, COLUMN_TRANSACTION_TIME_STRING) . '</td>'
							. '<td>' . $this -> getColumnData($row, COLUMN_PROCESS_TIME_STRINTG) . '</td>'
							. '<td class="c">' . $this -> getColumnData($row, COLUMN_TRANSACTION_NUMBER) . '</td>'
							. '<td class="l break">' . $this -> getColumnData($row, COLUMN_MESSAGE) . '</td>'
							. '<td class="c break">' . $dStatus . '</td>'
							. '<td class="r">' . $dispTotal . '</td>'
							. '</tr>'
							. $rtn;
			}

		} else {
			$rtn = '<tr><td colspan="13">' . $this -> getMessage(INFO, 'I_NO_SUCHE_SEARCH_DATA', array()) . '</td></tr>';
		}

        //add checker if the type of input is export_common
        if($this -> getType() == TYPE_EXPORT_COMMON) {	// エクスポート(共通)
            return $data;
        } else {
            echo $rtn;
        }
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 通貨の取得
	 * @parameter	: なし
	 * @return		: 通貨
	 -------------------------------------------------------------------------*/
	function echoCurrency() {
		echo $this -> currency;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 期間開始の取得
	 * @parameter	: なし
	 * @return		: 既刊会誌
	 -------------------------------------------------------------------------*/
	function getFrom() {
		return $this -> from;
	}
	
	function getPage(){
	    return $this -> page;
	}
	
	function getCurrency(){
	    return $this -> currency;
	}
	
	function getHistoryDefaultLimitCount(){
	    return VAL_INT_20;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 期間開始の取得
	* @parameter	: なし
	* @return		: 既刊会誌
	-------------------------------------------------------------------------*/
	function echoFrom() {
		echo $this -> from;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 期間終了の取得
	 * @parameter	: なし
	 * @return		: 期間終了
	 -------------------------------------------------------------------------*/
	function echoTo() {
		echo $this -> to;
	}
	
	/*-------------------------------------------------------------------------
	 * @function_name: 期間終了の取得
	 * @parameter	: なし
	 * @return		: 期間終了
	 -------------------------------------------------------------------------*/
	function echoTotal() {
	    echo $this -> total;
	}
	
	function echoTotalPage(){
	    echo $this -> totalPage;
	}
	
	function echoPage(){
	    echo $this -> page;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 通貨一覧の取得
	 * @parameter	: なし
	 * @return		: 通貨一覧
	 -------------------------------------------------------------------------*/
	public function echoCurrencyList() {
		echo $this -> dispCurrencyOptionList($this -> currency, false);
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 出金リストの設定
	 * @parameter	: 出金リスト
	 * @return		: なし
	 -------------------------------------------------------------------------*/
	public function setResult($rs) {
		$this -> rs = $rs;
	}
	
	/*-------------------------------------------------------------------------
	 * @function_name: 全額の設定
	 * @parameter	: 全額
	 * @return		: なし
	 -------------------------------------------------------------------------*/
	public function setTotal($total) {
	    $this -> total = $total;
	}
	
	public function setTotalPage($totalPage) {
	    $this -> totalPage = $totalPage;
	}
	
	public function setPage($page){
	    $this -> page = page;
	}

	/*-------------------------------------------------------------------------
	* @function_name: バランスの設定
	* @parameter	: バランス
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function setBalance($rs) {
		$this -> balance = $rs;
	}

    /*-------------------------------------------------------------------------
	* @function_name: getAccountType
	* @parameter	:
	* @return		: string
	-------------------------------------------------------------------------*/
	public function getAccountType() {
		return $this -> accountType;
	}
	
	public function echoJavascriptLabels(){
	    $labels = [
	        "progressIndicator" => VAL_STR_LOADING_TRANSACTIONS,
	        "internalTransfer" => VAL_STR_TRANSFER,
	        "internalTransferTrash" => VAL_STR_TRANSFER_TRASH,
	        "depositIndicator" => VAL_STR_DEPOSIT,
	        "exchangeIndicator" => VAL_STR_EXCHANGE,
	        "requestIndicator" => VAL_STR_REQUEST,
	        "withdrawIndicator" => VAL_STR_WITHDARAW,
	        "feeIndicator" => VAL_STR_FEE,
	        "noResultsFound" => $this -> getMessage(INFO, 'I_NO_SUCHE_SEARCH_DATA', array()),
	        "dormantFeeIndicator" => VAL_STR_DOMANT_FEE,
	        "monthlyFeeIndicator" => VAL_STR_MONTHLY_FEE,
	        "cardDepositIndicator" => VAL_STR_CARD_DEPOSIT,
	        
	        "headId" => VAL_STR_HEADER_ID,
	        "headTransactionType" => VAL_STR_HEADER_TRANSACTION_TYPE,
	        "headUserAccount" => VAL_STR_USER_ACCOUNT,
	        "headUserAccountName" => VAL_STR_HEADER_ACCOUNT_NAME,
	        "headMoneyIn" => VAL_STR_HEADER_MONEY_IN,
	        "headMoneyOut" => VAL_STR_HEADER_MONEY_OUT,
	        "headCurrency" => VAL_STR_CURRENCY,
	        "headFee" => VAL_STR_FEE,
	        "headSubmissionRequested" => VAL_STR_HEADER_SUBMISSION_DATE,
	        "headOperationDate" => VAL_STR_HEADER_OPERATION_DATE,
	        "headReferenceNumber" => VAL_STR_HEADER_REF_NO,
	        "headMessage" => VAL_STR_MESSAGE,
	        "headStatus" => VAL_STR_STATUS,
	        "headBalance" => VAL_STR_HEADER_BALANCE,
	        
	        "statusApply" => VAL_STR_APPLY,
	        "statusRemittanceAccepted" => VAL_STR_REMITTANCE_ACCEPTED,
	        "statusRemittanceAlready" => VAL_STR_REMITTANCE_ALREADY,
	        "statusDeficiencyChecking" => VAL_STR_DEFICIENCIES_CHECKING,
	        "statusRefund" => VAL_STR_REFUND,
	        "statusCancellation" => VAL_STR_CANCELLATION,
	        "statusCancel" => VAL_STR_CANCEL,
	        "statusComplete" => VAL_STR_STATUS_COMP
	    ];
	    
	    $labelBuilder = NO_STRING;
	    
	    foreach($labels as $key => $label){
	        $labelBuilder .= "\t<input type=\"hidden\" id=\"{$key}\" value=\"{$label}\"/>\n";
	    }
	    
	    echo <<<HTMLSTRING
            <span class="hidediv js-labels">
                {$labelBuilder}
            </span>
HTMLSTRING;
	}
}

?>