<?php
class TransactionModelClass extends ModelClassEx {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $rs							= null;			// 出金リスト
	private $total						= NO_COUNT;		// リスト総合計

	// ------------------ 検索系 ------------------//
	private $sTransactionNumber 		= NO_STRING;	// 取引番号
	private $sFrom						= NO_COUNT;		// 登録時刻（開始日）（検索項目）
	private $sTo						= NO_COUNT;		// 登録時刻（終了）（検索項目）
	private $sCurrency					= NO_COUNT;		// 通貨（検索項目）
	private $sMinAmount					= NO_COUNT;		// 送金額（最少）（検索項目）
	private $sMaxAmount					= NO_COUNT;		// 送金額（最大）（検索項目）
	private $sType						= NO_COUNT;		// 取引タイプ（検索項目）
	private $sWithdrawAccountName		= NO_COUNT;		// 出金口座名義（検索項目）
	private $sWithdrawAccountNumber		= NO_COUNT;		// 出金口座番号（検索項目）
	private $sDepositAccountName		= NO_COUNT;		// 入金口座名義（検索項目）
	private $sDepositAccountNumber		= NO_COUNT;		// 入金口座番号（検索項目）
	private $sAgent						= NO_COUNT;		// エージェント（検索項目）
	private $statuses					= NO_STRING;	// 処理タイプ
	private $sProcessFlg 				= NO_STRING;

	/**
	 *
	 * anton
	 *
	 */
	public $lang						= NO_STRING;
	// ------------------ 検索系 ------------------//

	/*-------------------------------------------------------------------------
	* @function_name: コントロールパネルシステムindexモデルクラスコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		// スーパークラスコンストラクタ呼び出し
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 初期設定関数
	* @parameter	: なし
	* @return		: 成功:success、失敗:error
	-------------------------------------------------------------------------*/
	public function init() {

		try {

			// パラメータの設定
			$this -> setParameter();

			// チェック
			return $this -> validate();

		} catch (Exception $e) {
			throw new Exception(NO_STRING);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: パラメータの設定
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function setParameter() {

		// ------------------ 検索系 ------------------//
		$this -> sTransactionNumber		= $this -> getDataPost(PARAM_TRANSACTION_NUMBER); 			// 取引番号
		$this -> sFrom					= $this -> getDataPost(PARAM_S_FROM);						// 登録時刻（開始日）（検索項目）
		$this -> sTo					= $this -> getDataPost(PARAM_S_TO);							// 登録時刻（終了）（検索項目）
		$this -> sCurrency				= $this -> getDataPost(PARAM_S_CURRENCY);					// 通貨（検索項目）
		$this -> sMinAmount				= $this -> getDataPost(PARAM_S_MIN_AMOUNT);					// 送金額（最少）（検索項目）
		$this -> sMaxAmount				= $this -> getDataPost(PARAM_S_MAX_AMOUNT);					// 送金額（最大）（検索項目）
		$this -> sType					= $this -> getDataPost(PARAM_S_TYPE);						// 取引タイプ（検索項目）
		$this -> sWithdrawAccountName	= $this -> getDataPost(PARAM_S_WITHDRAW_ACCOUNT_NAME);		// 出金口座名義（検索項目）
		$this -> sWithdrawAccountNumber	= $this -> getDataPost(PARAM_S_WITHDRAW_ACCOUNT_NUMBER);	// 出金口座番号（検索項目）
		$this -> sDepositAccountName	= $this -> getDataPost(PARAM_S_DEPOSIT_ACCOUNT_NAME);		// 入金口座名義（検索項目）
		$this -> sDepositAccountNumber	= $this -> getDataPost(PARAM_S_DEPOSIT_ACCOUNT_NUMBER);		// 入金口座番号（検索項目）
		$this -> sAgent					= $this -> getDataPost(PARAM_S_AGENT_CODE);					// エージェント（検索項目）
		$this -> statuses				= $this -> getDataPost(PARAM_STATUSES);								// 処理タイプ
		$this -> sProcessFlg 			= $this -> getDataPost(PARAM_S_PROCESS_FLG);
		$this -> testAccountFlg			= $this -> getDataPost(PARAM_TEST_ACCOUNT_FLG);			// WLID
		// ------------------ 検索系 ------------------//

		$this -> lang					= $this -> getLangage();
	}

	/*-------------------------------------------------------------------------
	* @function_name: サーバ側データチェック
	* @parameter	: なし
	* @return		: TRUE:成功、FALSE:失敗
	-------------------------------------------------------------------------*/
	public function validate() {
		/**
		 *
		 * -- anton --
		 * 04/22/2019
		 *
		 */
		$redirect = ($this -> lang != "en" ? "" : "{$this -> lang}/");

		//check access
		if(!$this -> checkAdminUserAccess('PHTR', array(''))){
			$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_PAGE_ACCESS', array());
			header('Location: /'.$redirect.'menu');
			exit();
		}

		return true;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 検索条件の取得
	* @parameter	: なし
	* @return		: 検索条件
	-------------------------------------------------------------------------*/
	public function getWhere() {

		// 変数宣言部
		$rtn	= array();
		$page	= NO_STRING;

		// ログインチェック
		if(!$this -> checkAdminUserLogin()) {
			throw new Exception(NO_STRING);
		}

		// 取引番号（検索項目）
		if($this -> sTransactionNumber != NO_STRING) {
			$rtn[] = ' trans.transaction_number = (\')' . $this -> sTransactionNumber . '(\') ';
		}

		// 出金口座名義（検索項目）
		if($this -> sWithdrawAccountName != NO_STRING) {
			$rtn[] = ' (withdraw_users.last_name LIKE (\')%' . trim($this -> sWithdrawAccountName) . '%(\') OR withdraw_users.first_name LIKE (\')%' . trim($this -> sWithdrawAccountName) . '%(\')) ';
		}

		// 出金口座番号（検索項目）
		if($this -> sWithdrawAccountNumber != NO_STRING) {
			$rtn[] = ' trans.withdraw_account_number = (\')' . $this -> sWithdrawAccountNumber . '(\') ';
		}

		// 入金口座名義（検索項目）
		if($this -> sDepositAccountName != NO_STRING) {
			$rtn[] = ' (deposit_users.last_name LIKE (\')%' . trim($this -> sDepositAccountName) . '%(\') OR deposit_users.first_name LIKE (\')%' . trim($this -> sDepositAccountName) . '%(\')) ';
		}

		// 入金口座番号（検索項目）
		if($this -> sDepositAccountNumber != NO_STRING) {
			$rtn[] = ' trans.deposit_account_number = (\')' . $this -> sDepositAccountNumber . '(\') ';
		}

		// エージェント（検索項目）

		// 取引タイプ（検索項目）
		if($this -> sType != NO_STRING) {

			switch($this -> sType) {
				case VAL_INT_1:
					$rtn[] = ' trans.transaction_type = (\')1(\')';					// 入金
					break;
				case VAL_INT_2:
					$rtn[] = ' trans.transaction_type IN ((\')2(\'), (\')7(\'))';	// 出金
					break;
				case VAL_INT_3:
					$rtn[] = ' trans.transaction_type = (\')4(\')';					// 通貨両替
					break;
				case VAL_INT_4:
					$rtn[] = ' trans.transaction_type = (\')3(\') ';				// 口座振替
					break;
				case VAL_INT_5:
					$rtn[] = ' trans.transaction_type = (\')5(\')';					// 引き落し
					break;
				case VAL_INT_6:
					$rtn[] = ' (trans.transaction_type = (\')11(\') OR trans.type = (\')1(\'))';					// 引き落し
					break;
				default:
					break;
			}
		}

		// 通貨
		if($this -> sCurrency != NO_STRING) {
			$rtn[] = ' (trans.withdraw_currency = (\')' . $this -> sCurrency . '(\') OR trans.deposit_currency = (\')' . $this -> sCurrency . '(\'))';
		}

		// 送金額（最少）（検索項目）
		if($this -> sMinAmount != NO_STRING) {
			if($this -> sCurrency == NO_STRING) {	// 通貨未指定
				$rtn[] = ' (trans.deposit_amount + trans.withdraw_amount) >= (\')' . $this -> sMinAmount . '(\')';
			} else {								// 通貨指定
				$rtn[] = ' (trans.deposit_amount + trans.withdraw_amount) >= (\')' . $this -> currencyToInt($this -> sMinAmount, $this -> sCurrency) . '(\')';
			}
		}

		// 送金額（最大）（検索項目）
		if($this -> sMaxAmount != NO_STRING) {
			if($this -> sCurrency == NO_STRING) {	// 通貨未指定
				$rtn[] = ' (trans.deposit_amount + trans.withdraw_amount) <= (\')' . $this -> sMaxAmount . '(\')';
			} else {								// 通貨指定
				$rtn[] = ' (trans.deposit_amount + trans.withdraw_amount) <= (\')' . $this -> currencyToInt($this -> sMaxAmount, $this -> sCurrency) . '(\')';
			}
		}


		// 口座状態
		// 		User:ユーザの操作
		// 		Admin:管理者操作
		// 		API：API口座間送金
		// 		Batch：Batch一括支払い
		// 		Bank：銀行入金
		// 		Card：プリペに出金
		// 		Credit：オンラインクレジットで入金した場合
		// if($this -> getType() != NO_STRING) {	// 検索ボタンを押している場合

			if(is_array($this -> statuses)) {	// 処理の選択がある場合


				$status = array();

				// データの入れ替え
				foreach($this -> statuses as $vals) {
					$status[$vals] = $vals;
					$chek[] = 'trans.process_status = (\')'.$vals.'(\') ';
				}

				// $where = NO_STRING;
				// $chek = array();

				// // Userチェックが入っていない場合
				// if($this -> getColumnData($status, NO_COUNT) == NO_STRING) {
				// 	$chek[] = 'trans.process_status != (\')0(\') ';
				// }

				// // Adminチェックが入っていない場合
				// if($this -> getColumnData($status, VAL_INT_1) == NO_STRING) {
				// 	$chek[] = 'trans.process_status != (\')1(\') ';
				// }

				// // Bankチェックが入っていない場合
				// if($this -> getColumnData($status, VAL_INT_4) == NO_STRING) {
				// 	$chek[] = ' NOT (trans.transaction_type = (\')1(\') AND trans.type = (\')0(\')) ';
				// }

				if($this -> isLoopData($chek)) {
					$where = '('.implode(DELIMIT_OR, $chek).')';
					$rtn[] = $where;
				}

			}
			// else {
				// 何もしない
			// }
		// }

		if($this -> sProcessFlg != NO_STRING){
			// 登録時刻（開始日）（検索項目）
			if($this -> sFrom != NO_STRING) {
				$rtn[] = ' trans.transaction_time >= (\')' . $this -> sFrom . '(\')';
			}

			// 登録時刻（終了）（検索項目）
			if($this -> sTo != NO_STRING) {
				$rtn[] = ' trans.transaction_time < DATE_ADD((\')' . $this -> sTo . '(\'), INTERVAL 1 DAY)';
			}
		}

		if($this -> testAccountFlg != NO_STRING) {
			$rtn[] .= '(withdraw_users.test_account_flg = (\')' . $this -> testAccountFlg . '(\') OR deposit_users.test_account_flg = (\')' . $this -> testAccountFlg . '(\'))'  ;
		}

		// ページ数
		$start	= ($this -> getTargetPage() - VAL_INT_1) * VAR_DEFAULT_PAGE_COUNT;

		$page = ' LIMIT ' . $start . DELIMIT_COMMA . VAL_INT_50;

        if($this -> getType() == TYPE_EXPORT)
            $page = '';
		
		// 検索条件の結合
		$delimitedArrayByAnd = 
		  (count($rtn) > NO_COUNT) 
		  ? DELIMIT_AND . implode(DELIMIT_AND, $rtn) 
		  : NO_STRING;
		
		return array($delimitedArrayByAnd, "transaction_time DESC", $page);
	}

	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function dispHTML() {
		return array();
	}

	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function echoList() {

		// 変数宣言部
		$rtn			= NO_STRING;
		$tType			= NO_STRING;
		$deposit		= NO_STRING;
		$withdraw		= NO_STRING;
		$depositCur		= NO_STRING;
		$withdrawCur	= NO_STRING;
		$debitCur		= NO_STRING;
		$debitAmount	= NO_STRING;
		$pStatus		= NO_STRING;

		if($this -> isLoopData($this -> rs)) {

			// データの数だけループを回す
			$start		= ($this -> getTargetPage() - VAL_INT_1) * VAR_DEFAULT_PAGE_COUNT;
			$end		= $this -> getTargetPage() * VAR_DEFAULT_PAGE_COUNT;
			$listCount	= count($this -> rs);
// 			for($cnt = $start; $cnt < $end && $cnt < $listCount; $cnt++) {

// 				$row = $this -> getRowData($this -> rs, $cnt);

			foreach($this -> rs as $row) {
				// 処理種別
				if($row[COLUMN_TRANSACTION_TYPE] == VAL_INT_1) {													// 入金

					$tType			= VAL_STR_DEPOSIT;
					$depositCur		= $this -> getColumnData($row, COLUMN_DEPOSIT_CURRENCY);
					$withdrawCur	= NO_STRING;
					$deposit		= $this -> getAmountString($this -> getColumnData($row, COLUMN_DEPOSIT_AMOUNT), $depositCur);
					$withdraw		= NO_STRING;
					$tNumber 		= $this -> getColumnData($row, COLUMN_TRANSACTION_NUMBER);
					$transId 		= $this -> getColumnData($row, COLUMN_TRANSACTION_ID);

				} else if($row[COLUMN_TRANSACTION_TYPE]							== VAL_INT_2
							&& $this -> getColumnData($row, COLUMN_TYPE)		== VAR_WITHDRAW_TYPE_NORMAL) {		// 通常出金

					$tType			= VAL_STR_WITHDARAW;
					$depositCur		= NO_STRING;
					$withdrawCur	= $this -> getColumnData($row, COLUMN_DEBIT_CURRENCY);
					$debitCur		= $this -> getColumnData($row, COLUMN_WITHDRAW_CURRENCY);
					$debitAmount	= $this -> getAmountString($this -> getColumnData($row, COLUMN_WITHDRAW_AMOUNT), $debitCur);

					$deposit		= NO_STRING;
					$withdraw		= $this -> getAmountString($this -> getColumnData($row, COLUMN_DEBIT_AMOUNT), $withdrawCur) . '(' . $debitCur . DELIMIT_SPACE . $debitAmount . ')';
					$tNumber 		= $this -> getColumnData($row, COLUMN_TRANSACTION_NUMBER);
					$transId 		= $this -> getColumnData($row, COLUMN_TRANSACTION_ID);
				} else if($row[COLUMN_TRANSACTION_TYPE]							== VAL_INT_2
					&& $this -> getColumnData($row, COLUMN_TYPE)				== VAR_WITHDRAW_TYPE_CARD) {		// 通常出金

						$tType			= VAL_STR_WITHDRAW_CARD;
						$depositCur		= NO_STRING;
						$withdrawCur	= $this -> getColumnData($row, COLUMN_DEBIT_CURRENCY);
						$debitCur		= $this -> getColumnData($row, COLUMN_WITHDRAW_CURRENCY);
						$debitAmount	= $this -> getAmountString($this -> getColumnData($row, COLUMN_WITHDRAW_AMOUNT), $debitCur);

						$deposit		= NO_STRING;
						$withdraw		= $this -> getAmountString($this -> getColumnData($row, COLUMN_DEBIT_AMOUNT), $withdrawCur) . '(' . $debitCur . DELIMIT_SPACE . $debitAmount . ')';
						$tNumber 		= $this -> getColumnData($row, COLUMN_TRANSACTION_NUMBER);
						$transId 		= $this -> getColumnData($row, COLUMN_TRANSACTION_ID);
				} else if($this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)	== VAL_INT_4) {						// 通貨両替

					$tType			= VAL_STR_EXCHANGE;
					$depositCur		= $this -> getColumnData($row, COLUMN_DEPOSIT_CURRENCY);
					$withdrawCur	= $this -> getColumnData($row, COLUMN_WITHDRAW_CURRENCY);
					$deposit		= $this -> getAmountString($this -> getColumnData($row, COLUMN_DEPOSIT_AMOUNT), $depositCur);
					$withdraw		= $this -> getAmountString($this -> getColumnData($row, COLUMN_WITHDRAW_AMOUNT), $withdrawCur);
					$tNumber 		= $this -> getColumnData($row, COLUMN_TRANSACTION_NUMBER);
					$transId 		= $this -> getColumnData($row, COLUMN_TRANSACTION_ID);
				} else if($row[COLUMN_TRANSACTION_TYPE]							== VAL_INT_2
							&& $this -> getColumnData($row, COLUMN_TYPE)		== VAR_WITHDRAW_TYPE_FEE) {			// 手数料出金

					$tType			= VAL_STR_FEE;
					$depositCur		= NO_STRING;
					$withdrawCur	= $this -> getColumnData($row, COLUMN_WITHDRAW_CURRENCY);
					$deposit		= NO_STRING;
					$withdraw		= $this -> getAmountString($this -> getColumnData($row, COLUMN_WITHDRAW_AMOUNT), $withdrawCur);
					$tNumber 		= $this -> getColumnData($row, COLUMN_TRANSACTION_NUMBER);
					$transId 		= $this -> getColumnData($row, COLUMN_TRANSACTION_ID);
				} else if($row[COLUMN_TRANSACTION_TYPE] == VAL_INT_3) {												// 口座振替（出金）

					$tType			= VAL_STR_TRANSFER;
					$depositCur		= $this -> getColumnData($row, COLUMN_DEPOSIT_CURRENCY);
					$withdrawCur	= $this -> getColumnData($row, COLUMN_WITHDRAW_CURRENCY);
					$deposit		= $this -> getAmountString($this -> getColumnData($row, COLUMN_DEPOSIT_AMOUNT), $depositCur);
					$withdraw		= $this -> getAmountString($this -> getColumnData($row, COLUMN_WITHDRAW_AMOUNT), $withdrawCur);
					$tNumber 		= $this -> getColumnData($row, COLUMN_TRANSACTION_NUMBER);
					$transId 		= $this -> getColumnData($row, COLUMN_TRANSACTION_ID) ;
				} else if($this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)	== VAL_INT_5) {						// 引落（出金）

					$tType			= VAL_STR_REQUEST;
					$depositCur		= $this -> getColumnData($row, COLUMN_DEPOSIT_CURRENCY);
					$withdrawCur	= $this -> getColumnData($row, COLUMN_WITHDRAW_CURRENCY);
					$deposit		= $this -> getAmountString($this -> getColumnData($row, COLUMN_DEPOSIT_AMOUNT), $depositCur);
					$withdraw		= $this -> getAmountString($this -> getColumnData($row, COLUMN_WITHDRAW_AMOUNT), $withdrawCur);
					$tNumber 		= $this -> getColumnData($row, COLUMN_TRANSACTION_NUMBER);
					$transId 		=  $this -> getColumnData($row, COLUMN_TRANSACTION_ID);

				} else if($this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)			== VAL_INT_7
							|| $this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)	== VAL_INT_8) {				// 出金差戻し

					$tType 			= VAL_STR_WITHDRAW_REFUND;
					$depositCur		= $this -> getColumnData($row, COLUMN_DEPOSIT_CURRENCY);
					$withdrawCur	= NO_STRING;
					$deposit		= $this -> getAmountString($this -> getColumnData($row, COLUMN_DEPOSIT_AMOUNT), $depositCur);
					$withdraw		= NO_STRING;
					$tNumber 		= $this -> getColumnData($row, COLUMN_TRANSACTION_NUMBER);
					$transId 		=  $this -> getColumnData($row, COLUMN_TRANSACTION_ID);
				} else if($this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)			== VAL_INT_11) {				// 出金差戻し

					$tType 			= VAL_STR_FEE;
					$depositCur		= NO_STRING;
					$withdrawCur	= $this -> getColumnData($row, COLUMN_DEPOSIT_CURRENCY);
					$deposit		= NO_STRING;
					$withdraw		= $this -> getAmountString($this -> getColumnData($row, COLUMN_FEE), $withdrawCur);
					$tNumber 		= $this -> getColumnData($row, COLUMN_TRANSACTION_NUMBER);
					$transId 		=  $this -> getColumnData($row, COLUMN_TRANSACTION_ID);
				} else {
					$tType = NO_STRING;
				}

				// 処理ステータス
				if($this -> getColumnData($row, COLUMN_PROCESS_STATUS) == NO_COUNT) {			// ユーザ側操作
					$pStatus = 'User';
				} else if($this -> getColumnData($row, COLUMN_PROCESS_STATUS) == VAL_INT_1) {	// 管理者側操作
					$pStatus = 'Admin';
				} else if($this -> getColumnData($row, COLUMN_PROCESS_STATUS) == VAL_INT_2) {	// API操作
					$pStatus = 'API';
				} else if($this -> getColumnData($row, COLUMN_PROCESS_STATUS) == VAL_INT_3) {	// API操作
					$pStatus = 'Batch';
				} else {
					$pStatus = '&nbsp;';
				}

				$rtn	.= '<tr>'
							. '<td>' . $this -> getColumnData($row, COLUMN_TRANSACTION_TIME) . '</td>'
							//. '<td>'. $transId .'' . $tNumber . '</a></td>'
							. '<td><a href="javascript:void(0);" onclick="javascript:actionDetail(\'' . $this -> getColumnData($row, COLUMN_TRANSACTION_ID) . '\', \'_blank\', '. $row[COLUMN_TRANSACTION_TYPE] .');">' . $tNumber . '</td>'
							. '<td>' . $tType . '</td>'
							// . '<td><a href="javascript:userDetail(\'' . $this -> getColumnData($row, COLUMN_WITHDRAW_ACCOUNT_NUMBER) . '\', \'_blank\');">' . $this -> getColumnData($row, COLUMN_WITHDRAW_ACCOUNT_NAME) . '</a></td>'
							. '<td><a href="account_edit?detail_account=' . $this -> getColumnData($row, COLUMN_WITHDRAW_ACCOUNT_NUMBER) . '">'. $this -> getColumnData($row, COLUMN_WITHDRAW_ACCOUNT_NAME) .'</a></td>'
							. '<td>' . $this -> getColumnData($row, COLUMN_WITHDRAW_ACCOUNT_NUMBER) . '</td>'
							. '<td>' . $withdrawCur . '</td>'
							. '<td class="r">' . $withdraw . '</td>'
							. '<td class="r">' . $this -> getAmountString($this -> getColumnData($row, COLUMN_WITHDRAW_FEE), $withdrawCur) . '</td>'
							// . '<td><a href="javascript:userDetail(\'' . $this -> getColumnData($row, COLUMN_DEPOSIT_ACCOUNT_NUMBER) . '\', \'_blank\');">' . $this -> getColumnData($row, COLUMN_DEPOSIT_ACCOUNT_NAME) . '</a></td>'
							. '<td><a href="account_edit?detail_account=' . $this -> getColumnData($row, COLUMN_DEPOSIT_ACCOUNT_NUMBER) . '">'. $this -> getColumnData($row, COLUMN_DEPOSIT_ACCOUNT_NAME) .'</a></td>'
							. '<td>' . $this -> getColumnData($row, COLUMN_DEPOSIT_ACCOUNT_NUMBER) . '</td>'
							. '<td>' . $depositCur . '</td>'
							. '<td class="r">' . $deposit . '</td>'
							. '<td class="r">' . $this -> getAmountString($this -> getColumnData($row, COLUMN_DEPOSIT_FEE), $depositCur) . '</td>'
							. '<td>' . $pStatus . '</td>'
							. '<td>' . $this -> getColumnData($row, COLUMN_RATE) . '</td>'
							. '</tr>';
			}

		} else {
			$rtn = '<tr><td colspan="14">' . $this -> getMessage(INFO, 'I_NO_SUCHE_SEARCH_DATA', array()) . '</td></tr>';
		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金リストの設定
	* @parameter	: 出金リスト
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function setResult($rs) {
		$this -> rs = $rs;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 出金リストの設定
	 * @parameter	: 出金リスト
	 * @return		: なし
	 -------------------------------------------------------------------------*/
	public function setTotal($count) {
		$this -> total = $count;
	}

	/*-------------------------------------------------------------------------
	* @function_name: ページャの表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispPager() {
		echo  $this -> getPagerCommon($this -> getTargetPage()
										, $this -> getTotalPageCommon(VAR_DEFAULT_PAGE_COUNT, $this -> total)
										, $this -> total
										, NO_STRING
										, true);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 取引番号の取得
	* @parameter	: なし
	* @return		: 取引番号
	-------------------------------------------------------------------------*/
	public function echoSTransactionNumber() {
		echo $this -> sTransactionNumber;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 検索開始日の取得
	* @parameter	: なし
	* @return		: 検索開始日
	-------------------------------------------------------------------------*/
	function echoSFrom() {
		echo $this -> sFrom;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 検索終了日の取得
	* @parameter	: なし
	* @return		: 検索終了日
	-------------------------------------------------------------------------*/
	function echoSTo() {
		echo $this -> sTo;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 検索通貨の取得
	* @parameter	: なし
	* @return		: 検索通貨
	-------------------------------------------------------------------------*/
	function echoSCurrency() {
		echo $this -> sCurrency;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 検索最小値の取得
	* @parameter	: なし
	* @return		: 検索最小値
	-------------------------------------------------------------------------*/
	function echoSMinAmount() {
		echo $this -> sMinAmount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 検索最大値の取得
	* @parameter	: なし
	* @return		: 検索最大値
	-------------------------------------------------------------------------*/
	function echoSMaxAmount() {
		echo $this -> sMaxAmount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金口座名義の取得
	* @parameter	: なし
	* @return		: 出金口座名義
	-------------------------------------------------------------------------*/
	function echoSWithdrawAccountName() {
		echo $this -> sWithdrawAccountName;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金口座番号の取得
	* @parameter	: なし
	* @return		: 出金口座番号
	-------------------------------------------------------------------------*/
	function echoSWithdrawAccountNumber() {
		echo $this -> sWithdrawAccountNumber;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 入金口座名義の取得
	* @parameter	: なし
	* @return		: 入金口座名義
	-------------------------------------------------------------------------*/
	function echoSDepositAccountName() {
		echo $this -> sDepositAccountName;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 入金口座番号の取得
	* @parameter	: なし
	* @return		: 入金口座番号
	-------------------------------------------------------------------------*/
	function echoSDepositAccountNumber() {
		echo $this -> sDepositAccountNumber;
	}

	/*-------------------------------------------------------------------------
	* @function_name: エージェントの取得
	* @parameter	: なし
	* @return		: エージェント
	-------------------------------------------------------------------------*/
	function echoSAgent() {
		echo $this -> sAgent;
	}

	function echoTestAccountFlg() {
		echo $this -> dispListOption($this -> getTestAccountList(), $this -> testAccountFlg);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 通貨リストの取得
	* @parameter	: なし
	* @return		: HTML表示用データ
	-------------------------------------------------------------------------*/
	public function dispCurrencyList() {
		echo $this -> dispListOption($this -> getCurrencyList(), $this -> sCurrency);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 取引タイプの取得
	* @parameter	: なし
	* @return		: HTML表示用データ
	-------------------------------------------------------------------------*/
	public function dispTransactionTypeList() {
		echo $this -> dispListOption($this -> getTransactionTypeList(), $this -> sType);
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 口座状態の表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispStatuses() {

		// 変数宣言部
		$rtn		= NO_STRING;
		$statuses	= array();
		$checked	= array();
		$cnt		= NO_COUNT;

		// 口座状態リストの取得
		$statuses = $this -> getProcessTypeList();

		// チェックリストの作成（デフォルト全取得）
		if(!is_array($this -> statuses)) {

			if($this -> getType() == NO_STRING) {
				if($this -> isLoopData($statuses)) {

					foreach($statuses as $row) {
						$checked[$this -> getColumnData($row, PARAM_DATA_KEY)] = $this -> getColumnData($row, PARAM_DATA_KEY);
					}
				}
			}
		} else {

			foreach($this -> statuses as $row) {
				$checked[$row] = $row;
			}
		}

		if($this -> isLoopData($statuses)) {

			$br = NO_STRING;

			foreach($statuses as $row) {
				if($cnt == VAL_INT_2) {
					$br = '<br/>';
				} else {
					$br = NO_STRING;
				}
				$rtn .= '<label>' . $this -> makeCheckOne(PARAM_STATUSES . $row[PARAM_DATA_KEY], PARAM_STATUSES . '[]', $row[PARAM_DATA_KEY], $row[PARAM_DATA_VALUE] , $this -> getColumnData($checked, $row[PARAM_DATA_KEY])) . '</label>&emsp;' . $br;
				$cnt++;
			}
		}

		echo $rtn;
	}

    /*-------------------------------------------------------------------------
	 * @function_name: makeExportData
	* @parameter	:
	* @return		: string - export data csv format
	-------------------------------------------------------------------------*/
    public function getExportDetails(){
        // 変数宣言部
		$rtn			= NO_STRING;
		$tType			= NO_STRING;
		$deposit		= NO_STRING;
		$withdraw		= NO_STRING;
		$depositCur		= NO_STRING;
		$withdrawCur	= NO_STRING;
		$debitCur		= NO_STRING;
		$debitAmount	= NO_STRING;
		$pStatus		= NO_STRING;

		if($this -> isLoopData($this -> rs)) {


			// データの数だけループを回す
			$start		= ($this -> getTargetPage() - VAL_INT_1) * VAR_DEFAULT_PAGE_COUNT;
			$end		= $this -> getTargetPage() * VAR_DEFAULT_PAGE_COUNT;
			$listCount	= count($this -> rs);
// 			for($cnt = $start; $cnt < $end && $cnt < $listCount; $cnt++) {

// 				$row = $this -> getRowData($this -> rs, $cnt);

			foreach($this -> rs as $row) {
				// 処理種別
				if($row[COLUMN_TRANSACTION_TYPE] == VAL_INT_1) {													// 入金

					$tType			= VAL_STR_DEPOSIT;
					$depositCur		= $this -> getColumnData($row, COLUMN_DEPOSIT_CURRENCY);
					$withdrawCur	= NO_STRING;
					$deposit		= $this -> getAmountString($this -> getColumnData($row, COLUMN_DEPOSIT_AMOUNT), $depositCur);
					$withdraw		= NO_STRING;

				} else if($row[COLUMN_TRANSACTION_TYPE]							== VAL_INT_2
							&& $this -> getColumnData($row, COLUMN_TYPE)		== VAR_WITHDRAW_TYPE_NORMAL) {		// 通常出金

					$tType			= VAL_STR_WITHDARAW;
					$depositCur		= NO_STRING;
					$withdrawCur	= $this -> getColumnData($row, COLUMN_DEBIT_CURRENCY);
					$debitCur		= $this -> getColumnData($row, COLUMN_WITHDRAW_CURRENCY);
					$debitAmount	= $this -> getAmountString($this -> getColumnData($row, COLUMN_WITHDRAW_AMOUNT), $debitCur);

					$deposit		= NO_STRING;
					$withdraw		= $this -> getAmountString($this -> getColumnData($row, COLUMN_DEBIT_AMOUNT), $withdrawCur) . '(' . $debitCur . DELIMIT_SPACE . $debitAmount . ')';

				} else if($row[COLUMN_TRANSACTION_TYPE]							== VAL_INT_2
					&& $this -> getColumnData($row, COLUMN_TYPE)				== VAR_WITHDRAW_TYPE_CARD) {		// 通常出金

						$tType			= VAL_STR_WITHDRAW_CARD;
						$depositCur		= NO_STRING;
						$withdrawCur	= $this -> getColumnData($row, COLUMN_DEBIT_CURRENCY);
						$debitCur		= $this -> getColumnData($row, COLUMN_WITHDRAW_CURRENCY);
						$debitAmount	= $this -> getAmountString($this -> getColumnData($row, COLUMN_WITHDRAW_AMOUNT), $debitCur);

						$deposit		= NO_STRING;
						$withdraw		= $this -> getAmountString($this -> getColumnData($row, COLUMN_DEBIT_AMOUNT), $withdrawCur) . '(' . $debitCur . DELIMIT_SPACE . $debitAmount . ')';

				} else if($this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)	== VAL_INT_4) {						// 通貨両替

					$tType			= VAL_STR_EXCHANGE;
					$depositCur		= $this -> getColumnData($row, COLUMN_DEPOSIT_CURRENCY);
					$withdrawCur	= $this -> getColumnData($row, COLUMN_WITHDRAW_CURRENCY);
					$deposit		= $this -> getAmountString($this -> getColumnData($row, COLUMN_DEPOSIT_AMOUNT), $depositCur);
					$withdraw		= $this -> getAmountString($this -> getColumnData($row, COLUMN_WITHDRAW_AMOUNT), $withdrawCur);

				} else if($row[COLUMN_TRANSACTION_TYPE]							== VAL_INT_2
							&& $this -> getColumnData($row, COLUMN_TYPE)		== VAR_WITHDRAW_TYPE_FEE) {			// 手数料出金

					$tType			= VAL_STR_FEE;
					$depositCur		= NO_STRING;
					$withdrawCur	= $this -> getColumnData($row, COLUMN_WITHDRAW_CURRENCY);
					$deposit		= NO_STRING;
					$withdraw		= $this -> getAmountString($this -> getColumnData($row, COLUMN_WITHDRAW_AMOUNT), $withdrawCur);

				} else if($row[COLUMN_TRANSACTION_TYPE] == VAL_INT_3) {												// 口座振替（出金）

					$tType			= VAL_STR_TRANSFER;
					$depositCur		= $this -> getColumnData($row, COLUMN_DEPOSIT_CURRENCY);
					$withdrawCur	= $this -> getColumnData($row, COLUMN_WITHDRAW_CURRENCY);
					$deposit		= $this -> getAmountString($this -> getColumnData($row, COLUMN_DEPOSIT_AMOUNT), $depositCur);
					$withdraw		= $this -> getAmountString($this -> getColumnData($row, COLUMN_WITHDRAW_AMOUNT), $withdrawCur);

				} else if($this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)	== VAL_INT_5) {						// 引落（出金）

					$tType			= VAL_STR_REQUEST;
					$depositCur		= $this -> getColumnData($row, COLUMN_DEPOSIT_CURRENCY);
					$withdrawCur	= $this -> getColumnData($row, COLUMN_WITHDRAW_CURRENCY);
					$deposit		= $this -> getAmountString($this -> getColumnData($row, COLUMN_DEPOSIT_AMOUNT), $depositCur);
					$withdraw		= $this -> getAmountString($this -> getColumnData($row, COLUMN_WITHDRAW_AMOUNT), $withdrawCur);

				} else if($this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)			== VAL_INT_7
							|| $this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)	== VAL_INT_8) {				// 出金差戻し

					$tType 			= VAL_STR_WITHDRAW_REFUND;
					$depositCur		= $this -> getColumnData($row, COLUMN_DEPOSIT_CURRENCY);
					$withdrawCur	= NO_STRING;
					$deposit		= $this -> getAmountString($this -> getColumnData($row, COLUMN_DEPOSIT_AMOUNT), $depositCur);
					$withdraw		= NO_STRING;

				} else if($this -> getColumnData($row, COLUMN_TRANSACTION_TYPE)			== VAL_INT_11) {				// 出金差戻し

					$tType 			= VAL_STR_FEE;
					$depositCur		= NO_STRING;
					$withdrawCur	= $this -> getColumnData($row, COLUMN_DEPOSIT_CURRENCY);
					$deposit		= NO_STRING;
					$withdraw		= $this -> getAmountString($this -> getColumnData($row, COLUMN_FEE), $withdrawCur);

				} else {
					$tType = NO_STRING;
				}

				// 処理ステータス
				if($this -> getColumnData($row, COLUMN_PROCESS_STATUS) == NO_COUNT) {			// ユーザ側操作
					$pStatus = 'User';
				} else if($this -> getColumnData($row, COLUMN_PROCESS_STATUS) == VAL_INT_1) {	// 管理者側操作
					$pStatus = 'Admin';
				} else if($this -> getColumnData($row, COLUMN_PROCESS_STATUS) == VAL_INT_2) {	// API操作
					$pStatus = 'API';
				} else {
					$pStatus = '&nbsp;';
				}

				$rtn	.= $this -> getColumnData($row, COLUMN_TRANSACTION_TIME) . ','
                           . $tType . ','
                           . $this -> getColumnData($row, COLUMN_WITHDRAW_ACCOUNT_NAME) . ','
                           . $this -> getColumnData($row, COLUMN_WITHDRAW_ACCOUNT_NUMBER) . ','
                           . $withdrawCur . ','
                           . str_replace(",","",$withdraw) . ','
                           . str_replace(",","",$this -> getAmountString($this -> getColumnData($row, COLUMN_WITHDRAW_FEE), $withdrawCur)) . ','
                           . $this -> getColumnData($row, COLUMN_DEPOSIT_ACCOUNT_NAME) . ','
                           . $this -> getColumnData($row, COLUMN_DEPOSIT_ACCOUNT_NUMBER) . ','
                           . $depositCur . ','
                           . str_replace(",","",$deposit) . ','
                           . str_replace(",","",$this -> getAmountString($this -> getColumnData($row, COLUMN_DEPOSIT_FEE), $depositCur)) . ','
                           . $pStatus . ','
                           . $this -> getColumnData($row, COLUMN_RATE)
							. "\n";
			}
		} else {
			$rtn = '';
		}

		return $rtn;
    }

    /*-------------------------------------------------------------------------
	* @function_name: dispProcessFlg
	* @parameter	: none
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispProcessFlg() {
		echo '<label>'
				. $this -> makeCheckOne(PARAM_S_PROCESS_FLG
											, PARAM_S_PROCESS_FLG
											, VAL_INT_1
											, NO_STRING, $this -> sProcessFlg)
				. '</label>';
	}


}
?>
