<?php

class RegistrationHistoryModelClass extends ModelClassEx {
    
    private $rs         = null;
    private $total      = NO_COUNT;
    
    // ------------------ 検索系 ------------------//
    private $sUserAccount 				= NO_STRING;	// 口座番号
    private $sIPAddress 				= NO_STRING;	// IPアドレス
    private $sFrom						= NO_COUNT;		// 登録時刻（開始日）（検索項目）
    private $sTo						= NO_COUNT;		// 登録時刻（終了）（検索項目）
    private $loginFlg                   = NO_COUNT;
    
    private $sCountry                    = NO_STRING;
    
    private $lang						= NO_STRING;
    
    public function __construct(){
        parent::__construct();
    }
    
    public function init(){
        try {
            $this -> setParameter();
            
            return $this -> validate();
            
        } catch (Exception $e) {
            throw new Exception(NO_STRING);
        }
    }
    
    /*-------------------------------------------------------------------------
     * @function_name: 国の表示
     * @parameter	: なし
     * @return		: 国
     -------------------------------------------------------------------------*/
    public function echoCountry() {
        echo $this -> dispListOption($this -> getCountyList(), $this -> sCountry);
    }
    
    public function exportRegistrationHistory(){
        if($this -> isLoopData($this -> rs)){
            
            $data = ($this -> lang == "en" ?
                "Login Time,Name,Account Number,IP Address,Country\n" :
                'ログイン時間,名前,口座番号,IPアドレス,国名' . "\n");
            
            foreach($this -> rs as $row){
                //print_r($row);
                
                $arr = [];
                
                $arr[] = $this -> getColumnData($row, COLUMN_CREATE_TIME);
                $arr[] = sprintf("%s %s", $this -> getColumnData($row, COLUMN_LAST_NAME), $this -> getColumnData($row, COLUMN_FIRST_NAME));
                $arr[] = $this -> getColumnData($row, COLUMN_USER_ACCOUNT);
                $arr[] = $this -> getColumnData($row, COLUMN_IP_ADDRESS);
                $arr[] = $this -> getColumnData($row, COLUMN_COUNTRY);
                
                $data .= '"'. implode('"' . DELIMIT_COMMA . '"', $arr) . '"' . "\n";
            }
            
            $this -> setExportDataCommon($data);
        }
    }
    
    private function setParameter(){
        // ------------------ 検索系 ------------------//
        $this -> sUserAccount	= $this -> getDataPost(PARAM_S_USER_ACCOUNT); 	// 口座番号
        $this -> sIPAddress		= $this -> getDataPost(PARAM_S_IP_ADDRESS); 	// IPアドレス
        $this -> sFrom			= $this -> getDataPost(PARAM_S_FROM);			// 登録時刻（開始日）（検索項目）
        $this -> sTo			= $this -> getDataPost(PARAM_S_TO);				// 登録時刻（終了）（検索項目）
        
        $this -> sCountry        = $this -> getDataPost(PARAM_COUNTRY);
        $this -> loginFlg       = $this -> getDataPost(PARAM_LOGIN_FLG);
        $this -> lang			= $this -> getLangage();
    }
    
    public function validate(){
        $redirect = ($this -> lang != "en" ? "" : "{$this -> lang}/");
        
        //check access
        if(!$this -> checkAdminUserAccess('RHTR', array(''))){
            $this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_PAGE_ACCESS', array());
            header('Location: /'.$redirect.'menu');
            exit();
        }
        
        return true;
    }
    
    public function getWhere() {
        // 変数宣言部
        $rtn	= array();
        $page	= NO_STRING;
        
        // ページ数
        $start	= ($this -> getTargetPage() - VAL_INT_1) * VAR_DEFAULT_PAGE_COUNT;
        
        // ログインチェック
        if(!$this -> checkAdminUserLogin()) {
            throw new Exception(NO_STRING);
        }
        
        // 口座番号（検索項目）
        if($this -> sUserAccount != NO_STRING) {
            $rtn[] = ' user_account = (\')' . $this -> sUserAccount . '(\') ';
        }
        
        // IPアドレス（検索項目）
        if($this -> sIPAddress != NO_STRING) {
            $rtn[] = ' create_ip_address = (\')' . $this -> sIPAddress . '(\') ';
        }
        
        if($this -> loginFlg  != NO_STRING){
            // 登録時刻（開始日）（検索項目）
            if($this -> sFrom != NO_STRING) {
                $rtn[] = ' create_time >= (\')' . $this -> sFrom . '(\')';
            }
            
            // 登録時刻（終了）（検索項目）
            if($this -> sTo != NO_STRING) {
                $rtn[] = ' create_time < DATE_ADD((\')' . $this -> sTo . '(\'), INTERVAL 1 DAY)';
            }
        }
        
        if($this -> sCountry != NO_STRING) {
            $rtn[] = ' country = (\')' . $this -> sCountry . '(\')';
        }
        
        if($this -> getType() != TYPE_EXPORT)
            $page = ' LIMIT ' . $start . DELIMIT_COMMA . VAL_INT_50;
        
        // 検索条件の結合
        if(count($rtn) > NO_COUNT) {
            return array(DELIMIT_AND . implode(DELIMIT_AND, $rtn), $page);
        } else {
            return array(NO_STRING, $page);
        }
    }
    
    public function dispPager() {
        $pager = $this -> getPagerCommon($this -> getTargetPage()
            , $this -> getTotalPageCommon(VAR_DEFAULT_PAGE_COUNT, $this -> total)
            , $this -> total
            , NO_STRING, true);
        echo $pager;
    }
    
    public function dispHTML(){
        return array();
    }
    
    public function setResult($rs) {
        $this -> rs = $rs;
    }
    
    public function setTotal($count) {
        $this -> total = $count;
    }
    
    public function dispLoginFlg() {
        echo '<label>'
            . $this -> makeCheckOne(PARAM_LOGIN_FLG
                , PARAM_LOGIN_FLG
                , VAL_INT_1
                , NO_STRING, $this -> loginFlg)
                . '</label>';
    }
    
    public function echoList(){
        // 変数宣言部
        $rtn			= NO_STRING;
        
        if($this -> isLoopData($this -> rs)) {            
            foreach($this -> rs as $row) {
                $rtn	.= '<tr>'
                    . '<td>' . $this -> getColumnData($row, COLUMN_CREATE_TIME) . '</td>'
                    . '<td>' . $this -> getColumnData($row, COLUMN_LAST_NAME) . '&nbsp;' . $this -> getColumnData($row, COLUMN_FIRST_NAME) . '</td>'
                    . '<td><a href="account_edit?detail_account=' . $this -> getColumnData($row, COLUMN_USER_ACCOUNT) . '">'. $this -> getColumnData($row, COLUMN_USER_ACCOUNT) .'</a></td>'
                    . '<td>' . $this -> getColumnData($row, COLUMN_IP_ADDRESS) . '</td>'
                    . '<td>' . $this -> dispCountryCommon($this -> getColumnData($row, COLUMN_COUNTRY)) . '</td>'
                    . '</tr>';
            }
        } else {
            $rtn = '<tr><td colspan="5">' . $this -> getMessage(INFO, 'I_NO_SUCHE_SEARCH_DATA', array()) . '</td></tr>';
        }
        
        echo $rtn;
    }
    
    public function echoSUserAccount(){
        echo $this -> sUserAccount;
    }
    
    public function echoSIPAddress(){
        echo $this -> sIPAddress;
    }
    
    public function echoSCountry(){
        echo $this -> sCountry;
    }
    
    public function echoFrom(){
        echo $this -> sFrom;
    }
    
    public function echoTo(){
        echo $this -> sTo;
    }
}