/**
 * anton
 *  
 **/
var invalidPrice = (lang == "en" ? "Invalid Price" : "不正な値です。");

$(function() {

	$('#btnAdd').click(function() {
		actionAction();
	});

	$('#btnConfirm').click(function() {
		$('#type').val('confirm');
		submitForm();
	});

	$('#btnComplete').click(function() {
		$('#type').val('complete');
		submitForm();
	});

	$("#btnSearch").click(function() {
		$('#type').val('search');
		submitForm('searchForm');
	});

	$("#btnSave").click(function() {
		$('#type').val('save');
		submitForm();
	});

	$("#btnUpdate").click(function() {
		$('#type').val('update');
		submitForm();
	});

	$("#btnAddAent").click(function() {
		addAgent();
	});

	$("#btnNext").click(function() {
		actionInput();
	});

	$('#btnList').click(function() {
		$('#type').val('');
		submitForm();
	});

	$('#date').change(function() {
		$('#type').val('commission');
		submitForm();
	});

	$('[id*=card_commission_]').blur(function() {

		reCalcurate();
	});

	$("#btnSearchToday").click(function() {
		$('#type').val('search');
		$('#s_from:text').datepicker().datepicker('setDate','today');
		$('#s_to:text').datepicker().datepicker('setDate','today');
		$('#s_email').val('');
		$('#s_name').val('');
		$('#s_agent_code').val('');

		submitForm('searchForm');
	});

	$("#btnSearchAll").click(function() {
		$('#type').val('search');
		$('#s_from:text').datepicker().datepicker('setDate', nowStr);
		$('#s_to:text').datepicker().datepicker('setDate','today');
		$('#s_email').val('');
		$('#s_name').val('');
		$('#s_agent_code').val('');

		submitForm('searchForm');
	});

	$('#s_from').datepicker({
		// カレンダーの設定
		dateFormat	: 'yy/mm/dd'
	});

	$('#s_to').datepicker({
		// カレンダーの設定
		dateFormat	: 'yy/mm/dd'
	});

	if($('#s_from').val() == '') {
		$('#s_from:text').datepicker().datepicker('setDate', nowStr);
	}

	if($('#s_to').val() == '') {
		$('#s_to:text').datepicker().datepicker('setDate','today');
	}

	setExchangeCommission($('#exchange_fee_id').val());
});


/**
 * 入力画面
 */
function actionAction() {
	$('#type').val('action');
	submitForm();
}

/**
 * 入力画面
 */
function actionInput() {
	$('#type').val('input');
	submitForm();
}

/**
 * 検索
 */
function actionSearch() {
	$('#type').val('search');
	submitForm();
}


/**
 * 詳細表示
 */
function actionDetail(dId) {
	$('#type').val('detail');
	$('#d_id').val(dId);
	submitForm();
}

/**
 * 子エージェントの追加
 */
function addAgent() {

	// コエージェントを追加する
	$.ajax({
		type		: 'POST'
		, url		: '../api/addAgent'
		, dataType	: 'json'
		, data	: {
			'user_account'	: $('#add_code').val()
			, 'd_id'		: $('#d_id').val()
			, 'lang'		: $("html[lang=en]").length >= 1 ? 1 : 0
		},
		success: function(data) {

			// 結果
			if(data.result == 'OK') {
				location.reload();
			} else {
				alert(data.msg);
			}
		}
	});
}

/**
 * コミッションの計算
 */
function calcurate(ag, mst) {

	// 変数宣言部
	var rtn		= true;
	var agent	= $('#' + ag).val();
	var master	= $('#' + mst).val();
	var sp		= null;

	// エラーチェック
	if(!agent.match(/^-?[0-9]+\.[0-9]+$/)
		&& !agent.match((/^-?[0-9]+$/))) {
		alert(invalidPrice);
		rtn = false;
	}

	if(!master.match(/^-?[0-9]+\.[0-9]+$/)
		&& !master.match((/^-?[0-9]+$/))) {
		alert(invalidPrice);
		rtn = false;
	}

	if(rtn) {

		agent	= parseFloat(agent);
		master	= parseFloat(master);

		sp = ag.split('_');

		$('#' + sp[0] + '_' + sp[1] + '_total').text((agent + master) + ' %');
	}
}

/**
 * エージェントコミッションデータ
 */
function goAgentCommission(agentCode) {
	$('#agent_code').val(agentCode);
	$('#type').val('commission');
	submitForm();
}

/**
 * 為替手数料データの取得
 */
function setExchangeCommission(pId) {

	// ポストアクション
	postAction('../api/getExchangeFeeAgent', {'p_id':pId, 'agent_code':$('#agent_code').val()})
	.done(function(data) {
		console.log(data);
		allReset();

		$.each(data, function(key, value) {
			$('#' + key).val(value);
		});
	})
	.fail(function(data) {
		console.log(data);
	});

}

//データをリセットする
function allReset() {

	// データをリセット
	$.each($('[id*=share_]'), function() {
		$(this).val('');
	});

	$.each($('[id*=bottom_]'), function() {
		$(this).val('');
	});
}

// カード手数料の合計値再計算
function reCalcurate() {

	var total = 0;

	$.each($('[id*=card_commission_]'), function(key, value) {


		var num = 0;

		if(!isNaN($(this).val())) {
			num = parseFloat($(this).val());
		} else {
			$(this).val('0');
		}

		total += parseFloat(num);
	});

	$('#total').text(format(total));
}

function format(num) {
	var rtn = String(num);
	while(rtn != (rtn = rtn.replace(/^(-?\d+)(\d{3})/, "$1,$2")));

	return rtn;
}