<?php
class BatchModelClass extends ModelClassEx {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $year	= NO_STRING;
	private $month	= NO_STRING;
	private $day	= NO_STRING;

	/*-------------------------------------------------------------------------
	* @function_name: コントロールパネルシステムindexモデルクラスコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		// スーパークラスコンストラクタ呼び出し
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 初期設定関数
	* @parameter	: なし
	* @return		: 成功:success、失敗:error
	-------------------------------------------------------------------------*/
	public function init() {

		try {

			// パラメータの設定
			$this -> setParameter();

			// チェック
			return $this -> validate();

		} catch (Exception $e) {
			throw new Exception(NO_STRING);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: パラメータの設定
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function setParameter() {

		// 変数宣言部
		$date = getdate(strtotime("- 1 days"));

		$this -> year	= $this -> getDataGet(PARAM_YEAR);
		$this -> month	= $this -> getDataGet(PARAM_MONTH);
		$this -> day	= $this -> getDataGet(PARAM_DAY);

		// データがなければ、デフォルト値
		if($this -> year == NO_STRING) {
			$this -> year = $date[PARAM_YEAR];
		}

		if($this -> month == NO_STRING) {
			$this -> month = $date[PARAM_MON];
		}

		if($this -> day == NO_STRING) {
			$this -> day = $date[PARAM_MDAY];
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: サーバ側データチェック
	* @parameter	: なし
	* @return		: TRUE:成功、FALSE:失敗
	-------------------------------------------------------------------------*/
	public function validate() {
		return true;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 日付（年）の取得
	* @parameter	: なし
	* @return		: 日付（年）
	-------------------------------------------------------------------------*/
	public function getYear() {
		return $this -> year;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 日付（月）の取得
	* @parameter	: なし
	* @return		: 日付（月）
	-------------------------------------------------------------------------*/
	public function getMonth() {
		return $this -> month;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 日付（日）の取得
	* @parameter	: なし
	* @return		: 日付（日）
	-------------------------------------------------------------------------*/
	public function getDay() {
		return $this -> day;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 集計バッチパラメータの取得
	* @parameter	: なし
	* @return		: 集計バッチパラメータ
	-------------------------------------------------------------------------*/
	public function getParams() {

		// 変数宣言部
		$rtn = array();

		$rtn[] = $this -> year;
		$rtn[] = $this -> month;
		$rtn[] = $this -> day;

		return $rtn;
	}
}
?>