<?php
require_once(SYSTEM_LOGICS . 'transaction/model.php');

class LogicTransaction extends TransactionModelClass {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $htmlStr = NO_STRING;	// 表示用HTML文字列

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジック（各クラス共通）
	* @parameter	: なし
	* @return		: TRUE:ロジック成功、FALSE:ロジック失敗
	-------------------------------------------------------------------------*/
	function logic() {

		try {

			// 初期データ処理
			if($this -> init()) {
				$this -> lists();

                //check if type is export
                if($this -> getType() == TYPE_EXPORT){
                    $this -> exportData();
                }
			}

		} catch (Exception $e) {
			throw $e;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金リストの取得
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function lists() {
		$this -> setResult($this -> accessSelect('LIST_TRANSACTION', $this -> getWhere()));
		$this -> setTotal($this -> getColumnData($this -> getRowData($this -> accessSelect('COUNT_TRANSACTION', $this -> getWhere())), COLUMN_COUNTER));
	}

    /*-------------------------------------------------------------------------
	* @function_name: makeExportData
	* @parameter	:
	* @return		:
	-------------------------------------------------------------------------*/
    function makeExportData(){
        $rtn  = NO_STRING;


        
        if ($this -> lang == "en") {
        	$rtn  = ',,Withdrawal Account Information,,,,,Deposit Account Information,,,,,,' . "\n";
        	$rtn .= 'Processing Date,Transaction Item,Name,Account Number,Currency,Amount,Fee,Name,Account Number,Currency,Amount,Fee,Type,Exchange Rate' . "\n";
        } else {
        	$rtn  = ',,出金口座情報,,,,,入金口座情報,,,,,,' . "\n";
        	$rtn .= '処理時間,取引科目,名前,口座番号,通貨,金額,手数料,名前,口座番号,通貨,金額,手数料,種別,為替レート' . "\n";
        }

        $rtn .= $this -> getExportDetails();

        return $rtn;
    }

    /*-------------------------------------------------------------------------
	* @function_name: exportData
	* @parameter	:
	* @return		:
	-------------------------------------------------------------------------*/
    function exportData(){
        $fileName = 'Processing History_' . str_replace("/", "", 
            $this -> getDataPost(PARAM_S_FROM, true, true, true) 
            . '-' . $this -> getDataPost(PARAM_S_TO, true, true, true)) 
            . '_' . $this -> getDataPost(PARAM_CURRENCY, true, true, true);

        header('Content-Encoding: UTF-8');
        header("Content-type: text/csv; charset=UTF-8");
        header('Content-Disposition: attachment; filename="' . $fileName . '.csv"');
        header('Content-Transfer-Encoding: binary');

        echo "\xEF\xBB\xBF";
        echo trim($this -> makeExportData());
        exit();
    }
}
?>
