<?php
include_once '../../system/lib/config.php';

class TestDeposit extends System {
    
    /**
     * 
     * @var string
     */
    private $customer           = NO_STRING;
    
    /**
     * 
     * @var string
     */
    private $currency           = NO_STRING;
    
    /**
     * 
     * @var string
     */
    private $reference          = NO_STRING;
    
    /**
     * 
     * @var string
     */
    private $amount             = NO_STRING;
    
    /**
     * 
     * @var string
     */
    private $securityCode       = NO_STRING;
    
    /**
     * 
     * @var string
     */
    private $ipAddress          = NO_STRING;
    
    /**
     * 
     * @var string
     */
    private $bank               = NO_STRING;
    
    /**
     * 
     * @var string
     */
    private $transferURL        = NO_STRING;
    
    /**
     * 
     * @var string
     */
    private $merchantCode       = NO_STRING;
    
    /**
     * 
     * @var string
     */
    private $rawKey             = NO_STRING;
    
    /**
     * 
     * @var string
     */
    private $transKey           = NO_STRING;
    
    /**
     * 
     * @var string
     */
    private $note               = NO_STRING;
    
    /**
     * 
     * @var double
     */
    private $fee                = NO_COUNT;
    
    /**
     * 
     * @var string
     */
    private $formattedAmount    = NO_COUNT;
    
    /**
     * 
     * @var boolean
     */
    private $usingPotMethod     = false;
    
    /**
     * 
     * @var string
     */
    private $transDateTime      = NO_STRING;
    
    /**
     * 
     * @var string
     */
    private $frontURI           = NO_STRING;
    
    /**
     * 
     * @var string
     */
    private $backURI            = NO_STRING;
    
    /**
     * 
     * @var string
     */
    private $language           = NO_STRING;
    
    public function __construct(){
        parent::__construct();
        $this -> setParameter();
        $this -> validation();
    }
    
    private function setParameter(){
        $h2pSettings = $this -> getRowData($this -> accessSelect("SELECT_DEV_SETTING", ["help2pay_conf"]));
        
        if($this -> isLoopData($h2pSettings)){
            $h2pSettings = json_decode($this -> getColumnData($h2pSettings, "dev_setting_value"));
            
            $this -> merchantCode   = $h2pSettings -> merchant_code;
            $this -> transferURL    = $h2pSettings -> transfer_url;
            $this -> ipAddress      = $_SERVER["REMOTE_ADDR"];
            $this -> securityCode   = $h2pSettings -> security_code;
        }
        
        $this -> customer   = $this -> getDataPost("customer");
        $this -> currency   = $this -> getDataPost("currency");
        $this -> amount     = $this -> getDataPost("amount");
        $this -> bank       = $this -> getDataPost("bank");
        $this -> note       = $this -> getDataPost("note");
        $this -> language   = $this -> getDataPost("lang");
        
        if($this -> language == NO_STRING)
            $this -> language = "en";
        
        $this -> frontURI   = SITE_PROTOCOL."://".SITE_DOMAIN_FULL."/test/help2pay/deposit_status.php";
        $this -> backURI    = SITE_PROTOCOL."://".SITE_DOMAIN_FULL."/api/H2PDepositWebhook.php?lang={$this -> language}";
    }
    
    private function validation(){
        $validationRemarks = [];
        
        if(strcasecmp($this -> getColumnData($_SERVER, "REQUEST_METHOD"), "POST") !== 0){
            $validationRemarks[] = json_encode([
                "code" => "01",
                "message" => "Invalid Request Method ({$_SERVER["REQUEST_METHOD"]})"
            ]);
        }else{
            $this -> usingPotMethod = true;
        }
        
        $account = $this -> getRowData($this -> getAccountCommon($this -> customer));
        
        if($this -> isLoopData($account)){
            if(!$this -> getColumnData($account, COLUMN_TEST_ACCOUNT_FLG)){
                $validationRemarks[] = json_encode([
                    "code" => "02",
                    "message" => "User Account ({$this -> customer}) must be under tester category"
                ]);
            }
        }else{
            $validationRemarks[] = json_encode([
                "code" => "03",
                "message" => "Invalid User Account ({$this -> customer})"
            ]);
        }
        
        if($this -> isLoopData($validationRemarks)){
            echo "<pre>";
            die(print_r($validationRemarks, true));
        }
        
        $this -> reference      = $this -> getTransactionNumberCommon(VAR_TRANSACTION_DEPOSIT);
    }
    
    private function buildData(){
        date_default_timezone_set('Asia/Manila');
        
        $this -> transDateTime = date("Y-m-d h:i:s A");
        
        $this -> fee = $this -> intToCurrency(round(bcmul($this -> amount, VAL_STR_H2P_FEE, VAL_INT_4)), PERCENT);
        
        $this -> formattedAmount = str_replace(
            ",",
            NO_STRING,
            $this -> formatCurrency(($this -> amount + $this -> fee), $this -> currency)
        );
        
        $militaryTime = date("YmdHis", strtotime($this -> transDateTime));
        
        $this -> rawKey = $this -> merchantCode
            .$this -> reference
            .$this -> customer
            .sprintf("%.2f", $this -> formattedAmount)
            .$this -> currency
            .$militaryTime
            .$this -> securityCode
            .$this -> ipAddress;
        
        $this -> transKey = md5($this -> rawKey);    
    }
    
    private function storeTemporaryDepositData(){
        $this -> accessModify("INSERT_DEPOSIT_H2P_TEMP", [
            $this -> reference,
            $this -> customer,
            $this -> amount,
            $this -> formattedAmount,
            $this -> currency,
            VAL_STR_H2P_METHOD,
            date("Y-m-d H:i:s"),
            $this -> bank,
            str_replace(",", NO_STRING, $this -> formatCurrency($this -> fee, $this -> currency)),
            "Local Bank Transfer (Southeast Asia)",
            "via IWL Tester Edge",
            date("Y-m-d H:i:s"),
            '9999',
            NO_COUNT,
            NO_COUNT,
            NO_COUNT
        ]);
    }
    
    public function getv($varname){
        if(isset($this -> $varname))
            return $this -> $varname;
        else
            return NO_STRING;
    }
    
    public function display(){
        if($this -> usingPotMethod){
            $this -> buildData();
            $this -> storeTemporaryDepositData();
        }
        
        include_once "template/deposit_form.php";
    }
}

$deposit = new TestDeposit();
$deposit -> display();