<?php
include_once '../../system/lib/config.php';

class TestDepositStatus extends System {
    
    /**
     * 
     * @var string
     */
    private $referer        = NO_STRING;
    
    /**
     * 
     * @var string
     */
    private $reference      = NO_STRING;
    
    /**
     * 
     * @var string
     */
    private $status         = NO_STRING;
    
    /**
     * 
     * @var string
     */
    private $amount         = NO_STRING;
    
    /**
     * 
     * @var string
     */
    private $currency       = NO_STRING;
    
    /**
     * 
     * @var string
     */
    private $fee            = NO_STRING;
    
    /**
     * 
     * @var string
     */
    private $createTime     = NO_STRING;
    
    /**
     * 
     * @var string
     */
    private $userAccount    = NO_STRING;
    
    public function __construct(){
        parent::__construct();
        $this -> setParameter();
        $this -> validation();
    }
    
    private function setParameter(){
        $this -> referer        = $this -> getColumnData($_SERVER, "HTTP_REFERER");
        
        $this -> reference      = $this -> getDataPost("Reference");
        $this -> status         = $this -> getDataPost("Status");
        $this -> userAccount    = $this -> getDataPost("Customer");
    }
    
    private function validation(){
        $validationRemarks = [];
        
        if($this -> status == NO_STRING){
            $validationRemarks[] = json_encode([
                "code" => "01",
                "message" => "No status code found"
            ]);
        }
        
        if($this -> userAccount != NO_STRING){
            $account = $this -> getRowData($this -> getAccountCommon($this -> userAccount));
            
            if(!$this -> getColumnData($account, COLUMN_TEST_ACCOUNT_FLG)){
                $validationRemarks[] = json_encode([
                    "code" => "02",
                    "message" => "User Account ({$this -> customer}) must be under tester category"
                ]);
            }
        }
        
        if($this -> isLoopData($validationRemarks)){
            echo "<pre>";
            die(print_r($validationRemarks, true));
        }
    }
    
    public function listen(){
        switch($this -> status){
            case "000":
            case "006":{
                $tempRow = $this -> accessSelect("SELECT_DEPOSIT_H2P_TEMP", [$this -> getDataPost("Reference")]);
                
                if($this -> isLoopData($tempRow)){
                    $tempRow = $this -> getRowData($tempRow);
                                        
                    if(strcmp($this -> getColumnData($tempRow, COLUMN_USER_ACCOUNT), $this -> userAccount) !== 0){
                        die("Ownership was falsified!");
                    }
                    
                    $processedTransaction = $this -> accessSelect("SELECT_DEPOSIT_BY_TRANSACTION_NUMBER", [$this -> getDataPost("Reference")]);
                    
                    if(!$this -> isLoopData($processedTransaction)){
                        $comment = "Bank:".$this -> getColumnData($tempRow, 'deposit_bank')
                        .",Merchant:{$this -> getDataPost('Merchant')}"
                        .",Status:{$this -> getDataPost('Status')}"
                        .",Currency:{$this -> getDataPost('Currency')}"
                        .",Amount:{$this -> getDataPost('Amount')}"
                        .",Datetime:{$this -> getDataPost('Datetime')}"
                        .",Customer:{$this -> getDataPost('Customer')}"
                        .",Language:{$this -> getDataPost('Language')}"
                        .",Reference:{$this -> getDataPost('Reference')}"
                        .",ID:{$this -> getDataPost('ID')}"
                        .",Key:{$this -> getDataPost('Key')}"
                        .",Note:{$this -> getDataPost('Note')}";
                        
                        $toInsert = [
                            $this -> getColumnData($tempRow, COLUMN_TRANSACTION_NUMBER),
                            $this -> getColumnData($tempRow, COLUMN_USER_ACCOUNT),
                            $this -> getColumnData($tempRow, COLUMN_AMOUNT),
                            $this -> getColumnData($tempRow, COLUMN_CURRENCY),
                            $this -> getColumnData($tempRow, COLUMN_METHOD),
                            "Local Bank Transfer(Southeast Asia)",
                            $this -> getColumnData($tempRow, COLUMN_DEPOSIT_DATE),
                            $this -> getColumnData($tempRow, COLUMN_FEE),
                            $comment,
                            $this -> getColumnData($tempRow, COLUMN_CREATE_TIME),
                            NO_COUNT,
                            NO_COUNT,
                            "Local Bank Transfer(Southeast Asia)"
                        ];
                        
                        $this -> accessModify("INSERT_WB_DEPOSIT_TRANSACTION", $toInsert, false);
                        $processedTransaction = $this -> accessSelect("SELECT_DEPOSIT_BY_TRANSACTION_NUMBER", [$this -> getDataPost("Reference")]);
                    }
                    
                    $this -> fee                 = $this -> intToCurrency(
                                                        round(bcmul($this -> getColumnData($tempRow, COLUMN_AMOUNT),
                                                        VAL_STR_H2P_FEE, VAL_INT_4)), PERCENT);
                    $this -> createTime	         = $this -> getColumnData($tempRow, COLUMN_CREATE_TIME);
                    $this -> amount	             = $this -> getColumnData($tempRow, COLUMN_AMOUNT);
                    $this -> currency	         = $this -> getColumnData($tempRow, COLUMN_CURRENCY);
                    
                    $this -> sendHelp2PaySuccessMail();
                    include_once "template/deposit_success.php";
                }
                break;
            }
            case "009":
                echo "Pending Transaction";
                break;
            default:
                $this -> sendHelp2PayFailMail();
                include_once "template/deposit_failed.php";
                break;
        }
    }
    
    private function getSendHelp2PaySuccessData() {
        // 変数宣言部
        $rtn		= array();
        
        // パラメータの設定
        $rtn[]	= $this -> userAccount;															           // 口座番号（1）
        $rtn[]	= $this -> getNameCommon($this -> userAccount);						            // 氏名（2）
        $rtn[]	= $this -> reference;										                      // 取引番号（3）
        $rtn[]	= $this -> createTime;												               // 取引時刻（4）
        $rtn[]	= $this -> currency;															  // 決済通貨（5）
        $rtn[]	= $this -> getAmountString($this -> amount, $this -> currency);					     // 決済金額（6）
        $rtn[]	= $this -> currency;																// 反映通貨（7）
        $rtn[]	= $this -> getAmountString(($this -> amount + $this -> fee), $this -> currency);	// 反映金額（8）
        $rtn[]  = "NOC"; // Not-A-Country
        
        return $rtn;
    }
    
    private function sendHelp2PaySuccessMail(){
        $params = '';
        // 変数宣言部
        $params = $this -> getSendHelp2PaySuccessData();
        // メールを送信（ユーザ）
        $this -> sendMailByTmp('en/help2pay_deposit_info.xml'
            , $params
            , $this -> getEMailCommon($this -> getColumnData($params, NO_COUNT))
            , VAR_CS_MAIL_ADDRESS
            , $this -> getLangage());
    }
    
    private function getSendHelp2PayFailData() {
        $this -> userAccount = $this -> getDataPost("Customer");
        
        // 変数宣言部
        $rtn		= array();
        $rtn[]	= $this -> userAccount;							// 口座番号
        $rtn[]	= $this -> getNameCommon($this -> userAccount);	// 氏名

        return $rtn;
    }
    
    private function sendHelp2PayFailMail(){
        // 変数宣言部
        $params = $this -> getSendHelp2PayFailData();
        
        // メールを送信（ユーザ）
        $this -> sendMailByTmp('en/help2pay_deposit_info_fail.xml'
            , $params
            , $this -> getEMailCommon($this -> getColumnData($params, NO_COUNT))
            , VAR_CS_MAIL_ADDRESS
            , $this -> getLangage());
    }
    
    public function getv($varname){
        if(isset($this -> $varname))
            return $this -> $varname;
        else
            return NO_STRING;
    }
}

$depositStatus = new TestDepositStatus();
$depositStatus -> listen();