<?php
require_once "config.php";

class H2PWithdrawalVerification extends System {
    
    private $transactionKey;
    private $transactionNum;
    
    // directories
    private $accessLog;
    private $errorLog;
    private $verifyLog;
    
    public function __construct(){
        parent::__construct();
        
        $this -> setParameter();
        $this -> validation();
    }
    
    private function setParameter(){
        $this -> transactionKey = $this -> getDataGet("transKey", true);
        $this -> transactionNum = $this -> getDataGet("transNum", true);
        
        $this -> accessLog  = "Logs/H2P_Withdrawal/verification/access";
        $this -> errorLog   = "Logs/H2P_Withdrawal/verification/error";
        $this -> verifyLog  = "Logs/H2P_Withdrawal/verification/verify";
    }
    
    private function validation(){
        if(!@file_exists($this -> accessLog)){
            mkdir($this -> accessLog, 0777, true);
        }
        
        if(!@file_exists($this -> errorLog)){
            mkdir($this -> errorLog, 0777, true);
        }
        
        if(!@file_exists($this -> verifyLog)){
            mkdir($this -> verifyLog, 0777, true);
        }
    }
    
    public function listen(){
        $logDate = date("Y-m-d");
        
        $logPostVar = print_r($_POST, true);
        $logGetVar  = print_r($_GET, true);
        
        error_log(
            date("[Y-m-d H:i:s]")."\r\nAccessed\nPOST: {$logPostVar}GET: {$logGetVar}\r\n\r\n", 
            VAL_INT_3, 
            "{$this -> accessLog}/Log_{$logDate}.log");
        
        $uriResponse = $this -> getColumnData($_SERVER, "REQUEST_URI");
        
        if($this -> transactionKey != NO_STRING && $this -> transactionNum != NO_STRING){
            $result = $this -> getRowData($this -> accessSelect("SELECT_WITHDRAW_H2P_TEMP", [$this -> transactionNum]));
            
            if($this -> isLoopData($result)){
                //get necessary details from result
                $key = $this -> getColumnData($result, 'api_key'); //transaction number
                
                if(strcasecmp($key, $this -> transactionKey) === NO_COUNT){
                    error_log(
                        date("[Y-m-d H:i:s]")."\r\nVERIFY:\r\n\r\nTRUE {$this -> transactionNum}  {$this -> transactionKey}\r\n\r\n", 
                        VAL_INT_3, 
                        "{$this -> verifyLog}/Log_{$logDate}.log"
                    );
                    
                    echo "true";
                }else{
                    error_log(
                        date("[Y-m-d H:i:s]")."\r\nERROR:\r\n"."\r\nFALSE: Key not verified {$this -> transactionNum}  {$this -> transactionKey} vs {$key}\r\n\r\n", 
                        VAL_INT_3, 
                        "{$this -> errorLog}/Log_{$logDate}.log"
                    );
                    
                    echo "false";
                }
            }else{
                //false
                error_log(
                    date("[Y-m-d H:i:s]")."\r\nERROR:\r\n\r\nFALSE: Not on database {$this -> transactionNum}  {$this -> transactionKey}\r\n\r\n", 
                    VAL_INT_3, 
                    "{$this -> errorLog}/Log_{$logDate}.log"
                );
                echo "false";
            }
        }else{
            //log the error
            error_log(
                date("[Y-m-d H:i:s]")."\r\nERROR:\r\n\r\nResponse:\r\n{$uriResponse}\r\n", 
                VAL_INT_3, 
                "{$this -> errorLog}/Log_{$logDate}.log"
            );
            
            echo "false";
        }
    }
}

$verification = new H2PWithdrawalVerification();
$verification -> listen();