<?php
require_once(SITE_LOGICS . 'card/logic.php');

class ControlCard extends LogicCard {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: コントロールパネルシステム動画データ編集ロジック（各クラス共通）
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function action() {
		// 変数宣言部
		$result = NO_STRING;

		try {
		    $this -> checkAvailability("site", function(){
		        require_once $this -> getUserHTML('TEMPLATE_MAINTENANCE_MODE_SITE_PATH');
		        exit();
		    });
		    
			// アクション実行
			$result = $this -> logic();

			if($this -> getType() == TYPE_DETAIL) {					// カード詳細
				require_once($this -> getUserHTML('TEMPLATE_CARD_STATEMENT_PATH', $this -> dispHTML()));

			} else if($this -> getType() == TYPE_INPUT) {			// カード入力
				require_once($this -> getUserHTML('TEMPLATE_CARD_LOAD_INPUT_PATH', $this -> dispHTML()));

			} else if($this -> getType() == TYPE_CONFIRM) {			// カード確認
				require_once($this -> getUserHTML('TEMPLATE_CARD_LOAD_CONFIRM_PATH', $this -> dispHTML()));

			} else if($this -> getType() == TYPE_COMPLETE) {		// カード完了
				require_once($this -> getUserHTML('TEMPLATE_CARD_LOAD_COMPLETE_PATH', $this -> dispHTML()));

			} else if($this -> getType() == TYPE_FAIL) {			// カード未所持・カード情報取得失敗
				require_once($this -> getUserHTML('TEMPLATE_CARD_FAIL_PATH', $this -> dispHTML()));

			} else {												// カードバランス
				require_once($this -> getUserHTML('TEMPLATE_CARD_BALANCE_PATH', $this -> dispHTML()));
			}

		} catch (Exception $e) {

			if($e -> getMessage() != NO_STRING) {
				require_once($this -> getUserHTML('TEMPLATE_TMP_PROCESS_INVALID_PATH', $this -> dispHTML()));
			} else {
				header('Location: /' . $this ->  getLangage() . '/login');
			}
		}
	}
}
?>