<?php
require_once(SYSTEM_LOGICS . 'deleted_transaction/model.php');

class LogicDeletedTransaction extends DeletedTransactionModelClass {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $htmlStr = NO_STRING;	// 表示用HTML文字列

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジック（各クラス共通）
	* @parameter	: なし
	* @return		: TRUE:ロジック成功、FALSE:ロジック失敗
	-------------------------------------------------------------------------*/
	function logic() {

		try {

			// 初期データ処理
			if($this -> init()) {



                //check if type is export
                if($this -> getType() == TYPE_EXPORT){
					$this -> lists();
                    $this -> exportData();
                }else if($this -> getType() == TYPE_DELETE){
                	$this -> insertActivity();
                    $this -> revertTransaction();
					$this -> lists();
                }else{
					$this -> lists();
				}

			}

		} catch (Exception $e) {
			throw $e;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金リストの取得
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function lists() {
		$this -> setResult($this -> accessSelect('LIST_DELETED_TRANSACTION', $this -> getWhere()));
		$this -> setTotal(count($this -> accessSelect('COUNT_DELETED_TRANSACTION', $this -> getWhere())));
	}

    /*-------------------------------------------------------------------------
	* @function_name: makeExportData
	* @parameter	:
	* @return		:
	-------------------------------------------------------------------------*/
    function makeExportData(){
        $rtn  = NO_STRING;

		        if ($this -> lang == "en") {
		        	$rtn  = ',,Withdrawal Account Information,,,,,Deposit Account Information,,,,,,' . "\n";
		        	$rtn .= 'Processing Date,Transaction Number,Transaction Type,Name,Account Number,Currency,Amount,Fee,Name,Account Number,Currency,Amount,Fee,Type' . "\n";
		        } else {
		        	$rtn  = ',,出金口座情報,,,,,入金口座情報,,,,,,' . "\n";
		        	$rtn .= '処理時間,取引番号,取引科目,名前,口座番号,通貨,金額,手数料,名前,口座番号,通貨,金額,手数料,種別' . "\n";
		        }

        $rtn .= $this -> getExportDetails();

        return $rtn;
    }

    /*-------------------------------------------------------------------------
	* @function_name: exportData
	* @parameter	:
	* @return		:
	-------------------------------------------------------------------------*/
    function exportData(){
        $fileName = 'Deleted Transactions_' . str_replace("/", "", date("Ymd"));

        header('Content-Encoding: UTF-8');
        header("Content-type: text/csv; charset=UTF-8");
        header('Content-Disposition: attachment; filename="' . $fileName . '.csv"');
        header('Content-Transfer-Encoding: binary');

        echo "\xEF\xBB\xBF";

        echo trim($this -> makeExportData());
        exit();
    }

    /*-------------------------------------------------------------------------
	* @function_name: insertActivity
	* @parameter	:
	* @return		:
	-------------------------------------------------------------------------*/
	function insertActivity(){
		$this -> accessModify('INSERT_ACTIVITY', $this -> getActivity());
	}

}
?>
