<?php
require_once(SYSTEM_LOGICS . 'account_edit/logic.php');

class ControlAccountEdit extends LogicAccountEdit {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: コントロールパネルシステム動画データ編集ロジック（各クラス共通）
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function action() {
		try {
		    $this -> checkAvailability("system", function(){
		        require_once($this -> getSystemHTML('TEMPLATE_MAINTENANCE_MODE_SYSTEM_PATH'));
		        exit();
		    });
		    
			// アクション実行
			$this -> logic();
			if($this -> getType()		== CONTROL_ACTION
				|| $this -> getType()	== NO_STRING
				|| $this -> getType()	== TYPE_UNLOCK
				|| $this -> getType()	== TYPE_LINK_ACCOUNT //Mikko 2019
				|| $this -> getType()	== TYPE_REMOVE_LINK //Mikko 2019
				|| $this -> getType()	== TYPE_CARD
				|| $this -> getType()	== TYPE_SEARCH
				|| $this -> getType()	== TYPE_REMOVE_CARD) {	// 詳細表示
				
				require_once($this -> getSystemHTML('TEMPLATE_ACCOUNT_EDIT_PATH', $this -> dispHTML()));
				
			} else if($this -> getType() == TYPE_INPUT) {		// 詳細編集
				
				require_once($this -> getSystemHTML('TEMPLATE_ACCOUNT_EDIT_INPUT_PATH', $this -> dispHTML()));
	
			} else if($this -> getType() == TYPE_INPUT_ACCESS) {		// 詳細編集
				
				require_once($this -> getSystemHTML('TEMPLATE_ACCOUNT_EDIT_INPUT_PAYMENT_ACCESS_PATH', $this -> dispHTML()));

			} else if($this -> getType() == TYPE_COMPLETE) {	// 詳細編集完了
				
				require_once($this -> getSystemHTML('TEMPLATE_ACCOUNT_EDIT_PATH', $this -> dispHTML()));

			} else if($this -> getType() == TYPE_SAVE) {		// ユーザメモ保存
				
				require_once($this -> getSystemHTML('TEMPLATE_ACCOUNT_EDIT_PATH', $this -> dispHTML()));

			}else if($this -> getType() == TYPE_SAVE_RISK) {		// ユーザメモ保存
				
				require_once($this -> getSystemHTML('TEMPLATE_ACCOUNT_EDIT_PATH', $this -> dispHTML()));

			} else if($this -> getType() == TYPE_CONFIRM) {		// 削除の確認
				
				require_once($this -> getSystemHTML('TEMPLATE_ACCOUNT_EDIT_CONFIRM_PATH', $this -> dispHTML()));

			} else if($this -> getType() == TYPE_DELETE) {		// 削除完了
				
				require_once($this -> getSystemHTML('TEMPLATE_ACCOUNT_EDIT_COMPLETE_PATH', $this -> dispHTML()));

			} else if($this -> getType() == TYPE_ROLL_BACK) {	// KYC書類の差戻し
				
				require_once($this -> getSystemHTML('TEMPLATE_ACCOUNT_EDIT_PATH', $this -> dispHTML()));

			} else if($this -> getType() == TYPE_SEND) {		// 認証メールの再送信
				
				require_once($this -> getSystemHTML('TEMPLATE_ACCOUNT_EDIT_PATH', $this -> dispHTML()));

			} else if($this -> getType()				== TYPE_ADMIN_KYC_UPLOAD
						&& $this -> getAccountType()	== VAR_CORP) {						// KYC登録（法人）
							
					require_once($this -> getSystemHTML('TEMPLATE_SETTING_KYC_UPLOAD_STEP2', $this -> dispHTML()));
			} else if($this -> getType()				== TYPE_ADMIN_KYC_UPLOAD
						&& $this -> getAccountType()	== VAR_PERSON) {	
							
				require_once($this -> getSystemHTML('TEMPLATE_SETTING_KYC_UPLOAD', $this -> dispHTML()));
			} else if($this -> getType()				== TYPE_ADMIN_PAGING) {	
				
				require_once($this -> getSystemHTML('TEMPLATE_ACCOUNT_EDIT_PAGING_PATH', $this -> dispHTML()));
			} else if ($this -> getType() == TYPE_EXPORT) {
				
				header('Content-Type: application/octet-stream');
				header('Content-Disposition: attachment; filename=Trans_List_' . date('YmdHis') . '.csv');
				header('Content-Transfer-Encoding: binary');
				echo "\xEF\xBB\xBF";
				echo $this -> makeExportData();
			} else {											// 画面の表示（ユーザ一覧）
				throw new Exception(NO_STRING);
			}

		} catch (Exception $e) {
			header('Location: /');
		}
	}
}
?>