<?php
include_once('config.php');

$sys = new System();

// パラメータ
$rtn			= array();
$dId			= $sys -> getDataPost(PARAM_D_ID);
$userAccount	= $sys -> getDataPost(PARAM_USER_ACCOUNT);
$validate		= true;
$lang 			= $sys -> getDataPost("lang");
$msg			= NO_STRING;
$parentCode		= NO_STRING;

// データの取得
$rs = $sys -> accessSelect('SELECT_AGENT', array($dId));

//チェック
if(count($rs) == NO_COUNT) { // エージェントが存在しない
	$msg = ($lang ? 'Agent does not exist' : 'エージェントが存在しません。').'(' . $dId . ',' . $userAccount . ')';
	$validate = false;
}

if($validate) {

	$row = $rs[NO_COUNT];

	// マスターエージェントではない
	if($sys -> getColumnData($row, COLUMN_PARENT_AGENT_CODE) != NO_STRING) {
		$msg = ($lang ? 'Only parent agents can be added' : 'マスターエージェントしか追加はできません。');
		$validate = false;
	}

	$parentCode = $sys -> getColumnData($row, COLUMN_AGENT_CODE);
}

if($validate) {

	$rs = $sys -> accessSelect('SELECT_AGENT', array($userAccount));

	if(count($rs) == NO_COUNT) { // エージェントが存在しない
		$msg = ($lang ? 'There is no child agent' : '子エージェントが存在しません。');
		$validate = false;
	}

	if($validate) {

		$row = $rs[NO_COUNT];

		if($sys -> getColumnData($row, COLUMN_AGENT_FLG) != VAR_FLG_ON) { // エージェントではない
			$msg = ($lang ? 'This user is not an agent' : 'このユーザはエージェントではありません。');
			$validate = false;
		}
	}
}

// データ更新
if($validate) {
	$sys -> accessModify('UPDATE_PARENT_AGENT_CODE', array($userAccount, $parentCode));
}

// 結果送信
if($validate) {
	$rtn['result'] = 'OK';
	$rtn['msg'] = ($lang ? 'Registration complete' : '登録が成功しました。');
} else {
	$rtn['result'] = 'NG';
	$rtn['msg'] = $msg;
}

echo json_encode($rtn);
?>
