<?php
$page_title = "カード入金";
include_once('./config.php');
include_once('template/base_head.php');
?>

<aside id="colLeft">
	<h1><a href="/en/menu"><img src="../img/logo.png" alt="iWallet"></a></h1>
	<?php include_once('template/base_sidebar.php'); ?>
</aside>

<div id="colMain">
	<div class="mainIn">
		<?php include_once('template/base_nav.php'); ?>
		<article>
			<div class="article-heading">
				<h2>
					<?php echo $page_title; ?>
				</h2>
			</div>
			<div class="mb10 pleft40"><?php echo $this -> echoMessage(); ?></div>
			
			<div id="confirm_main_content">
    			<p class="pleft40 mb20 respM">ご記入いただいた申請情報および注意事項をご確認の上、お手続きください。</p>
    
    			<div class="pleft40">
    				
    				<table class="table col bdr default odd  fontM summaryT">
                        <tr>
                            <th style="width: 180px;" colspan="2">入金詳細</th>
                        </tr>
                        <tr>
                            <th style="width: 180px;">入金額</th>
                            <td class="ralign"><?php echo $this -> getCurrency();?>&nbsp;<?php $this -> echoAmount(); ?></td>
                        </tr> 
                        <tr>
                            <th style="width: 180px;">取引手数料</th>
                            <td class="ralign"><?php echo $this -> getCurrency();?>&nbsp;<?php $this -> echoFee(); ?></td>
                        </tr>
                        <tr>
                            <th style="width: 180px;">料金</th>
                            <td class="ralign"><?php echo $this -> getCurrency();?>&nbsp;<?php $this -> echoDepositAmountNatural(); ?></td>
                        </tr>
                  	</table>
    			</div>
    			<br />
    			<br />
                <div class="container_wi650">
                    <ul class="pleft40 ul_list">
                    	<li>取引一回につきご入金額の7%の手数料が発生します。</li>
			            <li>この入金手段は、本人認証サービス（3Dセキュア）が有効化されたVisaまたはMasterCardクレジット / デビット / プリペイドカードをお持ちのエグゼクティブ会員のお客様のみご利用いただけます。</li>
			            <li>お手続き後、ご入金額は即座にお客様のiWallet口座残高に反映されます。</li>
			            <li>取引制限として、1日の取引成功回数は2回まで、1日の合計額上限は1000USDまでとなっております。この制限は最後に成功した取引から２４時間後にリセットされます。</li>
                    </ul>
                    
                    <p class="pleft40" style="margin-top:20px">
            			詳しい使用方法につきましては、
            			<a href="https://www.iwl.hk/jp/guide/card-guide.php" target="_blank"><b>[IWL] Card Deposit Solution Guide_JP</b></a>
            			<br/>
            			をご確認くださいませ。
            		</p>
                    
    			 	<div style="margin-top:20px" class="red pleft40">
    			 		※<span style="font-size:16.5px;">
    			 			<b>重要：</b>本カード入金のご利用はカード明細にて「ALTPAY*NOSAKA CHIBA」と記載されます。
    			 		</span> 
    			 		<br/><br/>
    			 		&nbsp;&nbsp;<input type="checkbox" id="agreementCheckbox" name="agreementCheckbox"/>&nbsp;はい、続行します
    			 		<br/><br/>
    			 		※<span style="font-size:14.5px;">
    			 			実行する場合は、チェックボックスにチェックを入れた上で、[次へ]ボタンを押してください。<br/>
    			 			他の入金手段をご利用いただく場合は、[戻る]ボタンを押すことで、入金方法一覧に戻ることができます。
    			 		</span>
    		 		</div>
                </div>
    			<div class="calign nextwbtn" style="    margin-top: 10px;">
    				<a id="btnBackCCDInput" class="btn bg-default calign">&laquo; 戻る</a>&emsp;
    				<a id="btnCCDComplete" class="btn bg-grad px180 mt10">次へ</a>
    			</div>
			</div>
						
			<form id="acForm" action="" method="post">
			    <input type="hidden" name="type" id="type" />
			    <input type="hidden" name="cdagreementflg" id="cdagreementflg" />
			    <input type="hidden" name="amount" value="<?php $this -> echoAmountPure(); ?>"  />
			    <input type="hidden" name="currency" value="<?php echo $this -> getCurrency(); ?>" />
			    <input type="hidden" name="fee" value="<?php $this -> echoFee() ?>" />
			    <input type="hidden" name="message" value="<?php echo $this -> message; ?>" />
			</form>
			
		</article>
	</div>
</div>
</div>
</div>
<?php include_once('template/base_foot.php'); ?>
</div>
<script src="../js/deposit.js"></script>
</body>
</html>

