<?php
require_once('config.php');

class APICheckTransferBase extends System {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $signature					= NO_STRING;
	private $account					= NO_STRING;
	private $fromAccount				= NO_STRING;	// 送金元口座
	private $toAccount					= NO_STRING;	// 送金先口座
	private $currency					= NO_STRING;	// 通貨
	private $amount						= NO_STRING;	// 金額
	private $debitCurrency				= NO_STRING;	// 引落通貨
	private $debitAmount				= NO_STRING;	// 引落金額
	private $message					= NO_STRING;	// 送金メッセージ
	private $result						= NO_STRING;	// チェック実行結果

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: パスワードの更新
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function action() {

		// 変数宣言部
		$rtn		= array();

		try {

			// パラメータの設定
			$this -> signature					= $this -> getDataPost(PARAM_SIGNATURE);
			$this -> fromAccount				= $this -> getDataPost(PARAM_FROM);							// 送金元口座
			$this -> toAccount					= $this -> getDataPost(PARAM_TO);							// 送金先口座
			$this -> currency					= strtoupper($this -> getDataPost(PARAM_CURRENCY));			// 通貨
			$this -> amount						= $this -> getDataPost(PARAM_AMOUNT);						// 金額
			$this -> debitCurrency				= strtoupper($this -> getDataPost(PARAM_DEBIT_CURRENCY));	// 引落通貨

			// エラーチェック
			return $this -> validate();

		} catch (Exception $e) {
			throw $e;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: エラーチェック
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function validate() {

		// 変数宣言部
		$rs = NO_COUNT;

		try {

			$this -> result = $this -> checkTransfer($this -> fromAccount
													, $this -> toAccount
													, $this -> currency
													, $this -> amount
													, $this -> debitCurrency);

			$rs = $this -> result[PARAM_RESULT];

			if($rs != NO_COUNT) {

				if($rs == VAL_INT_3) {			// 送金元口座の問題
					throw new Exception('E_ERROR_VALUE_AMOUNT_FROM');

				} else if($rs == VAL_INT_1) {	// 送金先口座の問題
					throw new Exception('E_ERROR_VALUE_AMOUNT_TO');

				} else if($rs == VAL_INT_99) {	// パラメータの問題
					throw new Exception('E_ERROR_PARAMETER');

				} else if($rs == VAL_INT_2) {	// 金額の問題
					throw new Exception('E_ERROR_AMOUNT');
				} else {
					throw new Exception('E_FATAL');
				}
			}

			return $this -> result;
		} catch (Exception $e) {
			throw  $e;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 送金通貨の取得
	* @parameter	: なし
	* @return		: 送金通貨
	-------------------------------------------------------------------------*/
	public function getCurrency() {
		return $this -> currency;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金金額の取得
	* @parameter	: なし
	* @return		: 送金金額
	-------------------------------------------------------------------------*/
	public function getToAmount() {
		return $this -> amount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 引き落し通貨の取得
	* @parameter	: なし
	* @return		: 引き落し通貨
	-------------------------------------------------------------------------*/
	public function getDebitCurrency() {
		return $this -> debitCurrency;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金金額の取得
	* @parameter	: なし
	* @return		: To金額
	-------------------------------------------------------------------------*/
	public function getDebitAmount() {
		return $this -> debitAmount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 換金レートの取得
	* @parameter	: なし
	* @return		: 換金レート
	-------------------------------------------------------------------------*/
	public function getRate() {
		return $this -> rate;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 通貨の取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	public function getOriginalAmount() {
		return $this -> originalAmount;
	}

}
?>