<?php
require_once('config.php');

class APICheckRequestBase extends System {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $signature					= NO_STRING;
	private $account					= NO_STRING;
	private $fromAccount				= NO_STRING;	// 送金元口座
	private $currency					= NO_STRING;	// 通貨
	private $amount						= NO_STRING;	// 金額
	private $message					= NO_STRING;	// 送金メッセージ

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: パスワードの更新
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function action() {

		// 変数宣言部
		$rtn		= array();

		try {

			// パラメータの設定
			$this -> signature					= $this -> getDataPost(PARAM_SIGNATURE);
			$this -> account					= $this -> getDataPost(PARAM_USER_ACCOUNT);					// 送金先口座
			$this -> fromAccount				= $this -> getDataPost(PARAM_FROM);							// 送金元口座
			$this -> currency					= strtoupper($this -> getDataPost(PARAM_CURRENCY));			// 通貨
			$this -> amount						= $this -> getDataPost(PARAM_AMOUNT);						// 金額

			// エラーチェック
			return $this -> validate();

		} catch (Exception $e) {
			throw $e;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: エラーチェック
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function validate() {

		// 変数宣言部
		$rs = NO_COUNT;

		try {

			// 申請元口座の存在確認
			$this -> user = $this -> getAccountCommon($this -> account);

			if(count($this -> user) == NO_COUNT) {
				throw new Exception('E_REQUIRED_VALUE');
			}

			// 申請先口座の存在確認
			$this -> user = $this -> getAccountCommon($this -> fromAccount);

			if(count($this -> user) == NO_COUNT) {
				throw new Exception('E_REQUIRED_VALUE');
			}

			// 必須項目
			// 金額のチェック
			if(!$this -> checkNull($this -> amount)) {
				throw new Exception('E_REQUIRED_VALUE');
			}

			// 数値の正規表現
			if(!$this -> checkStringNumber($this -> amount)) {
				throw new Exception('E_ERROR_REGULAR_NUMBER');
			}

			// 最低値と最高値の設定
			if(!$this -> checkRangeCurrency($this -> amount
											, $this -> currency
											, NO_COUNT
											, VAR_MAX_TRANSFER_LIMIT)) {
				throw new Exception('E_ERROR_AMOUNT');
			}

		} catch (Exception $e) {
			throw  $e;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金金額の取得
	* @parameter	: なし
	* @return		: To金額
	-------------------------------------------------------------------------*/
	public function getDebitAmount() {
		return $this -> debitAmount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 換金レートの取得
	* @parameter	: なし
	* @return		: 換金レート
	-------------------------------------------------------------------------*/
	public function getRate() {
		return $this -> rate;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 通貨の取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	public function getOriginalAmount() {
		return $this -> originalAmount;
	}

}
?>