
<?php
require_once(SITE_LOGICS . 'news/model.php');

class LogicNews extends NewsModelClass {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $htmlStr = NO_STRING;	// 表示用HTML文字列

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジック（各クラス共通）
	* @parameter	: なし
	* @return		: TRUE:ロジック成功、FALSE:ロジック失敗
	-------------------------------------------------------------------------*/
	function logic() {

		try {

			// 初期データ処理
			$this -> init();

			// ロジック実行
			$this -> biz();

		} catch (Exception $e) {
			throw $e;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジックの実行
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function biz() {

		// リスト表示
		$this -> lists();

		// 未読リスト
		$rs = $this -> accessSelect('LIST_NEWS_USER_ALL', $this -> getWhere());

		// データ登録
		$this -> regist($rs);

	}

	/*-------------------------------------------------------------------------
	* @function_name: データの取得
	* @parameter	: なし
	* @return		: データ
	-------------------------------------------------------------------------*/
	private function lists() {

		$rs = $this -> accessSelect('LIST_NEWS_USER', $this -> getWhere());
		$this -> setResult($rs);

		return $rs;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: データの登録
	 * @parameter	: なし
	 * @return		: データ登録
	 -------------------------------------------------------------------------*/
	private function regist($rs) {

		if($this -> isLoopData($rs)) {
			foreach ($rs as $row) {
				if($this -> getColumnData($row, COLUMN_NEWS_READ_FLG) == NO_COUNT) {
					// 初期化
					$param = array();

					// パラメータ設定
					$param[] = $this -> getColumnData($row, COLUMN_N_ID);
					$param[] = $this -> getUserAccount();
					$param[] = VAL_INT_1;
					// 登録
					$this -> accessModify('INSERT_NEWS_STATUS', $param, false);
				}
			}
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: ページ出力文字列取得関数
	* @parameter	: なし
	* @return		: HTML文字列
	-------------------------------------------------------------------------*/
	function getDisplay() {
		return $this -> htmlStr;
	}
}
?>