<?php
require_once(SYSTEM_LOGICS . 'api_signature/model.php');

class LogicApiSignature extends ApiSignatureModelClass {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $htmlStr = NO_STRING;	// 表示用HTML文字列

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジック（各クラス共通）
	* @parameter	: なし
	* @return		: TRUE:ロジック成功、FALSE:ロジック失敗
	-------------------------------------------------------------------------*/
	function logic() {

		try {

			// 初期データ処理
			if($this -> init()) {

				if($this -> getType()			== TYPE_INPUT) {	// データの登録
					$this -> select();

				} else if($this -> getType()	== TYPE_CONFIRM) {	// データの確認
					$this -> select();

				} else if($this -> getType()	== TYPE_COMPLETE) {	// データの登録
					$this -> regist();
					$this -> insertActivity();
					$this -> lists();
				} else if($this -> getType()	== TYPE_EDIT) {		// データの修正
					$this -> select();

				} else if($this -> getType()	== TYPE_SAVE) {		// データの保存
					$this -> insertActivity();
					$this -> update();
					$this -> lists();

				} else if($this -> getType()    == TYPE_DELETE) {
				    $this -> insertActivity();
				    $this -> delete();
				    $this -> lists();
				} else {											// 一覧データ
					$this -> lists();
				}
			}

		} catch (Exception $e) {
			throw $e;
		}
	}

	function delete(){
	    $this -> accessModify('DELETE_API_SIGNATURE', array($this -> getAId()));
	}
	
	/*-------------------------------------------------------------------------
	* @function_name: リストの取得
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function lists() {
		//remove _REVISED if want to use old query - mark
		$this -> setResult($this -> accessSelect('LIST_API_SIGNATURE_REVISED', $this -> getWhere()));
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座情報の取得
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function select() {
	    $rs = $this -> getRowData($this -> getAPISignatureCommon($this -> getAId()));
	    	    
	    $userAccount = $this -> getUserAccount();
	    
	    if(count($rs) > 0)
	        $userAccount = $this -> getColumnData($rs, COLUMN_USER_ACCOUNT);
	    
	    $this -> setResult($rs);
	    $this -> setAccount($this -> getAccountCommon($userAccount));
	    
		$this -> restore();
	}

	/*-------------------------------------------------------------------------
	* @function_name: データの登録
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function regist() {
		$this -> accessModify('INSERT_API_SIGNATURE', $this-> getRegistParams());
	}

	/*-------------------------------------------------------------------------
	* @function_name: データの更新
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function update() {
		$this -> accessModify('UPDATE_API_SIGNATURE', $this-> getUpdateParams());
	}

	/*-------------------------------------------------------------------------
	* @function_name: データの更新
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function insertActivity(){
	    if(count($this -> getActivity()) > 0)
	        $this -> accessModify('INSERT_ACTIVITY', $this -> getActivity());
	}
}
?>