<?php
//-----------------------------------------------------------------------//
// コアファイル群のインクルード
//-----------------------------------------------------------------------//
$root = explode('/', $_SERVER['REQUEST_URI']);

require_once(LIBRARIES_CORE . 'site_keys.php');			// SITE Literals
require_once(LIBRARIES_CORE . 'primary_lits.php');			// Mango Primary Literals
require_once(LIBRARIES_CORE . 'column_keys.php');			// DBカラム名群
require_once(LIBRARIES_CORE . 'control_keys.php');			// コントロールキー群
require_once(LIBRARIES_CORE . 'include_files.php');			// ライブラリインクルード群

// 多言語対応
if(count($root) >= 2) {

	// リテラルファイルが存在した場合そのファイルを利用する
	$literalPath = LIBRARIES_CORE . 'literals_' . $root[count($root) - 2] . '.php';

	if(file_exists($literalPath)) {
		require_once($literalPath);		// リテラル定数群（多言語利用）
	} else {
		require_once(LIBRARIES_CORE . 'literals.php');		// リテラル定数群（デフォルト）
	}

} else {
	require_once(LIBRARIES_CORE . 'literals.php');			// リテラル定数群
}

require_once(LIBRARIES_CORE . 'post_keys.php');				// ポストキー群
require_once(LIBRARIES_CORE . 'variables.php');				// 変数群
function get_ip() {
	if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
		return $_SERVER['HTTP_CLIENT_IP'];
	} elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
		return $_SERVER['HTTP_X_FORWARDED_FOR'];
	} else {
		return $_SERVER['REMOTE_ADDR'];
	}
}
?>