<?php
require_once('config.php');
require_once('CheckExchangeBase.php');

class APIMakeExchange extends System {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $signature		= NO_STRING;
	private $account		= NO_STRING;
	private $amount			= NO_STRING;
	private $amountType		= NO_STRING;
	private $fromCurrency	= NO_STRING;
	private $toCurrency		= NO_STRING;
	private $exAmount		= NO_STRING;
	private $fromAmount		= NO_STRING;
	private $toAmount		= NO_STRING;
	private $rate			= NO_STRING;
	private $originalAmount	= NO_STRING;
	private $fromBalance	= NO_STRING;
	private $toBalance		= NO_STRING;

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: パスワードの更新
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function action() {

		// 変数宣言部
		$rtn		= array();
		$base		= null;

		try {

			// パラメータの設定
			$this -> signature		= $this -> getDataPost(PARAM_SIGNATURE);
			$this -> account		= $this -> getDataPost(PARAM_USER_ACCOUNT);
			$this -> amount			= $this -> getDataPost(PARAM_AMOUNT);
			$this -> amountType		= $this -> getDataPost(PARAM_AMOUNT_TYPE);
			$this -> fromCurrency	= strtoupper($this -> getDataPost(PARAM_FROM));
			$this -> toCurrency		= strtoupper($this -> getDataPost(PARAM_TO));

			// シグネチャのチェック（デバッグの場合は処理しない）
			if($this -> getDataPost('debug') == NO_STRING) {
				$this -> checkSignature($this -> signature, 'E' . $this -> account);
			}

			// チェッククラスの生成
			$base = new APICheckExchangeBase();
			$base -> action();

			// 変数宣言部
			$original	= NO_COUNT;
			$from		= NO_STRING;
			$to			= NO_STRING;
			$profit		= NO_COUNT;

			// 返却値の追加
			$rtn[PARAM_RATE]		= $base -> getRate();
			$rtn[PARAM_FROM_AMOUNT]	= $base -> currencyToInt($base -> getFromAmount(), $base -> getFromCurrency());
			$rtn[PARAM_TO_AMOUNT]	= $base -> currencyToInt($base -> getToAmount(), $base -> getToCurrency());

			$this -> accessModify('INSERT_EXCHANGE', array($this -> account
															, $base -> getFromCurrency()
															, $base -> currencyToInt($base -> getFromAmount(), $base -> getFromCurrency())
															, $base -> getToCurrency()
															, $this -> currencyToInt($base -> getToAmount(), $base -> getToCurrency())
															, $base -> getRate()
															, $this -> getTransactionNumberCommon(VAR_TRANSACTION_EXCHANGE)));

			// コミッションの設定
			if($this -> amountType == NO_COUNT) {
				$original	= $base -> getOriginalAmount() - $base -> getToAmount();
				$profit		= $this -> currencyToInt($base -> getOriginalAmount(), $base -> getToCurrency());
				$from		= $base -> getFromCurrency();
				$to			= $base -> getToCurrency();

			} else {
				$original 	= $base -> getFromAmount() - $base -> getOriginalAmount();
				$profit		= $this -> currencyToInt($base -> getFromAmount(), $base -> getFromCurrency());
				$from		= $base -> getToCurrency();
				$to			= $base -> getFromCurrency();
			}

			$this -> registCommisionExchange($this -> getUserData(PARAM_USER_ACCOUNT)
											, $from
											, $to
											, $profit);

			// 成功の返却
			$rtn[PARAM_RESULT]	= 'OK';
			$rtn[PARAM_MESSAGE]	= 'I_COMPLETE_PROCESS';

			echo json_encode($rtn);

		} catch (Exception $e) {
			$rtn = array('result'		=> 'NG'
						, 'messages'	=> $e -> getMessage());

			echo json_encode($rtn);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: エラーチェック
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function validate() {
	}
}

$api = new APIMakeExchange();
$api -> action();
?>