<?php
require_once('config.php');

class APIGetAccountBalance extends System {

	/*-------------------------------------------------------------------------
	 * @ メンバ変数
	-------------------------------------------------------------------------*/
	private $signature		= NO_STRING;
	private $currency		= NO_STRING;
	private $userAccount	= NO_STRING;

	/*-------------------------------------------------------------------------
	 * @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		ob_start();
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	 * @function_name: パスワードの更新
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function action() {

		// 変数宣言部
		$rtn		= array();
		$currencies	= null;
		$tmp		= null;

		try {

			// パラメータの設定
			$this -> signature		= $this -> getDataPost(PARAM_SIGNATURE);
			$this -> userAccount	= $this -> getDataPost(PARAM_USER_ACCOUNT);
			$this -> currency		= strtoupper($this -> getDataPost(PARAM_CURRENCY));

			// シグネチャの確認
			if($this -> getDataPost('debug') == NO_STRING) {
// 				$this -> checkSignature($this -> signature, 'B' . $this -> userAccount);
			}

			// エラーチェック
			$this -> validate();

			if($this -> currency == VAL_ALL) {	// 残高データの取得（全通貨）

				$currencies	= $this -> getCurrencyList();
				$tmp		= array();

				if($this -> isLoopData($currencies)) {
					foreach($currencies as $currency) {
						$balance			= $this -> getBalanceCommon($this -> userAccount, $currency[PARAM_DATA_VALUE]);
						$tmp[]				= array(PARAM_CURRENCY => $currency[PARAM_DATA_VALUE], PARAM_BALANCE => $this -> formatCurrency($balance, $currency[PARAM_DATA_VALUE]));
						$rtn[PARAM_BALANCE]	= $tmp;
					}
				}

			} else {	// 残高データの取得（個別通貨）
				$balance			= $this -> getBalanceCommon($this -> userAccount, $this -> currency);
				$rtn[PARAM_BALANCE]	= array(PARAM_CURRENCY => $this -> currency, PARAM_BALANCE => $this -> formatCurrency($balance, $this -> currency));
			}

			// 返却データの設定
			$rtn['result']		= 'OK';
			$rtn['messages']	= 'I_COMPLETE_PROCESS';

			ob_end_clean();
			echo json_encode($rtn);

		} catch (Exception $e) {
			$rtn = array('result'		=> 'NG'
					, 'messages'	=> $e -> getMessage());

			ob_end_clean();
			echo json_encode($rtn);
		}
	}

	/*-------------------------------------------------------------------------
	 * @function_name: エラーチェック
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function validate() {

		// 変数宣言部
		$msgs = array();

		try {
		} catch (Exception $e) {
			throw  $e;
		}
	}
}

$api = new APIGetAccountBalance();
$api -> action();
?>
