<?php
class DepositModelClass extends ModelClassEx {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $rs					= array();		// 結果セット（リスト）
	private $total				= array();		// 結果セット（集計）
	private $detail				= array();		// 結果セット（詳細）
	private $csv				= array();		// CSVデータ
	private $errCsv				= null;			// CSVエラーデータ
	private $errFlg				= NO_COUNT;		// エラーフラグ
	private $currencies			= array();		// 通貨データ
	private $tmpPath			= NO_STRING;	// テンプレートパス
	private $dId				= NO_STRING;	// 入金ID
	private $amount				= NO_STRING;	// 入金額
	private $userName			= NO_STRING;	// ユーザ名
	private $userAccount		= NO_STRING;	// ユーザ口座番号
	private $createTime			= NO_STRING;	// 処理時間
	private $method				= NO_STRING;	// 入金種別
	private $depositMessage		= NO_STRING;	// メッセージ
	private $fee				= NO_STRING;	// 手数料
	private $bankAmount			= NO_STRING;	// 銀行入金額
	private $bankDepositTime	= NO_STRING;	// 銀行着金日
	private $bankName			= NO_STRING;	// 銀行名
	private $importTime			= NO_STRING;	// インポート時間
	private $procUser			= NO_STRING;	// インポート担当者
	private $oldFilename		= NO_STRING;	// 元ファイル名
	private $newFilename		= NO_STRING;	// 元ファイル名
	private $currency			= NO_STRING;	// 通貨
	private $comment			= NO_STRING;	// コメント
	private $agent				= NO_STRING;	// エージェント
	private $tNumber			= NO_STRING;

	// ------------------ 検索系 ------------------//
	private $sEmail				= NO_STRING;	// メールアドレス
	private $sUserAccount		= NO_STRING;	// 口座番号
	private $sFrom				= NO_STRING;	// 開始日
	private $sTo				= NO_STRING;	// 終了日
	private $sFileName			= NO_STRING;	// インポートファイル名
	private $sCurrency			= NO_STRING;	// 通貨
	private $sAcmountCurrency	= NO_STRING;	// 金額通貨
	private $sMin				= NO_STRING;	// 金額最小値
	private $sMax				= NO_STRING;	// 金額最大値
	private $sTransactionNumber	= NO_STRING;	// 取引番号
	private $sBankName			= NO_STRING;	// 銀行名
	private $sProcessFlg		= NO_STRING;
	// ------------------ 検索系 ------------------//

	/**
	 *
	 * anton
	 *
	 */
	public $lang				= NO_STRING;

	/*-------------------------------------------------------------------------
	* @function_name: コントロールパネルシステムindexモデルクラスコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		// スーパークラスコンストラクタ呼び出し
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 初期設定関数
	* @parameter	: なし
	* @return		: 成功:success、失敗:error
	-------------------------------------------------------------------------*/
	public function init() {

		try {

			// パラメータの設定
			$this -> setParameter();

			// チェック
			return $this -> validate();
		} catch (Exception $e) {
			throw new Exception(NO_STRING);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: パラメータの設定
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function setParameter() {
		$this -> tmpPath			= $this -> getDataPost(PARAM_TMP_PATH, true);				// テンプレートパス
		$this -> dId				= $this -> getDataPost(PARAM_D_ID, true);					// 入金ID
		$this -> amount				= $this -> getDataPost(PARAM_AMOUNT, true);				// 入金額
		$this -> userName			= $this -> getDataPost(PARAM_USER_NAME, true);			// ユーザ名
		$this -> userAccount		= $this -> getDataPost(PARAM_USER_ACCOUNT, true);			// ユーザ口座番号
		$this -> createTime			= $this -> getDataPost(PARAM_D_ID, true);					// 処理時間
		$this -> method				= $this -> getDataPost(PARAM_D_ID, true);					// 入金種別
		$this -> depositMessage		= $this -> getDataPost(PARAM_D_ID, true);					// メッセージ
		$this -> fee				= $this -> getDataPost(PARAM_D_ID, true);					// 手数料
		$this -> bankAmount			= $this -> getDataPost(PARAM_D_ID, true);					// 銀行入金額
		$this -> bankDepositTime	= $this -> getDataPost(PARAM_D_ID, true);					// 銀行着金日
		$this -> bankName			= $this -> getDataPost(PARAM_D_ID, true);					// 銀行名
		$this -> createTime			= $this -> getDataPost(PARAM_D_ID, true);					// インポート時間
		$this -> procUser			= $this -> getDataPost(PARAM_D_ID, true);					// インポート担当者
		$this -> oldFilename		= $this -> getDataPost(PARAM_D_ID, true, true);					// 元ファイル名
		$this -> comment			= $this -> getDataPost(PARAM_COMMENT, true);				// コメント
		$this -> newFilename		= $this -> getDataPost(PARAM_NEW_FILENAME, true, true);			// 新ファイル名

		// ------------------ 検索系 ------------------//
		$this -> sEmail				= $this -> getDataPost(PARAM_S_EMAIL, true);				// メールアドレス
		$this -> sUserAccount		= $this -> getDataPost(PARAM_S_ACCOUNT, true);			// 口座番号
		$this -> sFrom				= $this -> getDataPost(PARAM_S_FROM, true);				// 開始日
		$this -> sTo				= $this -> getDataPost(PARAM_S_TO, true);					// 終了日
		$this -> sFileName			= $this -> getDataPost(PARAM_S_FILE_NAME, true);			// インポートファイル名
		$this -> sCurrency			= $this -> getDataPost(PARAM_S_CURRENCY, true);			// 通貨
		$this -> sAcmountCurrency	= $this -> getDataPost(PARAM_S_ACMOUNT_CURRENCY, true);	// 金額通貨
		$this -> sMin				= $this -> getDataPost(PARAM_S_MIN_AMOUNT, true);			// 金額最小値
		$this -> sMax				= $this -> getDataPost(PARAM_S_MAX_AMOUNT, true);			// 金額最大値
		$this -> sTransactionNumber	= $this -> getDataPost(PARAM_TRANSACTION_NUMBER, true);	// 取引番号
		$this -> sBankName			= $this -> getDataPost(PARAM_S_BANK, true);				// 銀行名
		$this -> sProcessFlg        = $this -> getDataPost(PARAM_S_PROCESS_FLG, true);
		$this -> testAccountFlg		= $this -> getDataPost(PARAM_TEST_ACCOUNT_FLG, true);			// WLID
		// ------------------ 検索系 ------------------//

		$this -> lang				= $this -> getLangage();
	}

	/*-------------------------------------------------------------------------
	* @function_name: パラメータの再設定
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function restore() {
		$this -> currency			= $this -> detail[COLUMN_CURRENCY];				// 通貨
		$this -> amount				= $this -> detail[COLUMN_AMOUNT];				// 入金額
		$this -> userName			= $this -> detail[COLUMN_USER_NAME];			// ユーザ名
		$this -> userAccount		= $this -> detail[COLUMN_USER_ACCOUNT];			// ユーザ口座番号
		$this -> createTime			= $this -> detail[COLUMN_CREATE_TIME_STRING];	// 処理時間
		$this -> method				= $this -> detail[COLUMN_METHOD];				// 入金種別
//		$this -> method				= '銀行送金';									// 入金種別
		$this -> depositMessage		= $this -> detail[COLUMN_MESSAGE];				// メッセージ
		$this -> fee				= $this -> detail[COLUMN_FEE];					// 手数料
		$this -> bankAmount			= $this -> detail[COLUMN_DEPOSIT_BANK];			// 銀行入金額
		$this -> bankDepositTime	= $this -> detail[COLUMN_DEPOSIT_DATE];			// 銀行着金日
		$this -> bankName			= $this -> detail[COLUMN_DEPOSIT_BANK];			// 銀行名
		$this -> importTime			= $this -> detail[COLUMN_CREATE_TIME_STRING];	// インポート時間
		$this -> procUser			= $this -> detail[COLUMN_PROCESS_USER_NAME];	// インポート担当者
		$this -> oldFilename		= $this -> detail[COLUMN_OLD_FILENAME];			// 元ファイル名
		$this -> comment			= $this -> detail[COLUMN_COMMENT];				// コメント
		$this -> tNumber			= $this -> detail[COLUMN_TRANSACTION_NUMBER];				// コメント
	}

	/*-------------------------------------------------------------------------
	* @function_name: サーバ側データチェック
	* @parameter	: なし
	* @return		: TRUE:成功、FALSE:失敗
	-------------------------------------------------------------------------*/
	public function validate() {

		// 変数宣言部
		$rtn		= true;
		$path		= NO_STRING;
		$errorFlg	= true;

		// ログインチェック
		if(!$this -> checkAdminUserLogin()) {
			throw new Exception(NO_STRING);
		}

		/**
		 *
		 * -- anton --
		 * 04/22/2019
		 *
		 */
		$redirect = ($this -> lang != "en" ? "" : "{$this -> lang}/");

		//check access
		if(!$this -> checkAdminUserAccess('DPTP', array(''))){
			$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_PAGE_ACCESS', array());
			header('Location: /'.$redirect.'menu');
			exit();
		}

		if($this -> getType() == TYPE_IMPORT) {
			//check access
			if(!$this -> checkAdminUserAccess('DPTP', array('','3'))){
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_FUNCTION_ACCESS', array());
				header('Location: /'.$redirect.'menu');
				exit();
			}
		}

		if($this -> getType() == TYPE_DETAIL) {
			//check access
			if(!$this -> checkAdminUserAccess('DPDT', array(''))){
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_PAGE_ACCESS', array());
				header('Location: /'.$redirect.'menu');
				exit();
			}
		}

		if($this -> getType() == TYPE_UPDATE) {
			//check access
			if(!$this -> checkAdminUserAccess('DPDT', array('','1'))){
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_FUNCTION_ACCESS', array());
				header('Location: /'.$redirect.'menu');
				exit();
			}
		}
		if($this -> getType() == TYPE_DELETE) {
			//check access
			if(!$this -> checkAdminUserAccess('DPDT', array('','2'))){
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_FUNCTION_ACCESS', array());
				header('Location: /'.$redirect.'menu');
				exit();
			}
		}

		// 送信の時だけチェック
		if($this -> getType() == TYPE_CONFIRM) {	// データのファイルのチェック

			// アプロードチェック
			if(!isset($_FILES)
				|| !isset($_FILES[PARAM_CSV])
				|| !is_uploaded_file($_FILES[PARAM_CSV][PARAM_TMP_NAME])) {

				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NOT_EXIST', array(VAL_STR_UPLOAD_FILE));
				$this -> setType(TYPE_IMPORT);
				$rtn = false;
			}

			if($rtn) {
			    if(!@file_exists(SYSTEM_DOCUMENT_DOPOSIT)){
			        mkdir(SYSTEM_DOCUMENT_DOPOSIT);
			    }

				// ファイルパスの取得
				$path = SYSTEM_DOCUMENT_DOPOSIT . $_FILES[PARAM_CSV][PARAM_NAME];

				// アップロードファイルの移動
				move_uploaded_file($_FILES[PARAM_CSV][PARAM_TMP_NAME], $path);

				// CSV読み込み
				$this -> tmpPath = $path;
				$this -> load($this -> tmpPath);

				// ファイル名の設定
				$this -> newFilename =  $this -> createUId();

				// CSV成形
				$errorFlg = $this -> shapeCsv();
			}

			// エラーがあった場合
			if(!$errorFlg) {
				// エラーメッセージ表示
				$this -> popUpSessionMessage(WARNING, 'W_NOT_EXECUTE_DATA', array());

				// エラーCSVの生成
				$this -> touchErrorCsv($this -> errCsv);
			}

		}

		return true;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: エラーCSVの作成
	 * @parameter	: なし
	 * @return		: なし
	 -------------------------------------------------------------------------*/
	public function touchErrorCsv($data) {

		// エラーファイル名の設定
		$filename = $this -> newFilename . '_err.csv';

		// ファイルパスの設定
		$path = SYSTEM_DOCUMENT_DOPOSIT_ERROR . $filename;

		// ファイルの作成
		touch($path);
		chmod($path, 0777);

		// ファイルオープン
		$file = fopen($path, "w");

		// 書き込み
		if($file){
			foreach ($data as $row) {
			fputcsv($file, $row);
			}
		}

		// ファイルクローズ
		fclose($file);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 検索条件パラメータの取得
	* @parameter	: なし
	* @return		: 検索条件パラメータ
	-------------------------------------------------------------------------*/
	public function getWhere() {

		// 変数宣言部
		$rtnParams = array();

		if($this -> sTransactionNumber != NO_STRING) {	// メールアドレス
			$rtnParams[] = ' deposit.transaction_number = (\')' . $this -> sTransactionNumber . '(\') ';
		}

		if($this -> sEmail != NO_STRING) {				// メールアドレス
			$rtnParams[] = ' users.mail = (\')' . $this -> sEmail . '(\') ';
		}

		if($this -> sUserAccount != NO_STRING) {		// 口座番号
			$rtnParams[] = ' users.user_account = (\')' . $this -> sUserAccount . '(\') ';
		}

		if($this -> sProcessFlg != NO_STRING){
			if($this -> sFrom != NO_STRING) {				// 開始日
				$rtnParams[] = ' deposit.create_time >= (\')' . $this -> sFrom . ' 00:00:00(\') ';
			}

			if($this -> sTo != NO_STRING) {					// 終了日
				$rtnParams[] = ' deposit.create_time < (\')' . date('Y-m-d H:i:s', strtotime($this -> sTo . ' +1 days')) . '(\') ';
			}
		} else{	
			$dateFrom = strtotime("-3 month", time());	
			$dateFrom = date("Y-m-d h:m:s", $dateFrom);	
			$dateTo = date("Y-m-d h:m:s");	
			$rtnParams[] = ' deposit.create_time >= (\')' . $dateFrom . '(\')';	
			$rtnParams[] = ' deposit.create_time < DATE_ADD((\')' . $dateTo . '(\'), INTERVAL 1 DAY)';
		}

		if($this -> sFileName != NO_STRING) {			// インポートファイル名
			$rtnParams[] = ' deposit.old_filename LIKE (\')%' . $this -> sFileName . '%(\') ';
		}

		if($this -> sCurrency != NO_STRING) {			// 通貨
			$rtnParams[] = ' deposit.currency = (\')' . $this -> sCurrency . '(\') ';
		}

		if($this -> sBankName != NO_STRING) {			// 銀行名
			$rtnParams[] = ' deposit.deposit_bank LIKE (\')%' . $this -> sBankName . '%(\') ';
		}

		if($this -> sMin != NO_STRING) {				// 金額最小値

			if($this -> sCurrency != NO_STRING) {		// 通貨指定されている場合
				$rtnParams[] = ' deposit.amount >= (\')' . $this -> currencyToInt($this -> sMin, $this -> sCurrency) . '(\') ';;
			} else {
				$rtnParams[] = ' deposit.amount >= (\')' . $this -> sMin . '(\') ';
			}
		}

		if($this -> sMax != NO_STRING) {				// 金額最大値

			if($this -> sCurrency != NO_STRING) {		// 通貨指定されている場合
				$rtnParams[] = ' deposit.amount <= (\')' . $this -> currencyToInt($this -> sMax, $this -> sCurrency) . '(\') ';;
			} else {
				$rtnParams[] = ' deposit.amount <= (\')' . $this -> sMax . '(\') ';
			}
		}

		if($this -> testAccountFlg != NO_STRING) {
			$rtnParams[] .= 'users.test_account_flg = (\')' . $this -> testAccountFlg . '(\')';
		}

		// 検索条件の結合
		if(count($rtnParams) > NO_COUNT) {
			return DELIMIT_AND . implode(DELIMIT_AND, $rtnParams);
		} else {
			return NO_STRING;
		}
	}


	public function getWhere_new() {

		// 変数宣言部
		$rtnParams = array();

		if($this -> sTransactionNumber != NO_STRING) {	// メールアドレス
			$rtnParams[] = ' deposit.transaction_number = (\')' . $this -> sTransactionNumber . '(\') ';
		}

		if($this -> sEmail != NO_STRING) {				// メールアドレス
			$rtnParams[] = ' deposit.mail = (\')' . $this -> sEmail . '(\') ';
		}

		if($this -> sUserAccount != NO_STRING) {		// 口座番号
			$rtnParams[] = ' deposit.user_account = (\')' . $this -> sUserAccount . '(\') ';
		}

		if($this -> sProcessFlg != NO_STRING){
			if($this -> sFrom != NO_STRING) {				// 開始日
				$rtnParams[] = ' deposit.create_time >= (\')' . $this -> sFrom . ' 00:00:00(\') ';
			}

			if($this -> sTo != NO_STRING) {					// 終了日
				$rtnParams[] = ' deposit.create_time < (\')' . date('Y-m-d H:i:s', strtotime($this -> sTo . ' +1 days')) . '(\') ';
			}
		} else{	
			$dateFrom = strtotime("-3 month", time());	
			$dateFrom = date("Y-m-d h:m:s", $dateFrom);	
			$dateTo = date("Y-m-d h:m:s");	
			$rtnParams[] = ' deposit.create_time >= (\')' . $dateFrom . '(\')';	
			$rtnParams[] = ' deposit.create_time < DATE_ADD((\')' . $dateTo . '(\'), INTERVAL 1 DAY)';
		}

		if($this -> sFileName != NO_STRING) {			// インポートファイル名
			$rtnParams[] = ' deposit.old_filename LIKE (\')%' . $this -> sFileName . '%(\') ';
		}

		if($this -> sCurrency != NO_STRING) {			// 通貨
			$rtnParams[] = ' deposit.currency = (\')' . $this -> sCurrency . '(\') ';
		}

		if($this -> sBankName != NO_STRING) {			// 銀行名
			$rtnParams[] = ' deposit.deposit_bank LIKE (\')%' . $this -> sBankName . '%(\') ';
		}

		if($this -> sMin != NO_STRING) {				// 金額最小値

			if($this -> sCurrency != NO_STRING) {		// 通貨指定されている場合
				$rtnParams[] = ' deposit.amount >= (\')' . $this -> currencyToInt($this -> sMin, $this -> sCurrency) . '(\') ';;
			} else {
				$rtnParams[] = ' deposit.amount >= (\')' . $this -> sMin . '(\') ';
			}
		}

		if($this -> sMax != NO_STRING) {				// 金額最大値

			if($this -> sCurrency != NO_STRING) {		// 通貨指定されている場合
				$rtnParams[] = ' deposit.amount <= (\')' . $this -> currencyToInt($this -> sMax, $this -> sCurrency) . '(\') ';;
			} else {
				$rtnParams[] = ' deposit.amount <= (\')' . $this -> sMax . '(\') ';
			}
		}

		if($this -> testAccountFlg != NO_STRING) {
			$rtnParams[] .= 'users.test_account_flg = (\')' . $this -> testAccountFlg . '(\')';
		}

		// 検索条件の結合
		if(count($rtnParams) > NO_COUNT) {
			return DELIMIT_AND . implode(DELIMIT_AND, $rtnParams);
		} else {
			return NO_STRING;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function dispHTML() {
		return array();
	}

	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function echoList() {

		// 変数宣言部
		$rtn	= NO_STRING;
		$exist	= NO_STRING;
		$err	= NO_STRING;
		$amount	= NO_STRING;

		if($this -> isLoopData($this -> rs)) {

			// データの数だけループを回す
			$start		= 	($this -> getTargetPage() - VAL_INT_1) * VAR_DEFAULT_PAGE_COUNT;
			$end		= $this -> getTargetPage() * VAR_DEFAULT_PAGE_COUNT;
			$listCount	= count($this -> rs);

			for($cnt = $start; $cnt < $end && $cnt < $listCount; $cnt++) {

				$row = $this -> getRowData($this -> rs, $cnt);

				
				
				// 存在の表示
				if($this -> getColumnData($row, COLUMN_USER_NAME) == NO_STRING) {
					$exist = VAL_STR_ADMIN_NOEXIST;
				} else {
					$exist = VAL_STR_ADMIN_EXIST;
				}

				// エラーファイルの表示
				if($this -> getColumnData($row, COLUMN_ERR_FLG) == NO_COUNT) {
					$err = VAL_STR_ADMIN_NOERROR;
				} else {
					$err = '<a id="linkDownload" href="javascript:fileDownloadError(\'' . $this -> getColumnData($row, COLUMN_D_ID) . '\');">エラーあり</a>';
				}

				$rtn	.= '<tr>'
							. '<td>' . $this -> getColumnData($row, COLUMN_CREATE_TIME) . '</td>'
							. '<td class=""><a href="javascript:void(0);" onclick="actionDetail(\'' . $this -> getColumnData($row, COLUMN_D_ID) . '\', \'_blank\');">' . $this -> getColumnData($row, COLUMN_TRANSACTION_NUMBER) . '</td>'
							// . '<td><a href="javascript:userDetail(\'' . $this -> getColumnData($row, COLUMN_USER_ACCOUNT) . '\', \'_blank\');">' . $this -> getColumnData($row, COLUMN_USER_ACCOUNT) . '</a></td>'
							. '<td><a href="account_edit?detail_account=' . $this -> getColumnData($row, COLUMN_USER_ACCOUNT) . '">'. $this -> getColumnData($row, COLUMN_USER_ACCOUNT) .'</a></td>'
							. '<td>' . $this -> getColumnData($row, COLUMN_CURRENCY) . '</td>'
							. '<td class="r">' . number_format($this -> intToCurrency($this -> getColumnData($row, COLUMN_AMOUNT), $this -> getColumnData($row, COLUMN_CURRENCY)), $this -> getColumnData($row, COLUMN_DIGIT)) . '</td>'
							. '<td class="r">' . $this -> getAmountString($this -> getColumnData($row, COLUMN_FEE), $this -> getColumnData($row, COLUMN_CURRENCY)) . '</td>'

							. '<td>' . $this -> getColumnData($row, COLUMN_DEPOSIT_BANK) . '</td>'
							. '<td>' . $this -> getColumnData($row, COLUMN_DEPOSIT_DATE) . '</td>'
							. '<td><a id="linkDownload" href="javascript:fileDownload(\'' . $this -> getColumnData($row, COLUMN_D_ID) . '\');">' . $this -> getColumnData($row, COLUMN_OLD_FILENAME) . '</a></td>'
							. '<td>' . $err . '</td>'
							. '<td>' . $exist . '</td>'
							. '</tr>';
			}
		} else {
			$rtn = '<tr><td colspan="11">' . $this -> getMessage(INFO, 'I_NO_SUCHE_SEARCH_DATA', array()) . '</td></tr>';
		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function echoTotalList() {

		// 変数宣言部
		$rtn		= NO_STRING;
		$lists		= array();
		$counter	= NO_STRING;
		$data		= NO_STRING;
		$cName		= NO_STRING;
		$amount		= NO_STRING;

		// データを入れ替える
		if($this -> isLoopData($this -> total)) {
			foreach($this -> total as $row) {
				$lists[$this -> getColumnData($row, COLUMN_CURRENCY)] = $row;
			}
		}

		foreach($this -> currencies as $row) {

			if(isset($lists[$this -> getColumnData($row, COLUMN_CURRENCY_NAME)])) {

				$cName	= $this -> getColumnData($row, COLUMN_CURRENCY_NAME);
				$amount	= $this -> getColumnData($lists[$this -> getColumnData($row, COLUMN_CURRENCY_NAME)], COLUMN_AMOUNT);

				$counter	= number_format($this -> getColumnData($lists[$cName], COLUMN_USER_ACCOUNT));
				$data		= number_format($this -> intToCurrency($amount, $cName), $this -> getDigitCount($cName));
			} else {
				$counter	= NO_COUNT;
				$data		= number_format(NO_COUNT, $this -> getColumnData($row, COLUMN_DIGIT));

			}

			$rtn .=	'<tr>'
					. '<td>' . $this -> getColumnData($row, COLUMN_CURRENCY_NAME) . '</td>'
					. '<td>' . $counter . '</td>'
					. '<td class="r">' . $data . '</td>'
					. '</tr>';
		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 入金IDの取得
	* @parameter	: なし
	* @return		: 入金ID
	-------------------------------------------------------------------------*/
	public function echoDId() {
		echo $this -> dId;
	}

	/*-------------------------------------------------------------------------
	* @function_name: CSVデータの取得
	* @parameter	: なし
	* @return		: CSVデータ
	-------------------------------------------------------------------------*/
	public function getCsv() {
		// 成形する
		$this -> shapeCsv();
		return $this -> csv;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 入力用CSVデータの取得
	 * @parameter	: なし
	 * @return		: CSVデータ
	 -------------------------------------------------------------------------*/
	public function shapeCsv() {

		// 変数宣言部
		$csv		= null;
		$path		= NO_STRING;
		$cnt		= NO_COUNT;
		$rs			= null;
		$errorFlg	= true;
		$statusStr	= array();
		$msg		= NO_STRING;
		$errCnt		= NO_COUNT;
		$cList 		= $this -> getCurrencyList();	// 通貨リスト

		if(count($this -> csv) > NO_COUNT) {
			
			
			$csv = $this -> csv;

			// CSV行数分ループ
			for($cnt = NO_COUNT; $cnt < count($csv); $cnt++) {

				// 行データの取得
				$row = $csv[$cnt];

				if(count($row) == VAL_INT_7) {

					// 初期化
					$dataFlg 	= true;
					$statusStr 	= array();
					$msg 		= NO_STRING;

					// 口座番号のチェック
					$rs = $this -> accessSelect('SELECT_USER_BY_ACCOUNT', array($row[NO_COUNT]));

					if($this -> isLoopData($rs)) {
						$row[]	= $rs[NO_COUNT][COLUMN_USER_NAME];
					} else {
						$row[]	= '&nbsp;';
						$statusStr[] ='[口座番号]：ユーザが存在しません';
						$errorFlg = false;
					}

					// 通貨のチェック
					if(!$this -> checkNull($row[VAL_INT_1])) {
						$statusStr[] ='[金額]：通貨が入力されていません';
						$errorFlg = false;
					// 通貨の正規表現チェック
					} else {
						$activeCurrencyFlg = false;
						foreach ($cList as $key => $value) {
							if($value[PARAM_DATA_VALUE] == $row[VAL_INT_1]) {
								$activeCurrencyFlg = TRUE;
							}
						}
						if(!$activeCurrencyFlg) {
							$statusStr[] ='[金額]：不正な通貨が入力されています';
							$errorFlg = false;
						}
					}

					// 金額の入力チェック
					if(!$this -> checkNull($row[VAL_INT_2])) {
						$statusStr[] ='[金額]：金額が入力されていません';
						$errorFlg = false;
					// 金額の正規表現チェック
					} else if(!$this -> checkNumber($row[VAL_INT_2])
								|| !$this -> checkStringNumber($row[VAL_INT_2])) {
						$statusStr[] ='[金額]：金額は数字ではありません';
						$errorFlg = false;
					// 金額の整数チェック
					} else if($row[VAL_INT_2] < 0.01) {
						$statusStr[] ='[金額]：金額は0.01以上を入力して下さい';
						$errorFlg = false;
					// 金額の小数点チェック
					} else {
						// JPYの場合
						if($row[VAL_INT_1] == JPY || $row[VAL_INT_1] == PHP || $row[VAL_INT_1] == IDR || $row[VAL_INT_1] == MYR || $row[VAL_INT_1] == THB || $row[VAL_INT_1] == VND) {
							if(strstr($row[VAL_INT_2], DELIMIT_DOT)) {
								$statusStr[] ='[金額]：整数で入力してください';
								$errorFlg = false;
							}
						} else {

							$amountDecArr = explode('.', $row[VAL_INT_2]);
							if(isset($amountDecArr[VAL_INT_1])) {
								if(strlen($amountDecArr[VAL_INT_1]) > VAL_INT_2) {
									$statusStr[] ='[金額]：金額は小数点第2位までの数字を入力してください';
									$errorFlg = false;
								}
							}
						}
					}

					// 処理日時の入力チェック
					if(!$this -> checkNull($row[VAL_INT_3])) {
						$statusStr[] ='[処理日時]：処理日時が入力されていません';
						$errorFlg = false;
					} else
					// 処理日時の数字チェック
					if(!$this -> checkNumber($row[VAL_INT_3])) {
						$statusStr[] ='[処理日時]：処理日時は半角数字で入力して下さい';
						$errorFlg = false;
					} else
					// 処理日時の正規表現チェック
					if(strlen($row[VAL_INT_3]) != VAL_INT_8) {
						$statusStr[] ='[処理日時]：処理日時の形式が不正です';
						$errorFlg = false;
					}

					// これまでのチェックがOKならば、日付形式のチェック
					if(count($statusStr) == NO_COUNT) {

						$year	= intval(substr($row[VAL_INT_3], NO_COUNT, VAL_INT_4));
						$month	= intval(substr($row[VAL_INT_3], VAL_INT_4, VAL_INT_2));
						$day	= intval(substr($row[VAL_INT_3], VAL_INT_6, VAL_INT_2));

						if(!$this -> checkDate($year, $month, $day)) {
							$statusStr[] ='[処理日時]：日付が不正です';
							$errorFlg = false;
						}
					}

					// 銀行の入力チェック
					if(!$this -> checkNull($row[VAL_INT_4])) {
						$statusStr[] ='[銀行]：銀行が入力されていません';
						$errorFlg = false;
					}

					// 口座ステータスの制限
					$account = $this -> getRowData($rs);
					if($this -> getColumnData($account, COLUMN_STATUS)		== NO_STRING
						|| $this -> getColumnData($account, COLUMN_STATUS)	== VAL_INT_1
						|| $this -> getColumnData($account, COLUMN_STATUS)	== VAL_INT_5) {
						$statusStr[] ='[口座種別]：この口座へは入金処理はできません';
						$errorFlg = false;
					}

					// 備考文字を成形
					if($this -> isLoopData($statusStr)) {
						foreach ($statusStr as $err) {
							$msg .= '<strong class="red">' . $err . '</strong><br />';
						}
						// エラーCSVに行を追加
						$this -> errCsv[$errCnt] = $row;
						$errCnt ++;

						// CSVエラーフラグ
						$row[]	= VAL_INT_1;

						// エラーフラグ
						$this -> errFlg = VAL_INT_1;

					} else {
						$remarks = VAL_STR_ADMIN_IMPORTABLE;
						$msg = '<strong class="blue">'.$remarks.'</strong>';

						// エラーフラグ
						$row[]	= NO_COUNT;
					}

					// 備考を追加
					$row[] = $msg;

					// データを戻す
					$csv[$cnt] = $row;
				}
			}

			// データを戻す
			$this -> csv = $csv;
		}

		return $errorFlg;
	}

	/*-------------------------------------------------------------------------
	* @function_name: CSVデータの設定
	* @parameter	: CSVデータ
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function setCsv($csv) {
		$this -> csv = $csv;
	}

	/*-------------------------------------------------------------------------
	* @function_name: テンプレートファイルのパス取得
	* @parameter	: なし
	* @return		: テンプレートファイルのパス
	-------------------------------------------------------------------------*/
	public function getTmpPath() {
		return $this -> tmpPath;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: エラーフラグ取得
	 * @parameter	: なし
	 * @return		: エラーフラグ
	 -------------------------------------------------------------------------*/
	public function getErrFlg() {
		return $this -> errFlg;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 手数料取得
	 * @parameter	: なし
	 * @return		: 手数料
	 -------------------------------------------------------------------------*/
	public function getFee($amount, $currency, $account) {

		// 手数料データの取得
		$fee = $this -> getFeeCommon(VAR_DEPOSIT, $amount, $currency, $account);

		// エージェントの取得
		$this -> agent = $fee[PARAM_AGENT_CODE . VAL_INT_1];

		return $fee[$currency . VAL_INT_1];
	}

	/*-------------------------------------------------------------------------
	* @function_name: 通貨の取得
	* @parameter	: なし
	* @return		: 通貨
	-------------------------------------------------------------------------*/
	public function echoCurrency() {
		echo $this -> currency;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 入金額の取得
	* @parameter	: なし
	* @return		: 入金額
	-------------------------------------------------------------------------*/
	public function echoAmount() {
		echo number_format($this -> intToCurrency($this -> amount, $this -> currency), $this -> getDigitCount($this -> currency));
	}

	/*-------------------------------------------------------------------------
	* @function_name: ユーザ名の取得
	* @parameter	: なし
	* @return		: ユーザ名
	-------------------------------------------------------------------------*/
	public function echoUserName() {
		echo '<a href="account_edit?detail_account=' . $this -> userAccount . '" target="_blank">'. $this -> userName . '</a>';
	}

	/*-------------------------------------------------------------------------
	* @function_name: ユーザ口座番号の取得
	* @parameter	: なし
	* @return		: ユーザ口座番号
	-------------------------------------------------------------------------*/
	public function echoUserAccount() {
		echo $this -> userAccount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 処理時間の取得
	* @parameter	: なし
	* @return		: 処理時間
	-------------------------------------------------------------------------*/
	public function echoCreateTime() {
		echo $this -> createTime;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 入金種別の取得
	* @parameter	: なし
	* @return		: 入金種別
	-------------------------------------------------------------------------*/
	public function echoMethod() {
		echo $this -> method;
	}

	/*-------------------------------------------------------------------------
	* @function_name: メッセージの取得
	* @parameter	: なし
	* @return		: メッセージ
	-------------------------------------------------------------------------*/
	public function echoDepositMessage() {
		echo $this -> depositMessage;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 手数料の取得
	* @parameter	: なし
	* @return		: 手数料
	-------------------------------------------------------------------------*/
	public function echoFee() {
		echo $this -> fee;
	}

	/*-------------------------------------------------------------------------
	* @function_name:
	* @parameter	: なし
	* @return		: 手数料
	-------------------------------------------------------------------------*/
	public function echoTransactionNumber() {
		echo $this -> tNumber;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 手数料の取得
	* @parameter	: なし
	* @return		: 手数料
	-------------------------------------------------------------------------*/
	public function dispFee() {
		echo $this -> getAmountString($this -> fee, $this -> currency);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 銀行入金額の取得
	* @parameter	: なし
	* @return		: 銀行入金額
	-------------------------------------------------------------------------*/
	public function echoBankAmount() {
		echo $this -> bankAmount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 銀行着金日の取得
	* @parameter	: なし
	* @return		: 銀行着金日
	-------------------------------------------------------------------------*/
	public function echoBankDepositTime() {
		echo $this -> bankDepositTime;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 銀行名の取得
	* @parameter	: なし
	* @return		: 銀行名
	-------------------------------------------------------------------------*/
	public function echoBankName() {
		echo $this -> bankName;
	}

	/*-------------------------------------------------------------------------
	* @function_name: インポート時間の取得
	* @parameter	: なし
	* @return		: インポート時間
	-------------------------------------------------------------------------*/
	public function echoImportTime() {
		echo $this -> importTime;
	}

	/*-------------------------------------------------------------------------
	* @function_name: インポート担当者の取得
	* @parameter	: なし
	* @return		: インポート担当者
	-------------------------------------------------------------------------*/
	public function echoProcessUser() {
		echo $this -> procUser;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 元ファイル名の取得
	* @parameter	: なし
	* @return		: 元ファイル名
	-------------------------------------------------------------------------*/
	public function echoOldFilename() {
		echo $this -> oldFilename;
	}

	/*-------------------------------------------------------------------------
	* @function_name: コメントの取得
	* @parameter	: なし
	* @return		: コメント
	-------------------------------------------------------------------------*/
	public function echoComment() {
		echo $this -> comment;
	}
	/*-------------------------------------------------------------------------
	* @function_name: echolog
	* @parameter	: なし
	* @return		: コメント
	-------------------------------------------------------------------------*/
	public function echoLog() {
		ini_set( 'display_errors', 0 );
		error_reporting( E_ALL );
		$requestUrl = NO_STRING;
		$responseUrl = NO_STRING;
		$methodFodler = array();
		//get method
		$method = $this -> method;
		//get date
		$date2 = str_replace('/', '-', substr($this -> createTime, 0, 10));
		//set api folder path
		$apiPath     = dirname(SYSTEM_PATH).DIRECTORY_SEPARATOR.'api';
		//set file folder path
		if($this -> method == "CASHFLOWVM"){
			$requestUrl  = $apiPath.DIRECTORY_SEPARATOR.'Logs'.DIRECTORY_SEPARATOR.'cashflow'.DIRECTORY_SEPARATOR.'request'.DIRECTORY_SEPARATOR.'Log_'.$date2.'.log';
			$responseUrl = $apiPath.DIRECTORY_SEPARATOR.'Logs'.DIRECTORY_SEPARATOR.'cashflow'.DIRECTORY_SEPARATOR.'response'.DIRECTORY_SEPARATOR.'Log_'.$date2.'.log';
		}elseif($this -> method == "LBTC"){
			$requestUrl  = $apiPath.DIRECTORY_SEPARATOR.'Logs'.DIRECTORY_SEPARATOR.'SDPayDeposit'.DIRECTORY_SEPARATOR.'deposit_request'.DIRECTORY_SEPARATOR.'Log_'.$date2.'.log';
			$responseUrl  = $apiPath.DIRECTORY_SEPARATOR.'Logs'.DIRECTORY_SEPARATOR.'SDPayDeposit'.DIRECTORY_SEPARATOR.'async_callback'.DIRECTORY_SEPARATOR.'Log_'.$date2.'.log';
		}elseif($this -> method == "Overseas"){
			$requestUrl  = $apiPath.DIRECTORY_SEPARATOR.'Logs'.DIRECTORY_SEPARATOR.'Flat3'.DIRECTORY_SEPARATOR.'Log_'.$date2.'.log';
		}elseif($this -> method == "CUP"){
			$requestUrl  = $apiPath.DIRECTORY_SEPARATOR.'Logs'.DIRECTORY_SEPARATOR.'SDPay'.DIRECTORY_SEPARATOR.'cup_deposit_request'.DIRECTORY_SEPARATOR.'Log_'.$date2.'.log';
			$responseUrl  = $apiPath.DIRECTORY_SEPARATOR.'Logs'.DIRECTORY_SEPARATOR.'SDPay'.DIRECTORY_SEPARATOR.'deposit_cup_response'.DIRECTORY_SEPARATOR.'Log_'.$date2.'.log';
		}elseif($this -> method == "BIT"){
			$requestUrl  = $apiPath.DIRECTORY_SEPARATOR.'Logs'.DIRECTORY_SEPARATOR.'Bitcoin'.DIRECTORY_SEPARATOR.'db_response'.DIRECTORY_SEPARATOR.'Log_'.$date2.'.log';
		}elseif($this -> method == "Help2Pay"){
			$requestUrl  = $apiPath.DIRECTORY_SEPARATOR.'Logs'.DIRECTORY_SEPARATOR.'H2P'.DIRECTORY_SEPARATOR.'deposit_request'.DIRECTORY_SEPARATOR.'Log_'.$date2.'.log';
			$responseUrl  = $apiPath.DIRECTORY_SEPARATOR.'Logs'.DIRECTORY_SEPARATOR.'H2P'.DIRECTORY_SEPARATOR.'deposit_response'.DIRECTORY_SEPARATOR.'Log_'.$date2.'.log';
		}

		$request_content = file_get_contents($requestUrl);
		$response_content = file_get_contents($responseUrl);

		$request_before_tNumber = strstr($request_content, $this -> tNumber, true);
		$response_before_tNumber = strstr($response_content, $this -> tNumber, true);

		//$content_before_comment = strstr($file_content, $this -> comment, true);


		if (false !== $request_before_tNumber && $this -> method == "CASHFLOWVM") { //for CASHFLOWVM

		    $lineCountRequest = count(explode(PHP_EOL, $request_before_tNumber));
		    $lineCountResponse = count(explode(PHP_EOL, $response_before_tNumber));
		    $lineNumberRequest = file($requestUrl);
		    $lineNumberResponse  = file($responseUrl);
		    //echo request
		    echo $lineNumberRequest[$lineCountRequest-1];
		    echo $lineNumberRequest[$lineCountRequest];
		    echo "\n";
		    //echo  response
		    for($i = -2; $i < 61; $i++){
		    	echo $lineNumberResponse[$lineCountResponse+$i];
		    }


		}elseif (false !== $request_before_tNumber && $this -> method == "LBTC") { //for LBTC
			//response
		    $lineCountRequest = count(explode(PHP_EOL, $request_before_tNumber));
		    $lineCountResponse = count(explode(PHP_EOL, $response_before_tNumber));
		    $lineNumberRequest = file($requestUrl);
		    $lineNumberResponse = file($responseUrl);
		    // echo $lineNumber[$lineCount-1];
		    // echo $lineNumber[$lineCount];

		    //request
		    for($i = -1; $i < 19; $i++){
		    	echo $lineNumberRequest[$lineCountRequest+$i];
		    }
		    echo "\n";
		    //response
		    for($i = -1; $i < 3; $i++){
		    	echo $lineNumberResponse[$lineCountResponse+$i];
		    }


		}elseif (false !== $request_before_tNumber && $this -> method == "Overseas") {// for Overseas
		    $lineCount = count(explode(PHP_EOL, $request_before_tNumber));
		    $lineNumber = file($requestUrl);
		    for($i = -4; $i < 2; $i++){
		    	echo $lineNumber[$lineCount+$i];
		    }
		}elseif (false !== $request_before_tNumber && $this -> method == "CUP") { //for CUP
			//request
		    $lineCountRequest = count(explode(PHP_EOL, $request_before_tNumber));
		    $lineCountResponse = count(explode(PHP_EOL, $response_before_tNumber));
		    $lineNumberRequest = file($requestUrl);
		    $lineNumberResponse = file($responseUrl);
		    // echo request
		    for($i = -1; $i < 19; $i++){
		    	echo $lineNumberRequest[$lineCountRequest+$i];
		    }
		    echo "\n";
		    //echo response
		    for($i = -1; $i < 2; $i++){
		    	echo $lineNumberResponse[$lineCountResponse+$i];
		    }

		}elseif (false !== $request_before_tNumber && $this -> method == "BIT") { //for BIT
			//request
		    $lineCount = count(explode(PHP_EOL, $request_before_tNumber));
		    $lineNumber = file($requestUrl);
		    for($i = -2; $i < 1; $i++){
		    	echo $lineNumber[$lineCount+$i];
		    }
		}elseif (false !== $request_before_tNumber && $this -> method == "Help2Pay") { //for Help2Pay
			//request
		    $lineCountRequest = count(explode(PHP_EOL, $request_before_tNumber));
		    $lineCountResponse = count(explode(PHP_EOL, $response_before_tNumber));
		    $lineNumberRequest = file($requestUrl);
		    $lineNumberResponse = file($responseUrl);
		    //request
		    for($i = -2; $i < 1; $i++){
		    	echo $lineNumberRequest[$lineCountRequest+$i];
		    }
		    echo "\n";
		    //response
		    for($i = -1; $i < 1; $i++){
		    	echo $lineNumberResponse[$lineCountResponse+$i];
		    }
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 元ファイル名の取得
	* @parameter	: なし
	* @return		: 元ファイル名
	-------------------------------------------------------------------------*/
	public function getOldFilename() {
		return $this -> oldFilename;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 元ファイル名の取得
	* @parameter	: なし
	* @return		: 元ファイル名
	-------------------------------------------------------------------------*/
	public function getNewFilename() {
		return $this -> newFilename;
	}

	/*-------------------------------------------------------------------------
	* @function_name: エージェントコードの取得
	* @parameter	: なし
	* @return		: エージェントコード
	-------------------------------------------------------------------------*/
	public function getAgentCode() {
		return $this -> agent;
	}



	/*-------------------------------------------------------------------------
	* @function_name: 検索メールアドレスの取得
	* @parameter	: なし
	* @return		: 検索メールアドレス
	-------------------------------------------------------------------------*/
	public function echoSEmail() {
		echo $this -> sEmail;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 検索口座番号の取得
	* @parameter	: なし
	* @return		: 検索口座番号
	-------------------------------------------------------------------------*/
	public function echoSUserAccount() {
		echo $this -> sUserAccount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 検索開始日の取得
	* @parameter	: なし
	* @return		: 検索開始日
	-------------------------------------------------------------------------*/
	public function echoSFrom() {
		echo $this -> sFrom;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 検索終了日の取得
	* @parameter	: なし
	* @return		: 検索終了日
	-------------------------------------------------------------------------*/
	public function echoSTo() {
		echo $this -> sTo;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 検索終了日の取得
	* @parameter	: なし
	* @return		: 検索終了日
	-------------------------------------------------------------------------*/
	public function echoSFileName() {
		echo $this -> sFileName;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 検索終了日の取得
	* @parameter	: なし
	* @return		: 検索終了日
	-------------------------------------------------------------------------*/
	public function echoSMin() {
		echo $this -> sMin;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 検索終了日の取得
	* @parameter	: なし
	* @return		: 検索終了日
	-------------------------------------------------------------------------*/
	public function echoSMax() {
		echo $this -> sMax;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 取引番号の取得
	* @parameter	: なし
	* @return		: 取引番号
	-------------------------------------------------------------------------*/
	public function echoSTransactionNumber() {
		echo $this -> sTransactionNumber;
	}

	function echoTestAccountFlg() {
		echo $this -> dispListOption($this -> getTestAccountList(), $this -> testAccountFlg);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 検索銀行名の取得
	* @parameter	: なし
	* @return		: 検索銀行名
	 -------------------------------------------------------------------------*/
	public function echoSBankName() {
		echo $this -> sBankName;
	}

	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function echoUploadDataList() {

		// 変数宣言部
		$lists		= NO_STRING;
		$dataFlg	= false;

		if(count($this -> csv) > NO_COUNT) {

			// タイトル行の削除
			foreach($this -> csv as $row) {

				if(count($row) == VAL_INT_10) {

					$dataFlg	= true;

					$lists	.= '<tr>'
							. '<td>' . $row[NO_COUNT] . '</td>'					// 口座番号
							. '<td class="r">' . $row[VAL_INT_1] . ' ' . $row[VAL_INT_2] . '</td>'
							. '<td>' . $row[VAL_INT_3] . '</td>'				// 処理日時
							. '<td>' . $row[VAL_INT_4] . '</td>'				// 銀行
							. '<td class="l">' . $row[VAL_INT_5] . '</td>'		// メッセージ
							. '<td class="l">' . $row[VAL_INT_9] . '</td>'		// ステータス
							. '</tr>';
				}
			}

			if(!$dataFlg) {		// CSVはあったけどデータがない
				echo $rtn = '<tr><td colspan="7">' . $this -> getMessage(INFO, 'I_NO_SUCHE_SEARCH_DATA', array()) . '</td></tr>';

			} else {			// データが存在
				echo $lists;
			}
		} else {
			echo $rtn = '<tr><td colspan="7">' . $this -> getMessage(INFO, 'I_NO_SUCHE_SEARCH_DATA', array()) . '</td></tr>';
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 通貨リストの取得
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function echoCurrencyList() {

		// 変数宣言部
		$lists	= array();

		if($this -> isLoopData($this -> currencies)) {

			foreach($this -> currencies as $row) {
				$lists[] = array(PARAM_DATA_KEY			=> $this -> getColumnData($row, COLUMN_CURRENCY_NAME)
									, PARAM_DATA_VALUE	=> $this -> getColumnData($row, COLUMN_CURRENCY_NAME));
			}
		}

		echo $this -> dispListOption($lists, $this -> sCurrency);
	}



	/*-------------------------------------------------------------------------
	* @function_name: 結果セットの設定
	* @parameter	: 結果セット
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function setResult($rs) {
		$this -> rs = $rs;
		//$c = count($this -> rs);
		//echo "<br/><br/>::{$c}::<br/><br/>";
	}

	/*-------------------------------------------------------------------------
	* @function_name: 結果セットの設定
	* @parameter	: 結果セット
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function setTotal($rs) {
		$this -> total = $rs;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 結果セットの設定
	* @parameter	: 結果セット
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function setDetail($rs) {
		$this -> detail = $rs[NO_COUNT];
	}

	/*-------------------------------------------------------------------------
	* @function_name: 通貨データの設定
	* @parameter	: 通貨データ
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function setCurrencies($rs) {
		$this -> currencies = $rs;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 旧ファイル名の設定
	* @parameter	: 旧ファイル名
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function setOldFileName($name) {
		$this -> oldFilename = $name;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 旧ファイル名の設定
	* @parameter	: 旧ファイル名
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function setNewFileName($name) {
		$this -> newFilename = $name;
	}

	/*-------------------------------------------------------------------------
	* @function_name: データ取得用パラメータ
	* @parameter	: なし
	* @return		: データ取得用の配列
	-------------------------------------------------------------------------*/
	public function getDetailDatas() {
		return array($this -> dId, $this -> getAdminUserData(PARAM_UID));
	}

	/*-------------------------------------------------------------------------
	* @function_name: ページャの表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispPager() {
		echo  $this -> getPagerCommon($this -> getTargetPage()
										, $this -> getTotalPageCommon(VAR_DEFAULT_PAGE_COUNT, count($this -> rs))
										, count($this -> rs)
										, NO_STRING
                                        ,true);
	}

	/*-------------------------------------------------------------------------
	* @function_name: コメント更新用のパラメータを取得する
	* @parameter	: なし
	* @return		: コメント更新用のパラメータ
	-------------------------------------------------------------------------*/
	function getUpdateParams() {

		// 変数宣言部
		$rtn = array();

		$rtn[] = $this -> dId;
		$rtn[] = $this -> comment;

		return $rtn;
	}

    /*-------------------------------------------------------------------------
 	* @function_name: makeExportData
	* @parameter	:
	* @return		: string - export data csv format
	-------------------------------------------------------------------------*/
    public function getExportDetails(){
            // 変数宣言部
            $rtn	= NO_STRING;
            $exist	= NO_STRING;
            $err	= NO_STRING;
            $amount	= NO_STRING;

            if($this -> isLoopData($this -> rs)) {

                // データの数だけループを回す
                // $start		= 	($this -> getTargetPage() - VAL_INT_1) * VAR_DEFAULT_PAGE_COUNT;
                // $end		= $this -> getTargetPage() * VAR_DEFAULT_PAGE_COUNT;
                // $listCount	= count($this -> rs);

            	//　anton
            	
            	
                foreach($this -> rs as $row) {
                	$comment = $this -> findWalletAddress($this -> getColumnData($row, COLUMN_COMMENT));
                	$comment = str_replace([",", "\""], " ", $comment);
                	$comment = "\"{$comment}\"";

                    // 存在の表示
                    if($this -> getColumnData($row, COLUMN_USER_NAME) == NO_STRING) {
                    	$exist = VAL_STR_ADMIN_NOEXIST;
                    } else {
                    	$exist = VAL_STR_ADMIN_STORED;
                    }

                    // エラーファイルの表示
                    if($this -> getColumnData($row, COLUMN_ERR_FLG) == NO_COUNT) {
                    	$err = VAL_STR_ADMIN_NOERROR;
                    } else {
                        $err =  $this -> getColumnData($row, COLUMN_D_ID);
                    }

                    $rtn	.= $this -> getColumnData($row, COLUMN_CREATE_TIME) . ','
                                . $this -> getColumnData($row, COLUMN_TRANSACTION_NUMBER) . ','
                                . $this -> getColumnData($row, COLUMN_USER_ACCOUNT) . ','
								. $this -> getValueByList($this -> getTestAccountList(), $this -> getColumnData($row, COLUMN_TEST_ACCOUNT_FLG)) . ','
                                . $this -> getColumnData($row, COLUMN_CURRENCY) . ','
                                . str_replace(',','',number_format($this -> intToCurrency($this -> getColumnData($row, COLUMN_AMOUNT), $this -> getColumnData($row, COLUMN_CURRENCY)), $this -> getColumnData($row, COLUMN_DIGIT))) . ','
                                . str_replace(',', '', $this -> getAmountString($this -> getColumnData($row, COLUMN_FEE), $this -> getColumnData($row, COLUMN_CURRENCY))) . ','
                                . $this -> getColumnData($row, COLUMN_DEPOSIT_BANK) . ','
                                . $this -> getColumnData($row, COLUMN_DEPOSIT_DATE) . ','
                                . $this -> getColumnData($row, COLUMN_OLD_FILENAME) . ','
                                . $err . ','
                                . $exist . ','
                                . $comment . ','
                                . "\n";

                }
            } else {
                $rtn = '';
            }

            return $rtn;
        }

        private function findWalletAddress($managerComment){
        	if (strpos(strtolower($managerComment), 'wallet_address') !== false) {
        		$a = explode("&", $managerComment);
        		foreach($a as $v){
        			if(strpos($v, "wallet_address") === false)
        				continue;

        			if(strpos($v, "wallet_address") === 0){
        				$na = explode("=", $v);
        				return "{$na[1]}";
        			}else{
        				$nstr = substr($v, strpos($v, "wallet_address"));
        				$na = explode("=", $nstr);
        				return "{$na[1]}";
        			}
        		}
        	}else
        		return $managerComment;
        }

     /*-------------------------------------------------------------------------
	* @function_name: dispProcessFlg
	* @parameter	: none
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispProcessFlg() {
		echo '<label>'
				. $this -> makeCheckOne(PARAM_S_PROCESS_FLG
											, PARAM_S_PROCESS_FLG
											, VAL_INT_1
											, NO_STRING, $this -> sProcessFlg)
				. '</label>';
	}

	/*-------------------------------------------------------------------------
	* @function_name: getActivity()
	* @parameter	: none
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function getActivity(){

		$id =  $this -> dId;
		$type = $this -> getType();

   		$row 	 	= $this -> accessSelect('SELECT_DEPOSIT_NUMBER_BY_ID', array($id));
   		$tNumber 	= $this -> getColumnData($row[0], COLUMN_TRANSACTION_NUMBER);
   		$fileName 	= $this -> getColumnData($row[0], COLUMN_OLD_FILENAME);

   		if($type == TYPE_UPDATE){
   			$message = 'Edited administrator note ['.$tNumber.']';
   		}elseif($type == TYPE_DELETE){
   			$message = 'Deleted transaction ['.$tNumber.']';
   		}

		$rtn = array();

		$rtn[] = $this -> getAdminUserData(PARAM_UID);
		$rtn[] = $_SERVER[PARAM_REMOTE_ADDR];
		$rtn[] = $_SERVER[PARAM_HTTP_USER_AGENT];
		$rtn[] = 15;
		$rtn[] = date("Y-m-d H:i:s");
		$rtn[] = $message;

		return $rtn;
	}
}
?>
