<?php
class AccountListModelClass extends ModelClassEx {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $accounts		= null;			// 検索結果
	private $total			= null;			// 検索結果合計数
	private $userData		= null;			// ユーザデータ
	private $csv			= null;			// CSVデータ
	private $trueList		= null;			// CSVデータ（インポート対象データ）
	private $failList		= null;			// CSVデータ（エラー対象データ）
	private $userName		= NO_STRING;	// ユーザ名
	private $accountNumber	= NO_STRING;	// 口座番号
	private $currency		= NO_STRING;	// 通貨
	private $lastName		= NO_STRING;	// 姓
	private $firstName		= NO_STRING;	// 名
	private $birth			= NO_STRING;	// 生年月日
	private $kycFlg			= NO_STRING;	// KYCフラグ
	private $createTime		= NO_STRING;	// 登録日時
	private $status			= NO_STRING;	// 状態
	private $country		= NO_STRING;	// 国
	private $state			= NO_STRING;	// 都道府県
	private $city			= NO_STRING;	// 市区町村
	private $address		= NO_STRING;	// 番地1
	private $address2		= NO_STRING;	// 番地2
	private $zipCode		= NO_STRING;	// 郵便番号
	private $tel			= NO_STRING;	// 電話番号
	private $mail			= NO_STRING;	// メールアドレス
	private $agentCode		= NO_STRING;	// エージェントコード
	private $name			= NO_STRING;	// 氏名
	private $accountType	= NO_STRING;	// 口座種別
	private $from			= NO_STRING;	// 開始日（口座開設日）
	private $to				= NO_STRING;	// 終了日（口座開設日）
	private $loginFrom		= NO_STRING;	// 開始日（最終ログイン日）
	private $loginTo		= NO_STRING;	// 終了日（最終ログイン日）
	private $closeFrom		= NO_STRING;	// 開始日（口座閉鎖日）
	private $closeTo		= NO_STRING;	// 終了日（口座閉鎖日）
	private $detailAccount	= NO_STRING;	// 詳細ユーザ口座番号
	private $crmId			= NO_STRING;	// CRM ID
	private $minAmount		= NO_STRING;	// 残高額（最小値）
	private $maxAmount		= NO_STRING;	// 残高額（最大値）
	private $statuses		= NO_STRING;	// 登録状態
	private $openFlg		= NO_STRING;	// 開設日検索フラグ
	private $loginFlg		= NO_STRING;	// ログイン日検索フラグ
	private $closeFlg		= NO_STRING;	// 閉鎖日検索フラグ
	private $listData		= NO_STRING;	// 表示用データ
	private $id				= NO_STRING;	// 登録用ID
	private $wlId			= NO_STRING;	// WLID

	/**
	 *
	 *  anton
	 *
	 */
	private $lang			= NO_STRING;

	/*-------------------------------------------------------------------------
	* @function_name: コントロールパネルシステムindexモデルクラスコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		// スーパークラスコンストラクタ呼び出し
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 初期設定関数
	* @parameter	: なし
	* @return		: 成功:success、失敗:error
	-------------------------------------------------------------------------*/
	public function init() {

		try {

			// パラメータの設定
			$this -> setParameter();

			// チェック
			$this -> validate();

		} catch (Exception $e) {
			throw new Exception(NO_STRING);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: パラメータの設定
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function setParameter() {
		$this -> userName		= $this -> getDataPost(PARAM_USER_NAME, true);		// ユーザ名
		$this -> currency		= $this -> getDataPost(PARAM_CURRENCY, true);			// 通貨
		$this -> lastName		= $this -> getDataPost(PARAM_LAST_NAME, true);		// 姓
		$this -> firstName		= $this -> getDataPost(PARAM_FIRST_NAME, true);		// 名
		$this -> birth			= $this -> getDataPost(PARAM_BIRTH_YEAR, true);		// 生年月日
		$this -> country		= $this -> getDataPost(PARAM_COUNTRY, true);			// 国
		$this -> state			= $this -> getDataPost(PARAM_STATE, true);			// 都道府県
		$this -> city			= $this -> getDataPost(PARAM_CITY, true);				// 市区町村
		$this -> address		= $this -> getDataPost(PARAM_ADDRESS, true);			// 番地1
		$this -> address2		= $this -> getDataPost(PARAM_ADDRESS_2, true);		// 番地2
		$this -> zipCode		= $this -> getDataPost(PARAM_ZIP_CODE, true);			// 郵便番号
		$this -> tel			= $this -> getDataPost(PARAM_TEL, true);				// 電話番号
		$this -> agentCode		= $this -> getDataPost(PARAM_AGENT_CODE, true);		// エージェントコード
		$this -> accountType	= $this -> getDataPost(PARAM_ACCOUNT_TYPE, true);		// 口座種別
		$this -> mail			= $this -> getDataPost(PARAM_EMAIL, true);			// メールアドレス
		$this -> name			= $this -> getDataPost(PARAM_NAME, true);				// 氏名
		$this -> accountNumber	= $this -> getDataPost(PARAM_USER_ACCOUNT, true);		// 口座番号
		$this -> kycFlg			= $this -> getDataPost(PARAM_KYC_FLG, true);			// KYCフラグ
		$this -> status			= $this -> getDataPost(PARAM_STATUS, true);			// 状態
		$this -> from			= $this -> getDataPost(PARAM_FROM, true);				// 開始日（口座開設日）
		$this -> to				= $this -> getDataPost(PARAM_TO, true);				// 終了日（口座開設日）
		$this -> loginFrom		= $this -> getDataPost(PARAM_LOGIN_FROM, true);		// 開始日（最終ログイン日）
		$this -> loginTo		= $this -> getDataPost(PARAM_LOGIN_TO, true);			// 終了日（最終ログイン日）
		$this -> closeFrom		= $this -> getDataPost(PARAM_CLOSE_FROM, true);		// 開始日（口座閉鎖日）
		$this -> closeTo		= $this -> getDataPost(PARAM_CLOSE_TO, true);			// 終了日（口座閉鎖日）
		$this -> suspensionFrom	= $this -> getDataPost(PARAM_SUSPENSION_FROM, true);		// 開始日（口座閉鎖日）
		$this -> suspensionTo	= $this -> getDataPost(PARAM_SUSPENSION_TO, true);			// 終了日（口座閉鎖日）
		$this -> crmId			= $this -> getDataPost(PARAM_CRM_ID, true);			// CRM ID
		$this -> minAmount		= $this -> getDataPost(PARAM_S_MIN_AMOUNT, true);		// 残高額（最小値）
		$this -> maxAmount		= $this -> getDataPost(PARAM_S_MAX_AMOUNT, true);		// 残高額（最大値）
		$this -> statuses		= $this -> getDataPost(PARAM_STATUSES, true);			// 口座状態
		$this -> openFlg		= $this -> getDataPost(PARAM_OPEN_FLG, true);			// 開設日検索フラグ
		$this -> loginFlg		= $this -> getDataPost(PARAM_LOGIN_FLG, true);		// ログイン日検索フラグ
		$this -> closeFlg		= $this -> getDataPost(PARAM_CLOSE_FLG, true);		// 閉鎖日検索フラグ
		$this -> suspensionFlg	= $this -> getDataPost(PARAM_SUSPENSION_FLG, true);		// 閉鎖日検索フラグ
		$this -> id				= $this -> getDataPost(PARAM_ID, true);				// UID
		$this -> fail			= $this -> getDataPost(PARAM_FAIL, true, true, true);				// インポート失敗ファイル
		$this -> wlId			= $this -> getDataPost(PARAM_WL_ID, true);			// WLID
		$this -> testAccountFlg	= $this -> getDataPost(PARAM_TEST_ACCOUNT_FLG, true);			// WLID
		$this -> setValidateParaments();

		$this -> lang			= $this -> getLangage();
	}

	/*-------------------------------------------------------------------------
	* @function_name: パラメータの再設定
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function restore() {
		$this -> userName		= $this -> userData[COLUMN_USER_NAME];			// ユーザ名
		$this -> accountNumber	= $this -> userData[COLUMN_USER_ACCOUNT];		// 口座番号
		$this -> currency		= $this -> userData[COLUMN_CURRENCY];			// 通貨
		$this -> lastName		= $this -> userData[COLUMN_LAST_NAME];			// 姓
		$this -> firstName		= $this -> userData[COLUMN_FIRST_NAME];			// 名
		$this -> birth			= $this -> userData[COLUMN_BIRTH_STRING];		// 生年月日
		$this -> createTime		= $this -> userData[COLUMN_CREATE_TIME_STRING];	// 登録日時
		$this -> country		= $this -> userData[COLUMN_COUNTRY];			// 国
		$this -> state			= $this -> userData[COLUMN_STATE];				// 都道府県
		$this -> city			= $this -> userData[COLUMN_CITY];				// 市区町村
		$this -> address		= $this -> userData[COLUMN_ADDRESS];			// 番地1
		$this -> address2		= $this -> userData[COLUMN_ADDRESS_2];			// 番地2
		$this -> zipCode		= $this -> userData[COLUMN_ZIP_CODE];			// 郵便番号
		$this -> tel			= $this -> userData[COLUMN_TEL];				// 電話番号
		$this -> agentCode		= $this -> userData[COLUMN_AGENT_CODE];			// エージェントコード
		$this -> accountType	= $this -> userData[COLUMN_ACCOUNT_TYPE];		// 口座種別
		$this -> mail			= $this -> userData[COLUMN_MAIL];				// メールアドレス
		$this -> kycFlg			= $this -> userData[COLUMN_KYC_FLG];			// KYCフラグ
		$this -> status			= $this -> userData[COLUMN_STATUS];				// 状態
		$this -> crmId			= $this -> userData[COLUMN_CRM_ID];				// CRM ID
		$this -> testAccountFlg	= $this -> userData[COLUMN_TEST_ACCOUNT_FLG];				// CRM ID
	}

	/*-------------------------------------------------------------------------
	* @function_name: サーバ側データチェック
	* @parameter	: なし
	* @return		: TRUE:成功、FALSE:失敗
	-------------------------------------------------------------------------*/
	public function validate() {

		// ログインチェック
		if(!$this -> checkAdminUserLogin()) {
			throw new Exception(NO_STRING);
		}

		/**
		 *
		 * -- anton --
		 * 04/22/2019
		 *
		 */
		$redirect = ($this -> lang != "en" ? "" : "{$this -> lang}/");

		//check access
		if(!$this -> checkAdminUserAccess('ULST', array(''))){
			$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_PAGE_ACCESS', array());
			header('Location: /'.$redirect.'menu');
			exit();
		}

		if($this -> getType() == TYPE_IMPORT) {
			//check access
			if(!$this -> checkAdminUserAccess('ULST', array('','3'))){
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_FUNCTION_ACCESS', array());
				header('Location: /'.$redirect.'menu');
				exit();
			}
		}

		if($this -> getType() == TYPE_UPLOAD) {
			// アプロードチェック
			if(!isset($_FILES)
				|| !isset($_FILES[PARAM_CSV])
				|| !is_uploaded_file($_FILES[PARAM_CSV][PARAM_TMP_NAME])) {

				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NOT_EXIST', array(VAL_STR_UPLOAD_FILE));
				$this -> setType(TYPE_IMPORT);
				$rtn = false;
			}
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 行単位チェック
	* @parameter	: チェック対象行
	* @return		: チェック結果
	-------------------------------------------------------------------------*/
	public function validateRow($row) {

		// 変数宣言部
		$rtnArr	= array();
		$val	= NO_STRING;
		$rtn	= NO_STRING;

		// 必須項目チェック
		$val = $this -> getColumnData($row, NO_COUNT);
		if(!$this -> checkNull($val)) {
			$rtnArr[] = $this -> getMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_ACCOUNT_TYPE));
		}

		if($val		!= 'personal'
			&& $val	!= 'corporation') {
			$rtnArr[] = $this -> getMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_ACCOUNT_TYPE));
		}

		// 必須項目（メールアドレス）
		$val = $this -> getColumnData($row, VAL_INT_1);
		if(!$this -> checkNull($val)) {
			$rtnArr[] = $this -> getMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_EMAIL));
		}

		// メールアドレスの正規表現
		if(!$this -> checkStringMailAddress(addslashes($val))) {
			$rtnArr[] = $this -> getMessage(ERROR, 'E_ERROR_REGULAR_EMAIL', array(VAL_STR_EMAIL));
		}

		// メールアドレスの存在確認
		if(!$this -> checkMailAddress($val)) {
			$rtnArr[] = $this -> getMessage(ERROR, 'E_NO_SUCH_ANYTHING_DATA', array(VAL_STR_EMAIL, $val));
		}

		// 必須項目（国籍）
		$val = $this -> getColumnData($row, VAL_INT_2);
		if($this -> checkCountrySpell($val)) {
			$rtnArr[] = $this -> getMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_COUNTRY));
		}

		// 名
		$val = $this -> getColumnData($row, VAL_INT_3);
		if(!$this -> checkNull($val)) {
			$rtnArr[] = $this -> getMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_FIRST_NAME));
		}

		// 名の正規表現
		if(!$this -> checkStringAlphabetAndSpace($val)) {
			$rtnArr[] = $this -> getMessage(ERROR, 'E_ERROR_REGULAR_EMAIL', array(VAL_STR_FIRST_NAME));
		}

		// 名の文字数制限
		if(!$this -> checkLength($val
									, VAL_INT_1
									, VAL_INT_64)) {
			$rtnArr[] = $this -> getMessage(ERROR, 'E_ERROR_STRING_LENGTH_ANY', array(VAL_STR_FIRST_NAME
																						, VAL_INT_1
																						, VAL_INT_64));
		}

		// 姓
		$val = $this -> getColumnData($row, VAL_INT_4);
		if(!$this -> checkNull($val)) {
			$rtnArr[] = $this -> getMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_LAST_NAME));
		}

		// 姓の正規表現
		if(!$this -> checkStringAlphabet($val)) {
			$rtnArr[] = $this -> getMessage(ERROR, 'E_ERROR_REGULAR_EMAIL', array(VAL_STR_LAST_NAME));
		}

		// 姓の文字数制限
		if(!$this -> checkLength($val
								, VAL_INT_1
								, VAL_INT_64)) {
			$rtnArr[] = $this -> getMessage(ERROR, 'E_ERROR_STRING_LENGTH_ANY', array(VAL_STR_LAST_NAME
																						, VAL_INT_1
																						, VAL_INT_64));
		}

		// 日付のチェック
		$val = $this -> getColumnData($row, VAL_INT_5);
		$dates = explode(DELIMIT_SLASH, $val);

		if(count($dates) != VAL_INT_3
			|| !$this -> checkDate(intval($this -> getColumnData($dates, NO_COUNT))
									, intval($this -> getColumnData($dates, VAL_INT_1))
									, intval($this -> getColumnData($dates, VAL_INT_2)))) {
			$rtnArr[] = $this -> getMessage(ERROR, 'E_DATE_VALUE', array($this -> getColumnData($dates, NO_COUNT)
																		, $this -> getColumnData($dates, VAL_INT_1)
																		, $this -> getColumnData($dates, VAL_INT_2)));
		}

		if($this -> isLoopData($rtnArr)) {
			$rtn = implode('<br/>', $rtnArr);
		} else {
			$rtn = $this -> getMessage(INFO, 'I_POSSIBLE_IMPORT', array());
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function dispHTML() {
		return array();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 決済セットの設定（口座一覧）
	* @parameter	: 結果セット
	* @return		: なし
	-------------------------------------------------------------------------*/
	function setAccounts($rs) {
		$this -> accounts = $rs;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座開設データの設定(CSV)
	* @parameter	: 結果セット
	* @return		: なし
	-------------------------------------------------------------------------*/
	function setCSV($rs) {
		$this -> csv = $rs;
	}

	/*-------------------------------------------------------------------------
	* @function_name: ユーザ詳細データ
	* @parameter	: 結果セット
	* @return		: なし
	-------------------------------------------------------------------------*/
	function setUserDetail($rs) {
		$this -> userData = $rs[NO_COUNT];
	}


	public function setValidateParaments(){
		$this -> arrValidate[] = VAR_KYC_VALIDATE_STATUS_1;
		$this -> arrValidate[] = VAR_KYC_VALIDATE_STATUS_2;
		$this -> arrValidate[] = VAR_KYC_VALIDATE_STATUS_3;
		$this -> arrValidate[] = VAR_KYC_VALIDATE_STATUS_4;
		$this -> arrValidate[] = VAR_KYC_VALIDATE_STATUS_5;
		$this -> arrValidate[] = VAR_KYC_VALIDATE_STATUS_6;
		$this -> arrValidate[] = VAR_KYC_VALIDATE_STATUS_7;
		$this -> arrValidate[] = VAR_KYC_VALIDATE_STATUS_8;
		$this -> arrValidate[] = VAR_KYC_VALIDATE_STATUS_9;
		$this -> arrValidate[] = VAR_KYC_VALIDATE_STATUS_10;
		$this -> arrValidate[] = VAR_KYC_VALIDATE_STATUS_11;
		$this -> arrValidate[] = VAR_KYC_VALIDATE_STATUS_12;
		$this -> arrValidate[] = VAR_KYC_VALIDATE_STATUS_13;
		$this -> arrValidate[] = VAR_KYC_VALIDATE_STATUS_14;
		$this -> arrValidate[] = VAR_KYC_VALIDATE_STATUS_15;
		$this -> arrValidate[] = VAR_KYC_VALIDATE_STATUS_16;
		$this -> arrValidate[] = VAR_KYC_VALIDATE_STATUS_17;
		$this -> arrValidate[] = VAR_KYC_VALIDATE_STATUS_18;
		$this -> arrValidate[] = VAR_KYC_VALIDATE_STATUS_19;
		$this -> arrValidate[] = VAR_KYC_VALIDATE_STATUS_20;
		$this -> arrValidate[] = VAR_KYC_VALIDATE_STATUS_21;
		$this -> arrValidate[99] = '';
	}

	/*-------------------------------------------------------------------------
	* @function_name: 決済セットの設定（口座一覧）
	* @parameter	: 結果セット
	* @return		: なし
	-------------------------------------------------------------------------*/
	function dispAccounts() {

		// 変数宣言部
		$rtn		= NO_STRING;
		$kyc		= NO_STRING;
		$kycCounter	= NO_STRING;
		$kycStatus	= NO_STRING;

		if($this -> isLoopData($this -> accounts)) {

			// データの数だけループを回す
			$listCount	= count($this -> accounts);
			$start		= ($this -> getTargetPage() - VAL_INT_1) * VAR_DEFAULT_PAGE_COUNT;
			$end		= $this -> getTargetPage() * VAR_DEFAULT_PAGE_COUNT;

// 			for($cnt = $start; $cnt < $end && $cnt < $listCount; $cnt++) {

// 				$row = $this -> getRowData($this -> accounts, $cnt);

			foreach($this -> accounts as $row) {

				$affl = $this -> getColumnData($row, COLUMN_WL_NAME);

				// KYCドキュメント数の取得
				$wlname = ($this -> lang == "en" && $affl == "IWL本部" ? "IWL Headquarters" : $this -> getColumnData($row, COLUMN_WL_NAME));
				$kycCounter = $this -> accessSelect('COUNT_KYC_DOCUMENT', array($this -> getColumnData($row, COLUMN_USER_ACCOUNT)));


				// KYCの確認
				/*if(count($kycCounter) == NO_COUNT) {									// 書類なし
					$kyc = '&nbsp;';


				} else {																// 承認済みの表示

					// 現在のステータスを確認する
					$kycStatus = $this -> getKycCurrentStatusCommon($kycCounter);

					$kyc = '<a id="" href="kyc?type=detail&user_account=' . $this -> getColumnData($row, COLUMN_USER_ACCOUNT) . '" target="_blank">' . $this -> getValueByList($this -> getKYCFlgList(), $kycStatus) . '</a>';
				}*/

				if(count($kycCounter) == NO_COUNT){
					$kyc = '&nbsp;';
				}else{
					$kyc 	= '<a href="kyc?type='. TYPE_DETAIL .'&user_account='.$this -> getColumnData($row, COLUMN_USER_ACCOUNT) .'" target="_blank">' . $this -> arrValidate[$this -> getColumnData($row,COLUMN_VALIDATE_STATUS)] .'</a>';
				}

				$rtn	.= '<tr>'
						. '<td class="l">' . $wlname . '</td>'
						. '<td class="l">' . $this -> getColumnData($row, COLUMN_MAIL) . '</td>'
						. '<td class="l">' . $this -> getColumnData($row, COLUMN_LAST_NAME) . '&nbsp;' . $this -> getColumnData($row, COLUMN_FIRST_NAME) . '</td>'
						. '<td>' . $this -> dispUserAccountTypeCommon($this -> getColumnData($row, COLUMN_ACCOUNT_TYPE)) . '</td>'
						. '<td>' . $this -> getValueByList($this -> getTestAccountList(), $this -> getColumnData($row, COLUMN_TEST_ACCOUNT_FLG)) .'</td>'
						. '<td>' . $this -> getColumnData($row, COLUMN_USER_ACCOUNT) . '</td>'
						. '<td>' . $this -> dispCountryCommon($this -> getColumnData($row, COLUMN_COUNTRY)) . '</td>'
						. '<td>' . $this -> getColumnData($row, COLUMN_STATE) . '</td>'
						. '<td>' . $this -> getColumnData($row, COLUMN_CARD_HOLDS) . '</td>'
						. '<td>' . $this -> dispUserStatusCommon($this -> getColumnData($row, COLUMN_STATUS)) . '</td>'
						. '<td>' . $kyc . '</td>'
						. '<td>' . $this -> getColumnData($row, COLUMN_CRM_ID) . '</td>'
						. '<td>' . $this -> getColumnData($row, COLUMN_PARENT_AGENT_CODE) . '</td>'
						. '<td>' . $this -> getColumnData($row, COLUMN_CREATE_TIME_STRING) . '</td>'
						. '<td>' . $this -> getColumnData($row, COLUMN_LAST_LOGIN_TIME) . '</td>'
						. '<td>' . $this -> getColumnData($row, COLUMN_CLOSE_TIME) . '</td>'
						. '<td>' . $this -> getColumnData($row, COLUMN_SUSPENSION_TIME) . '</td>'
						// . '<td class="blocka"><a href="javascript:actionDetail(\'' . $this -> getColumnData($row, COLUMN_USER_ACCOUNT) . '\');"><span class="fa fa-info-circle fa-lg"></span></a></td>'
						. '<td class="blocka">'
                            .'<a href="account_edit?detail_account=' . $this -> getColumnData($row, COLUMN_USER_ACCOUNT) . '" title="'.VAL_STR_ACCOUNT_DETAILS.'"><span class="fa fa-info-circle fa-lg"></span></a>&nbsp;'
                            .'<a href="account_transactions?detail_account=' . $this -> getColumnData($row, COLUMN_USER_ACCOUNT) . '" title="'.VAL_STR_ACCOUNT_TRANSACTIONS.'"><span class="fa fa-university fa-lg"></span></a>'
						  .'</td>'
						. '</tr>';
			}

		} else {
			$rtn = '<tr><td colspan="16">'.VAL_STR_SEARCH_MESSAGE.'</td></tr>';
		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: アップロードデータの一覧を作成
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function makeData() {

		// 変数宣言部
		$rtn				= NO_STRING;
		$result				= NO_STRING;
		$this -> trueList	= array();			// CSVデータ（インポート対象データ）
		$this -> failList	= array();			// CSVデータ（エラー対象データ）

		if($this -> isLoopData($this -> csv)) {

			foreach($this -> csv as $row) {

				// 配列でなければ、無視
				if(count($row) < VAR_REGIST_CSV_COUNT) {
					continue;
				}

				// インポートデータのチェック
				$result = $this -> validateRow($row);

				if($result  != $this -> getMessage(INFO, 'I_POSSIBLE_IMPORT', array())) {
					$result 			= '<span class="red">' . $result . '</span>';
					$this -> failList[]	= $row;

				} else {
					$this -> trueList[]	= $row;
				}

				$rtn .=	'<tr>'
						. '<td>' . $this -> getColumnData($row, NO_COUNT) . '</td>'
						. '<td>' . $this -> getColumnData($row, VAL_INT_1) . '</td>'
						. '<td>' . $this -> getColumnData($row, VAL_INT_2) . '</td>'
						. '<td>' . $this -> getColumnData($row, VAL_INT_3) . '</td>'
						. '<td>' . $this -> getColumnData($row, VAL_INT_4) . '</td>'
						. '<td>' . $this -> getColumnData($row, VAL_INT_5) . '</td>'
						. '<td>' . $this -> getColumnData($row, VAL_INT_6) . '</td>'
						. '<td>' . $this -> getColumnData($row, VAL_INT_7) . '</td>'
						. '<td>' . $this -> getColumnData($row, VAL_INT_8) . '</td>'
						. '<td>' . $this -> getColumnData($row, VAL_INT_9) . '</td>'
						. '<td>' . $this -> getColumnData($row, VAL_INT_10) . '</td>'
						. '<td>' . $this -> getColumnData($row, VAL_INT_11) . '</td>'
						. '<td>' . $result . '</td>'
						. '</tr>';
			}

		} else {
			$rtn = '<tr><td colspan="12">'.VAL_STR_IMPORT_MESSAGE.'</td></tr>';
		}

		$this -> listData = $rtn;

		// 保存用IDを作成
		$this -> id = $this -> createUId();
	}

	/*-------------------------------------------------------------------------
	* @function_name: アップロードデータの一覧を表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispUploadDataList() {
		echo $this -> listData;
	}

	/*-------------------------------------------------------------------------
	* @function_name: ページャの取得
	* @parameter	: 結果セット
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function echoPager() {
		echo $this -> dispPagerCommon();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 登録用IDの取得
	* @parameter	: 結果セット
	* @return		: メールアドレス
	-------------------------------------------------------------------------*/
	function getID() {
		return  $this -> id;
	}

	/*-------------------------------------------------------------------------
	* @function_name: インポートリストの取得
	* @parameter	: 結果セット
	* @return		: インポートリスト
	-------------------------------------------------------------------------*/
	function getTrueList() {
		return $this -> trueList;
	}

	/*-------------------------------------------------------------------------
	* @function_name: インポートリストの取得
	* @parameter	: 結果セット
	* @return		: インポートリスト
	-------------------------------------------------------------------------*/
	function getFailList() {
		return $this -> failList;
	}

	/*-------------------------------------------------------------------------
	* @function_name: インポート未完了ファイルIDの取得
	* @parameter	: 結果セット
	* @return		: インポート未完了ファイルID
	-------------------------------------------------------------------------*/
	function getFail() {
		return $this -> fail;
	}

	/*-------------------------------------------------------------------------
	* @function_name: インポート未完了リストの取得
	* @parameter	: 結果セット
	* @return		: インポート未完了
	-------------------------------------------------------------------------*/
	function isFail() {

		$path	= SYSTEM_DOCUMENT_ACCOUNT . $this -> getID() . '_fail.csv';

		// ファイルの存在確認
		if(file_exists($path)) {
			echo $this -> id;
		} else {
			echo NO_STRING;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 氏名の取得
	* @parameter	: 結果セット
	* @return		: 氏名
	-------------------------------------------------------------------------*/
	function getName() {
		return $this -> name;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 氏名の取得
	* @parameter	: 結果セット
	* @return		: 氏名
	-------------------------------------------------------------------------*/
	function echoName() {
		echo $this -> name;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座番号の取得
	* @parameter	: 結果セット
	* @return		: 口座番号
	-------------------------------------------------------------------------*/
	function getAccountNumber() {
		return $this -> accountNumber;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 国の取得
	* @parameter	: 結果セット
	* @return		: 国
	-------------------------------------------------------------------------*/
	function getCountry() {
		return $this -> country;
	}
	/*-------------------------------------------------------------------------
	* @function_name: 住所の取得
	* @parameter	: 結果セット
	* @return		: 住所
	-------------------------------------------------------------------------*/
	function getAddress() {
		return $this -> address;
	}

	/*-------------------------------------------------------------------------
	* @function_name: エージェントコードの取得
	* @parameter	: 結果セット
	* @return		: エージェントコード
	-------------------------------------------------------------------------*/
	function getAgentCode() {
		return $this -> agentCode;
	}

	/*-------------------------------------------------------------------------
	* @function_name: KYCフラグの取得
	* @parameter	: 結果セット
	* @return		: KYCフラグ
	-------------------------------------------------------------------------*/
	function getKycFlg() {
		return $this -> kycFlg;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座状態の取得
	* @parameter	: 結果セット
	* @return		: 口座状態
	-------------------------------------------------------------------------*/
	function getStatus() {
		return $this -> status;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座種別の取得
	* @parameter	: 結果セット
	* @return		: 口座種別
	-------------------------------------------------------------------------*/
	function getAccountType() {
		return $this -> accountType;
	}
	/*-------------------------------------------------------------------------
	* @function_name: 検索開始日の取得
	* @parameter	: 結果セット
	* @return		: 検索開始日
	-------------------------------------------------------------------------*/
	function getFrom() {
		return $this -> from;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 検索終了日の取得
	* @parameter	: 結果セット
	* @return		: 検索終了日
	-------------------------------------------------------------------------*/
	function getTo() {
		return $this -> to;
	}

	/*-------------------------------------------------------------------------
	* @function_name: KYCの表示
	* @parameter	: 結果セット
	* @return		: KYC
	-------------------------------------------------------------------------*/
	function dispKYCFlg() {
		echo $this -> dispKYCStatusCommon($this -> kycFlg);
	}

	/*-------------------------------------------------------------------------
	* @function_name: KYCの表示
	* @parameter	: 結果セット
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function echoKYCFlg() {
		$arrTmp = array();
		foreach($this -> arrValidate as $key=>$val){
			$arrTmp[$key][PARAM_DATA_KEY] = $key;
			$arrTmp[$key][PARAM_DATA_VALUE] = $val;
		}
		echo $this -> dispListOption($arrTmp, $this -> kycFlg);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 状態の表示
	* @parameter	: 結果セット
	* @return		: 状態
	-------------------------------------------------------------------------*/
	function dispStatus() {
		echo $this -> dispUserStatusCommon($this -> status);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 状態の表示
	* @parameter	: 結果セット
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function echoStatus() {
		echo $this -> dispListOption($this -> getStatusList(), $this -> status);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座種別の表示
	* @parameter	: 結果セット
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function echoAccountType() {
		echo $this -> dispListOption($this -> getAccountTypeList(), $this -> accountType);
	}
	/*-------------------------------------------------------------------------
	* @function_name: 口座種別の表示
	* @parameter	: 結果セット
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function echoTestAccountFlg() {
		echo $this -> dispListOption($this -> getTestAccountList(), $this -> testAccountFlg);
	}

	/*-------------------------------------------------------------------------
	* @function_name: ユーザ名の表示
	* @parameter	: なし
	* @return		: ユーザ名
	-------------------------------------------------------------------------*/
	function echoUserName() {
		echo $this -> userName;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 通貨の表示
	* @parameter	: なし
	* @return		: 通貨
	-------------------------------------------------------------------------*/
	function echoCurrency() {
		echo $this -> currency;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 通貨の表示
	* @parameter	: なし
	* @return		: 通貨
	-------------------------------------------------------------------------*/
	function dispCurrency() {
		echo $this -> dispListOption($this -> getCurrencyList(), $this -> currency);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 姓の表示
	* @parameter	: なし
	* @return		: 姓
	-------------------------------------------------------------------------*/
	function echoLastName() {
		echo $this -> lastName;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 名の表示
	* @parameter	: なし
	* @return		: 名
	-------------------------------------------------------------------------*/
	function echoFirstName() {
		echo $this -> firstName;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 生年月日の表示
	* @parameter	: なし
	* @return		: 生年月日
	-------------------------------------------------------------------------*/
	function echoBirth() {
		echo $this -> birth;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 国の表示
	* @parameter	: なし
	* @return		: 国
	-------------------------------------------------------------------------*/
	function echoCountry() {
		echo $this -> dispListOption($this -> getCountyList(), $this -> country);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 都道府県の表示
	* @parameter	: なし
	* @return		: 都道府県
	-------------------------------------------------------------------------*/
	function echoState() {
		echo $this -> state;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 市区町村の表示
	* @parameter	: なし
	* @return		: 市区町村
	-------------------------------------------------------------------------*/
	function echoCity() {
		echo $this -> city;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 番地1の表示
	* @parameter	: なし
	* @return		: 番地1
	-------------------------------------------------------------------------*/
	function echoAddress() {
		echo $this -> address;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 番地2の表示
	* @parameter	: なし
	* @return		: 番地2
	-------------------------------------------------------------------------*/
	function echoAddress2() {
		echo $this -> address2;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 郵便番号の表示
	* @parameter	: なし
	* @return		: 郵便番号
	-------------------------------------------------------------------------*/
	function echoZipCode() {
		echo $this -> zipCode;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 電話番号の表示
	* @parameter	: なし
	* @return		: 電話番号
	-------------------------------------------------------------------------*/
	function echoTel() {
		echo $this -> tel;
	}

	/*-------------------------------------------------------------------------
	* @function_name: エージェントコードの表示
	* @parameter	: なし
	* @return		: エージェントコード
	-------------------------------------------------------------------------*/
	function echoAgentCode() {
		echo $this -> agentCode;
	}

	/*-------------------------------------------------------------------------
	* @function_name: メールアドレスの表示
	* @parameter	: なし
	* @return		: メールアドレス
	-------------------------------------------------------------------------*/
	function echoMail() {
		echo $this -> mail;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座番号の表示
	* @parameter	: なし
	* @return		: 口座番号
	-------------------------------------------------------------------------*/
	function echoAccountNumber() {
		echo $this -> accountNumber;
	}

	/*-------------------------------------------------------------------------
	* @function_name: CRM IDの表示
	* @parameter	: なし
	* @return		: CRM ID
	-------------------------------------------------------------------------*/
	function echoCrmId() {
		echo $this -> crmId;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 登録日時の表示
	* @parameter	: なし
	* @return		: 登録日時
	-------------------------------------------------------------------------*/
	function echoCreateTime() {
		echo $this -> createTime;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 詳細口座番号の取得
	* @parameter	: なし
	* @return		: 詳細口座番号
	-------------------------------------------------------------------------*/
	function getDetailAccount() {
		return $this -> detailAccount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 残高額（最小値）の表示
	* @parameter	: なし
	* @return		: 残高額（最小値）
	-------------------------------------------------------------------------*/
	function echoSMinAmount() {
		echo $this -> minAmount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 残高額（最大値）の表示
	* @parameter	: なし
	* @return		: 残高額（最大値）
	-------------------------------------------------------------------------*/
	function echoSMaxAmount() {
		echo $this -> maxAmount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 開始日（口座開設日）の表示
	* @parameter	: なし
	* @return		: 開始日（口座開設日）
	-------------------------------------------------------------------------*/
	function echoSFrom() {
		echo $this -> from;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 終了日（口座開設日）の表示
	* @parameter	: なし
	* @return		: 終了日（口座開設日）
	-------------------------------------------------------------------------*/
	function echoSTo() {
		echo $this -> to;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 開始日（最終ログイン日）の表示
	* @parameter	: なし
	* @return		: 開始日（最終ログイン日）
	-------------------------------------------------------------------------*/
	function echoSLoginFrom() {
		echo $this -> loginFrom;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 終了日（最終ログイン日）の表示
	* @parameter	: なし
	* @return		: 終了日（最終ログイン日）
	-------------------------------------------------------------------------*/
	function echoSLoginTo() {
		echo $this -> loginTo;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 残高額（最大値）の表示
	* @parameter	: なし
	* @return		: 残高額（最大値）
	-------------------------------------------------------------------------*/
	function echoSCloseFrom() {
		echo $this -> closeFrom;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 開始日（口座閉鎖日）の表示
	* @parameter	: なし
	* @return		: 終了日（口座閉鎖日）
	-------------------------------------------------------------------------*/
	function echoSCloseTo() {
		echo $this -> closeTo;
	}

	function echoSSuspensionFrom() {
		echo $this -> suspensionFrom;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 開始日（口座閉鎖日）の表示
	* @parameter	: なし
	* @return		: 終了日（口座閉鎖日）
	-------------------------------------------------------------------------*/
	function echoSSuspensionTo() {
		echo $this -> suspensionTo;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 開設日検索フラグの表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispOpenFlg() {
		echo '<label>'
				. $this -> makeCheckOne(PARAM_OPEN_FLG
											, PARAM_OPEN_FLG
											, VAL_INT_1
											, NO_STRING, $this -> openFlg)
				. '</label>';
	}

	/*-------------------------------------------------------------------------
	* @function_name: ログイン日検索フラグの表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispLoginFlg() {
		echo '<label>'
				. $this -> makeCheckOne(PARAM_LOGIN_FLG
										, PARAM_LOGIN_FLG
										, VAL_INT_1
										, NO_STRING, $this -> loginFlg)
				. '</label>';
	}

	/*-------------------------------------------------------------------------
	* @function_name: 閉鎖日検索フラグの表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispCloseFlg() {
		echo '<label>'
				. $this -> makeCheckOne(PARAM_CLOSE_FLG
										, PARAM_CLOSE_FLG
										, VAL_INT_1
										, NO_STRING, $this -> closeFlg)
				. '</label>';
	}

	function dispSuspensionFlg() {
		echo '<label>'
				. $this -> makeCheckOne(PARAM_SUSPENSION_FLG
										, PARAM_SUSPENSION_FLG
										, VAL_INT_1
										, NO_STRING, $this -> suspensionFlg)
				. '</label>';
	}

	/*-------------------------------------------------------------------------
	* @function_name: 所属WLの表示
	* @parameter	: 結果セット
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispWLId() {
		echo $this -> dispListOption($this -> getWhiteLabelList(), $this -> wlId);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座状態の表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispStatuses() {

		// 変数宣言部
		$rtn		= NO_STRING;
		$statuses	= array();
		$checked	= array();

		// 口座状態リストの取得
		$statuses = $this -> getStatusList();

		// チェックリストの作成（デフォルト全取得）
		if(!is_array($this -> statuses)) {

			if($this -> getType() == NO_STRING) {
				if($this -> isLoopData($statuses)) {

					foreach($statuses as $row) {
						$checked[$this -> getColumnData($row, PARAM_DATA_KEY)] = $this -> getColumnData($row, PARAM_DATA_KEY);
					}
				}
			}
		} else {

			foreach($this -> statuses as $row) {
				$checked[$row] = $row;
			}
		}

		if($this -> isLoopData($statuses)) {

			foreach($statuses as $row) {
				$rtn .= '<label>' . $this -> makeCheckOne(PARAM_STATUSES . $row[PARAM_DATA_KEY], PARAM_STATUSES . '[]', $row[PARAM_DATA_KEY], $row[PARAM_DATA_VALUE] , $this -> getColumnData($checked, $row[PARAM_DATA_KEY])) . '</label>&emsp;';
			}
		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 検索条件の取得
	* @parameter	: 結果セット
	* @return		: 検索条件配列
	-------------------------------------------------------------------------*/
	function getWhere() {

		// 変数宣言部
		$where		= NO_STRING;
		$having		= NO_STRING;
		$rtn		= array();
		$statuses	= array();

		// 所属WL
		if($this -> wlId != NO_STRING) {
			$where .= ' AND data.wl_id = (\')' . $this -> wlId . '(\')';
		}

		// メールアドレス
		if($this -> mail != NO_STRING) {
			$where .= ' AND data.mail LIKE (\')%' . $this -> mail . '%(\')';
		}

		// 氏名
		if($this -> name != NO_STRING) {
			$where .= ' AND (data.last_name LIKE (\')%' . $this -> name . '%(\') OR data.first_name LIKE (\')%' . $this -> name . '%(\'))';
		}

		// 口座番号
		if($this -> accountNumber != NO_STRING) {
			$where .= ' AND data.user_account = (\')' . $this -> accountNumber . '(\')';
		}

		// 国
		if($this -> country != NO_STRING) {
			$where .= ' AND data.country = (\')' . $this -> country . '(\')';
		}

		// 都道府県
		if($this -> state != NO_STRING) {
			$where .= ' AND data.state LIKE (\')%' . $this -> state . '%(\')';
		}

		// 住所
		if($this -> address != NO_STRING) {
			$where .= ' AND (data.state = (\')' . $this -> address . '(\') OR city = (\')' . $this -> address . '(\') OR zip_code = (\')' . $this -> address . '(\') OR address = (\')' . $this -> address . '(\'))';
		}

		// エージェントコード
		if($this -> agentCode != NO_STRING) {
			$where .= ' AND data.parent_agent_code = (\')' . $this -> agentCode . '(\')';
		}

		// KYCフラグ
		if($this -> kycFlg != NO_STRING) {
			if($this -> kycFlg != NO_COUNT){
				$where .= ' AND data.kyc_validate_status = (\')' . $this -> kycFlg . '(\')';
			}
		}

		// CRM ID
		if($this -> crmId != NO_STRING) {
			$where .= ' AND data.crm_id = (\')' . $this -> crmId . '(\')';
		}

		// 状態
		if($this -> status != NO_STRING) {
			$where .= ' AND data.status = (\')' . $this -> status . '(\')';
		}

		// 口座種別
		if($this -> accountType != NO_STRING) {
			$where .= ' AND data.account_type = (\')' . $this -> accountType . '(\')';
		}

		// 口座種別
		if($this -> testAccountFlg != NO_STRING) {
			$where .= ' AND data.test_account_flg = (\')' . $this -> testAccountFlg . '(\')';
		}

		// 通貨
		if($this -> currency != NO_STRING) {
			$where .= ' AND (data.from_currency = (\')' . $this -> currency . '(\') OR data.to_currency = (\')' . $this -> currency . '(\') OR data.from_currency = (\')0(\') OR data.to_currency = (\')0(\'))';
		}

		// 金額（最低値）
		if($this -> minAmount != NO_STRING) {
			$having .= ' AND (data.deposit_amount + data.withdraw_amount) >= (\')' . $this -> minAmount . '(\')';
		}

		// 金額（最高値）
		if($this -> maxAmount != NO_STRING) {
			$having .= ' AND (data.deposit_amount + data.withdraw_amount) <= (\')' . $this -> maxAmount . '(\')';
		}

		// 検索のフラグがある場合
		if($this -> openFlg != NO_STRING) {

			// 開始日（口座開設日）
			if($this -> from != NO_STRING) {
				$having .= ' AND data.create_time >= (\')' . str_replace(DELIMIT_SLASH, DELIMIT_HYPHEN, $this -> from) . '(\')';
			}

			// 終了日（口座開設日）
			if($this -> to != NO_STRING) {
				$having .= ' AND data.create_time < DATE_ADD((\')' . str_replace(DELIMIT_SLASH, DELIMIT_HYPHEN, $this -> to) . '(\'), INTERVAL 1 DAY)';
			}
		}

		// 検索のフラグがある場合
		if($this -> loginFlg != NO_STRING) {

			// 開始日（最終ログイン日）
			if($this -> loginFrom != '2014/01/01'
					&& $this -> loginFrom != NO_STRING) {
				$having .= ' AND data.last_login_time >= (\')' . str_replace(DELIMIT_SLASH, DELIMIT_HYPHEN, $this -> loginFrom) . '(\')';
			}

			// 終了日（最終ログイン日）
			if($this -> loginTo != NO_STRING) {
				$having .= ' AND data.last_login_time < DATE_ADD((\')' . str_replace(DELIMIT_SLASH, DELIMIT_HYPHEN, $this -> loginTo) . '(\'), INTERVAL 1 DAY)';
			}
		}

		// 検索のフラグがある場合
		if($this -> closeFlg != NO_STRING) {

			// 開始日（口座閉鎖日）
			if($this -> closeFrom != '2014/01/01'
				&& $this -> closeFrom != NO_STRING) {
				$having .= ' AND data.close_time >= (\')' . str_replace(DELIMIT_SLASH, DELIMIT_HYPHEN, $this -> closeFrom) . '(\')';
			}

			// 終了日（口座閉鎖日）
			if($this -> closeTo != NO_STRING) {
				$having .= ' AND data.close_time < DATE_ADD((\')' . str_replace(DELIMIT_SLASH, DELIMIT_HYPHEN, $this -> closeTo) . '(\'), INTERVAL 1 DAY)';
			}
		}

		// 検索のフラグがある場合
		if($this -> suspensionFlg != NO_STRING) {

			// 開始日（口座閉鎖日）
			if($this -> suspensionFrom != '2014/01/01'
				&& $this -> suspensionFrom != NO_STRING) {
				$having .= ' AND data.suspension_time >= (\')' . str_replace(DELIMIT_SLASH, DELIMIT_HYPHEN, $this -> suspensionFrom) . '(\')';
			}

			// 終了日（口座閉鎖日）
			if($this -> suspensionTo != NO_STRING) {
				$having .= ' AND data.suspension_time < DATE_ADD((\')' . str_replace(DELIMIT_SLASH, DELIMIT_HYPHEN, $this -> suspensionTo) . '(\'), INTERVAL 1 DAY)';
			}
		}

		// 口座状態
		if($this -> getType() != NO_STRING) {		// 検索ボタンを押している場合

			if(is_array($this -> statuses)) {

				$where .= ' AND (';

				foreach($this -> statuses as $row) {
					$statuses[] = ' data.status = (\')' . $row . '(\')';
				}

				$where .= implode(DELIMIT_OR, $statuses) . ')';
			} else {
				$where .= ' AND data.status = (\')0(\')';
			}
		}

		// ページ数
		$start	= ($this -> getTargetPage() - VAL_INT_1) * VAR_DEFAULT_PAGE_COUNT;
		$end	= $this -> getTargetPage() * VAR_DEFAULT_PAGE_COUNT;

		$page = ' LIMIT ' . $start . DELIMIT_COMMA . VAL_INT_50;

		$rtn[] = $where;
		$rtn[] = $having;
		$rtn[] = $page;

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: ページャの表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispPager() {
		echo  $this -> getPagerCommon($this -> getTargetPage()
										, $this -> getTotalPageCommon(VAR_DEFAULT_PAGE_COUNT, $this -> total)
										, $this -> total
										, NO_STRING
										, true);
	}

	/*-------------------------------------------------------------------------
	* @function_name: エクスポートデータの作成
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function makeExportData() {

		// 変数宣言部
		$data				= NO_STRING;
		$arr				= null;
		$intermediaryFlg	= NO_STRING;


		// anton

		// まずはタイトル
		$data = (
				$this -> lang == "en" ?
				"E-mail Address,First Name,Last Name,Type,Category,Account Number,Birth Date,Country,State,Municipality,Street Address,Post Code,Phone Number,Status,Agent Code,Parent Agent Code,CRM-ID,Date Opened,Date of Last Login,Date of Account Closing,Date of Account Suspension\n" :
				'メールアドレス,名前,姓,種別,口座番号,生年月日,国, 都道府県,市町村,住所,郵便番号,電話番号,ステータス,エージェントコード,親エージェントコード,CRM-ID,開設日,最終ログイン日,口座閉鎖日,口座休止日' . "\n"
				);

		// データの存在確認
		if($this -> isLoopData($this -> accounts)) {

			foreach($this -> accounts as $row) {

				// 配列の初期化
				$arr = array();
				$crmId = ($this -> getColumnData($row, COLUMN_CRM_ID)!=='')? "'".$this -> getColumnData($row, COLUMN_CRM_ID) : '';

				// データの設定
				$arr[] = $this -> getColumnData($row, COLUMN_MAIL);					// (01)メールアドレス
				$arr[] = $this -> getColumnData($row, COLUMN_FIRST_NAME);			// (02)名前
				$arr[] = $this -> getColumnData($row, COLUMN_LAST_NAME);			// (03)姓
				$arr[] = $this -> dispUserAccountTypeCommon($this -> getColumnData($row, COLUMN_ACCOUNT_TYPE)); 			// (04)種別
				$arr[] = $this -> getValueByList($this -> getTestAccountList(), $this -> getColumnData($row, COLUMN_TEST_ACCOUNT_FLG));
				$arr[] = $this -> getColumnData($row, COLUMN_USER_ACCOUNT);			// (05)口座番号
				$arr[] = $this -> getColumnData($row, COLUMN_BIRTH);				// (06)生年月日
				$arr[] = $this -> getColumnData($row, COLUMN_COUNTRY);				// (07)国
				$arr[] = $this -> getColumnData($row, COLUMN_STATE);				// (08)都道府県
				$arr[] = $this -> getColumnData($row, COLUMN_CITY);					// (09)市町村
				$arr[] = $this -> getColumnData($row, COLUMN_ADDRESS);				// (10)住所
				$arr[] = $this -> getColumnData($row, COLUMN_ZIP_CODE);				// (11)郵便番号
				$arr[] = $this -> getColumnData($row, COLUMN_TEL);					// (12)電話番号
				$arr[] = $this -> dispUserStatusCommon($this -> getColumnData($row, COLUMN_STATUS));				// (13)ステータス
				$arr[] = $this -> getColumnData($row, COLUMN_AGENT_CODE);			// (14)Agent Code
				$arr[] = $this -> getColumnData($row, COLUMN_PARENT_AGENT_CODE);	// (15)Parent Agent Code
				$arr[] = $crmId;				// (16)CRM-ID
				$arr[] = $this -> getColumnData($row, COLUMN_CREATE_TIME);			// (17)開設日
				$arr[] = $this -> getColumnData($row, COLUMN_LAST_LOGIN_TIME);		// (18)最終ログイン日
				$arr[] = $this -> getColumnData($row, COLUMN_CLOSE_TIME);			// (19)口座閉鎖日
				$arr[] = $this -> getColumnData($row, COLUMN_SUSPENSION_TIME);		// (20)口座休止日

				$data .= '"'. implode('"' . DELIMIT_COMMA . '"', $arr) . '"' . "\n";
			}
		}

		// 共通項目へデータをセット
		$this -> setExportDataCommon($data);
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 合計取得件数の設定
	 * @parameter	: 合計数
	 * @return		: なし
	 -------------------------------------------------------------------------*/
	function setTotal($total) {
		$this -> total = $total;
	}
}
?>
