<?php 
require_once(SYSTEM_LOGICS . 'account_transactions/logic.php');

class ControlAccountTransactions extends LogicAccountTransactions {
    
    public function __construct(){
        parent::__construct();
    }
    
    public function action(){
        try{
            $this -> checkAvailability("system", function(){
                require_once($this -> getSystemHTML('TEMPLATE_MAINTENANCE_MODE_SYSTEM_PATH'));
                exit();
            });
            
            $this -> logic();
            
            if($this -> getType() == TYPE_EXPORT){
                header('Content-Type: application/octet-stream');
                header('Content-Disposition: attachment; filename=Trans_List_' . date('YmdHis') . '.csv');
                header('Content-Transfer-Encoding: binary');
                echo "\xEF\xBB\xBF";
                echo $this -> makeExportData();
            }else{
                require_once($this -> getSystemHTML('TEMPLATE_ACCOUNT_TRANSACTIONS', $this -> dispHTML()));
            }
        }catch(Exception $ex){
            header("Location: /");
        }
    }
}