<?php
require_once(SITE_LOGICS . 'card/model.php');

class LogicCard extends CardModelClass {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $htmlStr = NO_STRING;	// 表示用HTML文字列
	private $refId 	 = NO_STRING;	// transactionId

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジック（各クラス共通）
	* @parameter	: なし
	* @return		: TRUE:ロジック成功、FALSE:ロジック失敗
	-------------------------------------------------------------------------*/
	function logic() {

		try {

			// 初期データ処理
			$this -> init();

			// ロジック実行
			$this -> biz();

		} catch (Exception $e) {
			throw $e;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジックの実行
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function biz() {

		// 出金処理
		if($this -> getType() == TYPE_COMPLETE) {
			// 出金処理を行う
			$this -> regist();
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: データのロード
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function lists() {
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座情報のロード
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function loadAccount() {

		// 通貨情報
		$this -> setCurrencies($this -> accessSelect('LIST_MST_CURRENCY_ACTIVE', array()));

		// バランスの取得
		$this -> setBalances($this -> accessSelect('SELECT_USER_BALANCES', array($this -> getUserData(PARAM_USER_ACCOUNT))));
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジックの実行
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function regist() {

		// 出金申請の登録
		if($this -> accessModify('INSERT_WITHDRAW_CARD', $this -> getRegistData())) {

			// カードデポジット
			if(!$this -> depositCard()) {
				//if error, update status to 3 by transactionId
				$this -> accessModify('UPDATE_FAIL_WITHDRAW_CARD', array($this -> refId));
				return false;
			}else{
				//if success, update status to 2 by transactionId
				$this -> accessModify('UPDATE_SUCCESS_WITHDRAW_CARD', array($this -> refId));

			}

			// 異通貨の場合は為替コミッション発生
			if(USD != $this -> getDebitCurrency()) {

				if($this -> getTransferType() == NO_COUNT) {

					$this -> registCommisionExchange($this -> getUserData(PARAM_USER_ACCOUNT)
														, $this -> getDebitCurrency()
														, USD
														, $this -> currencyToInt($this -> getToAmount(), USD));
				} else {
					$this -> registCommisionExchange($this -> getUserData(PARAM_USER_ACCOUNT)
														, USD
														, $this -> getDebitCurrency()
														, $this -> currencyToInt($this -> getDebitAmount(), $this -> getDebitCurrency()));
				}
			}

			// コミッションの設定
			$this -> registCommision(VAR_CARD_DEPOSIT
									, null
									, $this -> getUserData(PARAM_USER_ACCOUNT)
									, $this -> getDebitCurrency()
									, $this -> getFeeEx());

			// メール送信用のパラメータ取得
			$params = $this -> getSendData();

			// メールを送信（ユーザ）
			$this -> sendMailByTmp('cardloading_complete.xml'
									, $params
									, $params[VAL_INT_5]
									, VAR_CARD_MAIL_ADDRESS);

			// メールを送信（管理者）
			$this -> sendMailByTmp('cardloading_complete_for_admin.xml'
									, $params
									, VAR_NOTICE_MAIL_ADDRESS
									, VAR_NOTICE_MAIL_ADDRESS);
		}else{		//if sql error, write log and don't process card charge

			//LOG写入
			$dir = "../api/Logs/VPC_LOG_".date("Y-m-d");
			if(!is_dir($dir))
			{
				mkdir($dir);
				chmod($dir,0777);
			}
			// パラメータを設定する
			$sqlString = $this -> setElementParam('INSERT_WITHDRAW_CARD', $this -> getRegistData());

			$log = "Log_".date("Y-m-d H:i:s").'.log';//文件名及路径,在当前目录下新建aa.txt文件 
			$fopen = fopen($dir."/".$log,   'a+');//新建文件命令 
			fputs($fopen,   "--------------------------".date("Y-m-d H:i:s")."LOG---------------------------\r\n");
			fputs($fopen,   "Error happen when execute sql.\r\n");
			fputs($fopen,   $sqlString."\r\n");
			fclose($fopen); 

			$this -> setMsg($this -> getMessage(ERROR, 'E_FATAL', array()));
			return false;

		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: カードデポジットAPI
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function depositCard() {

		$params = array(PARAM_CARD_HOLDER_ID	=> $this -> getCardHolderId()
						, PARAM_AMOUNT			=> $this -> currencyToInt($this -> getToAmount(), USD)
						, 'refId'				=> $this -> getTransactionNumber()
						);

		$options = array('http'		=> array('method' => 'POST'
						, 'header'  => implode("\r\n", array('Content-Type: application/x-www-form-urlencoded',))
						, 'content'	=> http_build_query($params)));

		$data	= file_get_contents('https://' . SITE_SUB_DOMAIN . '.' .SITE_DOMAIN.'/api/GetPlatinumCardLoading'
									, false
									, stream_context_create($options));

		$data	= json_decode($data, true);

		$this -> setCode($this -> getColumnData($data, PARAM_CODE));
		$this -> setReturnData($this -> getColumnData($data, PARAM_RESULT));
		//get transactionId from vendor response
	 	$this -> refId = $this -> getColumnData($data, 'refId');			

		if($this -> getColumnData($data, PARAM_RESULT) == PARAM_SUCCESS) {		// 処理成功
			 $this -> setMsg($this -> getMessage(INFO, 'I_COMPLETE_PROCESS', array()));
			 return true;
		} else {									// 処理失敗
			$this -> setMsg($this -> getMessage(ERROR, 'E_FATAL', array()));
			return false;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: ページ出力文字列取得関数
	* @parameter	: なし
	* @return		: HTML文字列
	-------------------------------------------------------------------------*/
	function getDisplay() {
		return $this -> htmlStr;
	}
}
?>