<?php
$page_title = "Local Bank Transfer (Southeast Asia) Withdrawal Application";
include_once 'template/base_head.php';
?>
			<!-- サイドバー -->
			<aside id="colLeft">
				<h1><a href="/en/menu"><img src="../img/logo.png" alt="iWallet"></a></h1>
<?php include_once 'template/base_sidebar.php';?>
			</aside>
			<!-- /サイドバー -->
			<!-- メインカラム -->
			<div id="colMain">
				<div class="mainIn">
<?php include_once 'template/base_nav.php';?>

<article>
						<div class="article-heading">
							<h2><?php echo $page_title; ?></h2>
						</div>
						<div class="mb10"><?php $this->echoMessage();?></div>
						<form id="acForm" action="" method="post">
							<table class="table col bdr default odd withdrawT fontM mb20 ma90sp">
                            		<tbody>
                                 	<tr>
                                 		<th>Transaction History</th>
                                 		<td class="clr">
                                 		<select id="withdraw_history_h2p" name="withdraw_history" class="w100p">
											<option>Choose from History</option>
											<?php $this->dispWithdarawHistory();?>
										</select>

                                 		</td>
                                 	</tr>
                                    <tr>
                                    	<th>Debit Currency</th>
                                    	<td class="clr selectC">
                                    		<?php $this->dispBalances();?>
                                    	</td>
                               	 	</tr>
                                    <tr>
										<th>Amount</th>
										<td>
												<?php $this -> dispH2PCurrency(); ?>
											<input type="text" id="amount" name="amount" value="<?php $this -> echoAmount(); ?>" class="px180 ralign" maxlength="<?php $this -> echoH2PMaxValue(); ?>">
										</td>
                            		</tr>
                                    <tr><th>Account Number</th><td class="clr"><input id="account_number" name="account_number" type="text" class="w50p" value="<?php $this -> echoAccountNumber(); ?>"></td></tr>
                                    <tr><th>Account Name</th><td class="clr"><input id="account_name" name="account_name" type="text" class="w50p" value="<?php $this -> echoAccountName(); ?>"></td></tr>
                                    <tr><th>Bank Name</th><td class="clr">
                                        <select id="receipt_bank_name" name="receipt_bank_name">
                                            <option disabled value="" selected>Select Bank</option>
                                            <?php $this -> dispH2PBankList();?>
                                        </select>
                                    </td></tr>
                                    <tr>
                                    	<th>Bank Code</th><td class="clr">
                                    	<input id="receipt_bank_code" name="receipt_bank_code" type="text" class="w15p" value="<?php $this -> echoReceiptBankCode(); ?>" readonly>
                                    	</td>
                                	</tr>
                                    <tr><th>Country</th>
										<td class="clr">
											<?php $this -> echoH2PCountry(); ?>
										</td>
									</tr>
									<tr>
										<th>Message</th>
										<td>
											<span class="w80p">Local Bank Transfer (Southeast Asia)</span>
										</td>
									</tr>
                                 </tbody>
                            </table>

                        <strong>Note:</strong>
                        <ol class="ol_list ml50">
							<li>This option is only available to all individual account memebers with bank acoount in Vietnam, Thailand, Indonesia and Malaysia.</li>
                            <li>The supported currencies are VND, THB, IDR and MYR.</li>
                            <li>Below are the withdrawal limitation per currency:
                                <p>
                                    <strong>VND</strong>: VND 300,000.00 - VND 300,000,000.00 per transaction.<br>
                                    <strong>THB</strong>: THB 500.00 - THB 500,000.00 per transaction.<br>
                                    <strong>IDR</strong>: IDR 300,000.00 - IDR 200,000,000.00 per transaction.<br>
                                    <strong>MYR</strong>: MYR 50.00 - MYR 50,000.00 per transaction.
                                </p>
                            </li>
                            <li>A transaction fee, 2.00% (Minimum VND 10,000.00/THB 20.00/IDR 10,000.00/MYR 2.00) of the withdrawal amount will be charged to the number.</li>
                            <li>The funds will be credited to your bank account in 5-10 minutes. If you have not received the funds in 30 minutes, please contact us.</li>
                        </ol>
                        <input type="hidden" value="" id="type" name="type" />
                        <p><input type="submit" id = "btnH2PConfirm" value="Confirm" class="btn bg-grad px180 calign"></p>
                        </form>
					</article>
				</div>
			</div>
			<!-- /メインカラム -->
		</div>
<?php include_once 'template/base_foot.php';?>
	</div>
	<script src="../js/withdraw.js"></script>
</body>
</html>
