<?php
require_once('config.php');
require_once('GetPlatinumCardAuthToken.php');

class APIGetPlemiumCardBalance extends System {

	/*-------------------------------------------------------------------------
	 * @ メンバ変数
	-------------------------------------------------------------------------*/
	private $currency	= NO_STRING;
	private $amount		= NO_COUNT;
	private $expireDate	= NO_COUNT;
	private $dispType	= NO_COUNT;

	/*-------------------------------------------------------------------------
	 * @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		ob_start();
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	 * @function_name: パスワードの更新
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function action() {

		// 変数宣言部
		$userId		= NO_STRING;
		$proxy		= NO_STRING;

		try {

			// トークンの取得
			$objAuth	= new APIGetPlemiumCardAuthToken();
			$token		= $objAuth -> getToken();

			$cardId			= $this -> getPosParameter(PARAM_CARD_HOLDER_ID);
			$row			= $this -> getCardCommon($cardId);
			$proxy			= $this -> getColumnData($row, COLUMN_PROXY);

			$balanceUrl		= PLATINUM_CARD_ROOT_URL . '/users/' . $cardId . '/cards/' . $proxy . '/balance';

// 			$balanceUrl		= PLATINUM_CARD_ROOT_URL . 'users/1650232/cards/246654410527640/balance';

			$curl = curl_init($balanceUrl); // 初期化！

			$params = array("businessPartnerId"	=> "1508229");

			$options = array(
				CURLOPT_URL					=> $balanceUrl
				, CURLOPT_HTTPHEADER		=> array('Developerid:' . PLATINUM_CARD_DEVELOPER_ID
														, 'Developerpassword:' . PLATINUM_CARD_DEVELOPER_PASSWORD
														, 'X-Method-Override:login'
														, 'AuthenticationToken:' . $token
				)
				, CURLOPT_POSTFIELDS		=> json_encode($params)
				, CURLOPT_HTTPGET			=> true
				, CURLINFO_HEADER_OUT		=> true
				, CURLOPT_RETURNTRANSFER	=> true
			);

			curl_setopt_array($curl, $options);

			// リクエスト実行
			$result			= curl_exec($curl);
			$json_result	= json_decode($result, true);
// echo $result;
			// 通貨があった場合
			$this -> currency	= $this -> getColumnData($json_result, PARAM_CURRENCY);
			$this -> amount		= intval($this -> getColumnData($json_result, 'avlBal'));

			curl_close($curl);

			// カード有効期限の取得
			$card				= $this -> getRowData($this -> getCardsCommon($this -> getUserData(PARAM_USER_ACCOUNT), $cardId));
			$this -> expireDate	= $this -> getColumnData($card, COLUMN_EXPIRE_DATE);

		} catch (Exception $e) {
			ob_end_clean();
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: エラーチェック
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function validate() {

		// 変数宣言部
		$msgs = array();

		try {
		} catch (Exception $e) {
			throw  $e;
		}
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 残高の取得
	 * @parameter	: カード残高
	 * @return		: なし
	 -------------------------------------------------------------------------*/
	function getBalance() {
		return  $this -> amount;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 残高の取得
	 * @parameter	: カード残高
	 * @return		: なし
	 -------------------------------------------------------------------------*/
	function getBalanceJson() {

		// 変数宣言部
		$rtn = array(PARAM_AMOUNT		=> $this -> amount
					, PARAM_RESULT		=> $this -> getAmountString($this -> amount, USD)
					, PARAM_EXPIRE_DATE	=> $this -> expireDate
		);

		return  json_encode($rtn);
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 残高の取得
	 * @parameter	: カード残高
	 * @return		: なし
	 -------------------------------------------------------------------------*/
	function getDispType() {
		return  $this -> dispType;
	}
}

$api = new APIGetPlemiumCardBalance();
$api -> action();
echo $api -> getBalanceJson();
?>
