<?php
require_once('config.php');
require_once('CheckTransferBase.php');

class APICheckTransfer extends System {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $signature					= NO_STRING;
	private $account					= NO_STRING;
	private $fromAccount				= NO_STRING;	// 送金元口座
	private $toAccount					= NO_STRING;	// 送金先口座
	private $currency					= NO_STRING;	// 通貨
	private $amount						= NO_STRING;	// 金額
	private $debitCurrency				= NO_STRING;	// 引落通貨
	private $debitAmount				= NO_STRING;	// 引落金額
	private $message					= NO_STRING;	// 送金メッセージ
	private $result						= NO_STRING;	// チェック実行結果

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: パスワードの更新
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function action() {

		// 変数宣言部
		$rtn		= array();

		try {

			// パラメータの設定
			$this -> signature		= $this -> getDataPost(PARAM_SIGNATURE);
			$this -> account		= $this -> getDataPost(PARAM_USER_ACCOUNT);
			$this -> fromAccount	= $this -> getDataPost(PARAM_FROM);							// 送金元口座
			$this -> toAccount		= $this -> getDataPost(PARAM_TO);							// 送金先口座

			// シグネチャのチェック（デバッグの場合は処理しない）
			if($this -> getDataPost('debug') == NO_STRING) {
				$this -> checkSignature($this -> signature, 'T' . $this -> fromAccount . $this -> toAccount);
			}


		} catch (Exception $e) {
			throw $e;
		}
	}
}

try {


	$api = new APICheckTransfer();
	$api -> action();

	// チェックロジック
	$api = new APICheckTransferBase();
	$rs = $api -> action();

	echo json_encode(array('result'			=> 'OK'
						, 'messages'		=> 'I_COMPLETE_PROCESS'
						, 'currency'		=> $api -> getCurrency()
						, 'amount'			=> $api -> getToAmount()
						, 'debit_currency'	=> $api -> getDebitCurrency()
						, 'debit_amount'	=> $api -> getColumnData($rs, PARAM_AMOUNT)
						, 'fee'				=> $api -> getColumnData($rs, PARAM_FROM_FEE)
						, 'rate'			=> $api -> getColumnData($rs, PARAM_RATE)));

} catch (Exception $e) {	// チェックエラー

	$rtn = array('result'		=> 'NG'
				, 'messages'	=> $e -> getMessage());

	echo json_encode($rtn);
}
?>