
<?php
require_once('config.php');
require_once('CheckCardLoadBase.php');

class APICheckCardLoad extends System {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $signature		= NO_STRING;
	private $account		= NO_STRING;

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: パスワードの更新
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function action() {

		// 変数宣言部
		$rtn		= array();
		$base		= null;

		try {

			// エラーチェック
			$this -> validate();


		} catch (Exception $e) {
			$rtn = array('result'		=> 'NG'
						, 'messages'	=> $e -> getMessage());

			echo json_encode($rtn);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: エラーチェック
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function validate() {}
}

try {

	$api = new APICheckCardLoad();
	$api -> action();

	// チェックロジック
	$api = new APICheckCardLoadBase();
	$api -> action();

	echo json_encode(array('result'				=> 'OK'
							, 'messages'		=> 'I_COMPLETE_PROCESS'
							, 'digit'			=> $api -> getCardDigtCommon($api -> getDataPost(PARAM_CARD_HOLDER_ID))
							, 'debit_currency'	=> $api -> getDebitCurrency()
							, 'debit_amount'	=> $api -> getDebitAmount()
							, 'rate'			=> $api -> getRateEx()
							, 'fee_currency'	=> 'USD'
							, 'fee_Amount'		=> $api -> getFeeEx()
							, 'load_amount'		=> $api -> getToAmount()));

} catch (Exception $e) {	// チェックエラー

	$rtn = array('result'		=> 'NG'
				, 'messages'	=> $e -> getMessage());

	echo json_encode($rtn);
}

?>