var lang = $("html[lang]").attr("lang")
var connectionError = (lang == "en" ? "Connection Error" : '通信エラー');
var deleteTransaction = (lang == "en" ? "Delete the transaction?"
	: "取引を削除しますか？")

$(function(){

	function getRate() {
		$ . ajax( {
			url: '../api/getRate.php',
			type: 'post',
			dataType: 'text',
			data: {
				from_currency: $("input[name='from_currency']:checked").val(),
				to_currency: $("#to_currency").val(),
				transfer_type: $("input[name='transfer_type']:checked").val(),
				from: $("#from").val()
			},
			success: function(data) {
				$("#rate").text(data);
			},
			error: function( data ) {
				alert(connectionError);
			}
		});
	}

	$(document).ready(function(){
		if($("#rate")[0]) {
			getRate();
		}
	});

	$('input[name="from_currency"]:radio').change(function() {
		getRate();
	});

	$('input[name="transfer_type"]:radio').change(function() {
		getRate();
	});

	$('select').change(function() {
		getRate();
	});

	$('#btnComplete').click(function() {
		$('#type').val('complete');
		submitForm();
	});

	$('#btnConfirm').click(function() {
		$('#type').val('confirm');
		submitForm();
	});

	$('#btnInput').click(function() {
		$('#type').val('input');
		submitForm();
	});

	$('#btnImport').click(function() {
		$('#type').val('import');
		submitForm();
	});

	$('#btnImportConfirm').click(function() {
		$('#type').val('import_confirm');
		submitForm();
	});

	$('#btnUpdate').click(function() {
		$('#type').val('update');
		submitForm();
	});

	$('#btnImportComplete').click(function() {
		$('#type').val('import_complete');
		submitForm();
	});

	$('#btnList').click(function() {
		$('#type').val('lsit');
		submitForm();
	});


	$("#btnSearch").click(function() {
		$('#s_type').val('search');
		submitForm('searchForm');
	});

	$('#btnDelete').click(function(){
		if(confirm(deleteTransaction)){
			$('#type').val('delete');
			$('#acForm').submit();
		}
	});
	
	$("#btnSearchAll").click(function() {
		$('#s_t_id').val('');
		$('#s_from_name').val('');
		$('#s_from_account').val('');
		$('#s_to_name').val('');
		$('#s_to_account').val('');
		$('#transaction_number').val('');

		$('#s_from:text').datepicker().datepicker('setDate', nowStr);
		$('#s_to:text').datepicker().datepicker('setDate','today');

		$('#s_type').val('search');
		submitForm('searchForm');
	});

	$("#btnSearchToday").click(function() {
		$('#s_t_id').val('');
		$('#s_from_name').val('');
		$('#s_from_account').val('');
		$('#s_to_name').val('');
		$('#s_to_account').val('');
		$('#transaction_number').val('');

		$('#s_from:text').datepicker().datepicker('setDate','today');
		$('#s_to:text').datepicker().datepicker('setDate','today');

		$('#s_type').val('search');
		submitForm('searchForm');
	});

    $("#btnExportCommonHigh, #btnExportCommonLow").click(function() {
        $('#s_type').val('export');
        submitForm('searchForm');
    });

	$('#s_from').datepicker({
		// カレンダーの設定
		dateFormat	: 'yy/mm/dd'
	});

	$('#s_to').datepicker({
		// カレンダーの設定
		dateFormat	: 'yy/mm/dd'
	});

	if($('#s_from').val() == '') {
		$('#s_from:text').datepicker().datepicker('setDate', nowStr);
	}

	if($('#s_to').val() == '') {
		$('#s_to:text').datepicker().datepicker('setDate','today');
	}
});

/**
 * 入力
 */
function actionInput() {
	$('#type').val('input');
	submitForm();
}

/**
 * ファイルインポート（確認）
 */
function actionConfirm() {
	$('#type').val('confirm');
	submitForm();
}

/**
 * ファイルインポート（確認）
 */
function actionComplete() {
	$('#type').val('complete');
	submitForm();
}

/**
 * ユーザ詳細表示
 */
function actionDetail(uAccount) {
	$('#acForm').attr('action','account_edit.php');
	$('#detail_account').val(uAccount);
	$('#action').val('account_edit');
	$('#type').val('action');
	submitForm();
}

/**
 * 詳細表示
 */
function goDetail(tId, target) {
	$('#acForm').attr('action','');
	$('#type').val('detail');
	$('#t_id').val(tId);

	// ターゲットがない場合
	if(target != undefined) {
		getForm().attr('target', target);
	} else {
		getForm().attr('target', '');
	}

	submitForm();
}

/**
 * 新規作成
 */
$(function() {
	$('#btnCreate').click(function() {
		$('#type').val('action');
		submitForm();
})});

/**
 * 口座番号入力
 */
$(function() {
	$('#btnNextPage').click(function() {
		$('#type').val('input');
		submitForm();
})});

/**
 * ダウンロード
 */
function fileDownload(tId) {
	$('#type').val('export');
	$('#t_id').val(tId);
	submitForm();
}

/**
 * ダウンロード（エラー）
 */
function fileDownloadError(tId) {
	$('#type').val('export_error');
	$('#t_id').val(tId);
	submitForm();
}