
var sendVerificationEmail  = (lang == "en" ?
    "Do you want to send Verification URL to the registered email"
    : "認証URLを登録メールアドレスに送信しますか？");

var changeStatusOne = (lang == "en" ?
    "If you change the status to \"closed\", fees will occur. \nAre you really going to change it?"
    : "ステータスを閉鎖へ変更し、料金が発生します。\n本当に更新しますか？");

var changeStatusTwo = (lang == "en" ?
    "You're about to change the status. \nAre you really going to change it?"
    : "ステータスを変更しようとしています。\n本当に更新しますか？");

var removeLoginRestriction = (lang == "en" ?
    "Are you going to unlock the login limitation?"
    : "ログイン制限を解除しますか？");

var kycSendBack = (lang == "en" ?
    "You're about to return the KYC review. \nAre you really going to proceed with it?"
    : "KYC書類の確認を差戻します。\n本当に実行しますか？");

var deleteButton = (lang == "en" ?
    "Once deleted, it can not be recovered. Are you really going to delete it?"
    : "一旦削除すると元には戻せません、本当に削除しますか？");

var accountNumber = (lang == "en" ?
	    "Account Number：" : "口座番号：");

var removeLinkMsg = (lang == "en" ?
		"Once deleted, it will never be recovered. Are you really going to delete it? " :
			'一旦削除すると元には戻せません、本当に削除しますか？')

/**
 * サブミットを行う
 */
$(function() {
	$('.caption').click(function(){
		var cs=$(this).find("i").eq(0).attr("class");
		if(cs.indexOf("iconbottom")>0){
			$(this).find("i").eq(0).removeClass("iconbottom")

			}else{
		$(this).find("i").eq(0).addClass("iconbottom")

		}
	});

	$('#btnInput').click(function() {
		$('#type').val('input');
		submitForm();
	});

	$('#btnList').click(function() {
		$('#acForm').attr('action','account_list');
		$('#detail_account').val('');
		$('#action').val('account_list');
		$('#type').val('action');
		submitForm();
	});

	$("#btnSeeTransactions").click(function(){
		var currentUrl = window.location.href; 
		var modifiedBase = currentUrl.substring(0, currentUrl.lastIndexOf("/") + 1)
		
		window.location.href = modifiedBase+"account_transactions?detail_account="+$("#detail_account").val()
	})
	
	$('#btnEdit').click(function() {
		$('#type').val('action');
		submitForm();
	});

	$('#btnConfirm').click(function() {
		$('#type').val('confirm');
		submitForm();
	});

	$('#btnComplete').click(function() {
		checkSave();
	});

	$('#btnSave').click(function() {
		$('#type').val('save');
		submitForm();
	});
	$('#btnSaveRisk').click(function() {
		$('#type').val('save_risk');
		submitForm();
	});
	$('#btnInputPaymentAccess').click(function() {
		$('#type').val('input_access');
		submitForm();
	});
	$('#btnSavePaymentAccess').click(function() {
		$('#type').val('save_access');
		submitForm();
	});
	$('#btnDelete').click(function() {
		$('#type').val('delete');
		submitForm();
	});

	$('#btnUnlock').click(function() {
		confirmUnlock();
	});

	$('#btnRollBack').click(function() {
		rollBack();
	});

	$('#btnRegistCard').click(function() {
		$('#type').val('card');
		submitForm();
	});

	//--------------- Mikko 2019 ---------------//
	$('#btnLinkUser').click(function() {
		  $('#type').val('link_account');
		  submitForm();
		 //alert('Account Linking');
	});

    $(".risk_levels").change(function() {
    	$(".risk_levels").not(this).prop('checked', false);
	})

    $('#addField').click(function() {
    	var lastField = $("#fields div:last");
		var intId = (lastField && lastField.length && lastField.data("idx") + 1) || 1;
		var fieldWrapper = $("<div class=\"fieldwrapper\" id=\"field" + intId + "\">");
		fieldWrapper.data("idx", intId);
		var fName = $("<input type=\"text\" value=\"\" id=\"link_user\" name=\"link_user[]\" class=\"w20p\" />");
		var removeButton = $("<input type =\"button\" value=\" - \" id=\"removeField\" name=\"removeField\" class=\"btn bg-grad px40\" />");

		removeButton.click(function() {
			$(this).parent().remove();
		});
		fieldWrapper.append(accountNumber);
		fieldWrapper.append(fName);
		fieldWrapper.append("&nbsp;");
		fieldWrapper.append(removeButton);
		$("#fields").append(fieldWrapper);
	});

	//--------------- Mikko 2019 ---------------//

	$('#btnSend').click(function() {
		if(confirm(sendVerificationEmail)) {
			$('#type').val('send');
			submitForm();
		}
	});

	$('#kycUpload').click(function() {

		$('#type').val('adminKycUpload');
		submitForm();

	});

	$('#btnKyc').click(function() {
		if(checkUploadFileSize()) {
			$('#type').val('adminKycUploadComplete');
			submitForm();
		}
	});

	$('#s_from').datepicker({
		// カレンダーの設定
		dateFormat	: 'yy/mm/dd'
	});

	$('#s_to').datepicker({
		// カレンダーの設定
		dateFormat	: 'yy/mm/dd'
	});

	$("#btnExport").click(function() {
		$('#s_type').val('export');
		submitForm('searchForm');
	});

	if($('#s_from').val() == '') {
		var nowDate	= new Date();
		nowDate.setMonth(nowDate.getMonth() - 2);
		var month	= nowDate.getMonth();
		var year	= nowDate.getFullYear();
		var date 	= nowDate.getDate();

		month = month + 1;

		if(month < 9) {
			month = "0" + month
		}

		if(date < 9) {
			date = "0" + date
		}

		var thisStr = year + '/' + month + '/' + '01';
		$('#s_from:text').datepicker().datepicker('setDate', thisStr);
	}

	var currentSToVal = new Date($('#s_to').val())
	var currentSToMonth = currentSToVal.getMonth() + 1
	var currentSToYear = currentSToVal.getFullYear()
	var currentSToDate = currentSToVal.getDate()
	if(month < 9) {
		currentSToMonth = "0" + currentSToMonth
	}

	if(date < 9) {
		currentSToDate = "0" + currentSToDate
	}

	var setSto = currentSToYear + '/' + currentSToMonth + '/' + currentSToDate;

	if($('#s_to').val() == '') {
		$('#s_to:text').datepicker().datepicker('setDate','today');
	} else {
		$('#s_to:text').datepicker().datepicker('setDate', setSto);
	}
});


function movePageEx(ccy) {
	var targetPageNum = parseInt($('#move_page_high_' + ccy).val());
	var crntPage = parseInt($('#crnt_page_' + ccy).val());
	var totalPageNum = parseInt($('#total_page_' + ccy).val());
	if (targetPageNum > totalPageNum || targetPageNum <= 0 || targetPageNum == crntPage) {
		$('#move_page_high_' + ccy).val(crntPage);
		return;
	} else {
		$.post(window.location.href, {
			type : 'paging',
			detail_account : $('#detail_account:hidden').val(),
			s_from : $('#s_from:text').val(),
			s_to : $('#s_to:text').val(),
			s_email : $('#s_email').val(),
			s_account : $('#s_account').val(),
			transaction_number : $('#transaction_number').val(),
			s_currency : ccy,
			crnt_page : targetPageNum
		}, function(result){
			$('#crnt_page_' + ccy).val(targetPageNum);
			$('#move_page_high_' + ccy).val(targetPageNum);
			$('#crntPageNum_' + ccy).text(targetPageNum);
			$('#tbl_' + ccy).html(result);
		});
	}
}

function moveNextPage(ccy) {
	var crntPage = parseInt($('#crnt_page_' + ccy).val());
	var totalPageNum = parseInt($('#total_page_' + ccy).val());
	var targetPageNum = crntPage + 1;
	if (targetPageNum > totalPageNum || targetPageNum <= 0) {
		return;
	} else {
		$.post(window.location.href, {
			type : 'paging',
			detail_account : $('#detail_account:hidden').val(),
			s_from : $('#s_from:text').val(),
			s_to : $('#s_to:text').val(),
			s_email : $('#s_email').val(),
			s_account : $('#s_account').val(),
			transaction_number : $('#transaction_number').val(),
			transaction_type : $('#transaction_type').val(),
			s_currency : ccy,
			crnt_page : targetPageNum
		}, function(result){
			$('#crnt_page_' + ccy).val(targetPageNum);
			$('#move_page_high_' + ccy).val(targetPageNum);
			$('#crntPageNum_' + ccy).text(targetPageNum);
			$('#tbl_' + ccy).html(result);
		});
	}
}

function movePrevPage(ccy) {
	var crntPage = parseInt($('#crnt_page_' + ccy).val());
	var totalPageNum = parseInt($('#total_page_' + ccy).val());
	var targetPageNum = crntPage - 1;
	if (targetPageNum > totalPageNum || targetPageNum <= 0) {
		return;
	} else {
		$.post(window.location.href, {
			type : 'paging',
			detail_account : $('#detail_account:hidden').val(),
			s_from : $('#s_from:text').val(),
			s_to : $('#s_to:text').val(),
			s_email : $('#s_email').val(),
			s_account : $('#s_account').val(),
			transaction_number : $('#transaction_number').val(),
			transaction_type : $('#transaction_type').val(),
			s_currency : ccy,
			crnt_page : targetPageNum
		}, function(result){
			$('#crnt_page_' + ccy).val(targetPageNum);
			$('#move_page_high_' + ccy).val(targetPageNum);
			$('#crntPageNum_' + ccy).text(targetPageNum);
			$('#tbl_' + ccy).html(result);
		});
	}
}

/**
 * サブミットを行う（詳細画面の表示）
 */
function actionDetail(uAccount) {
	$('#type').val('edit');
	$('#user_account').val(uAccount);
	submitForm();
}

/**
 * サブミットを行う（ステータスの更新）
 */
function actionList() {
	$('#k_id').val(kId);
	$('#status').val(status);
	submitForm();
}

/**
 * サブミットを行う（詳細画面）
 */
function actionBack() {

	// 変数宣言部
	var action	= '';
	var form	= null;

	if($('#action').val() != '') {
		form = getForm();
		action = form.attr('action', $('#action').val());
	}

	submitForm();
}

/**
 * サブミットを行う（ステータス更新時の確認）
 */
function checkSave() {

	// 変数宣言部
	var old		= $('#old_status').val();
	var status	= $('#status').val();

	if(old != status) {

		if(status == 5) {
            // two
			if(confirm(changeStatusOne)) {

				$('#type').val('complete');
				submitForm();
			}
		} else {
            // three
			if(confirm(changeStatusTwo)) {

				$('#type').val('complete');
				submitForm();
			}
		}
	} else {
		$('#type').val('complete');
		submitForm();
	}
}

function confirmUnlock() {
    // four
	if(confirm(removeLoginRestriction)) {
		$('#type').val('unlock');
		submitForm();
	}
}

function rollBack() {
    // five
	if(confirm(kycSendBack)) {
		$('#type').val('roll_back');
		submitForm();
	}
}

function removeCard(cardHolderId) {
    // six
	if(confirm(deleteButton)) {
		$('#type').val('remove_card');
		$('#c_id').val(cardHolderId);
		submitForm();
	}
}
//Mikko 2019 0312 start
function removeLink(userLink) {
	if(confirm(removeLinkMsg)) {
		$('#type').val('remove_link');
		$('#l_id').val(userLink);
		submitForm();

	}

}
//Mikko 2019 0312 end
function checkUploadFileSize() {

	// 変数宣言部
	var rtn			= true;
	var file		= null;
	var msg			= '';
	var maxSize 	= 5242880;
	var maxSizeStr	= '5MB';

	if($('#img1').prop('files')[0] != undefined) {

		file = $('#img1').prop('files')[0];

		if(file.size > maxSize) {
            // msg += file.name + 'は、サイズを' + maxSizeStr + '以下にして下さい。';
            msg = fileSizeStrConcat(file.name, maxSizeStr);
			rtn = false;
		}
	}

	if($('#img2').prop('files')[0] != undefined) {

		file = $('#img2').prop('files')[0];

		if(file.size > maxSize) {
            // msg += file.name + 'は、サイズを' + maxSizeStr + '以下にして下さい。';
            msg = fileSizeStrConcat(file.name, maxSizeStr);
			rtn = false;
		}
	}

	if($('#img3').prop('files')[0] != undefined) {

		file = $('#img3').prop('files')[0];

		if(file.size > maxSize) {
            // msg += file.name + 'は、サイズを' + maxSizeStr + '以下にして下さい。';
            msg = fileSizeStrConcat(file.name, maxSizeStr);
			rtn = false;
		}
	}

	if($('#img4').prop('files')[0] != undefined) {

		file = $('#img4').prop('files')[0];

		if(file.size > maxSize) {
            // msg += file.name + 'は、サイズを' + maxSizeStr + '以下にして下さい。';
            msg = fileSizeStrConcat(file.name, maxSizeStr);
			rtn = false;
		}
	}

	if($('#img5').prop('files')[0] != undefined) {

		file = $('#img5').prop('files')[0];

		if(file.size > maxSize) {
            // msg += file.name + 'は、サイズを' + maxSizeStr + '以下にして下さい。';
            msg = fileSizeStrConcat(file.name, maxSizeStr);
			rtn = false;
		}
	}

	if($('#img6').prop('files')[0] != undefined) {

		file = $('#img6').prop('files')[0];

		if(file.size > maxSize) {
            // msg += file.name + 'は、サイズを' + maxSizeStr + '以下にして下さい。';
            msg = fileSizeStrConcat(file.name, maxSizeStr);
			rtn = false;
		}
	}

	if($('#img7').prop('files') != undefined) {
		if($('#img7').prop('files')[0]	!= undefined) {

			file = $('#img7').prop('files')[0];

			if(file.size > maxSize) {
                // msg += file.name + 'は、サイズを' + maxSizeStr + '以下にして下さい。';
                msg = fileSizeStrConcat(file.name, maxSizeStr);
				rtn = false;
			}
		}
	}

	if($('#img8').prop('files') != undefined) {
		if($('#img8').prop('files')[0]	!= undefined) {

			file = $('#img8').prop('files')[0];

			if(file.size > maxSize) {
                // msg += file.name + 'は、サイズを' + maxSizeStr + '以下にして下さい。';
                msg = fileSizeStrConcat(file.name, maxSizeStr);
				rtn = false;
			}
		}
	}

	if($('#img9').prop('files') != undefined) {
		if($('#img9').prop('files')[0]	!= undefined) {

			file = $('#img9').prop('files')[0];

			if(file.size > maxSize) {
                // msg += file.name + 'は、サイズを' + maxSizeStr + '以下にして下さい。';
                msg = fileSizeStrConcat(file.name, maxSizeStr);
				rtn = false;
			}
		}
	}

	if($('#img10').prop('files') != undefined) {
		if($('#img10').prop('files')[0]	!= undefined) {

			file = $('#img10').prop('files')[0];

			if(file.size > maxSize) {
                // msg += file.name + 'は、サイズを' + maxSizeStr + '以下にして下さい。';
                msg = fileSizeStrConcat(file.name, maxSizeStr);
				rtn = false;
			}
		}
	}

	if($('#img11').prop('files') != undefined) {
		if($('#img11').prop('files')[0]	!= undefined) {

			file = $('#img11').prop('files')[0];

			if(file.size > maxSize) {
                // msg += file.name + 'は、サイズを' + maxSizeStr + '以下にして下さい。';
                msg = fileSizeStrConcat(file.name, maxSizeStr);
				rtn = false;
			}
		}
	}

	if(!rtn) {
		alert(msg);
	}

	return rtn;
}


/**
 *
 * anton
 *
 * @param {*} filename
 * @param {*} fileSize
 * @param {*} lang
 */
function fileSizeStrConcat(filename, fileSize){
    if(lang == "en"){
        return "["+filename+"] Please upload a file which file size is less than "+fileSize;
    }else{
        return filename + 'は、サイズを' + fileSize + '以下にして下さい。';
    }
}