<?php
class CardApplyModelClass extends ModelClassEx {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $rs							= null;			// 結果セット
	private $user						= null;			// ユーザデータ

	private $country					= NO_STRING;	// 郵送国
	private $state						= NO_STRING;	// 県・州
	private $city						= NO_STRING;	// 市区町村
	private $address					= NO_STRING;	// 住所
	private $zipCode					= NO_STRING;	// 番号
	private $tel						= NO_STRING;	// 電話番号
	private $sipFlg						= NO_COUNT;		// 送付フラグ
	private $status						= NO_COUNT;		// ユーザステータス
	private $index						= NO_COUNT;		// カード枚数
	private $lastName					= NO_COUNT;		// 姓
	private $firstName					= NO_COUNT;		// 名

	/*-------------------------------------------------------------------------
	* @function_name: コントロールパネルシステムindexモデルクラスコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		// スーパークラスコンストラクタ呼び出し
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 初期設定関数
	* @parameter	: なし
	* @return		: 成功:success、失敗:error
	-------------------------------------------------------------------------*/
	public function init() {

		try {

			// パラメータの設定
			$this -> setParameter();

			// チェック
			$this -> validate();

		} catch (Exception $e) {
			throw $e;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: パラメータの設定
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function setParameter() {

		// データを取得する
		$this -> user = $this -> getRowData($this -> getAccountCommon($this -> getUserData(PARAM_USER_ACCOUNT)));

		$this -> country		= $this -> getDataPost(PARAM_COUNTRY);						// 国
		$this -> state			= $this -> getDataPost(PARAM_STATE);						// 県・州
		$this -> city			= $this -> getDataPost(PARAM_CITY);							// 市区町村
		$this -> address		= $this -> getDataPost(PARAM_ADDRESS);						// 住所
		$this -> zipCode		= $this -> getDataPost(PARAM_ZIP_CODE);						// 郵便番号
		$this -> tel			= $this -> getDataPost(PARAM_TEL);							// 電話番号
		$this -> sipFlg			= $this -> getDataPost(PARAM_SIP_FLG);						// 郵送フラグ
		$this -> status			= $this -> getColumnData($this -> user, COLUMN_STATUS);		// ユーザステータス
		$this -> index			= intval($this -> getDataPost(PARAM_INDEX));				// カード取得枚数
		$this -> lastName		= $this -> getColumnData($this -> user, COLUMN_LAST_NAME);	// 姓
		$this -> firstName		= $this -> getColumnData($this -> user, COLUMN_FIRST_NAME);	// 名
	}

	/*-------------------------------------------------------------------------
	* @function_name: 国の取得
	* @parameter	: なし
	* @return		: 国
	-------------------------------------------------------------------------*/
	public function echoCountry() {
		echo $this -> country;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 国の取得
	* @parameter	: なし
	* @return		: 国
	-------------------------------------------------------------------------*/
	public function dispCountry($flg = NO_COUNT) {

		if($this -> sipFlg == NO_COUNT) {			// デフォルト値
			echo $this -> dispCountryCommon($this -> getColumnData($this -> user, COLUMN_COUNTRY));

		} else if($this -> sipFlg == VAL_INT_1) {	// 入力値の場合
			echo $this -> dispCountryCommon($this -> country);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 国の取得
	* @parameter	: なし
	* @return		: 国
	-------------------------------------------------------------------------*/
	public function dispHTMLCountry() {
		echo $this -> dispListOption($this -> getCountyList(), $this -> country);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 県・州の取得
	* @parameter	: 表示フラグ（0：デフォルト値、1：入力値、2：フラグ次第）
	* @return		: 県・州
	-------------------------------------------------------------------------*/
	public function echoState($flg = NO_COUNT) {

		if($flg == NO_COUNT) {			// デフォルト値
			echo $this -> getColumnData($this -> user, COLUMN_STATE);

		} else if($flg == VAL_INT_1) {	// 入力値の場合
			echo $this -> state;

		} else {						// その他

			if($this -> sipFlg == NO_COUNT) {
				echo $this -> getColumnData($this -> user, COLUMN_STATE);
			} else {
				echo $this -> state;
			}
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 市区町村の取得
	* @parameter	: なし
	* @return		: 市区町村
	-------------------------------------------------------------------------*/
	public function echoCity($flg = NO_COUNT) {

		if($flg == NO_COUNT) {			// デフォルト値
			echo $this -> getColumnData($this -> user, COLUMN_CITY);

		} else if($flg == VAL_INT_1) {	// 入力値の場合
			echo $this -> city;

		} else {						// その他

			if($this -> sipFlg == NO_COUNT) {
				echo $this -> getColumnData($this -> user, COLUMN_CITY);
			} else {
				echo $this -> city;
			}
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: の取得
	* @parameter	: なし
	* @return		: 住所
	-------------------------------------------------------------------------*/
	public function echoAddress($flg = NO_COUNT) {

		if($flg == NO_COUNT) {			// デフォルト値
			echo $this -> getColumnData($this -> user, COLUMN_ADDRESS);

		} else if($flg == VAL_INT_1) {	// 入力値の場合
			echo $this -> address;

		} else {						// その他

			if($this -> sipFlg == NO_COUNT) {
				echo $this -> getColumnData($this -> user, COLUMN_ADDRESS);
			} else {
				echo $this -> address;
			}
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 郵便番号の取得
	* @parameter	: なし
	* @return		: 郵便番号
	-------------------------------------------------------------------------*/
	public function echoZipCode($flg = NO_COUNT) {

		if($flg == NO_COUNT) {			// デフォルト値
			echo $this -> getColumnData($this -> user, COLUMN_ZIP_CODE);

		} else if($flg == VAL_INT_1) {	// 入力値の場合
			echo $this -> zipCode;

		} else {						// その他

			if($this -> sipFlg == NO_COUNT) {
				echo $this -> getColumnData($this -> user, COLUMN_ZIP_CODE);
			} else {
				echo $this -> zipCode;
			}
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 電話番号の取得
	* @parameter	: なし
	* @return		: 電話番号
	-------------------------------------------------------------------------*/
	public function echoTel($flg = NO_COUNT) {

		if($flg == NO_COUNT) {			// デフォルト値
			echo $this -> getColumnData($this -> user, COLUMN_TEL);

		} else if($flg == VAL_INT_1) {	// 入力値の場合
			echo $this -> tel;

		} else {						// その他

			if($this -> sipFlg == NO_COUNT) {
				echo $this -> getColumnData($this -> user, COLUMN_TEL);
			} else {
				echo $this -> tel;
			}
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 送付フラグの取得
	* @parameter	: なし
	* @return		: 送付フラグ
	-------------------------------------------------------------------------*/
	public function echoSipFlg() {
		echo $this -> sipFlg;
	}

	/*-------------------------------------------------------------------------
	* @function_name: カード枚数の取得
	* @parameter	: なし
	* @return		: カード枚数
	-------------------------------------------------------------------------*/
	public function getIndex() {
		return $this -> index;
	}

	/*-------------------------------------------------------------------------
	* @function_name: カード枚数の取得
	* @parameter	: なし
	* @return		: カード枚数
	-------------------------------------------------------------------------*/
	public function echoIndex() {
		echo $this -> index;
	}

	/*-------------------------------------------------------------------------
	* @function_name: DB情報の取得
	* @parameter	: カラム名
	* @return		: DB情報
	-------------------------------------------------------------------------*/
	public function echoUserDataFromDB($column) {
		echo $this -> getColumnData($this -> user, $column);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 国の取得
	* @parameter	: なし
	* @return		: 国
	-------------------------------------------------------------------------*/
	public function echoUserCountry() {
		echo $this -> dispCountryCommon($this -> getColumnData($this -> user, COLUMN_COUNTRY));
	}


	/*-------------------------------------------------------------------------
	* @function_name: カード枚数の取得
	* @parameter	: なし
	* @return		: カード枚数
	-------------------------------------------------------------------------*/
	public function echoSippingName() {
		echo $this -> firstName . DELIMIT_SPACE . $this -> lastName;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 送付フラグの取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	public function dispHTMLSipFlg() {
		echo $this -> makeRadio(PARAM_SIP_FLG
								, $this -> getSippingFlgList()
								, intval($this -> sipFlg));
	}

	/*-------------------------------------------------------------------------
	* @function_name: カード進捗状況の取得
	* @parameter	: カード枚目
	* @return		: カード進捗状況
	-------------------------------------------------------------------------*/
	public function dispCardProgress($index) {

		// 変数宣言部
		$status = intval($this -> getColumnData($this -> getRowData($this -> rs, $index), COLUMN_STATUS));

		if($status == VAL_INT_1) {	// 申請中の場合、「審査中」へ変更
			$status += VAL_INT_2;
		}

		echo $this -> getValueByList($this -> getCardProgressList(), $status);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 引落リストの設定
	* @parameter	: 引落リスト
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function setResult($rs) {
		$this -> rs = $rs;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 申し込み上限の取得
	* @parameter	: なし
	* @return		: 申し込み上限
	-------------------------------------------------------------------------*/
	public function dispCardLimit() {

		// 変数宣言部
		$rtn = NO_STRING;

		if($this -> status == VAR_ACCOUNT_STATUS_UNLIMITED) {
			$rtn = VAL_STR_CARD_LIMIT_MIDDLE;
		} else {
			$rtn = VAL_STR_CARD_LIMIT_SMALL;
		}
		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 申し込み上限文言の取得
	* @parameter	: なし
	* @return		: 申し込み上限文言
	-------------------------------------------------------------------------*/
	public function dispCardLimitWord() {

		// 変数宣言部
		$rtn = NO_STRING;

		if($this -> status == VAR_ACCOUNT_STATUS_UNLIMITED) {
			$rtn = NO_STRING;
		} else {
			$rtn = VAL_STR_CARD_LIMIT_WORD;
		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 申し込み上限文言の取得
	* @parameter	: なし
	* @return		: 申し込み上限文言
	-------------------------------------------------------------------------*/
	public function dispCardLimitRecharge() {
		if($this -> status == VAR_ACCOUNT_STATUS_UNLIMITED) {
			$rtn = VAL_STR_CARD_POSSIBLE_RECHARGE;
		} else {
			$rtn = NO_STRING;
		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: データリストの表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	public function echoList() {

		// 変数宣言部
		$rtn	= NO_STRING;

		for($cnt = NO_COUNT; $cnt < VAL_INT_2 - count($this -> rs); $cnt++) {	// とりあえず、MAX2枚まで
			$rtn .= '<option value="' . ($cnt + VAL_INT_1) . '">' . ($cnt + VAL_INT_1) . '</option>';

		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 登録用のデータ取得関数
	* @parameter	: なし
	* @return		: 登録用データ配列
	-------------------------------------------------------------------------*/
	public function getRegistData() {

		// 変数宣言部
		$rtn = array();

		$rtn[] = $this -> getUserData(PARAM_USER_ACCOUNT);								// 口座番号

		if($this -> sipFlg == NO_COUNT) {	// デフォルト値
			$rtn[] = $this -> getRowData($this -> user, COLUMN_COUNTRY);	// 国コード
			$rtn[] = $this -> getRowData($this -> user, COLUMN_STATE);		// 県・州
			$rtn[] = $this -> getRowData($this -> user, COLUMN_CITY);		// 市区町村
			$rtn[] = $this -> getRowData($this -> user, COLUMN_ADDRESS);	// 住所
			$rtn[] = $this -> getRowData($this -> user, COLUMN_ZIP_CODE);	// 郵便番号
			$rtn[] = $this -> getRowData($this -> user, COLUMN_TEL);		// 電話番号

		} else {							// 入力値
			$rtn[] = $this -> country;										// 国コード
			$rtn[] = addslashes($this -> state);							// 県・州
			$rtn[] = addslashes($this -> city);								// 市区町村
			$rtn[] = addslashes($this -> address);							// 住所
			$rtn[] = addslashes($this -> zipCode);							// 郵便番号
			$rtn[] = addslashes($this -> tel);								// 電話番号
		}

		$rtn[] = VAL_INT_1;													// 最初のステータス（申請中）

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: サーバ側データチェック
	* @parameter	: なし
	* @return		: TRUE:成功、FALSE:失敗
	-------------------------------------------------------------------------*/
	public function validate() {

		// 変数宣言部
		$rtn = true;

		// ログインチェック
		if(!$this -> checkSiteUserLogin()) {
			throw new Exception(NO_STRING);
		}

		if($this -> getType()		== TYPE_CONFIRM
			|| $this -> getType()	== TYPE_COMPLETE) {			// 確認画面か完了画面の場合

			if($this -> sipFlg == NO_COUNT) {	// デフォルトの場合はチェックなし
				return $rtn;
			}

			// 必須項目
			// 都道府県のチェック
			if(!$this -> checkNull($this -> state)) {
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_STATE));
				$rtn = false;
			}

			// 市区町村のチェック
			if(!$this -> checkNull($this -> city)) {
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_CITY));
				$rtn = false;
			}

			// 住所のチェック
			if(!$this -> checkNull($this -> address)) {
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_ADDRESS));
				$rtn = false;
			}

			// 郵便番号のチェック
			if(!$this -> checkNull($this -> zipCode)) {
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_ZIP_CODE));
				$rtn = false;
			}

			// 電話番号のチェック
			if(!$this -> checkNull($this -> tel)) {
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_TEL));
				$rtn = false;
			}

			if(!$rtn) {
				if($this -> getType() == TYPE_COMPLETE) {	// 完了の場合
					$this -> setType(TYPE_CONFIRM);

				} else {									// その他
					$this -> setType(NO_STRING);
				}

				return;
			}

			// 正規表現
			// 都道府県のチェック
			if(!$this -> checkStringAsciiStateAndCity($this -> state)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_REGULAR_ASCII_STATE_CITY', array(VAL_STR_STATE, VAL_INT_64));
				$rtn = false;
			}

			if(!$this -> checkLength($this -> state
					, VAL_INT_1
					, VAL_INT_64)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_STRING_LENGTH_ANY', array(VAL_STR_STATE
						, VAL_INT_1
						, VAL_INT_64));
				$rtn = false;
			}

			// 市区町村のチェック
			if(!$this -> checkStringAsciiStateAndCity($this -> city)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_REGULAR_ASCII_STATE_CITY', array(VAL_STR_CITY, VAL_INT_64));
				$rtn = false;
			}

			if(!$this -> checkLength($this -> city
					, VAL_INT_1
					, VAL_INT_64)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_STRING_LENGTH_ANY', array(VAL_STR_CITY
						, VAL_INT_1
						, VAL_INT_64));
				$rtn = false;
			}

			// 住所のチェック
			if(!$this -> checkStringAddress($this -> address)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_REGULAR_ASCII_ADDRESS', array(VAL_STR_ADDRESS, VAL_INT_128));
				$rtn = false;
			}

			if(!$this -> checkLength($this -> address
					, VAL_INT_1
					, VAL_INT_128)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_STRING_LENGTH_ANY', array(VAL_STR_ADDRESS
						, VAL_INT_1
						, VAL_INT_128));
				$rtn = false;
			}

			// 郵便番号のチェック
			if(!$this -> checkStringNumberZipCode($this -> zipCode)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_REGULAR_NUMBER_ZIP_CODE', array(VAL_STR_ZIP_CODE));
				$rtn = false;
			}

			// 電話番号のチェック
			if(!$this -> checkStringNumberTel($this -> tel)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_REGULAR_NUMBER_TEL', array(VAL_STR_TEL, VAL_INT_20));
				$rtn = false;
			}

			if(!$this -> checkLength($this -> tel
					, VAL_INT_7
					, VAL_INT_20)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_STRING_LENGTH_ANY', array(VAL_STR_TEL
						, VAL_INT_7
						, VAL_INT_20));
				$rtn = false;
			}

			if(!$rtn) {
				if($this -> getType() == TYPE_COMPLETE) {	// 完了の場合
					$this -> setType(TYPE_CONFIRM);

				} else {									// その他
					$this -> setType(NO_STRING);
				}
			}
		} else if($this -> getType() == NO_STRING) {	// 初期画面の場合
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function dispHTML() {
		return array();
	}
}
?>